<SCRIPT LANGUAGE="VBScript.Encode" RUNAT="Server">

'========================
Sub Application_OnStart
'========================

'############################################################################################
'### This section contains important and powerful FM settings. You can edit them to fit your needs.
'### Lines with an apostophe ( ' ) in front of them are commented out and therefore inactive. Uncomment them if necessary.
'### See the FAQ for common questions: http://iisworks.com/fileman
'############################################################################################

'###### System settings ###### 
Application.Lock
Application("Debugging")=True '### If set to True: "On error resume next" will be inactive on the page and error messages will be shown (Note: FM may not work 100% correctly if debugging is turned on!)
Application("DBConnection")="DBQ=" & server.mappath("database/fileman.mdb") & ";Driver={Microsoft Access Driver (*.mdb)}" '### Database connection string. For alternatives (for example a DSN): refer to general IIS docs.
Application("ScriptTimeout")=900 '### The value for Server.ScriptTimeout of Fileman. Increase if the script times out on long actions like an upload of big files with a modem.
Application("UploadPage")="ul_asp.asp" '### Page to use for uploads (support for 3rd party upload components). Default: ul_asp.asp, options are any of the ul_*.asp pages.
Application("DefaultLanguageFile")="English.dat" '### Default language file to use for FileMan. This defines the initial language of FM before a user logs in and his own language page is loaded
'Application("SelectLanguageOnLoginPage")=True '### Show the language selectbox on the login page. Language change is affected immediately after selection.
Application("EmailEnabled")=True '### If jmail is installed and this option is enabled, users can have their pass resent to them from the login page (if an email address is defined)
Application("UnEditableExtensions")="com,exe,dll,ocx,386,sys,vxd,drv,bin,jpg,gif,bmp,zip,arj,rar,mdb,xls,mp3,mpg,avi,mov,pdf,chm" 
Application("MaxZipItems")=1000 '### Maximum number of files in a ZIP file (only when zipping folders, to prevent possible server overload)
'Application("DeleteRootFolder")=True '### CAUTION! Remove users rootfolder when deleting accounts (from admin page or automatic database maintenance).

'###### Security settings ###### 
'Application("UseNTAuthentication")=True '### Use integrated NT authentication if available. Anonymous access from fileman needs to be revoked in IIS. Also create FM accounts for the NT Users! 
'Application("AutoCreateNTUsers")=True '### Auto create non existing authenticated users in Fileman if NT authentication is enabled (with default values for database fields).
Application("FMRecyclerName")="FMRecycler_" '### If defined, this subfolder of RootFolder will be used to move deleted files to if configured for user with a rootfolder defined (username will be appended to this name). Example: "FMRecycler_". 
Application("AllowedIP")="" '### Comma delimited list of allowed IP numbers/ranges. Example: "192.*,10.0.0.*" 
Application("DeniedIP")="" '### Comma delimited list of denied IP numbers/ranges (this setting overrides AllowedIP). Example: "192.*,10.0.0.*" 
Application("LogFile")="fileman.log" '### Name of the logfile that Fileman will use. If no full path is entered the FM folder will be used.
Application("LogLevel")=3 '### 0=Off, 1=Basic logging, 2=Debug level logging, 3=Debug + full matching

'######  View settings ###### 
Application("MaxHistoryItems")=30 '### Remember this number of last folders in user selectable listbox 
Application("MaxLengthOfHistoryItems")=30 '### Names of items in history listbox will be shortened if longer than this value 
Application("ExtraErrorMsg")= "" '### Optional customizable additional error message string that is displayed in case of an error, for example how to contact the helpdesk. 
Application("CustomButtons")="" '### Gives admins the option to add functionality to FileMan. This HTML string containing custom links and/or buttons (20x20 pixels) will be added to the button bar.
Application("HomeURL")="http://www.iisworks.com/fileman" '### The link under the Home button. Use %user% as username variable.

'######  User Subscriptions settings to web based file storage. This section is only active if AllowSubscriptions=True! JMail also needs to be installed to use it. ###### 
'Application("AllowSubscriptions")=True '### Users can subscribe themselves with their email address. Useful to provide a web-based storage service like FreeDrive. This option will create a FM account with the defaults defined in the database. 
Application("AutoMaintenance")=True '### Perform automatic maintenance on the database if AllowSubscriptions=True. Remove accounts (only non-admins): 1. Never used for 3 days and 2. Not logged in for 90 days). Make sure the time on the server is always OK!
Application("SMTPMailServer")= "Localhost" '### SMTP Mailserver to be used to send account information to users.
Application("SMTPAccount")= "user" '### SMTP Authentication account name
Application("SMTPPass")= "pass" '### SMTP Authentication account password
Application("ReplyToAddress")="info@domain.com" '### Email address used in reply-to field of email.
Application("ServiceURL")="http://www.domain.com" '### Home URL of the service. This address is mentioned in the email sent to users with their password.
Application("AllowedDomains")="" '### If defined: only email addresses in these domains are allowed to subscribe (Comma delimited list, for example:"dom1.org,dom2.com")
Application("DeniedDomains")="" '### If defined: only email addresses in these domains are rejected

'############################################################################################

'**Start Encode**
'### Check and format application vars ###
Application("FMVersion")="5.2a"
Application("NumLangEntries")=192 '### Maximum index of entries in the language file (UBound of array) to validate language files
Application("BgColorHeader")="000080"
Application("BgColorFolders")="DDDDEE"
Application("BgColorFiles")="EEEEF8"
Application("MaxEditSize")=2*1024*1024 '### Maximum file size for Edit. Slow for large files (>1MB).

Application("FMAppIsInitialized")=True
Application("AllowedIP")=Replace(Application("AllowedIP"),"*","")
Application("DeniedIP")=Replace(Application("DeniedIP"),"*","")
Application("UnEditableExtensions")= ","& Replace(Application("UnEditableExtensions")," ","") & ","
If Application("LogFile")<>"" AND Instr(Application("LogFile"),":\")=0 AND Instr(Application("LogFile"),"\\")=0 Then Application("LogFile")=Server.Mappath(Application("LogFile"))

Application("SettingNames")=Split("Create new folders, Create new text files, Allow upload, Beautify file names, Find items, Find text, Send to, Copy items, Cut items, Paste items, Rename items, Change attributes, Delete items, Zip functions, Manage folders, Config page, Show logout button, Show FM user info, Download items, View MDB files, Edit MDB files, Edit text files, Change password, Force overwrite/delete items, Show hidden items, Show system items,Change language , Show full date, Show inputbox, Show history list, Show property column headers, Show drive bar, Show copy list icon, Calculate folder size, Use FM recycler, Download in new window, Download instead of save, Return to last folder on login,Change pass on first login, Copy template on each login, Change email address, Show refresh button, Save name in cookie", ",")
Set fso=Server.CreateObject("Scripting.FileSystemObject")

'### ShortName property (8.3) Supported? ###
On Error Resume Next
Set f=fso.getfile(Server.Mappath("global.asa"))
t=f.ShortName
If err=0 Then Application("GetShortName")=True Else Application("GetShortName")=False

'### Get existing file type icons. ###
Set ofolder=fso.getfolder(Server.Mappath("Img"))
Set oFiles=oFolder.files
Application("TypeIcons")=VbTab
For each f in oFiles
	If UCase(fso.GetExtensionName(f))="GIF" AND Instr(1,f.name,"t_",1)=1 Then Application("TypeIcons")=Application("TypeIcons") & Mid(fso.getbasename(f),3) & VbTab
Next
Set oFiles=Nothing
Set ofolder=Nothing

'### Check if email component is installed ###
If ObjectExists("JMail.Message") AND Application("EmailEnabled") Then Application("EmailEnabled")=True Else Application("EmailEnabled")=False
If Application("AllowSubscriptions") AND Application("EmailEnabled") Then Application("AllowSubscriptions")=True Else Application("AllowSubscriptions")=False

'### Get available languages ###
Set ofolder=fso.getfolder(Server.Mappath("lang"))
Set oFiles=oFolder.files
For each f in oFiles
	If UCase(fso.GetExtensionName(f))="DAT" Then 
		s=fso.getbasename(f)
		s=UCase(Left(s,1)) & LCase(Mid(s,2))
		Application("LanguageList")=Application("LanguageList") & "<Option value=" & f.name & ">" & s
	End If
Next
Set oFiles=Nothing
Set ofolder=Nothing

'### Get language settings ###
ReDim aTmp(0)
f=Server.Mappath("lang/"& Application("DefaultLanguageFile"))
If fso.fileexists(f) Then
	Set fr=fso.OpenTextFile(f,1,False)
	aLines=Split(fr.readall,VbCrLf)
	fr.close
	For n = 0 To UBound(aLines)
		s=Trim(aLines(n))
		Pos=Instr(s,"=")
		If s<>"" AND Pos>1 AND Pos<10 AND left(s,1)<>"'" AND left(s,1)<>";" Then 
			If Instr(s,";") Then s=Left(s,Instr(pos,s,";",1)-1)
			If IsNumeric(Left(s,Pos-1)) Then
				i=Int(Left(s,Pos-1))
					If i>Hi Then
					Hi=i
					Redim Preserve aTmp(i)
				End If
				aTmp(i)=Trim(Mid(s,Pos+1))
			End If
		End If
	Next
	Application("Str")=aTmp
	Session("Str")=aTmp
End If
Application.Unlock
Set fso=Nothing
If Application("LogLevel")>0 Then WriteLogLine "Application started: FileMan " & Application("FMVersion")

End SUB

Sub Application_OnEnd
End Sub

'========================
Sub Session_OnStart
'========================
If Request.ServerVariables("HTTP_X_FORWARDED_FOR")<>"" Then
	Session("Proxy")="Proxy: " & Request.ServerVariables("HTTP_VIA") & VbTab  & Request.ServerVariables("REMOTE_ADDR")
	Session("IP")=Request.ServerVariables("HTTP_X_FORWARDED_FOR")
Else
	Session("IP")=Request.ServerVariables("REMOTE_ADDR")
End If
If Application("UseNTAuthentication") Then
	Session("NTUser")=Request.ServerVariables("AUTH_USER")
	If Instr(Session("NTUser"),"\")>0 Then Session("NTUser")=Mid(Session("NTUser"),Instrrev(Session("NTUser"),"\")+1)
Else
	Session("NTUser")=""
End If
Session("Str")=Application("Str") '### Set app language file as default for user unless defined otherwise in user profile.
Session("LanguageFile")=Application("DefaultLanguageFile")

'### Clean up accounts that were created more than n days ago, but never used
If Application("AutoMaintenance") AND Application("AllowSubscriptions") AND DateDiff("h", Application("LastMaint"),Now)>12 Then DatabaseMaintenance
End Sub

'========================
Sub Session_OnEnd
'========================
'On error resume next
If IsObject(Session("RS")) Then Set Session("RS")=Nothing
If Session("User")<>"" Then
	Set Conn=Server.CreateObject("ADODB.Connection")
    	Conn.Mode = 3
	Conn.Open Application("DBConnection")
	SQL= "UPDATE Login SET NumLogins=" & Session("NumLogins") & ", LastIP='" & Session("IP") & "', LanguageFile='" & Session("LanguageFile") & "', SortBy='" & Session("SortBy") & "',LastTime='" & Session("LoginTime") & "', LastDir='" & Session("Dir") & "', History='" & Replace(Session("History"),"'","''") & "' WHERE [User] ='" & Session("User") & "';"
	Conn.execute(SQL)
	Conn.Close
	Set Conn=Nothing
	If Application("LogLevel")>0 Then WriteLogLine "Logout"
	Application("NumConn")=Application("NumConn")-1
End If
End Sub

'========================
Function ObjectExists(oClass)
'========================
	On Error Resume Next
	Set obj=Server.CreateObject(oClass)
	If Err Then ObjectExists=False Else ObjectExists=True
	Set Obj=Nothing
End Function

'========================
Sub DatabaseMaintenance
'========================
	On error resume next
	Set fso=Server.CreateObject("Scripting.FileSystemObject")
	Application("LastMaint")=Now
	Set Conn =Server.CreateObject("ADODB.Connection")
	Conn.Mode = 3
	Conn.Open Application("DBConnection")
	'### Clean up all accounts that were created more than n days ago, but never used
	SQL= "Delete From LOGIN WHERE CrDate<#" & DateAdd("d",-3,Now()) & "# AND LastTime Is Null"
	Conn.Execute(SQL)
	If Application("LogLevel")>0 Then WriteLogLine "Database maintenance: " & SQL
	'### Clean up accounts that were not used for n days (not for admins!)
	Set RS = Server.CreateObject("ADODB.RecordSet")
	SQL= "SELECT [User],RootFolder,UserRootFolder From LOGIN INNER JOIN GROUPS ON Groups.GroupID = LOGIN.GroupID WHERE LastTime<#" & DateAdd("d",-90,Now()) & "# AND LastTime<>Null AND NOT Groups.IsAdmin"
	RS.Open SQL, Conn
	While not RS.EOF
		'### Delete RootFolder if configured
		RootFolder=Replace(RS("UserRootFolder") & "","%user%",RS("User"),1,-1,1)
		If RootFolder="" Then RootFolder=Replace(RS("RootFolder"),"%user%",RS("User"),1,-1,1)
		If Application("DeleteRootFolder") AND RootFolder<>"" Then
			If Right(RootFolder,1)="\" Then RootFolder=Left(RootFolder,Len(RootFolder)-1)
			If fso.Folderexists(RootFolder) Then fso.DeleteFolder RootFolder, True
		End If
		'### Delete account
		SQL="DELETE FROM Login WHERE [User]='" & RS("User") & "';"
		Conn.Execute(SQL)
		Application("NumAccounts")=Application("NumAccounts")-1
		If Application("LogLevel")>0 Then WriteLogLine "Database maintenance: " & SQL
		RS.movenext
	Wend
	RS.close
	Set RS=Nothing
	Conn.Close
	Set Conn=Nothing
	Set fso=Nothing
End Sub

'========================
SUB WriteLogLine(msg)
'========================
	If Application("LogFile")<>"" Then
		If err<>0 then sErr=VbTab & "Error: " & err.description Else sErr=""
		Set f=Server.CreateObject("Scripting.FileSystemObject")
		Set fLog=f.OpenTextFile(Application("LogFile"),8,True)
		fLog.WriteLine Now & Vbtab & Session("User") & Vbtab & Session("IP") & VbTab & msg & sErr
		fLog.close
		Set f=Nothing
	End If
End SUB
</SCRIPT>





