VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "DNSLookup"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit
'=================================================================================
'===  You may use and distribute this code, but you may not charge
'===  for it or present it as your own work. This notice should be retained.
'===  This source code is provided WITHOUT WARRANTY either expressed or implied.
'===  If you find any bugs in this code, please notify the author.
'===  This code is provided "As-Is" - if it doesn't work, we accept
'===  no responsibility, nor do we support it.
'===
'===  Purpose:  Perform DNS Lookup and Reverse Name Lookup
'===  Adapted:  Michael Meelis (michael@meelix.com)
'===  Updated:  12Apr01
'=================================================================================
Private Const ERROR_SUCCESS       As Long = 0
Private Const WS_VERSION_REQD     As Long = &H101
Private Const WS_VERSION_MAJOR    As Long = WS_VERSION_REQD \ &H100 And &HFF&
Private Const WS_VERSION_MINOR    As Long = WS_VERSION_REQD And &HFF&
Private Const MIN_SOCKETS_REQD    As Long = 1
Private Const SOCKET_ERROR        As Long = -1

Public WSError As Long

Private Type HOSTENT
    hName      As Long
    hAliases   As Long
    hAddrType  As Integer
    hLen       As Integer
    hAddrList  As Long
End Type

Private Type WSADATA
    wVersion As Integer
    wHighVersion As Integer
    szDescription As String * 257
    szSystemStatus As String * 129
    iMaxSockets As Long
    iMaxUdpDg As Long
    lpVendorInfo As Long
End Type

Private Declare Function gethostbyaddr Lib "wsock32.dll" (ByRef dwHost As Long, ByVal hLen As Integer, ByVal aType As Integer) As Long
Private Declare Function gethostname Lib "wsock32.dll" (ByVal szHost As String, ByVal dwHostLen As Long) As Long
Private Declare Function gethostbyname Lib "wsock32.dll" (ByVal szHost As String) As Long
    
Private Declare Function WSAGetLastError Lib "wsock32.dll" () As Long
Private Declare Function WSAStartup Lib "wsock32.dll" (ByVal wVersionRequired As Long, lpWSADATA As WSADATA) As Long
Private Declare Function WSACleanup Lib "wsock32.dll" () As Long
    
Private Declare Function inet_addr Lib "wsock32.dll" (ByVal szHost As String) As Long
Private Declare Function lstrlen Lib "kernel32" (ByVal lpString As Long) As Long
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (hpvDest As Any, ByVal hpvSource As Any, ByVal cbCopy As Long)


Public Function IsDnsResponsive() As Boolean
'=======================================================================================
'===  Purpose:  Check if we can reach a DNS and if it is responsive
'===  Note:     This is a workaround. gethostbyname and gethostbyaddr will return a 0
'===            for either a value not found in de DNS of if it can not contact a DNS.
'===            I haven't figured out how I can make the distinction, so here I will
'===            test an DNS entry that I am sure about that exists.
'===  Created:  MM 11Apr01
'=======================================================================================

    IsDnsResponsive = True
    If Len(IPLookup("meelix.com")) = 0 Then
        WSError = 1
        IsDnsResponsive = False
    End If

End Function

Public Function IPLookup(Optional ByRef sHost As Variant) As String
'=======================================================================================
'===  Purpose:  Resolves the host-name (or current machine if blank) to an IP address
'===  Updated:  MM 11Apr01
'=======================================================================================
Dim sHostName   As String * 256
Dim lpHost      As Long
Dim HOST        As HOSTENT
Dim dwIPAddr    As Long
Dim tmpIPAddr() As Byte
Dim i           As Integer
Dim sIPAddr     As String

    IPLookup = ""
    If Not SocketsInitialize() Then Exit Function

    If IsNull(sHost) Then sHost = ""
    If Len(sHost) > 0 Then
        '=== Prepare given DNS Name =============================
        sHostName = Trim$(CStr(sHost)) & Chr$(0)
    Else
        '=== No Name supplied, so take Name of local machine ====
        If gethostname(sHostName, 256) = SOCKET_ERROR Then
            GoTo Err_IPLookup_Winsock
        Else
            '=== Host name of this machine =======================
            sHostName = Trim$(sHostName)
        End If
    End If
    
    '=== Do the actual Winsock lookup ============================
    lpHost = gethostbyname(sHostName)
    If lpHost = 0 Then GoTo Err_IPLookup_Winsock

    '=== Convert value ===========================================
    CopyMemory HOST, lpHost, Len(HOST)
    CopyMemory dwIPAddr, HOST.hAddrList, 4

    ReDim tmpIPAddr(1 To HOST.hLen)
    CopyMemory tmpIPAddr(1), dwIPAddr, HOST.hLen

    For i = 1 To HOST.hLen
        sIPAddr = sIPAddr & tmpIPAddr(i) & "."
    Next

    '=== Return Value ============================================
    IPLookup = Mid$(sIPAddr, 1, Len(sIPAddr) - 1)


Exit_IPLookup:
    '=== Clean-up =================================================
    SocketsCleanup
    Exit Function
    
Err_IPLookup_Winsock:
    WSError = WSAGetLastError()
    GoTo Exit_IPLookup

End Function


        
Public Function ReverseLookup(ByRef sIPAddr As Variant) As String
'=====================================================================================
'===  Purpose:  Returns the host name for a given an IP address string
'===  Updated:  MM 11Apr01
'=====================================================================================
Dim dwIPAddr    As Long
Dim lpHost      As Long
Dim HOST        As HOSTENT
Dim WSErr        As Long

    ReverseLookup = ""
    If Not SocketsInitialize() Then Exit Function
    
    If IsNull(sIPAddr) Then sIPAddr = ""
    dwIPAddr = inet_addr(CStr(sIPAddr))
    
    '=== Ask Winsock to do the real work =================
    lpHost = gethostbyaddr(dwIPAddr, Len(dwIPAddr), 2)
    '=== Check for any returned errors ===================
    If lpHost = 0 Then
        GoTo Err_ReverseLookup_Winsock
    Else
        CopyMemory HOST, lpHost, Len(HOST)
        ReverseLookup = PointerToString(HOST.hName)
    End If
    
Exit_ReverseLookup:
    '=== Clean-up ========================================
    SocketsCleanup
    Exit Function
    
Err_ReverseLookup_Winsock:
    WSError = WSAGetLastError()
    GoTo Exit_ReverseLookup

End Function



Private Function PointerToString(lpString As Long) As String
'=================================================================
'===  Purpose:  The PointerToString function is used to convert a
'===            pointer to a string into a string variable
'=================================================================
Dim Buffer() As Byte
Dim nLen As Long
  
    If lpString Then
       nLen = lstrlen(lpString)
       If nLen Then
          ReDim Buffer(0 To (nLen - 1)) As Byte
          CopyMemory Buffer(0), ByVal lpString, nLen
          PointerToString = StrConv(Buffer, vbUnicode)
       End If
    End If

End Function



Private Function SocketsInitialize(Optional sErr As String) As Boolean
'=======================================================================
'===  Purpose:  Init Socket work
'=======================================================================
Dim WSAD As WSADATA
Dim sLoByte As String
Dim sHiByte As String
    
    SocketsInitialize = False
    
    If WSAStartup(WS_VERSION_REQD, WSAD) <> ERROR_SUCCESS Then
        sErr = "The 32-bit Windows Socket is not responding."
        Exit Function
    End If
    
    If WSAD.iMaxSockets < MIN_SOCKETS_REQD Then
        sErr = "This application requires a minimum of " & CStr(MIN_SOCKETS_REQD) & " supported sockets."
        Exit Function
    End If
    
    If LoByte(WSAD.wVersion) < WS_VERSION_MAJOR Or (LoByte(WSAD.wVersion) = WS_VERSION_MAJOR And _
            HiByte(WSAD.wVersion) < WS_VERSION_MINOR) Then
    
        sHiByte = CStr(HiByte(WSAD.wVersion))
        sLoByte = CStr(LoByte(WSAD.wVersion))
        sErr = "Sockets version " & sLoByte & "." & sHiByte & " is not supported by 32-bit Windows Sockets."
        Exit Function
    End If
    '=== All okay ==========
    SocketsInitialize = True

End Function


Private Function HiByte(ByVal wParam As Integer)
'===============================================
'===  Purpose:  Helper function
'===============================================
    HiByte = wParam \ &H1 And &HFF&
End Function


Private Function LoByte(ByVal wParam As Integer)
'===============================================
'===  Purpose:  Helper function
'===============================================
    LoByte = wParam And &HFF&
End Function


Private Sub SocketsCleanup()
'===============================================================
'===  Purpose:  Socket Clean up
'===============================================================
    If WSACleanup() <> ERROR_SUCCESS Then
        App.LogEvent "Socket error occurred in Cleanup.", vbLogEventTypeError
    End If

End Sub


