<%
Public Const DaysToShow = 3

Class Planner_Calendar_Schedular
%>
<!-- #INCLUDE FILE = "../inc/f_EscapeApostrophes.asp" -->
<%
	Private tmpDate

	Private Sub Class_Initialize()
		Call LoadSchedule()
	End Sub

	Public Property Get SelectedDate()
		SelectedDate = FormatDateTime(tmpDate, 1)
	End Property

	Private Property Let SelectedDate(byVal dDate)
		tmpDate = dDate
	End Property

	Private Function GetDaysInMonth(iMonth, iYear)
		Select Case iMonth
			Case 1, 3, 5, 7, 8, 10, 12
				GetDaysInMonth = 31
			Case 4, 6, 9, 11
				GetDaysInMonth = 30
			Case 2
				If IsDate("February 29, " & iYear) Then
					GetDaysInMonth = 29
				Else
					GetDaysInMonth = 28
				End If
		End Select
	End Function

	Private Function GetWeekdayMonthStartsOn(dAnyDayInTheMonth)
		Dim dTemp

		dTemp = DateAdd("d", _
			-(Day(dAnyDayInTheMonth) - 1), dAnyDayInTheMonth)
		GetWeekdayMonthStartsOn = WeekDay(dTemp)
	End Function

	Private Function SubtractOneMonth(dDate)
		SubtractOneMonth = DateAdd("m", -1, dDate)
	End Function

	Private Function AddOneMonth(dDate)
		AddOneMonth = DateAdd("m", 1, dDate)
	End Function

	Private Sub LoadSchedule()
		Dim dDate, i

		Select Case(lcase(request("action")))
			Case "addevent"
				' we are adding an event so redirect to the form
				Response.Redirect("./myCalendarForm.asp?date=" & request("date"))
			Case "delete"
				' we are deleting an entry
				Call deleteUsrEvent()
				response.redirect("./myCalendar.asp")
			Case Else
				'chances are we are just viewing the schedule...

				dDate = Request("date")
				if dDate = "" Or Not IsDate(dDate) then 
					dDate = FormatDateTime(date, 2)
				else
					dDate = FormatDateTime(dDate, 2)
				end if
				With Response
					.Write("<TABLE WIDTH=""100%"" CELLPADDING=1 CELLSPACING=1 BORDER=0><TR><TD WIDTH=""10%"" VALIGN=TOP>")
					.Write(ASP101Calendar)
					.Write("</TD><TD VALIGN=TOP ALIGN=CENTER>")
					.Write("<TABLE WIDTH=""100%"" BGCOLOR=""#60786B"" CELLPADDING=1 CELLSPACING=1 BORDER=0><TR>")
					For i = 0 to DaysToShow - 1
						.Write("<TD ALIGN=CENTER NOWRAP><FONT SIZE=1 COLOR=""#EEEEEE"" " & _
							"FACE=""tahoma, times, arial, helvetica"">" & _
							formatdatetime(DateAdd("d", i, dDate), 1) & _
							"</FONT></TD><TD ALIGN=RIGHT><A HREF=""./myCalendar." & _
							"asp?action=addEvent&date=" & _
							server.urlencode(formatdatetime(DateAdd("d", i, dDate), 2)) & _
							"""><FONT SIZE=1 COLOR=""#FFFFFF"">add<BR>event</FONT></A></TD>")
					Next
					.Write("</TR><TR>")
					For i = 0 to DaysToShow - 1
						.Write(MySchedule(DateAdd("d", i, dDate)))
					Next
					.Write("</TR></TABLE></TD></TR></TABLE>")
				End With
		End Select
	End Sub

	Private Sub DeleteUsrEvent()
		dim c, sSQL

		Set c = Server.CreateObject("adodb.connection")
		sSQL = "EXECUTE sp_remUsrEvent '" & EscapeApostrophes(session("user")) & "', " & request("ID")
		With c
			.Open ConnString, ConnUser, ConnPass
			.Execute sSQL
			.Close
		End With
		Set c = nothing
	End Sub

	Private Function ASP101Calendar()
		' #### Start Calendar ####
		' \\\\\\\\\\\\\\\\\\\\ start asp 101 calendar \\\\\\\\\\\\\\\\\\\\\\\
		' This is the calendar sample from ASP 101
		' http://www.asp101.com/samples/calendar.asp
		' I have made a few significant changes to this calendar code. I used this
		' calendar because I needed a calendar quick and I thought it would be useful
		' to show ASP beginners how to modify existing code to incorporate it into
		' a new or expanded idea. If I have in any way violated the ASP 101 license,
		' please send mail to me via the ASP Emporium feedback area:
		'           http://www.aspEmporium.com/aspEmporium/feedback/index.asp
		' This calendar has been modified from it's original form as follows:
		'  *  All response.writes were put into a string called strTemp, completely separating
		'     the calendar script from the resultant HTML page. This improved the loading 
		'     speed of the app (at least on my server).
		'  *  The colors were changed to reflect this site's design.
		'  *  The query strings were redesigned to make them all uniform by following this
		'     format: xx/xx/xx
		'     The old version used both xx-xx-xx and xx/xx/xx depending on whether you
		'     selected a day or prev/next month respectively by using the HTML links 
		'     on the calendar. Since I use the date to query a database, I want the date
		'     querystrings to be uniform.
		'  *  The date input form was removed although it could be really useful for this
		'     day planner app with a few modifications
		'I didn't change any of the calendar variables but 
		'I added 3 variables below
		Dim dDate     ' Date we're displaying calendar for
		Dim iDIM      ' Days In Month
		Dim iDOW      ' Day Of Week that month starts on
		Dim iCurrent  ' Variable we use to hold current day of month as we write table
		Dim iPosition ' Variable we use to hold current position in table
		'my new variables
		Dim iMyNewDate    ' holds new xx/xx/xx date format from the query string if we use the form
		Dim iNewFullDate  ' str that holds entire old date query string
		Dim iFinalNewDate ' proper date format for each day link on the calendar
		Dim strTemp

		strTemp = ""
		'Get selected date.  There are two ways to do this.
		'First check if we were passed a full date in RQS("date").
		'If so use it, if not look for seperate variables, putting them together into a date.
		'Lastly check if the date is valid...if not use today
		If IsDate(Request.QueryString("date")) Then
			dDate = CDate(Request.QueryString("date"))
		Else
			'changed the date string from "-" to "/"
			iMyNewDate = Request.QueryString("month") & "/" & _
			Request.QueryString("day") & "/" & _
			Request.QueryString("year")
			If IsDate(iMyNewDate) Then
				dDate = CDate(iMyNewDate)
			Else
				dDate = Date()
				'I use IIS4 so I deleted the old solution below
				'The elegant solution for those of you running IIS4
				If Request.QueryString.Count <> 0 Then strTemp = strTemp & "The date you " & _
				"picked was not a valid date.  The calendar was set to today's date.<BR><BR>"
			End If
		End If
		'Now we've got the date.
		'save selected date into properties
		SelectedDate = dDate


		'Now get Days in the chosen month and the day of the week it starts on.
		iDIM = GetDaysInMonth(Month(dDate), Year(dDate))
		iDOW = GetWeekdayMonthStartsOn(dDate)
		'put calendar into strTemp, trying to keep html formatting
		strTemp = strTemp & "<center>"
		strTemp = strTemp & "<TABLE BORDER=0 CELLSPACING=1 CELLPADDING=1 BGCOLOR=""#60786B"">" & vbCrLf
		strTemp = strTemp & vbTab & "<TR>" & vbCrLf
		strTemp = strTemp & vbTab & vbTab & "<TD BGCOLOR=""#60786B"" ALIGN=""center"" COLSPAN=7>" & vbCrLf
		strTemp = strTemp & vbTab & vbTab & vbTab & "<TABLE WIDTH=""100%"" BORDER=0 " & _
			"CELLSPACING=0 CELLPADDING=0>" & vbCrLf
		strTemp = strTemp & vbTab & vbTab & vbTab & vbTab & "<TR>" & vbCrLf
		strTemp = strTemp & vbTab & vbTab & vbTab & vbTab & vbTab & "<TD ALIGN=""right"">" & _
			"<A HREF=""" & request.serverVariables("SCRIPT_NAME") & _
			"?date=" & SubtractOneMonth(dDate) & """>" & _
			"<FONT COLOR=""#FFFF00"" SIZE=""-1"">" & _
			"&lt;&lt;</FONT></A></TD>" & vbCrLf
		strTemp = strTemp & vbTab & vbTab & vbTab & vbTab & vbTab & "<TD ALIGN=""center"">" & _
			"<FONT COLOR=""#FFFF00"" SIZE=2><B>" & MonthName(Month(dDate)) & "  " & Year(dDate) & "</B>" & _
			"</FONT></TD>" & vbCrLf
		strTemp = strTemp & vbTab & vbTab & vbTab & vbTab & vbTab & "<TD ALIGN=""left"">" & _
			"<A HREF=""" & request.serverVariables("SCRIPT_NAME") & "?date=" & _
			AddOneMonth(dDate) & """><FONT COLOR=""#FFFF00"" SIZE=""-1"">&gt;&gt;</FONT></A></TD>" & vbCrLf
		strTemp = strTemp & vbTab & vbTab & vbTab & vbTab & "</TR>" & vbCrLf
		strTemp = strTemp & vbTab & vbTab & vbTab & "</TABLE>" & vbCrLf
		strTemp = strTemp & vbTab & vbTab & "</TD>" & vbCrLf
		strTemp = strTemp & vbTab & "</TR>" & vbCrLf
		strTemp = strTemp & vbTab & "<TR>" & vbCrLf
		strTemp = strTemp & vbTab & vbTab & "<TD ALIGN=""center"" BGCOLOR=""#999999"">" & _
			"<FONT COLOR=""#FFFF00"" SIZE=2><B>Sun</B></FONT><BR><IMG SRC=""./images/spacer.gif"" " & _
			"WIDTH=30 HEIGHT=1 BORDER=0></TD>" & vbCrLf
		strTemp = strTemp & vbTab & vbTab & "<TD ALIGN=""center"" BGCOLOR=""#999999"">" & _
			"<FONT COLOR=""#FFFF00"" SIZE=2><B>Mon</B></FONT><BR><IMG SRC=""./images/spacer.gif"" " & _
			"WIDTH=30 HEIGHT=1 BORDER=0></TD>" & vbCrLf
		strTemp = strTemp & vbTab & vbTab & "<TD ALIGN=""center"" BGCOLOR=""#999999"">" & _
			"<FONT COLOR=""#FFFF00"" SIZE=2><B>Tue</B></FONT><BR><IMG SRC=""./images/spacer.gif"" " & _
			"WIDTH=30 HEIGHT=1 BORDER=0></TD>" & vbCrLf
		strTemp = strTemp & vbTab & vbTab & "<TD ALIGN=""center"" BGCOLOR=""#999999"">" & _
			"<FONT COLOR=""#FFFF00"" SIZE=2><B>Wed</B></FONT><BR><IMG SRC=""./images/spacer.gif"" " & _
			"WIDTH=30 HEIGHT=1 BORDER=0></TD>" & vbCrLf
		strTemp = strTemp & vbTab & vbTab & "<TD ALIGN=""center"" BGCOLOR=""#999999"">" & _
			"<FONT COLOR=""#FFFF00"" SIZE=2><B>Thu</B></FONT><BR><IMG SRC=""./images/spacer.gif"" " & _
			"WIDTH=30 HEIGHT=1 BORDER=0></TD>" & vbCrLf
		strTemp = strTemp & vbTab & vbTab & "<TD ALIGN=""center"" BGCOLOR=""#999999"">" & _
			"<FONT COLOR=""#FFFF00"" SIZE=2><B>Fri</B></FONT><BR><IMG SRC=""./images/spacer.gif"" " & _
			"WIDTH=30 HEIGHT=1 BORDER=0></TD>" & vbCrLf
		strTemp = strTemp & vbTab & vbTab & "<TD ALIGN=""center"" BGCOLOR=""#999999"">" & _
			"<FONT COLOR=""#FFFF00"" SIZE=2><B>Sat</B></FONT><BR><IMG SRC=""./images/spacer.gif"" " & _
			"WIDTH=30 HEIGHT=1 BORDER=0></TD>" & vbCrLf
		strTemp = strTemp & vbTab & "</TR>" & vbCrLf
		' Write spacer cells at beginning of first row if month doesn't start on a Sunday.
		If iDOW <> 1 Then
			strTemp = strTemp & vbTab & "<TR BGCOLOR=""#60786B"">" & vbCrLf
			iPosition = 1
			Do While iPosition < iDOW
				strTemp = strTemp & vbTab & vbTab & "<TD BGCOLOR=""#FFFFEE"">&nbsp;</TD>" & vbCrLf
				iPosition = iPosition + 1
			Loop
		End If
		'Write days of month in proper day slots
		iCurrent = 1
		iPosition = iDOW
		Do While iCurrent <= iDIM
			'If we're at the beginning of a row then write TR
			If iPosition = 1 Then
				strTemp = strTemp & vbTab & "<TR>" & vbCrLf
			End If
			'If the day we're writing is the selected day then highlight it somehow.
			If iCurrent = Day(dDate) Then
				strTemp = strTemp & vbTab & vbTab & "<TD BGCOLOR=""#EEEEEE"">"
				strTemp = strTemp & "<FONT SIZE=""-1""><B>" & iCurrent & "</B>"
				strTemp = strTemp & "</FONT><BR><BR></TD>" & vbCrLf
			Else
				'added 2 new variables to create uniform querystrings
				iNewFullDate = CStr(Month(dDate) & "/" & iCurrent & "/" & Year(dDate))
				iFinalNewDate = FormatDateTime(iNewFullDate, 2)
				strTemp = strTemp & vbTab & vbTab & "<TD BGCOLOR=""#FFFFEE"">" & _
					"<A HREF=""" & request.serverVariables("SCRIPT_NAME") & _
					"?date=" & iFinalNewDate & """><FONT SIZE=""-1"">" & iCurrent &  _
					"</FONT>" & "</A><BR><BR></TD>" & vbCrLf
			End If
			'If we're at the end of a row then write /TR
			If iPosition = 7 Then
				strTemp = strTemp & vbTab & "</TR>" & vbCrLf
				iPosition = 0
			End If
			'Increment variables
			iCurrent = iCurrent + 1
			iPosition = iPosition + 1
		Loop
		' Write spacer cells at end of last row if month doesn't end on a Saturday.
		If iPosition <> 1 Then
			Do While iPosition <= 7
				strTemp = strTemp & vbTab & vbTab & "<TD BGCOLOR=""#FFFFEE"">&nbsp;</TD>" & vbCrLf
				iPosition = iPosition + 1
			Loop
			strTemp = strTemp & vbTab & "</TR>" & vbCrLf
		End If
		strTemp = strTemp & "</TABLE>"
		' \\\\\\\\\\\\\\\\\\\\ end asp 101 calendar \\\\\\\\\\\\\\\\\\\\\\\
		' #### End Calendar ####
		ASP101Calendar = strTemp
	End Function

	Private Function MySchedule(byVal selDate)
		' #### Start Schedule System ####
		Dim dateToday, c, r, sql, strTemp, tTime1, tTime2
		
		dateToday = selDate
		strTemp = strTemp & "<TD VALIGN=TOP BGCOLOR=""#FFFFEE"" WIDTH=""25%"" COLSPAN=2>"
		if dateToday = "today" then dateToday = date()
		if not isdate(dateToday) then dateToday = date()
		sql = "EXECUTE sp_getUsrEvents '" & EscapeApostrophes(session("user")) & "', '" & cdate(dateToday) & "'"
		set c = server.createobject("adodb.connection")
		c.Open ConnString, ConnUser, ConnPass
		set r = c.Execute(sql)
		strTemp = strTemp & "<table width=""100%"" align=center cellpadding=0 cellspacing=0 border=0>"
		If r.BOF Then
			strTemp = strTemp & "<tr><td align=center><FONT SIZE=2>No events for <b>" & dateToday & "</b></FONT></td></tr>"
		else
			on error resume next
			Do While NOT r.BOF AND NOT r.EOF
				tTime2 = formatdatetime(r("eventTime"), 3)
				strTemp = strTemp & "<tr bgcolor=""#EEEEEE""><td align=left "
				strTemp = strTemp & "><font size=""1"">" & _
					tTime2 & "</font></td><td align=right><a href=""" & _
					"./myCalendar.asp?action=delete&ID=" & r("ID") & """>"
				strTemp = strTemp & "<font size=-2 face=arial>[delete event]</font></a></td></tr>"


				strTemp = strTemp & "<tr><td align=center colspan=2><font size=2><b>" & _
					cstr(r("eventTitle")) & "</b></font></td></tr>"
				strTemp = strTemp & "<tr><td colspan=2><font size=2>" & cstr(r("eventNotes")) & _
				"</font></td></tr><tr><td colspan=3>&nbsp;</td></tr>"
				r.MoveNext
			LOOP
			on error goto 0
		end if
		strTemp = strTemp & "</table>"
		strTemp = strTemp & "</TD>"
		r.close
		set r = nothing
		c.close
		set c = nothing
		' #### End Schedule System ####
		MySchedule = strTemp
	End Function
End Class
%>