<% Option Explicit %>
<!-- #include file="inc.common.asp" -->
<%
	
	' 
	' $Id: $
	' 
	' Sends new message to chat room.
	' 
	' @author	Peter Theill	peter@theill.com
	' 
	
	Response.Buffer = True
	
	Dim userId
	userId = CStr(Request("chatId"))
	
	If (NOT isLoggedIn(userId)) Then
		Response.Write("<font size=1>Please Wait ...</font>")
		Response.End
	End If
	
%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">

<html>
<head>
	<title><%= APPLICATION_NAME %></title>
	<link rel="stylesheet" type="text/css" href="css/chat.css">
	<script language="JavaScript1.2" type="text/javascript" src="js/update.js"></script>
	<script language="JavaScript1.2">
	<!--
		
		// using styles for messages being sent
		var boldStyle = false, italicStyle = false, underlineStyle = false;
		
		var justSent = false;
		
		function init() {
			setMessageFocus();
		}
		
		function setMessageFocus() {
			if (typeof document.frmControl != 'undefined' && typeof document.frmControl.message != 'undefined') {
				document.frmControl.message.focus();
			}
		}
		
		function sendMessage() {
		
			// collect required information
			var userId = document.frmControl.userId.value;
			var toUserId = document.frmControl.users.options[document.frmControl.users.selectedIndex].value;
			var message = document.frmControl.message.value;
			
			// show help window if user requests this
			if (message == '/help' || message == '/?') {
				openHelp();
				return;
			}
			
			// refresh view if user is sending an empty message
			if (message == '') {
				executeRequest('action=refresh,userId=' + userId);
				return;
			}
			
			// apply styles if appropriate
			if (boldStyle) {
				message = "<b>" + message + "</b>";
			}
			
			if (italicStyle) {
				message = "<i>" + message + "</i>";
			}
			
			if (underlineStyle) {
				message = "<u>" + message + "</u>";
			}
			
			// add new message to site
			executeRequest('action=refresh,mode=message,message=' + escape(message) + ',userId=' + userId + ',toUserId=' + toUserId);
			
			<% If (MESSAGE_FLOOD_TIMEOUT > 0) Then %>
				
				if (justSent) {
					alert('<%= getMsg("typing_too_fast") %>');
					return false;
				}
				
				// avoid users spamming by sending a lot of messages all the time
				justSent = true;
				setTimeout('justSent = false;', <%= MESSAGE_FLOOD_TIMEOUT %>);
				
			<% End If %>
			
			<% If (CLEAR_MESSAGE) Then %>
				
				clearMessageArea();
				
			<% End If %>
			
		} // > function sendMessage()
		
		
		function logOff() {
			
//			executeRequest('action=logoff,userId=<%= userId %>');
//			setTimeout('parent.location.replace("default.asp");', 1000);
			parent.location.replace("logout.active.asp");
			
		}
		
		function openHelp() {
			var mConquerChatHelp = window.open(
				'help.asp',
				mConquerChatHelp,
				'toolbar=no,width=380,height=380,resizable=0'
			);
			
			mConquerChatHelp.focus();
			
		} // > function openHelp()
		
		
		/**
		 *	Clears all text in message box.
		 *	
		 */
		function clearMessageArea() {
			if (typeof document.frmControl != 'undefined' && document.frmControl.message != 'undefined') {
				document.frmControl.message.value = '';
				return true;
			}
			
			return false;
		}
		
		function insertSmiley(s) {
			if (typeof document.frmControl != 'undefined' && document.frmControl.message != 'undefined') {
				document.frmControl.message.value += s;
			}
			
			setMessageFocus();
		}
		
		function toggleStyle(image, styleName) {
			
			var pressed = false;
			switch (styleName) {
				case "bold":
					pressed = boldStyle = !boldStyle;
					break;
					
				case "italic":
					pressed = italicStyle = !italicStyle;
					image.src = "images/ico.bold.down.gif";
					break;
					
				case "underline":
					pressed = underlineStyle = !underlineStyle;
					break;
			}
			
			image.src = "images/ico." + styleName + (pressed ? ".down" : "") + ".gif"
			
		}
		
		function onUsersChanged(data) {
			// data could be e.g. "1|Peter,2|Bill,3|Steve"
			
			// setup required data
			var slb = document.frmControl.users;
			var userId = document.frmControl.userId.value;
			var selectedUserId = slb.options[slb.selectedIndex].value;
			
			// build selection box
			for (var i = 0; i < slb.options.length; i++) {
				slb.options[i] = null;
			}
			
			slb.options[0] = new Option('<%= jsEncode(getMsg("users.all")) %>', '-1');
			
			if (data != undefined && data.length > 0) {
				var users = data.split(',');
				for (var i = 0, idx = 1; i < users.length; i++) {
					var user = users[i].split('|');
					if (user[0] != userId) {
						slb.options[idx] = new Option(user[1], user[0]);
						if (user[0] == selectedUserId) {
							slb.options[idx].selected = true;
						}
						
						idx++;
					}
				}
			}
		} // > function onUsersChanged(data)
		
	// -->
	</script>
</head>

<body onLoad="init()" class=message>
<div class=hdr>
	<%= getMsg("message.title") %>
</div>

<table border=0 cellspacing=8 cellpadding=0>
<form name="frmControl" onSubmit="sendMessage(); return false;">
<tr>
   	<td width="100%"><input type=text class="editField" name="message" style="width: 100%;" size="40" taborder="1"></td>
   	<td nowrap>
   		<input type=submit class=btn value="<%= getMsg("button.send") %>" taborder=2 name=submit border=0 title="Sends message">
   		<input type=button class=btn value="<%= getMsg("button.help") %>" onClick="openHelp(); return false;" border=0 title="Open Help window">
   		<input type=button class=btn value="<%= getMsg("button.logout") %>" onClick="logOff(); return false;" border=0 title="Logs out of chat">
   	</td>
</tr>
<tr>
	<td>
		<table border=0 cellspacing=0 cellpadding=0>
		<tr>
			<td>
				<select name=users>
					<option value="-1"><%= getMsg("users.initializing") %></option>
				</select>
			</td>
			<td>&nbsp;</td>
			<td>
				<img src="images/ico.bold.gif" width=16 height=16 border=0 class=lnk onClick="toggleStyle(this, 'bold')">
				<img src="images/ico.italic.gif" width=16 height=16 border=0 class=lnk onClick="toggleStyle(this, 'italic')">
				<img src="images/ico.underline.gif" width=16 height=16 border=0 class=lnk onClick="toggleStyle(this, 'underline')">
			</td>
			<td>&nbsp;</td>
			<td>
				<img src="images/smilies/dead.gif" width=16 height=16 border=0 class=lnk onClick="insertSmiley('xx(')">
				<img src="images/smilies/clown.gif" width=16 height=16 border=0 class=lnk onClick="insertSmiley(':o)')">
				<img src="images/smilies/smile.gif" width=16 height=16 border=0 class=lnk onClick="insertSmiley(':-)')">
				<img src="images/smilies/devil.gif" width=16 height=16 border=0 class=lnk onClick="insertSmiley(':-]')">
				<img src="images/smilies/biggrin.gif" width=16 height=16 border=0 class=lnk onClick="insertSmiley(':D')">
				<img src="images/smilies/frown.gif" width=16 height=16 border=0 class=lnk onClick="insertSmiley(':-(')">
				<img src="images/smilies/oh.gif" width=16 height=16 border=0 class=lnk onClick="insertSmiley(':O')">
				<img src="images/smilies/wink.gif" width=16 height=16 border=0 class=lnk onClick="insertSmiley(';-)')">
				<img src="images/smilies/tongue.gif" width=16 height=16 border=0 class=lnk onClick="insertSmiley(':P')">
			</td>
		</tr>
		</table>
	</td>
	<td></td>
</tr>

<!-- what action are being performed -->
<input type=hidden name="mode" value="message">

<!-- who are going to receive this message -->
<input type=hidden name=scope value="-1">

<!-- what is the unique identification of this user -->
<input type=hidden name=chatId value="<%= userId %>">
<input type=hidden name=userId value="<%= userId %>">

<!-- where are this user going? -->
<input type=hidden name=roomId value="-1">

</form>
</table>

</body>
</html>