<% 	Option Explicit %>
<!-- #include file="inc.common.asp" -->
<%
	
	' 
	' $Id: $
	' 
	' This page is the main entrace for ConquerChat. It shows a list of currently
	' logged in chatusers and makes it possible to log in by entering your user-
	' name in the appropriate field.
	' 
	' @author	Peter Theill	peter@theill.com
	' 
	
	Response.Buffer = True
	
	' many users does not read the included README.TXT file before trying to 
	' set up this chat -- in order to help them a bit we check if we have the
	' required objects properly initialised
	On Error Resume Next
	If (NOT IsObject(conquerChatUsers) OR NOT IsObject(conquerChatRooms)) Then
		Response.Redirect("errorInSetup.asp")
		Response.End
	End If
	
	Dim userId
	userId = Request("chatId")
	
	' do not show login screen if a valid session exists
	If (userId <> "") Then
		Response.Redirect "frames.asp?chatId=" & userId
		Response.End
	End If
	
	Dim i
	
	Dim mode, errorMessage
	mode = Request("mode")
	
	If (mode = "userLogin") Then
		
		Dim userName
		userName = Server.HTMLEncode(Request("username"))
		
		If (countUsers() >= USERS) Then
			errorMessage = getMsg("error.maximum_users_reached")
		ElseIf (Len(userName) = 0)  Then
			errorMessage = getMsg("error.missing_username")
		ElseIf (Len(userName) > MAX_USERNAME_LENGTH) Then
			errorMessage = getMsg("error.username_length_exceeded", MAX_USERNAME_LENGTH)
		ElseIf (userExists(userName)) Then
			errorMessage = getMsg("error.username_in_use")
		ElseIf (NOT isValidUsername(userName)) Then
			errorMessage = getMsg("error.invalid_username")
		ElseIf (isUserNameBlocked(userName)) Then
			errorMessage = getMsg("error.username_blocked")
		Else
			
			Dim p
			Set p = New Person
			p.id = -1
			p.name = userName
			p.roomId = 0
			p.ipAddress = Request.ServerVariables("REMOTE_ADDR")
			
			' we have a new chat user thus we need to create a new
			' id for him/her
			Set p = addUser(p)
			
			' tell all other users about this new user
			Call addMessage( _
				p.id, _
				"-1", _
				"<span class=LoggedIn><img src='images/new.gif' height=9 width=9>&nbsp;" & getMsg("user.logged_on", p.name, Now()) & "</span><br>" _
			)
			
			' redirect to new frame window and create a new user login
			Response.Redirect("frames.asp?chatId=" & p.id)
			Response.End
			
		End If
		
	End If ' > If (mode = "userLogin") Then
	
	' make sure we don't show any inactive users for new chat users
	kickInactiveUsers()
	
	If (conquerChatRooms.Count = 0) Then
		setupRooms()
	End If
	
%>
<html>
<head>
	<title><%= APPLICATION_NAME %></title>
	<link rel="stylesheet" type="text/css" href="css/chat.css">
	<script language="JavaScript1.2">
	<!--
		
		function init() {
			
			// set focus on 'username' field
			f = document.frmLogin;
			if (typeof f != 'undefined' && typeof f.username != 'undefined') {
				f.username.select();
				f.username.focus();
			}
		}
		
	// -->
	</script>
</head>

<body topmargin=0 leftmargin=0 marginwidth=0 marginheight=0 style="background-color: #CCCCCC" onLoad="init()">

<% If (Len(errorMessage) > 0) Then %>
<center>
	<br>
	<div class=err>
		<%= errorMessage %>
	</div>
</center>
<% End If %>

<table width=100% border=0 cellspacing=0 cellpadding=0 style="position: absolute; top: 90px">
<tr>
	<td style="font-size: 10px; font-weight: bold; color: 333333; text-align: right; padding-right: 8px; padding-bottom: 8px"><%= getMsg("login.join_chat", APPLICATION_NAME) %></td>
</tr>
<tr>
	<td style="background-color: #b3d68e; border-top: 1px dashed #ffffff; border-bottom: 1px dashed #ffffff" align=center>
		
		<br>
		
		<table width=240 border=0 cellspacing=0 cellpadding=2>
		<form name=frmLogin method=GET action="default.asp">
		<tr>
			<td>&nbsp;</td>
			<td align=right style="font-size: 10px;"><%= getMsg("login.username") %></td>
			<td width="100%"><input type=text name=username value="<%= Server.HTMLEncode(userName) %>" class=editField size=28 maxlength=32 tabindex=1></td>
			<td>&nbsp;</td>
		</tr>
		<tr>
			<td>&nbsp;</td>
			<td colspan=2 align=right><input type=submit class=btn name=login value="<%= getMsg("button.login") %>" border=0 tabindex=2></td>
			<td>&nbsp;</td>
		</tr>
		<input type=hidden name=mode value=userLogin>
		</form>
		<tr>
			<td>&nbsp;</td>
			<td colspan=2 align=center style="color: #999999;">
				<br>
				<br>
				<br>
			</td>
			<td>&nbsp;</td>
		</tr>
		<tr>
			<td>&nbsp;</td>
			<td colspan=2>
			
		<table width=100% border=0 cellspacing=0 cellpadding=4 style="border-right: 3px double #003300">
		<tr>
			<td colspan=3 class=uocap><%= getMsg("login.users_online") %></td>
		</tr>
		<% If (countUsers() <> 0) Then %>
		<tr>
			<th class=uo>&nbsp;</th>
			<th class=uo><%= getMsg("login.header.username") %></th>
			<th class=uo><%= getMsg("login.header.room") %></th>
		</tr>
		<%
			
			' display all users and their associated rooms
			
			Dim user, room_
			For Each userId In conquerChatUsers
				
				Set user = getUser(userId)
				Set room_ = getRoom(user.roomId)
				If (room_ Is Nothing) Then
					Set room_ = New Room
					room_.name = "N/A"
				End If
				
				Response.Write("<tr>")
				Response.Write(" 	<td class=uo width=24><nobr><img src='images/transparent.gif' width=8 height=16><img src='images/ico.user.gif' width=16 height=16 border=0></nobr></td>")
				Response.Write(" 	<td class=uo>" & user.name & "</td>")
				Response.Write(" 	<td class=uo>" & Server.HTMLEncode(room_.name) & "</td>" & vbCrLf)
				Response.Write("</tr>")
				
			Next
			
		%>
		<tr>
			<td class=uofoot colspan=3>
				<br>
				<%= getMsg("login.users_logged_on", countUsers(), USERS) %>
			</td>
		</tr>
		<% Else %>
		<tr>
			<td class=uo colspan=3>&nbsp;<%= getMsg("login.no_users_online") %></td>
		</tr>
		<% End If %>
		</table>	
			
			</td>
			<td>&nbsp;</td>
		</tr>
		</table>
		
		<br>
		
	</td>
</tr>
<tr>
	<td style="font-size: 10px; font-weight: lighter; text-align: justify;color: #666666; padding: 8px">
		This is the development version of ConquerChat -- you are able to log on to test the features of it but errors might occur since I'm working 
        directly on this one. This chat may not show the exact download source 
        either since&nbsp; I could be in the progress of developing additional 
        features. If you're interested in getting the <b>free ASP source code</b> 
        for this chat, visit the <a href="http://www.theill.com/asp/conquerchat.asp" style="font-weight: bolder">ConquerChat section</a> where you're able to download all versions.</td>
</tr>
</table>

<!-- Copyright(c) 2002, The Theill Web Site -->
<div style="position: absolute; bottom: 4px; right: 4px; padding: 4px; border: 3px dashed #bbbbbb;"><a href="http://www.theill.com/" target="_top"><img border="0" src="http://www.theill.com/images/ani_theillcom_scroll.gif" alt="Part of the Theill Web Site"></a></div>

</body>
</html>