<% Option Explicit %>
<!-- #include file="inc.common.asp" -->
<%
	
	' 
	' $Id: $
	' 
	' Controls all server-side processing when a user request list of users,
	' rooms, messages, etc.
	' 
	' @author	Peter Theill	peter@theill.com
	' 
	
	Dim userId, user
	userId = CStr(Request("userId"))
	
	If (NOT isLoggedIn(userId)) Then
		Response.Write("document.location.replace('" & PAGE_EXPIRED & "');")
		Response.End
	End If
	
	Set user = getUser(userId)
	
	'
	' Builds view to be shown as "list of available users"
	'
	'
	Function getUsersUI(userId)
	
		' we need to show all users available in this room
		Dim thisUser
		Set thisUser = getUser(userId)
		If (IsNull(thisUser)) Then
			Exit Function
		End If
		
		getUsersUI = "<table border=0 width=100% cellspacing=0 cellpadding=2>"
		
		Dim userId_
		For Each userId_ In conquerChatUsers
			Set user = getUser(userId_)
			If (user.roomId = thisUser.roomId) Then
				
				getUsersUI = getUsersUI & "<tr>"
				getUsersUI = getUsersUI & " <td><img src='images/" & getUserIcon(user) & "' width=16 height=16 border=0></td>"
				
				If (user.id = thisUser.id) Then
					' print users own name in bold
					getUsersUI = getUsersUI & " <td width=100% class=infoText><b>" & user.name & "</b>&nbsp;</td>"
				Else
					' users are able to send private messages to all other users
					' but themselves
					getUsersUI = getUsersUI & " <td width=100% class=infoText><a href=""javascript:openUserProfile('" & user.id & "', '" & thisUser.id & "')"">" & user.name & "</a>&nbsp;<a href=""javascript:openPrivateChat('" & thisUser.id & "', '" & user.id & "')"">(chat)</a></td>"
				End If
				
				getUsersUI = getUsersUI & "</tr>"
			End If
			
		Next ' // > For Each userId_ In conquerChatUsers
		
		getUsersUI = getUsersUI & "</table>"
		
	End Function ' // > Function getUsersUI(...)
	
	
	'
	'
	'
	Function getRoomsUI(userId)
		
		Dim user
		Set user = getUser(userId)
		
		getRoomsUI = "<table border=0 width=100% cellspacing=0 cellpadding=2>"
		
		Dim rooms, room, i
		rooms = conquerChatRooms.Keys
		If (IsArray(rooms)) Then
			For i = 0 To UBound(rooms)
				Set room = getRoom(rooms(i))
				
				getRoomsUI = getRoomsUI & "<tr>"
				
				If (room.createdBy <> user.id) Then
					getRoomsUI = getRoomsUI & " <td><img src='images/ico.room.gif' width=16 height=16 alt='" & Server.HTMLEncode(room.name) & "' border=0></td>"
				Else
					getRoomsUI = getRoomsUI & " <td><a href='rooms.asp?chatId=" & userId & "&action=remove&roomId=" & room.id & "' onClick=""return confirmRemoveRoom('" & Server.HTMLEncode(room.name) & "')""><img src='images/ico.room.remove.gif' width=16 height=16 alt='Remove " & Server.HTMLEncode(room.name) & "' border=0></a></td>"
				End If
				
				If (room.id = user.roomId) Then
					' this room is where the user is located so we make it bold
					getRoomsUI = getRoomsUI & " <td width=100% class=infoText><a href=""javascript:goToRoom('" & room.id & "')""><b>" & Server.HTMLEncode(room.name) & "</b></a></td>"
				Else
					getRoomsUI = getRoomsUI & " <td width=100% class=infoText><a href=""javascript:goToRoom('" & room.id & "')"">" & Server.HTMLEncode(room.name) & "</a></td>"
				End If
				
				getRoomsUI = getRoomsUI & "<td align=right class=infoText>" & countUsersInRoom(room.id) & "</td>"
				
				getRoomsUI = getRoomsUI & "</tr>"
			Next
		Else
			getRoomsUI = getRoomsUI & "<tr><td colspan=2>No rooms available</td></tr>"
		End If
		
		getRoomsUI = getRoomsUI & "</table>"
		
	End Function
	
	
	If (Request("mode") = "message") Then
		
		' a new message has been send to chat. We want this message to 
		' be added our list of messages, indicating which user send it
		
		Dim textMessage
		textMessage = Request("message")
		
		' do not add empty messages to chat
		If (Len(textMessage) > 0) Then
			
			If (DEBUG__) Then
				Response.Write("<br>userId      = " & user.id)
				Response.Write("<br>textMessage = " & textMessage)
				Response.Write("<br>user.roomId = " & user.roomId)
			End If
			
			If (Request("toUserId") = "" OR Request("toUserId") = "-1") Then
				Call addUserMessage(user.id, textMessage)
			Else
				Call addPrivateMessage(user.id, CStr(Request("toUserId")), textMessage)
			End If
			
		End If ' > If (Len(textMessage) > 0) Then
		
	End If
	
	
	
	' user wants to logoff, so we will have to notify all other users 
	' about this by printing some kind of 'user X is now logging off' 
	' message.
	If (Request("action") = "logoff") Then
		
		' add a leaving message to chatroom and remove user from list of active
		' users in this chat room
		logoutUser(user.id)
		
	End If
	
	kickInactiveUsers()
	
	If (countUsers() = 0 AND CLEAR_ON_EMPTY) Then
		
		' clear all messages in all rooms
		conquerChatMessages.RemoveAll
		
	End If
	
	If (Request("action") = "refresh") Then
		
		Response.Write("updateMessages('messages', '" & jsEncode(getMessages(user.roomId, user.id, NEWEST_MESSAGE_IN_TOP)) & "');")
		Response.Write("scrollToBottom('" & LCase(CStr(Not NEWEST_MESSAGE_IN_TOP)) & "');")
		
	End If
	
	If (Request("action") = "private.refresh") Then
		
		Dim touser
		Set touser = getUser(CStr(Request("toUserId")))
		
		Response.Write("updatePrivateMessages('messages', '" & jsEncode(getPrivateMessages(user.roomId, user.id, touser.id, NEWEST_MESSAGE_IN_TOP)) & "');")
		Response.Write("scrollToBottom('" & LCase(CStr(Not NEWEST_MESSAGE_IN_TOP)) & "');")
		
	End If
	
	If (Request("action") = "update.users") Then
		
		Response.Write("updateUsers('data', '" & jsEncode(getUsersUI(user.id)) & "');")
		
		Dim data, userId_, user_
		data = ""
		
		For Each userId_ In conquerChatUsers
			Set user_ = getUser(userId_)
			If (user_.roomId = user.roomId) Then
				data = data & user_.id & "|" & user_.name & ","
			End If
		Next
		
		If (Len(data) > 1) Then
			data = Left(data, Len(data)-1)
		End If
		
		Response.Write("onUsersChanged('" & data & "');")
		
	End If
	
	If (Request("action") = "update.rooms") Then
		
		Response.Write("updateRooms('data', '" & jsEncode(getRoomsUI(user.id)) & "');")
		
	End If
	
	
	' user clicked on a new room and thus we need to put the user into the 
	' selected room and refresh list of messages, users and rooms
	If (Request("action") = "room.switch") Then
		
		' get room destination
		Dim roomId
		roomId = Request("roomId")
		If (roomId = "") Then	' this ought not to happen, but ...
			roomId = u.roomId
		End If
		
		' switch to new room
		Call enterRoom(CStr(user.id), CStr(roomId))
		
		Response.Write("updateRooms('data', '" & jsEncode(getRoomsUI(user.id)) & "');")
		Response.Write("updateUsers('data', '" & jsEncode(getUsersUI(user.id)) & "');")
		Response.Write("updateMessages('messages', '" & jsEncode(getMessages(user.roomId, user.id, NEWEST_MESSAGE_IN_TOP)) & "');")
		Response.Write("scrollToBottom('" & LCase(CStr(Not NEWEST_MESSAGE_IN_TOP)) & "');")
		
	End If
	
%>