<%
'    ASP Template
'    Copyright (C) 2001  Valerio Santinelli
'
'    This program is free software; you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation; either version 2 of the License, or
'    (at your option) any later version.
'
'    This program is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.
'
'    You should have received a copy of the GNU General Public License
'    along with this program; if not, write to the Free Software
'    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
'
'   ---------------------------------------------------------------------------
'
' ASP Template main class file
'
' Author: Valerio Santinelli <tanis@mediacom.it>
' $Id: asptemplate.asp,v 1.2 2001/05/30 22:23:06 tanis Exp $
'

class ASPTemplate

	' Contains the error objects
	private p_error
	
	' Print error messages?
	private p_print_errors
	
	' Opening delimiter
	private p_opening_delimiter
	
	' Closing delimiter
	private p_closing_delimiter

	private p_start_block_delimiter_o
	private p_start_block_delimiter_c
	private p_end_block_delimiter_o
	private p_end_block_delimiter_c
	
	private p_int_block_delimiter
	
	private p_template
	
	private p_variables_list
	
	private p_blocks_list
	
	private p_blocks_name_list
	
	private sub class_Initialize
		p_print_errors = FALSE
		p_opening_delimiter = "{{"
		p_closing_delimiter = "}}"
		p_start_block_delimiter_o = "<!-- BEGIN "
		p_start_block_delimiter_c = " -->"
		p_end_block_delimiter_o = "<!-- END "
		p_end_block_delimiter_c = " -->"
		p_int_block_delimiter = "__"
		set p_variables_list = createobject("Scripting.Dictionary")
		set p_blocks_list = createobject("Scripting.Dictionary")
		set p_blocks_name_list = createobject("Scripting.Dictionary")
		p_template = Array()
	end sub
	
	public sub mSetTemplate(template)
		p_template = split(template, VbCrLf)
	end sub
	
	public sub mSetTemplateFile(inFileName)
		if len(inFileName) > 0 then
			dim FSO, oFile
			set FSO = createobject("Scripting.FileSystemObject")
			if FSO.FileExists(server.mappath(inFileName)) then
				set oFile = FSO.OpenTextFile(server.mappath(inFileName))
				p_template = split(oFile.ReadAll, VbCrLf)
				oFile.Close
				set oFile = Nothing
			else
				response.write "File is not existant!<br>"
			end if
			set FSO = nothing
		else
			'Filename was never passed!
		end if
		
	end sub
	
	public sub mSetVariable(s, v)
		if p_variables_list.Exists(s) then
			tmp = p_variables_list.Item(s) & v
			p_variables_list.Remove s
			p_variables_list.Add s, tmp
		else
			p_variables_list.Add s, v
		end if
	end sub
	
	public sub mSetVariableFile(s, inFileName)
		if len(inFileName) > 0 then
			dim FSO, oFile
			set FSO = createobject("Scripting.FileSystemObject")
			if FSO.FileExists(server.mappath(inFileName)) then
				set oFile = FSO.OpenTextFile(server.mappath(inFileName))
				mReplaceBlock s, oFile.ReadAll
				'p_template = split(oFile.ReadAll, VbCrLf)
				oFile.Close
				set oFile = Nothing
			else
				response.write "File is not existant!<br>"
			end if
			set FSO = nothing
		else
			'Filename was never passed!
		end if
	end sub

	public sub mReplaceBlock(s, inFile)
		tmp = join(p_template, VbCrLf)
		if instr(tmp, p_opening_delimiter & s & p_closing_delimiter) > 0 then
			tmp = replace(tmp, p_opening_delimiter & s & p_closing_delimiter, inFile)
		end if
		p_template = split(tmp, VbCrLf)
	end sub

	public sub mParse
		for each s_line in p_template
			mParseLine s_line
		next		
	end sub
	
	public sub mParseLine(inLine)
		inLine = mClearBlocks(inLine)
		tag_start = instr(inLine, p_opening_delimiter)
		if tag_start > 0 then
			s_line = left(inLine, tag_start - 1)
			tag_end = instr(inLine, p_closing_delimiter)
			s_line2 = mid(inLine, tag_end + Len(p_closing_delimiter))
			s_token = trim(mid(inLine, tag_start + Len(p_opening_delimiter), (tag_end - tag_start - Len(p_closing_delimiter))))
			'response.write "s_line: " & s_line & "<br>"
			'response.write "tag_start: " & tag_start & "<br>"
			'response.write "tag_end: " & tag_end & "<br>"
			'response.write "s_token: " & s_token & "<br>"
			Response.Write(s_line & VbCrLf)
			mGetToken(s_token)
			mParseLine(s_line2)
		else
			Response.Write(inLine & VbCrLf)
		end if		
	end sub

	private sub mGetToken(inToken)
		'This routine checks the Dictionary for the text passed to it.
		'If it finds a key in the Dictionary it Display the value to the user.
		'If not, by default it will display the full Token in the HTML source so that you can debug your templates.
		if p_variables_list.Exists(inToken) then
			Response.Write(p_variables_list.Item(inToken) & VbCrLf)
		else
			Response.Write("<!--[%" & inToken & "%]-->" & VbCrLf)
		end if
	end sub
	
	public sub mUpdateBlock(inBlockName)
		inLine = join (p_template, VbCrLf)
		t_start = p_start_block_delimiter_o & inBlockName & p_start_block_delimiter_c
		t_end = p_end_block_delimiter_o & inBlockName & p_end_block_delimiter_c
		tag_start = instr(inLine, t_start)
		tag_end = instr(inLine, t_end)
		if (tag_start > 0) and (tag_end > 0) then
			s_token = trim(mid(inLine, tag_start + Len(t_start), (tag_end - tag_start - Len(t_start))))
			'response.write "s_line: " & s_line & "<br>"
			'response.write "tag_start: " & tag_start & "<br>"
			'response.write "tag_end: " & tag_end & "<br>"
			'response.write "s_token: " & s_token & "<br>"
			p_blocks_list.Add inBlockName, s_token
			p_blocks_name_list.Add inBlockName, inBlockName
			inLine = left(inLine, tag_start-1) & "__" & inBlockName & "__" & mid(inLine, tag_end + Len(t_end))
			'Replace inLine, t_start & s_token & t_end, "__" & inBlockName & "__"
			'response.write "token: " & "|" &s_token & "|"
		end if
		p_template = split(inLine, VbCrLf)
	end sub

	public sub mParseBlock(inBlockName)
		inLine = join (p_template, VbCrLf)
		t_start = p_int_block_delimiter & inBlockName & p_int_block_delimiter
		t_end = p_int_block_delimiter & inBlockName & p_int_block_delimiter
		tag_start = instr(inLine, t_start)
		tag_end = instr(inLine, t_end)
		if (tag_start > 0) and (tag_end > 0) then
			's_token = trim(mid(inLine, tag_start + Len(t_start), (tag_end - tag_start - Len(t_start))))
			'response.write "s_line: " & s_line & "<br>"
			'response.write "tag_start: " & tag_start & "<br>"
			'response.write "tag_end: " & tag_end & "<br>"
			'response.write "s_token: " & s_token & "<br>"
			inLine = left(inLine, tag_start-1) & mGetBlock(inBlockName) & "__" & inBlockName & "__" & mid(inLine, tag_end + Len(t_end))
			'Replace inLine, t_start & s_token & t_end, "__" & inBlockName & "__"
			'response.write "token: " & "|" &s_token & "|"
		end if
		p_template = split(inLine, VbCrLf)
	end sub

	private property get mGetBlock(inToken)
		'This routine checks the Dictionary for the text passed to it.
		'If it finds a key in the Dictionary it Display the value to the user.
		'If not, by default it will display the full Token in the HTML source so that you can debug your templates.
		if p_blocks_list.Exists(inToken) then
			tmp = p_blocks_list.Item(inToken) & VbCrLf
			tmp_lines = split(tmp, VbCrLf)
			for each s_line in tmp_lines
				t_line = t_line & mParseBlockLine(s_line) & VbCrLf
				'response.write "s_line: " & s_line
			next		
			s = t_line
			's = join(tmp_lines, VbCrLf)
			mGetBlock = s
			'response.write "s: " & s
		else
			mGetBlock = "<!--__" & inToken & "__-->" & VbCrLf
		end if
	end property

	public property get mParseBlockLine(inLine)
		tag_start = instr(inLine, p_opening_delimiter)
		if tag_start > 0 then
			s_line = left(inLine, tag_start - 1)
			tag_end = instr(inLine, p_closing_delimiter)
			s_line2 = mid(inLine, tag_end + Len(p_closing_delimiter))
			s_token = trim(mid(inLine, tag_start + Len(p_opening_delimiter), (tag_end - tag_start - Len(p_closing_delimiter))))
			'response.write "s_line: " & s_line & "<br>"
			'response.write "tag_start: " & tag_start & "<br>"
			'response.write "tag_end: " & tag_end & "<br>"
			'response.write "s_token: " & s_token & "<br>"
			mParseBlockLine = s_line & VbCrLf
			mParseBlockLine = mParseBlockLine & mGetBlockToken(s_token)
			mParseBlockLine = mParseBlockLine & mParseBlockLine(s_line2)
		else
			mParseBlockLine = inLine & VbCrLf
		end if		
	end property

	private property get mGetBlockToken(inToken)
		'This routine checks the Dictionary for the text passed to it.
		'If it finds a key in the Dictionary it Display the value to the user.
		'If not, by default it will display the full Token in the HTML source so that you can debug your templates.
		if p_variables_list.Exists(inToken) then
			mGetBlockToken = p_variables_list.Item(inToken) & VbCrLf
			p_variables_list.Remove(inToken)
		else
			mGetBlockToken = "<!--[[%" & inToken & "%]]-->" & VbCrLf
		end if
	end property

	private property get mClearBlocks(inLine)
		found = FALSE
		a = p_blocks_name_list.Items
		for i = 0 to p_blocks_list.Count -1
		inBlockName = a(i)
		t_start = p_int_block_delimiter & inBlockName & p_int_block_delimiter
		t_end = p_int_block_delimiter & inBlockName & p_int_block_delimiter
		tag_start = instr(inLine, t_start)
		tag_end = instr(inLine, t_end)
		if (tag_start > 0) and (tag_end > 0) then
			's_token = trim(mid(inLine, tag_start + Len(t_start), (tag_end - tag_start - Len(t_start))))
			'response.write "s_line: " & s_line & "<br>"
			'response.write "tag_start: " & tag_start & "<br>"
			'response.write "tag_end: " & tag_end & "<br>"
			'response.write "s_token: " & s_token & "<br>"
			mClearBlocks = left(inLine, tag_start-1) & mid(inLine, tag_end + Len(t_end))
			'Replace inLine, t_start & s_token & t_end, "__" & inBlockName & "__"
			'response.write "token: " & "|" &s_token & "|"
			found = TRUE
		else
			'mClearBlocks = inLine
		end if
		next
		if found <> TRUE then
			mClearBlocks = inLine
		end if
	end property	
end class
%>