<!--#include file="includes/globals.asa"-->

<%

Function Exec_asprep_del_tblReport(intReportID, strErrDesc)
 Dim strSQL 
 Dim objCmd 
 Dim objCn  

	On Error Resume Next
	Set objCmd = Server.CreateObject("ADODB.Command")
	Set objCn = Server.CreateObject("ADODB.Connection")
	strSQL = "asprep_del_tblReport"

	objCn.Open g_strConnect
	With objCmd
		.Commandtext = strSQL
		.Commandtype = adCmdStoredProc
		Set .ActiveConnection = objCn

		.Parameters.Append .CreateParameter("RETURN_VALUE", adInteger, adParamReturnValue, 0)
		.Parameters.Append .CreateParameter("ReportID", adInteger, adParamInput, 4, intReportID)
		.Execute ,,adExecuteNoRecords
	
		Exec_asprep_del_tblReport = .Parameters("RETURN_VALUE")
	End With
	objCn.Close
	Set objCn = Nothing

	Set objCmd = Nothing
	
	If Err <> 0 Then
		Exec_asprep_del_tblReport = Err.Number
		strErrDesc = Err.description
	End If
End Function

Function Exec_asprep_ins_tblReport(strReportName, strProcName, strCategory, strErrDesc)
 Dim strSQL 
 Dim objCmd 
 Dim objCmdParams
 Dim objCn  
 Dim intReportID	

	On Error Resume Next
	Set objCmd = Server.CreateObject("ADODB.Command")
	Set objCmdParams = Server.CreateObject("ADODB.Command")
	Set objCn = Server.CreateObject("ADODB.Connection")
	strSQL = "asprep_ins_tblReport"

	objCn.Open g_strConnect
	With objCmd
		.Commandtext = strSQL
		.Commandtype = adCmdStoredProc
		Set .ActiveConnection = objCn

		.Parameters.Append .CreateParameter("RETURN_VALUE", adInteger, adParamReturnValue, 0)
		.Parameters.Append .CreateParameter("ReportID", adInteger, adParamInputOutput, 4, Null)
		.Parameters.Append .CreateParameter("ReportName", adVarChar, adParamInput, 75, strReportName)
		.Parameters.Append .CreateParameter("ProcName", adVarChar, adParamInput, 75, strProcName)
		.Parameters.Append .CreateParameter("Category", adVarChar, adParamInput, 75, strCategory)
     	.Execute ,,adExecuteNoRecords
	
		Exec_asprep_ins_tblReport = .Parameters("RETURN_VALUE")
		intReportID = .Parameters("ReportID")
	End With
	Set objCmd = Nothing
	
	'	Let's add the parameters to the parameter table
	lngRetVal = AddParams(strProcName, intReportID, strErrDesc)
	
	If lngRetVal <> 0 Then 
		Response.Redirect "Error.asp?ErrNum=" & lngRetVal & "&ErrDesc=" & strErrDesc
		lngRetVal = 0
	End If
	
	objCn.Close
	Set objCn = Nothing

	If Err <> 0 Then
		Exec_asprep_ins_tblReport = Err.Number
		strErrDesc = Err.description
		Response.Write strErrDesc
	End If
End Function

Function Exec_asprep_upd_tblReport(intReportID, strReportName, strProcName, strCategory, strErrDesc)
 Dim strSQL 
 Dim objCmd 
 Dim objCn 
 Dim lngRetVal

	On Error Resume Next
	Set objCmd = Server.CreateObject("ADODB.Command")
	Set objCn = Server.CreateObject("ADODB.Connection")
	strSQL = "asprep_upd_tblReport"

	objCn.Open g_strConnect
	With objCmd
		.Commandtext = strSQL
		.Commandtype = adCmdStoredProc
		Set .ActiveConnection = objCn

		.Parameters.Append .CreateParameter("RETURN_VALUE", adInteger, adParamReturnValue, 0)
		.Parameters.Append .CreateParameter("ReportID", adInteger, adParamInput, 4, intReportID)
		.Parameters.Append .CreateParameter("ReportName", adVarChar, adParamInput, 75, strReportName)
		.Parameters.Append .CreateParameter("ProcName", adVarChar, adParamInput, 75, strProcName)
		.Parameters.Append .CreateParameter("Category", adVarChar, adParamInput, 75, strCategory)
		.Execute ,,adExecuteNoRecords
	
		Exec_asprep_upd_tblReport = .Parameters("RETURN_VALUE")
	End With

	'	Let's add the parameters to the parameter table upon INSERT
	lngRetVal = AddParams(strProcName, intReportID, strErrDesc)
	
	objCn.Close
	Set objCn = Nothing

	Set objCmd = Nothing
	
	If Err <> 0 Then
		Exec_asprep_upd_tblReport = Err.Number
		strErrDesc = Err.description
	End If
End Function

Function Exec_asprep_upd_tblReportParams(intParamID, intControlType, strControlSource, boRequired, strErrDesc)
 Dim strSQL 
 Dim objCmd 
 Dim objCn  

	On Error Resume Next
	Set objCmd = Server.CreateObject("ADODB.Command")
	Set objCn = Server.CreateObject("ADODB.Connection")
	strSQL = "asprep_upd_tblReportParams"

	objCn.Open g_strConnect
	With objCmd
		.Commandtext = strSQL
		.Commandtype = adCmdStoredProc
		Set .ActiveConnection = objCn
		
		.Parameters.Append .CreateParameter("RETURN_VALUE", adInteger, adParamReturnValue, 0)
		.Parameters.Append .CreateParameter("ParamID", adInteger, adParamInput, 4, intParamID)
		.Parameters.Append .CreateParameter("ControlType", adUnsignedTinyInt, adParamInput, 1, intControlType)
		.Parameters.Append .CreateParameter("ControlSource", adVarChar, adParamInput, 75, strControlSource)
		.Parameters.Append .CreateParameter("Required", adBoolean, adParamInput, 1, 0)
		.Execute ,,adExecuteNoRecords
	
		Exec_asprep_upd_tblReportParams = .Parameters("RETURN_VALUE")
	End With
	objCn.Close
	Set objCn = Nothing

	Set objCmd = Nothing
	
	If Err <> 0 Then
		Exec_asprep_upd_tblReportParams = Err.Number
		strErrDesc = Err.description
	End If
End Function

Function Exec_asprep_ins_tblReportParams(intReportID, strParamName,  strErrDesc)
 Dim strSQL 
 Dim objCmd 
 Dim objCn  

	On Error Resume Next
	Set objCmd = Server.CreateObject("ADODB.Command")
	Set objCn = Server.CreateObject("ADODB.Connection")
	strSQL = "asprep_ins_tblReportParams"

	objCn.Open g_strConnect
	With objCmd
		.Commandtext = strSQL
		.Commandtype = adCmdStoredProc
		Set .ActiveConnection = objCn

		.Parameters.Append .CreateParameter("RETURN_VALUE", adInteger, adParamReturnValue, 0)
		.Parameters.Append .CreateParameter("ParamID", adInteger, adParamInputOutput, 4, Null)
		.Parameters.Append .CreateParameter("ReportID", adInteger, adParamInput, 4, intReportID)
		.Parameters.Append .CreateParameter("ParamName", adVarChar, adParamInput, 75, strParamName)
		.Execute ,,adExecuteNoRecords
	
		Exec_asprep_ins_tblReportParams = .Parameters("RETURN_VALUE")
	End With
	objCn.Close
	Set objCn = Nothing

	Set objCmd = Nothing
	
	If Err <> 0 Then
		Exec_asprep_ins_tblReportParams = Err.Number
		strErrDesc = Err.description
	End If
End Function

Function Exec_asprep_del_tblReportParams(intReportID, strErrDesc)
 Dim strSQL 
 Dim objCmd 
 Dim objCn  

	On Error Resume Next
	Set objCmd = Server.CreateObject("ADODB.Command")
	Set objCn = Server.CreateObject("ADODB.Connection")
	
	strSQL = "asprep_del_tblReportParams"

	objCn.Open g_strConnect
	
	
	With objCmd
		.Commandtext = strSQL
		.Commandtype = adCmdStoredProc
		Set .ActiveConnection = objCn

		.Parameters.Append .CreateParameter("RETURN_VALUE", adInteger, adParamReturnValue, 0)
		.Parameters.Append .CreateParameter("ReportID", adInteger, adParamInput, 4, intReportID)
		.Execute ,,adExecuteNoRecords
	
		Exec_asprep_del_tblReportParams = .Parameters("RETURN_VALUE")
	End With
	
	objCn.Close
	Set objCn = Nothing

	Set objCmd = Nothing
	
	If Err <> 0 Then
		Exec_asprep_del_tblReportParams = Err.Number
		strErrDesc = Err.Description
	End If
End Function

Function AddParams(strProcName, intReportID, strErrDesc)
 Dim lngRetVal
 Dim objCmdParams
 Dim objCn
 Dim n
 
	On Error Resume Next
	Set objCmdParams = Server.CreateObject("ADODB.Command")
	Set objCn = Server.CreateObject("ADODB.Connection")
	
	objCn.open g_strConnect
 
	If Err = 0 Then
		'	First delete any existing param info in tblReportParams

		lngRetVal = Exec_asprep_del_tblReportParams(intReportID, strErrDesc)

		If lngRetVal <> 0 Then 
			Response.Redirect "Error.asp?ErrNum=" & lngRetVal & "&ErrDesc=" & strErrDesc
			lngRetVal = 0
		End If
	
		'	Now gather up parameter info.
		With objCmdParams
			.Commandtext = strProcName
			.Commandtype = adCmdStoredProc
			Set .ActiveConnection = objCn
			.Parameters.Refresh
			
			For n =1 to .Parameters.Count -1	'	we want to skip RETURN_VALUE
				
				'	Add to tblReportParams
				lngRetVal = Exec_asprep_ins_tblReportParams(intReportID, Replace(objcmdparams.Parameters(n).name,"@",""), strErrDesc)
				
				If lngRetVal <> 0 Then 
					Response.Redirect "Error.asp?ErrNum=" & lngRetVal & "&ErrDesc=" & strErrDesc
					lngRetVal = 0
				End If
			Next
	
		End With
	End If
	
	If Err <> 0 Then
		AddParams = Err.Number
		strErrDesc = Err.description
	End If
End Function

%>



