<%
Function LoadINIFile(ByVal strINIFileName)

	Dim objFileSys, objTextFile
	Dim strBuffer, strHdrBuffer, varPairValue
	Dim vINIFile
	
	Set objFileSys = CreateObject("Scripting.FileSystemObject")
	Set objTextFile = objFileSys.OpenTextFile(strINIFileName, 1)
	
	Do while Not objTextFile.AtEndOfStream
		strBuffer = Trim(objTextFile.ReadLine)
		If strBuffer <> "" Then
			'There is data on this line
			If Left(strBuffer, 1) <> ";" And Left(strBuffer, 1) <> "<" Then
				'It's not a comment or an ASP line
				If Left(strBuffer, 1) = "[" Then
					'It's a section header
					strHdrBuffer = Mid(strBuffer, 2, Len(strBuffer) - 2)
				Else
					'It's a value
					strBuffer = Split(strBuffer,"=",2)
					vINIFile = vINIFile & strHdrBuffer & "|" & strBuffer(0) & "|" & strBuffer(1) & "|"
				End If
	    	End If
	    End If
	Loop
	
	objTextFile.Close
	Set objTextFile = Nothing
	Set objFileSys = Nothing
	
	LoadINIFile = vINIFile
	
End Function

Function IniFileValue(ByVal vINIFile, ByVal strSectionName, ByVal strKeyName)

	Dim vArray
	Dim n
	
	vArray = Split(vINIFile, "|")

	For n = LBound(vArray) To UBound(vArray)-1 Step 3
		If UCase(vArray(n)) = UCase(strSectionName) And UCase(vArray(n+1)) = UCase(strKeyName) Then
			IniFileValue = vArray(n+2)
			Exit For
		End If
	Next
  
End Function

Function OutputINISection(ByVal vINIFile, ByVal strSectionName)

	Dim vArray
	Dim n
	Dim strOutput
	
	vArray = Split(vINIFile, "|")

	For n = LBound(vArray) To UBound(vArray)-1 Step 3
		If UCase(vArray(n)) = UCase(strSectionName) Then
			strOutput = strOutput & Server.URLEncode(vArray(n+1)) & "=" & Server.URLEncode(vArray(n+2)) & "&"
		End If
	Next
	OutputINISection = strOutput & "Result=OK"
	
End Function
%>