<%
'*******************************************************
'*     ASP 101 Sample Code - http://www.asp101.com     *
'*                                                     *
'*   This code is made available as a service to our   *
'*      visitors and is provided strictly for the      *
'*               purpose of illustration.              *
'*                                                     *
'* Please direct all inquiries to webmaster@asp101.com *
'*******************************************************
%>

<%
' I've got some pretty lame validation going here, but I've set
' it up so you can easily implement any criteria you want.
Function ValidateField(sFieldValue, sFieldType)
	Dim bFieldIsOkay
	
	' defaut it to true
	bFieldIsOkay = True
	
	' go to the field name to validate the entry
	Select Case LCase(sFieldType)
		Case "name"
			If Len(sFieldValue) = 0 Then bFieldIsOkay = False
		Case "email"
			If Len(sFieldValue) < 5 Then
				bFieldIsOkay = False
			Else
				If Instr(1, sFieldValue, " ") <> 0 Then
					bFieldIsOkay = False
				Else
					If InStr(1, sFieldValue, "@") < 2 Then
						bFieldIsOkay = False
					Else
						If InStrRev(sFieldValue, ".") < InStr(1, sFieldValue, "@") + 2 Then
							bFieldIsOkay = False
						End If
					End If
				End If
			End If
			' Previous validation code
			'If Len(sFieldValue) < 5 Then
			'	bFieldIsOkay = False
			'Else
			'	If InStr(1, sFieldValue, "@", 1) < 2 Then
			'		bFieldIsOkay = False
			'	Else
			'		If InStr(1, sFieldValue, ".", 1) < 4 Then
			'			bFieldIsOkay = False
			'		End If
			'	End If
			'End If
		Case "address"
			If Len(sFieldValue) = 0 Then bFieldIsOkay = False
		Case "city"
			If Len(sFieldValue) = 0 Then bFieldIsOkay = False
		Case "state"
			If Len(sFieldValue) <> 2 Then bFieldIsOkay = False
		Case "zip"
			If Len(sFieldValue) <> 5 And Len(sFieldValue) <> 10 Then
				bFieldIsOkay = False
			End If
			' Don't use cause of 00000-0000
			'If Not IsNumeric(sFieldValue) Then bFieldIsOkay = False
		Case Else 'if an unknown type gets in reject form!
			bFieldIsOkay = False
	End Select

	ValidateField = bFieldIsOkay
End Function

' Little helper function to save me from typing out each field.
' I'm lazy... so sue me!
Sub ShowFormField(strField)
' This function needs access to the dictFields object!
	%>
	<TR>
		<TD ALIGN="right"><B><%= strField %>:</B>&nbsp;</TD>
		<TD><INPUT NAME="<%= strField %>" TYPE="text" VALUE="<%= Request.Form(strField) %>"></INPUT></TD>
		<TD><%
		If dictFields(LCase(strField)) Then
			Response.Write "<IMG SRC=""../images/check.gif"" BORDER=""0"" WIDTH=""25"" HEIGHT=""25"">"
		End If
		%></TD>
	</TR>
	<%
End Sub
%>

<%' Begin Runtime Code

' If you just want to check the fields and don't care about which fields
' failed, try a series using this type of syntax:
'Dim bFormIsOkay 'As Boolean
'bFormIsOkay = True
'bFormIsOkay = bFormIsOkay And ValidateField("John", "name")
'bFormIsOkay = bFormIsOkay And ValidateField("john_doe@some_domain.com", "e-mail")
'bFormIsOkay = bFormIsOkay And ValidateField("NY", "state")
'
' At the end, if bFormIsOkay is True, everything checked out, o/w it didn't


' I want to maintain a list of failures so my code's not going to be
' quite as nice and neat, but I'm going to be pulling a different trick
' to save me some typing!  Check out the For Each Loop!  What do you want?
' I already said I was lazy!

Dim Field      'looping variable
Dim dictFields 'dictionary for failed fields

Set dictFields = Server.CreateObject("Scripting.Dictionary")
		
' We never need to ask for fields by name and their names
' identify them to the validation script!
For Each Field in Request.Form
	If ValidateField(Request.Form(Field), Field) = False Then
		dictFields.Add LCase(Field), True
	End If
Next 'Field

' Troubleshooting lines - left in for when you break it!
'Response.Write Request.Form.Count
'Response.Write dictFields.Count

' Check to be sure fields were entered (Request.Form.Count <> 0)
' and correctly (dictFields.Count = 0)
' If so we process the form, o/w we show the form with checks showing
' fields to be fixed.
If Request.Form.Count <> 0 And dictFields.Count = 0 Then

' Some people have reported problems using Request.Form.Count
' Validating a required field instead should work just as well:
'If Request.Form("name") <> "" And dictFields.Count = 0 Then

	' Process Input
	' This is where you'd actually do something!
	' I'm not overly creative, so I just write it out to the browser
	%>
	<B>Your entry meets our validation criteria!</B><BR>
	<BR>This would naturally be the point where your just entered data
	would be getting logged to a file, inserted into a database, mailed
	off to someone, or whatever your plans for it might happen to be!
	Since we're just playing with the form here, I simply show it below.<BR>
	<BR>
	<B>Here's what you entered:</B><BR>
	<%
	' Loop through the fields writing out the field name and value.
	For Each Field In Request.Form
		Response.Write Field & ": " & Request.Form(Field) & "<BR>" & vbCrLf
	Next 'Field
Else
	' Two possible reasons for us to be here
	' 1. It's their first visit to the page - show the form with no check marks.
	' 2. They've entered data and validation failed - show why in form below!

	' If they entered some data, and we're still here, then
	' they must have made a mistake.  Tell them so:
	If Request.Form.Count <> 0 Then
		%>
		I'm sorry but your form wasn't filled out correctly.
		Please correct the fields indicated by the check marks.
		<%
	End If
	
	' Show thw form with checks if appropriate
	%>
	<FORM ACTION="<%= Request.ServerVariables("Script_Name") %>" METHOD="post" NAME="TheForm">

	<TABLE BORDER="0" CELLSPACING="0" CELLPADDING="0">
	<%
	' This was done mearly to save myself some typing and to ensure a uniform
	' look and feel.  You'll find the ShowFormField function directly above
	' the beginning of the run time code
	ShowFormField("Name")
	ShowFormField("Email")
	ShowFormField("Address")
	ShowFormField("City")
	ShowFormField("State")
	ShowFormField("Zip")
	%>
	</TABLE>
	<INPUT TYPE="reset" VALUE="Reset The Form"></INPUT>
	<INPUT TYPE="submit" VALUE="Submit The Form"></INPUT><BR>
	<BR>
	<INPUT TYPE="button" VALUE="Enter Invalid Data!" OnClick="return FillInTheFormBad()"></INPUT>
	<INPUT TYPE="button" VALUE="Enter Valid Data!" OnClick="return FillInTheFormGood()"></INPUT><BR>
	</FORM>
	<%
End If

' Just to make life a little easier for our visitors, we've added two buttons.
' One's attached to each script below.  The first simulates a user typing in
' information which fails to meet or criteria in a couple of places.  The second
' simulates data which, as far as were concerned, is fine for whatever
' processing we decide to do to it.
%>
<SCRIPT LANGUAGE="Javascript">
<!--
//Us doing client-side script!  Did you ever thing you'd see the day?

//Enter Bad Data Into the Form
function FillInTheFormBad() {
	document.TheForm.Name.value = "John";
	document.TheForm.Email.value = "john@some_domaincom";
	document.TheForm.Address.value = "123 Main Street";
	document.TheForm.City.value = "Any Town";
	document.TheForm.State.value = "New York";
	document.TheForm.Zip.value = "1111";
}

//Enter Good Data Into the Form
function FillInTheFormGood() {
	document.TheForm.Name.value = "John";
	document.TheForm.Email.value = "john@some_domain.com";
	document.TheForm.Address.value = "123 Main Street";
	document.TheForm.City.value = "Any Town";
	document.TheForm.State.value = "NY";
	document.TheForm.Zip.value = "11111";
}
//-->
</SCRIPT>
