<%
'*---------------------------------------------------------------------------------------------*
'| -> RA|AdmUser v 1.0 Beta                                                                        | 
'|                                                                                             |
'|   Exemplo de um Sistema de Administrao On-line de Usurios, utilizando o ASP 3.0 com o    |
'| banco de dados MS Access 2000, com funes em VBScript e ADO.                               |
'|                                                                                             |
'| Autor : Rodrigo Almeida     E-mail : rodrigo@clickmidia.com  Site : rodrigo.clickmidia.com  | 
'|                                                                                             |
'*---------------------------------------------------------------------------------------------*

'Aqui vamos determinar que s sero utilizadas as variveis declaradas no sistema abaixo. Se
'existir outra varivel no declarada, o sistema te retornar um erro.
Option Explicit

'Abaixo esto as variveis globais que utilizaremos
Dim Caminho, Conexao, Selecao, Check, OK, SQLEstatistica, Estatisticas

'Informando o tipo de driver utilizado na conexo com o banco e o seu caminho fsico.
Caminho="Provider=Microsoft.Jet.OLEDB.4.0;" & "Data Source=" & Server.MapPath ("banco.mdb")

'Criando o conjunto de conexo junto ao servidor e abrindo a conexo com o banco.
Set Conexao=Server.CreateObject ("ADODB.Connection")
Conexao.ConnectionString = Caminho
Conexao.Open

'Varivel Selecao, far o trabalho de selecionar quais as funes que o usurio quer, tudo
'isso  permitido por outra varivel chamada Opcao, onde est por meio de uma QueryString
Selecao = Request.QueryString ("Opcao")

'Rotina para validar os Campos do Formulrio de Login do Usurio.
Sub ValidacaoLogin ()

'Se os campos esto vazios, emitir uma mensagem de erro.
If (Request.Form("Login")="" Or Request.Form("Senha")="") Then
  With Response
   .Write "<br><br><br>"
   .Write "<font color='red' size='3'><center>"
   .Write "Os campos devem ser preenchidos corretamente."
   .Write "<br><Br>"
   .Write "<a href='javascript:history.back (-1)'>Voltar a Pgina Inicial</a>"
   .Write "</center>"
  End With
 Response.End
 Else

'Se forem preenchidos corretamente, validar a transao.
  Check=OK

End If

End Sub

'Rotina de Validao do formulrio de incluso de Usurio
Sub ValidacaoInclusao ()

'Se os campos esto vazios, emitir uma mensagem de erro.
If (Request.Form("ILogin")="" Or Request.Form("ISenha")="" Or Request.Form("IIdade")="" Or Request.Form("INome")="" Or Request.Form("ISexo")="0") Then
  With Response
   .Write "<br><br><br>"
   .Write "<font color='red' size='3'><center>"
   .Write "Os campos devem ser preenchidos corretamente."
   .Write "<br><Br>"
   .Write "<a href='javascript:history.back (-1)'>Voltar a Pgina Inicial</a>"
   .Write "</center>"
  End With
 Response.End
 Else

'Se forem preenchidos corretamente, validar a transao.
  Check=OK

End If

End Sub

'Rotina de Validao do formulrio de Alterao de Usurio
Sub ValidacaoAlteracao ()

'Se os campos esto vazios, emitir uma mensagem de erro.
If (Request.Form("AId")="") Then
  With Response
   .Write "<br><br><br>"
   .Write "<font color='red' size='3'><center>"
   .Write "Os campos devem ser preenchidos corretamente."
   .Write "<br><Br>"
   .Write "<a href='javascript:history.back (-1)'>Voltar a Pgina Inicial</a>"
   .Write "</center>"
  End With
 Response.End
 Else

'Se forem preenchidos corretamente, validar a transao.
  Check=OK

End If

End Sub

'Rotina de Validao do formulrio de Excluso do Usurio
Sub ValidacaoExclusao ()

'Se os campos esto vazios, emitir uma mensagem de erro.
If (Request.Form("EId")="") Then
  With Response
   .Write "<br><br><br>"
   .Write "<font color='red' size='3'><center>"
   .Write "Os campos devem ser preenchidos corretamente."
   .Write "<br><Br>"
   .Write "<a href='javascript:history.back (-1)'>Voltar a Pgina Inicial</a>"
   .Write "</center>"
  End With
 Response.End
 Else

'Se forem preenchidos corretamente, validar a transao.
  Check=OK

End If

End Sub

'Rotina de Validao do formulrio de Consulta do Usurio
Sub ValidacaoConsulta ()

'Se os campos esto vazios, emitir uma mensagem de erro.
If (Request.Form("Quantidade")="" Or Request.Form("Pesquisa")="0" Or Request.Form("DadoPesquisa")="") Then
  With Response
   .Write "<br><br><br>"
   .Write "<font color='red' size='3'><center>"
   .Write "Os campos devem ser preenchidos corretamente."
   .Write "<br><Br>"
   .Write "<a href='javascript:history.back (-1)'>Voltar a Pgina Inicial</a>"
   .Write "</center>"
  End With
 Response.End
 Else

'Se forem preenchidos corretamente, validar a transao.
  Check=OK

End If

End Sub

'Rotina da Sada do sistema, onde abrimos conexo com o banco de dados para registrar o
'ltimo acesso do usurio dentro do sistema. Tambm iremos destruir a Session do usurio.
Public Sub Sair ()

Dim RecSet, SQL

SQL="SELECT Id, Cod, Data FROM Usuario WHERE Cod='"&Session("Usuario")&"'"

Set RecSet=Server.CreateObject ("ADODB.RecordSet")
RecSet.Open SQL, Conexao, 3, 3

RecSet("Data")=now()
RecSet.Update

RecSet.Close
Set RecSet = Nothing

Session.Abandon

Response.Redirect ("index.asp")

End Sub

'Rotina de Login do usurio, apartir daqui, ser de onde ele ter acesso ou no ao sistema,
'nesse parte, vc ter que criar um session, no caso, chamada Session("Usuario"), para dizer
'se o usurio est logado ou no e dar as permisses de acesso.
Private Sub Login ()

Dim RecSet, SQL, Login, Senha

Login=(TRIM(Request.Form("Login")))
Senha=(TRIM(Request.Form("Senha")))

SQL="SELECT Login, Senha, Id FROM Usuario WHERE Login='"&Login&"' And Senha='"&Senha&"'"

Set RecSet=Server.CreateObject ("ADODB.RecordSet")
RecSet.Open SQL, Conexao, 3, 3

'Verificando se existe o usurio com o Login e Senha no banco de dados
If RecSet.EoF Then
  With Response
   .Write "<br><br><br><br>"
   .Write "<center><font color='red' size='4'>ERRO! Usurio no existente.</font></center>"
   .Write "<br><br><br>"
   .Write "<center><a href='index.asp'>Voltar</a></center>"
  End With

 Else

'Criando o Registro do Usuario dentro do sistema 
 Session("Usuario") = RecSet("Id")
'Chamando a pgina, onde ter as opes do sistema.
 Call Identificacao()

 RecSet.Close
 Set RecSet = Nothing
End If

End Sub

'Criando uma funo para calcular a Idade total dos Usurios e a Idade Mdia
'Percebe-se abaixo que utilizei algumas funes do ADO e VBScript.
Private Function IdadeUsuario ()

Dim SQLIdade, Idades, Idade, Media

SQLIdade="SELECT Id, Login, Nome, Data, Idade FROM Usuario"  

Set Idades=Server.CreateObject ("ADODB.RecordSet")
Idades.Open SQLIdade, Conexao, 3, 3

Do While Not Idades.EoF
 Idade = CInt(Idades("Idade")) + Idade
Idades.MoveNext
Loop

Media=(Idade/Idades.RecordCount)

Idades.Close
Set Idades = Nothing

Response.Write "Idade Total dos usurios do sistema  de<font color='red'> " & Idade & " </font>anos."
Response.Write "<br><br>"
Response.Write "Idade Mdia dos usurios do sistema  de<font color='red'> " & Round(Media, 2) & " </font>anos."

End Function

'Criao da funo para calcular quantos usurios de cada sexo existe dentro do sistema.
'A Lgica foi a mesma que a de cima, utilizando as funes de ADO e VBScript. Porm
'usando 2 objetos de conexo com o Servidor, para pegar as informaes.
Private Function SexoUsuario ()

Dim SQLMSexo, SQLFSexo, MSexo, FSexo

SQLMSexo = "SELECT Sexo FROM Usuario WHERE Sexo='M'"
SQLFSexo = "SELECT Sexo FROM Usuario WHERE Sexo='F'"

Set MSexo=Server.CreateObject ("ADODB.RecordSet")
MSexo.Open SQLMSexo, Conexao, 3, 3

Set FSexo=Server.CreateObject ("ADODB.RecordSet")
FSexo.Open SQLFSexo, Conexao, 3, 3

Do While Not MSexo.EoF And FSexo.EoF

MSexo("Sexo")
FSexo("Sexo")

MSexo.MoveNext
FSexo.MoveNext
Loop

Response.Write "Total de Usurios do Sexo <b>Masculino</b> :<font color='red'> " & MSexo.RecordCount & "</font><br><br>"
Response.Write "Total de Usurios do Sexo <b>Feminino</b> :<font color='red'> " & FSexo.RecordCount & "</font><br><br>"

MSexo.Close
FSexo.Close
Set MSexo = Nothing
Set FSexo = Nothing

End Function

'Est rotina  muito importante, pois aqui ser a interface do sistema com o usurio, onde ficar
'todas as opes de utilizao e estatsticas do sistema, assim como Seu Login, Ultimo acesso,
'idade e sexo.
Private Sub Identificacao ()

Dim RecSet, SQL

SQL="SELECT Id, Cod, Login, Nome, Sexo, Idade, Data FROM Usuario WHERE Cod='"&Session("Usuario")&"'"

Set RecSet=Server.CreateObject ("ADODB.RecordSet")
RecSet.Open SQL, Conexao, 3, 3

'Interface do sistema em HTML
With Response 
 .Write "<html><head>"
 .Write "<title>USURIO : " & RecSet("Nome") & "</title>"
 .Write "<body bgground='white' cellppading='0' face='arial'>"
 .Write "<font size='6' color='blue'><b>Sistema de Administrao de Usurios</b></font><br><br>"
 .Write "Ol,<font color='red'><b> " & RecSet("Nome") & "</b></font> ! Seja Bem-Vindo."
 .Write " Hoje  <b>" & FormatDateTime (Date(),vblongDate) & "</b>"
 .Write "<br><br>"
 .Write "* <b><i>Suas Informaes </i></b>: <br><br>"
 .Write "Sexo : <i><font color='red'>" & RecSet("Sexo") & "</font></i><br>"
 .Write "Idade : <i><font color='red'>" & RecSet("Idade") & "</font></i><br>"
 .Write "Seu ltimo acesso no sistema : <i><font color='red'>" & RecSet("Data") & "</font></i>."
 .Write "<br><br><br>"
 .Write "* <b><i>Opes do Sistema</i></b>: <br><br>"
 .Write "<center>"
 .Write "<a href='nucleo.asp?Opcao=Sair'> Sair </a> | "
 .Write "<a href='nucleo.asp?Opcao=Incluir'> Incluir Usurio </a> | "
 .Write "<a href='nucleo.asp?Opcao=Alterar'> Alterar Usurio </a> | "
 .Write "<a href='nucleo.asp?Opcao=Excluir'> Excluir Usurio </a> | "
 .Write "<a href='nucleo.asp?Opcao=Consultar'> Consultar Usurio </a> | "
 .Write "<a href='nucleo.asp?opcao=Visualizar'> Visualizar Usurios</a> "
 .Write "</center><br><br>"
 .Write "* <b><i>Estatsticas do Sistema</i></b>: <br><br>"

'Calculando as estatsticas do sistema, calculando o total de usurio e chamando as funes
'IdadeUsuario() e SexoUsuario() 
 SQLEstatistica="SELECT Id, Login, Nome, Data, Idade FROM Usuario"  

 Set Estatisticas=Server.CreateObject ("ADODB.RecordSet")
 Estatisticas.Open SQLEstatistica, Conexao, 3, 3
 
 .Write "Total de Usurios Cadastrados no Banco de Dados : <font color='red'>" & Estatisticas.RecordCount & "</font>"
 .Write "<br><br>"
 .Write IdadeUsuario () 
 .Write "<br><br>"
 .Write SexoUsuario ()

 Estatisticas.MoveLast 

 .Write "ltimo Usurio Cadastrado no Sistema : <font color='red'>" & Estatisticas("Login") & "</font>"
 
 Estatisticas.Close
 Set Estatisticas = Nothing
 
 .Write "<br>"
 .Write "<hr>"
 .Write "<font size='2' face='arial, helvetica, sans-serif'>"
 .Write "<center>Sistema Exemplo desenvolvido por : <b><font color='orange'>Rodrigo Almeida</font></b></center><br>"
 .Write "<center><i>E-Mail : </i><font color='gray'><b><a href='mailto:rodrigo@clickmidia.com'>rodrigo@clickmidia.com</a></b></font>"
 .Write " <i>Website :</i> <a href='http://rodrigo.clickmidia.com' target='_blank'> Rodrigo Almeida - Website</a></center>"
 .Write "</font>"
 .Write "</body>"
 .Write "</html>"
End With

RecSet.Close
Set Recset = Nothing

End Sub

'Rotina de interface para retirar as informaes de cadastro dos usurios
Private Sub Inclusao ()

With Response
 .Write "<html>"
 .Write "<head>"
 .Write "<title>INSERIR USURIO</title>"
 .Write "</head>"
 .Write "<body bgground='white' cellppading='0'>"
 .Write "<br>"
 .Write "<font color='blue' size='6'>INSERIR USURIO</font>"
 .Write "<br><br>"
 .Write "<form action='nucleo.asp?Opcao=AdicionarUsuario' method='post'>"
 .Write "<b>Nome : </b><br>"
 .Write "<input type='text' name='INome' maxlength='50'><br>"
 .Write "<b>Login : </b><br>"
 .Write "<input type='text' name='ILogin' maxlength='20'><br>"
 .Write "<b>Senha : </b><br>"
 .Write "<input type='password' name='ISenha' maxlength='8'><br>"
 .Write "<b>Sexo : </b><br>"
 .Write "<Select name='ISexo'>"
 .Write "<option value='0' Selected>:: Escolha o Sexo</option>"
 .Write "<option value='M'>- Masculino</option>"
 .Write "<option value='F'>- Feminino</option>"
 .Write "</select><br>"
 .Write "<b>Idade : </b><br>"
 .Write "<input type='text' name='IIdade' maxlength='2'><br><br>"
 .Write "<input type='Submit' name='Enviar' value='Cadastrar'>"
 .Write "</form>"
 .Write "</body>"
 .Write "</html>"
End With

End Sub

'Rotina importante, pois aqui, que o sistema ir incluir, alterar e deletar o usurio, dentro
'da funo existe uma varivel que j vimos onde selecionar a opo desejada do usurio, tudo
'utilizando conexes com o ADO, comandos DML e objetos do ADO. Atrves das condies IF, se pode
'saber o caminho exato de cada formulrio solicito.
Private Sub Usuario ()

Dim RecSet, SQL, Contador, Opcao

Opcao = Request.QueryString ("Opcao")

'Condio para incluso dos usurios. Para dar um desempenho melhor ao sistema, no utilizei
'no banco de dados o AUTO-INCREMENTO, ento eu mesmo fiz o controle dos usurios utilizando
'programao.
If (Opcao="AdicionarUsuario") Then
 
   Contador = 0

   SQL="SELECT Id, Cod, Login, Senha, Nome, Sexo, Idade, Data FROM Usuario"

   Set RecSet=Server.CreateObject ("ADODB.RecordSet")
   RecSet.Open SQL, Conexao, 3, 3

   RecSet.MoveLast
   Contador = Recset("Cod")

   RecSet.AddNew
   RecSet("Cod") = Contador + 1
   RecSet("Id") = RecSet("Cod")
   RecSet("Login") = TRIM(Request.Form("ILogin"))
   RecSet("Senha") = TRIM(Request.Form("ISenha"))
   RecSet("Nome") = TRIM(Request.Form("INome"))
   RecSet("Sexo") = Request.Form("ISexo")
   RecSet("Idade") = Request.Form("IIdade")
   RecSet("Data") = now() 
   RecSet.Update
   RecSet.MoveNext

   RecSet.Close
   Set RecSet = Nothing
'Enviando a resposta para o usurio de que foi incluido com sucesso e redirecionamento automatico
'para a rotina Principal()
   Call Redirecionamento()
End If

'Condio para inserir as alteraes do usurio no banco de dados.
If (Opcao="ConcluirAlteracao") Then
 
   SQL = "SELECT Id, Cod, Login, Senha, Nome, Sexo, Idade, Data " 
   SQL = SQL & "FROM Usuario WHERE Cod='"&TRIM(Request.Form("AId"))&"'"

   Set RecSet=Server.CreateObject ("ADODB.RecordSet")
   RecSet.Open SQL, Conexao, 3, 3

   RecSet("Login") = TRIM(Request.Form("ALogin"))
   RecSet("Senha") = TRIM(Request.Form("ASenha"))
   RecSet("Nome") = TRIM(Request.Form("ANome"))
   RecSet("Sexo") = Request.Form("ASexo")
   RecSet("Idade") = Request.Form("AIdade")
   RecSet("Data") = now() 
   RecSet.Update

   RecSet.Close
   Set RecSet = Nothing

   Call Redirecionamento()
End If

'Condio de excluso de usurio
If (Opcao="ConfirmarExclusao") Then
 
   SQL = "SELECT Id, Cod, Login, Senha, Nome, Sexo, Idade, Data " 
   SQL = SQL & "FROM Usuario WHERE Cod='"&TRIM(Request.Form("EId"))&"'"

   Set RecSet=Server.CreateObject ("ADODB.RecordSet")
   RecSet.Open SQL, Conexao, 3, 3

   RecSet.Delete
   RecSet.Update

   RecSet.Close
   Set RecSet = Nothing

   Call Redirecionamento()
End If

End Sub

'Rotina de redirecionamento de pgina aps algum evento no banco de dados.
Public Sub Redirecionamento ()

'Redirecionar para a rotina Principal
Response.AddHeader "REFRESH","2;URL=nucleo.asp?Opcao=Principal"

With Response
 .Write "<br><br><br><br><br><br>"
 .Write "<html><head><title>Redirecionamento...</title></head><body>"
 .Write "<font color='red' size='4' face='arial'>"
 .Write "<center><b>Pgina sendo redirecionada em<i> 5 </i>s.</b></center><br><br>"
 .Write "</font><center>As informaes foram executadas com sucesso.</center>"
 .Write "</body></html>"
End With

End Sub

'Rotina de interface com o usurio para a alterao do usurio
Private Sub Alteracao ()
 With Response
  .Write "<br><br><br><br>"
  .Write "<center>"
  .Write "<form action='nucleo.asp?Opcao=AlterarUsuario' method='post'>"
  .Write "Entre com a Identificao do Usurio abaixo.<br><br>"
  .Write "<input type='text' name='AId' maxlegenth='4'><br><br>"
  .Write "<input type='submit' name='Enviar' value='Prximo Passo'>"
  .Write "</center></form>"
 End With
End Sub

'Rotina que ir retirar as informaes a serem alteradas.
Private Sub AlterarDados ()

Dim RecSet, SQL, Usuario

Usuario=TRIM(Request.Form("AId"))

SQL="SELECT Cod, Id, Nome, Idade, Login, Senha, Sexo FROM Usuario WHERE Cod='"&Usuario&"'"

Set RecSet=Server.CreateObject ("ADODB.RecordSet")
RecSet.Open SQL, Conexao, 3, 3

'Verificando se a Identificao do usurio existe no sistema
If RecSet.EoF Then
  With Response
   .Write "<br><br><br><br>"
   .Write "<center><font color='red' size='4'>ERRO! Usurio no existente no sistema.</font></center>"
   .Write "<br><br><br>"
   .Write "<center><a href='nucleo.asp?Opcao=Principal'>Voltar</a></center>"
  End With

 Else
 
 With Response
 .Write "<html>"
 .Write "<head>"
 .Write "<title>ALTERAR USURIO</title>"
 .Write "</head>"
 .Write "<body bgground='white' cellppading='0'>"
 .Write "<br>"
 .Write "<font color='blue' size='3'>ALTERAR DADOS DO USURIO : </font><b>" & RecSet("Nome") & "</b>"
 .Write "<br><br>"
 .Write "<form action='nucleo.asp?Opcao=ConcluirAlteracao' method='post'>"
 .Write "<b>Identificao : </b><br>"
 .Write "<input type='text' name='AId' maxlength='4' value='"&RecSet("Id")&"' readonly='true'><br>"
 .Write "<b>Nome : </b><br>"
 .Write "<input type='text' name='ANome' maxlength='50' value='"&RecSet("Nome")&"'><br>"
 .Write "<b>Login : </b><br>"
 .Write "<input type='text' name='ALogin' maxlength='20' value='"&RecSet("Login")&"'><br>"
 .Write "<b>Senha : </b><br>"
 .Write "<input type='text' name='ASenha' maxlength='8' value='"&RecSet("Senha")&"'><br>"
 .Write "<b>Sexo : </b><br>"
 .Write "<Select name='ASexo'>"
 .Write "<option value='"& RecSet ("Sexo")&"' Selected>Sexo Atual :"&RecSet("Sexo")&"</option>"
 .Write "<option value='M'>- Masculino</option>"
 .Write "<option value='F'>- Feminino</option>"
 .Write "</select><br>"
 .Write "<b>Idade : </b><br>"
 .Write "<input type='text' name='AIdade' maxlength='2' value='"&RecSet("Idade")&"'><br><br>"
 .Write "<input type='Submit' name='Enviar' value='Alterar dados'>"
 .Write "</form>"
 .Write "</body>"
 .Write "</html>"
 End With

End If

RecSet.Close
Set RecSet = Nothing

End Sub

'Rotina de interface com o usurio para saber qual usurio ser deletado.
Private Sub Exclusao ()
 With Response
  .Write "<br><br><br><br>"
  .Write "<center>"
  .Write "<form action='nucleo.asp?Opcao=ConfirmarExclusao' method='post'>"
  .Write "Entre com a Identificao do Usurio para excluir do sistema.<br><br>"
  .Write "<input type='text' name='EId' maxlegenth='4'><br><br>"
  .Write "<input type='submit' name='Enviar' value='Deletar Usurio'>"
  .Write "</center></form>"
 End With
End Sub

'Rotina simples para saber todos os usurios cadastrados no sistema, junto com sua informaes.
Private Sub Visualizar ()

Dim RecSet, SQL, Contador

SQL = "SELECT Id, Nome, Login, Idade, Sexo FROM Usuario Order by Nome ASC"

Set RecSet=Server.CreateObject ("ADODB.RecordSet")
RecSet.Open SQL, Conexao, 3, 3

Contador = 0

With Response
 .Write "<html><head>" 
 .Write "<title>VISUALIZAO DOS USURIOS DO SISTEMA</title>" 
 .Write "</head><body bgground='white' cellppading='0'>" 
 .Write "<font face='arial' size='3' color='blue'>Visualizao de todos os usurios</font>" 
 .Write "<br><br>" 
 .Write "<b>Nome, Idade,Sexo e sua Identificao entre () :</b>"
 .Write "<br><br>"
 Do While Not Recset.EoF
  Contador = Contador + 1
   .Write "<font color='orange'><b>" & Contador & "  -</b></font> " 
   .Write RecSet ("Nome") & ", " & RecSet("Idade") & ", " & RecSet("Sexo")
   .Write ". (<font color='red'> " & RecSet("Id") & "</font> )"
   .Write " - <b>Login de Acesso</b> : <font color='red'>" & Recset("Login") & "</font>"
   .Write "<br>"
 RecSet.MoveNext
 Loop
 .Write "<br><br>"
 .Write "<center><a href='nucleo.asp?Opcao=Principal'>Voltar para a Principal</a></center>"
 .Write "</body>" 
 .Write "</html>" 
End With

RecSet.Close
Set RecSet = Nothing

End Sub

'Rotina de consulta de usurios, aqui voc pode determinar em que campo quer pesquisar, por NOME
'ou Login, e dependendo da sua consulta, ele retorna a consulta do modo que escolheu, com as
'informaes pedidas. E ainda atrves dela, vc pode estabelecer quantos registros deveram 
'aparecer na consulta.
Private Sub Consulta ()

'Interface de consulta
With Response
 .Write "<html><head>" 
 .Write "<title>Consultar usurios</title>" 
 .Write "</head><body bgground='white' cellppading='0'>" 
 .Write "<font face='arial' size='6' color='blue'>Consultar Banco de dados de Usurios</font>" 
 .Write "<br><br>" 
 .Write "<form action='nucleo.asp?Opcao=ConsultaResposta' method='post'>"
 .Write "Informe a quantidade de registros na consulta : "
 .Write "<input type='text' name='Quantidade' value='10' maxlegenth='2' size='2'>"
 .Write " registros."
 .Write "<br><br><br>"
 .Write "<b>Escolha o campo de pesquisa e digite uma palavra-chave :</b>"
 .Write "<br><br>"
 .Write "<select name='Pesquisa'>"
 .Write "<option value='0' selected>Pesquisar por :</option>"
 .Write "<option value='Nome'>- Nome</option>"
 .Write "<option value='Login'>- Login</option>"
 .Write "</select>"
 .Write "<input type='text' name='DadoPesquisa' maxlegenth='50'>"
 .Write "<input type='submit' name='Enviar' value='Pesquisar Agora'>"
 .Write "</form>"
 .Write "<br><br>"
 .Write "<center><a href='nucleo.asp?Opcao=Principal'>Voltar para a Principal</a></center>"
 .Write "</body>" 
 .Write "</html>" 
End With

End Sub

'Est rotina  onde processar todas as informaes de consulta, e aqui  responsvel por 
'entregar ao usurio a consulta com os campos determindos pelo usurio. E processar todos
'os registros e entregar em forma crescente.
Private Sub Resposta ()

Dim RecSet, SQL, Contador, Campo, Pesquisa, Registros

Campo=TRIM(Request.Form("Pesquisa"))
Pesquisa=TRIM(Request.Form("DadoPesquisa"))
Registros=TRIM(Request.Form("Quantidade"))

'Atrves dessa SQL, voc pode determinar a consulta inteira.
SQL = "SELECT TOP "&Registros&" Id, Nome, Sexo, Idade, Login"
SQL = SQL & " FROM Usuario WHERE "&Campo&" LIKE '%"&Pesquisa&"%'"
SQL = SQL & " ORDER BY "&Campo&" ASC" 

Set RecSet=Server.CreateObject ("ADODB.RecordSet")
RecSet.Open SQL, Conexao, 3, 3

Contador = 0

With Response
 .Write "<html><head>" 
 .Write "<title>Resultado da Pesquisa em " & Campo & " por " & Pesquisa & "</title>" 
 .Write "</head><body bgground='white' cellppading='0'>" 
 .Write "<font face='arial' size='5' color='blue'>Resultado da pesquisa</font>" 
 .Write "<br><br>" 
 .Write "Foram encontrados <font color='red'>" & RecSet.RecordCount & " </font>registros,"
 .Write " de <font color='red'>" & Request.Form("Quantidade") & " </font>registros pedidos."
 .Write "<br><br>"
 .Write "<b>O resultado est abaixo :</b>"
 .Write "<br><br><br>"
 If (Campo="Nome") Then
     Do While Not RecSet.EoF
        Contador = Contador + 1
        .Write "<font color='orange'><b>"& Contador &"</b></font> -)<br>"
        .Write "<b>Nome do Usurio : </b>" & RecSet("Nome") & "<br>"
        .Write "<b>Idade : </b>" & RecSet("Idade") & "<br>"
        .Write "<b>Sexo : </b>" & RecSet("Sexo") & "<br>"
        .Write "<br><br>"
     RecSet.MoveNext
     Loop
 End If
 If (Campo="Login") Then
     Do While Not RecSet.EoF
        Contador = Contador + 1
        .Write "<font color='orange'><b>"& Contador &"</b></font> -)<br>"
        .Write "<b>Login do Usurio : </b><font color='red'>" & RecSet("Login") & "</font><br>"
        .Write "<b>Identificao : </b>" & RecSet("Id") & "<br>"   
        .Write "<b>Idade : </b>" & RecSet("Idade") & "<br>"
        .Write "<b>Sexo : </b>" & RecSet("Sexo") & "<br>"
        .Write "<br><br>"
     RecSet.MoveNext
     Loop
 End If
 .Write "<br><br>"
 .Write "<center><a href='nucleo.asp?Opcao=Consultar'>Voltar para a Principal</a></center>"
 .Write "</body>" 
 .Write "</html>" 
End With

RecSet.Close
Set RecSet = Nothing

End Sub

'Aqui  o pequeno cerebro do sistema, pois aqui ele determinar quais funes sero executadas
'no sistema, e fica com ele, a tarefa de saber se a validao dos formulrios esto corretas e
'chamar as rotinas responsveis por cada opo. Utilizei o SELECT CASE, pois fica mais fcil
'e inteligente, desde utilizar a condio IF.. ELSE.. END IF.
Select Case Selecao
   Case "Login"
         Call ValidacaoLogin()
         If (Check=OK) Then
            Call Login()
         End If   
   Case "Incluir"
         Call Inclusao()
   Case "AdicionarUsuario"
         Call ValidacaoInclusao()
         If (Check=OK) Then
            Call Usuario()
         End If
   Case "Alterar"
         Call Alteracao()
   Case "AlterarUsuario"
         Call ValidacaoAlteracao()
         If (Check=OK) Then
            Call AlterarDados()
         End If
   Case "ConcluirAlteracao"
         Call Usuario()
   Case "Excluir"
         Call Exclusao()
   Case "ConfirmarExclusao"
         Call ValidacaoExclusao()
         If (Check=OK) Then
            Call Usuario()
         End If
   Case "Consultar"
         Call Consulta()
   Case "ConsultaResposta"
         Call ValidacaoConsulta()
         If (Check=OK) Then
            Call Resposta()
         End If
   Case "Visualizar"
         Call Visualizar()
   Case "Principal"
         Call Identificacao ()
   Case "Sair"
         Call Sair()
End Select

'Fechando a conexo com o banco de dados
Conexao.Close
Set Conexao = Nothing

'Aqui eu determino que apartir desta linha, no ser executada mais nenhum cdigo.
Response.End
%>