VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsUpload"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit
Option Compare Text


Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" _
(hpvDest As Any, hpvSource As Any, ByVal cbCopy As Long)

Private poContext As ASPTypeLibrary.ScriptingContext
Private poRequest As ASPTypeLibrary.Request
Private poFormDetails As clsFormDetails

Private psPath As String
Private psSaveAs As String
Private sData As String
Private poSavedRequest As New Scripting.Dictionary
Private psUserFileName As String
Private plFileStart As Long
Private plFileEnd As Long
Private pbNoFileName As Boolean
Private pbNoFileContents As Boolean
Private pbytArrContents() As Byte
Private pbytArrInput() As Byte
Private psError As String

'Header/content delimiter per RFC1867
Private Const HTTP_DELIMITER = "-----------------------------"
Private FORM_DATA As String

Public Sub OnStartPage(Sc As ScriptingContext)

'IIS Passes the scripting context to
'any component contained with the
'requested page
    Dim iCtr As Integer
    
    Set poContext = Sc
    Set poRequest = poContext.Request
    PopulateForm
  
    
End Sub

Public Property Get Path() As String
    Dim s As String
    If psPath = "" Then ResolveFileName (s)
    
    Path = psPath
End Property

Public Property Let Path(ByVal NewValue As String)
    If Right(NewValue, 1) <> "\" Then NewValue = NewValue & "\"
    psPath = NewValue
End Property

Public Property Get FileName() As String
    Dim s As String
    
    If psSaveAs = "" Then ResolveFileName (s)
    FileName = psSaveAs
End Property

Public Property Let FileName(ByVal NewValue As String)
    Dim sFileName As String
    sFileName = NewValue
    
    'the replace statement is necessary probably due to a bug in
    'in the populate form procedure.
    'but it works, so do we care?
    
    sFileName = Replace(NewValue, vbLf, "")
    
    If InStr(sFileName, "\") > 0 Then
        psSaveAs = NameFromFullPath(sFileName)
        Path = PathOnly(sFileName)
    Else
        psSaveAs = TrimWithoutPrejudice(sFileName)
    End If
End Property

Private Function PopulateForm() As Boolean
    
    On Error GoTo ErrorHandler
   
    Dim sFileName As String
    
    Dim lBytes As Long
   
    Dim sPath As String
    Dim sSplit() As String
    Dim lCtr As Long, iCtr As Long
    Dim lCtr2 As Long, iCtr2 As Integer
    Dim lFileCtr As Long

    Dim sKey As String
    Dim sValue As String
    Dim sChar As String
    Dim sTemp As String
    Dim lSavedCtr As Long
    
    
    
    lBytes = poRequest.TotalBytes
    'save the entire request in a byte array
    ReDim pbytArrInput(lBytes) As Byte
  
    pbytArrInput = poRequest.BinaryRead(lBytes)
   
    
    'save the http header, the end of which is indicated by
    'two vbcrlfs

    lCtr = 0
    Do Until lCtr >= lBytes
       sTemp = sTemp & Chr(pbytArrInput(lCtr))

        lCtr = lCtr + 1
        'check at certain lengths for items of interest
        If sTemp = HTTP_DELIMITER Then
  
                    'this is the delimiter, move on to the next
                        lCtr = lCtr + 1
                        Do
                        
                         sTemp = sTemp & Chr(pbytArrInput(lCtr))
                           If Right(sTemp, 2) = vbCrLf Then Exit Do
                           lCtr = lCtr + 1
                           
                        Loop
                        sTemp = ""
                        lCtr = lCtr + 1

       ElseIf sTemp = FORM_DATA Then

            sTemp = ""
            sKey = ""
            '
            'get the key
            Do
                If Chr(pbytArrInput(lCtr)) = Chr(34) Then Exit Do
                    'CopyMemory ByVal StrPtr(sKey) + 1, pbytArrInput(lCtr), 1
                    sKey = sKey & Chr(pbytArrInput(lCtr))
                    lCtr = lCtr + 1
                Loop
                
                           
                
                'see if this is the file name
                For iCtr = lCtr To (lCtr + 11)
                 
                    sTemp = sTemp & Chr(pbytArrInput(iCtr))
                Next
                    
                    If InStr(sTemp, "filename=") > 0 Then
 
                        sTemp = ""
                        lCtr = lCtr + 1
                        'move past "filename ="
                        Do
                            sChar = Chr(pbytArrInput(lCtr))
                            If sChar = Chr(34) Then Exit Do
                            lCtr = lCtr + 1
                        Loop
                        
                        Do
                            lCtr = lCtr + 1
                            sChar = Chr(pbytArrInput(lCtr))
                            If sChar = Chr(34) Then Exit Do
                              'CopyMemory ByVal StrPtr(sTemp) + 1, pbytArrInput(lCtr), 1
                            sTemp = sTemp & Chr(pbytArrInput(lCtr))
                        Loop
                        If Trim(sTemp) = "" Then
                            pbNoFileName = True
                            pbNoFileContents = True
                        Else
                            AddToForm sKey, sTemp
                            'user file name
                            sSplit = Split(sTemp, "\")
                            'Other OS's use backslashes (I think)
                            'If I'm wrong, won't change anything anyway
                            If UBound(sSplit) = 0 Then sSplit = Split(sTemp, "/")
                            psUserFileName = sSplit(UBound(sSplit))
                            
                            
                        End If
                        'next line tells us content type, move past
                        lCtr = lCtr + 2
                        sTemp = ""
                        Do
                            lCtr = lCtr + 1
                       
                            sTemp = sTemp & Chr(pbytArrInput(lCtr))
                            If Right(sTemp, 2) = vbCrLf Then Exit Do
                        Loop
                         sTemp = ""
 
                        
                        'Now file contents.  Get start point and end
                        'point in the byte array.  Commit to disk when the
                        'user calls the save method. move forward 3 to account
                        'for vbcrlf

                        lCtr = lCtr + 3
              
                        plFileStart = lCtr
                 
                        sValue = ""
                             Do
                            
                            If Chr(pbytArrInput(lCtr)) = Left(HTTP_DELIMITER, 1) Then
                                sValue = ""
                         
                                For iCtr2 = 1 To Len(HTTP_DELIMITER)
                                    
                                    
                                    sValue = sValue & Chr(pbytArrInput(lCtr))
                                    lCtr = lCtr + 1
                                Next
                           
                            lSavedCtr = lCtr
                            If sValue = HTTP_DELIMITER Then
                                plFileEnd = lCtr
                          
                                Exit Do
                            Else
                                lCtr = lSavedCtr
                            End If
                             End If
                                                      
                            lCtr = lCtr + 1
                            Loop
                            'now we can figure out the end point of the file's contents
                           plFileEnd = lCtr - (Len(HTTP_DELIMITER) + 2)
                            If plFileEnd <= plFileStart Then pbNoFileContents = True
                          
                            If Not pbNoFileContents Then
                              
                                ReDim pbytArrContents(plFileEnd - plFileStart - 1)
                                
                                CopyMemory pbytArrContents(0), pbytArrInput(plFileStart), plFileEnd - plFileStart
   
                                
                         
                                
                            End If
                            
                            'we're at a delimiter again, just move past it.
                            sValue = ""
                            Do Until Right(sValue, 2) = vbCrLf
                                sValue = sValue & Chr(pbytArrInput(lCtr))
                                lCtr = lCtr + 1
                            Loop
                            
                            sTemp = ""
                            
                Else

                            
                        lCtr = lCtr + 4
            
                'read value
                'until we hit HTTP_DELMITER we don't know
                'that we have whole value.  This is because value
                'can be multiline
                
                'if someone enters HTTP_DELIMITER as a value in your form
                'this code dies.  But that is very unlikely.
                sValue = ""
                    Do
                          
                        sValue = sValue & Chr(pbytArrInput(lCtr))
                        If Right(sValue, Len(HTTP_DELIMITER)) = HTTP_DELIMITER Then
                            If Len(TrimWithoutPrejudice(sValue)) <= Len(HTTP_DELIMITER) Then
                                sValue = ""
                            Else
                                sValue = Mid(sValue, 2, Len(sValue) - (Len(HTTP_DELIMITER) + 3))
                            End If
                            AddToForm sKey, sValue
                            sValue = ""
                            'we're at a delimiter again, just move past it.
                            Do Until Right(sValue, 2) = vbCrLf
                          
                              sValue = sValue & Chr(pbytArrInput(lCtr))
                                lCtr = lCtr + 1
                            Loop
                            
                            sTemp = ""
                            Exit Do
                        End If
                    lCtr = lCtr + 1
                Loop
            End If 'INSTR
      Else

                            
      End If 'stemp = form_data
    
    Loop

 PopulateForm = True

Exit Function

ErrorHandler:
    psError = Err.Description

    

End Function
Private Function AppPath() As String
'http://www.freevbcode.com/ShowCode.Asp?ID=878
    
    Dim sAns As String
    sAns = App.Path
    If Right(App.Path, 1) <> "\" Then sAns = sAns & "\"
    AppPath = sAns

End Function
 
Public Property Get Error() As String
    Error = psError
End Property
Private Function ResolveFileName(FullPath As String) As Boolean
    Dim sFileName As String
    Dim sPath As String
    
    'logic:
    'if no path supplied, use app.path by default
    'if no file name supplied, use the user's file name be default
    
    
    
    If psPath = "" Then psPath = AppPath
    sPath = psPath

    sFileName = psSaveAs

   
    If sFileName = "" Then
        sFileName = psUserFileName
        psSaveAs = psUserFileName
       
    End If
     
   
    ResolveFileName = Dir(psPath, vbDirectory) <> ""
    If ResolveFileName = False Then
        psError = sPath & " is an invalid path"
    Else
        FullPath = psPath & sFileName
    End If
   
    
End Function
Private Function NameFromFullPath(FullPath As String) As String
'Input: Name/Full Path of a file
'Returns: Name of file

    Dim sPath As String
    Dim sList() As String
    Dim sAns As String
    Dim iArrayLen As Integer

    If Len(FullPath) = 0 Then Exit Function
    sList = Split(FullPath, "\")
    iArrayLen = UBound(sList)
    sAns = IIf(iArrayLen = 0, "", sList(iArrayLen))
    
    NameFromFullPath = sAns

End Function
Private Function PathOnly(FullPath As String) As String
'Input: Name/Full Path of a file
'Returns: Name of Directory Only

    Dim sPath As String
    Dim sList() As String
    Dim sAns As String
    Dim iArrayLen As Integer, iArrayStart As Integer
    
    
    Dim iCtr As Integer
    
    sList = Split(FullPath, "\")
    
    iArrayStart = LBound(sList)
    iArrayLen = UBound(sList) - 1
    
    If iArrayLen > LBound(sList) Then
    For iCtr = iArrayStart To iArrayLen
        sAns = sAns & sList(iCtr) & "\"
    
    Next
    End If
    PathOnly = sAns
End Function

Public Function Form(sKey As String) As String
    If poSavedRequest.Exists(sKey) Then
            Form = poSavedRequest(sKey)
     End If

End Function


Private Function ByteArrayToString(bytArray() As Byte) As String
    Dim sAns As String
    Dim iPos As String
    
    sAns = StrConv(bytArray, vbUnicode)
    iPos = InStr(sAns, Chr(0))
    If iPos > 0 Then sAns = Left(sAns, iPos - 1)
    
    ByteArrayToString = sAns
 
 End Function
 Private Function AddToForm(Key As String, Data As String)
   Dim lCtr As Long
   
   If poFormDetails Is Nothing Then Set poFormDetails = New clsFormDetails
   
     If poSavedRequest.Exists(Key) Then
        poSavedRequest.Item(Key) = poSavedRequest.Item(Key) & ", " & Data
        'Modify array held by formdetails
        With poFormDetails
            lCtr = .GetItemArrayIndex(Key)
            .UpdateItemArray lCtr, poSavedRequest.Item(Key)
        End With
            
    Else
        poSavedRequest.Add Key, Data
        'Add to form details object
        With poFormDetails
            .IncrementCount
            .AddKeyValuePair Key, Data
        End With
    End If


      
 End Function
Private Function TrimWithoutPrejudice(ByVal InputString As String) As String
'http://www.freevbcode.com/ShowCode.ASP?ID=104
Dim sAns As String
Dim sWkg As String
Dim sChar As String
Dim lLen As Long
Dim lCtr As Long

sAns = InputString
lLen = Len(InputString)

If lLen > 0 Then
'Ltrim
    For lCtr = 1 To lLen
        sChar = Mid(sAns, lCtr, 1)
        If Asc(sChar) > 32 Then Exit For
    Next

sAns = Mid(sAns, lCtr)
lLen = Len(sAns)

'Rtrim
    If lLen > 0 Then
        For lCtr = lLen To 1 Step -1
            sChar = Mid(sAns, lCtr, 1)
            If Asc(sChar) > 32 Then Exit For
        Next
    End If
    sAns = Left$(sAns, lCtr)
End If

TrimWithoutPrejudice = sAns

End Function


Public Function Save() As Boolean
Dim lCtr As Long

Dim iFile As Integer
Dim sFullPath As String
Dim lLen As Long

On Error GoTo ErrorHandler
iFile = FreeFile

If pbNoFileName Then
        psError = "No file was uploaded"
        Exit Function
End If

If pbNoFileContents Then
    psError = "Uploaded file was empty"
    Exit Function
End If

'sfullpath is empty string passed byref
'will be populated by resolvefilename function

If Not ResolveFileName(sFullPath) Then Exit Function

If Dir(sFullPath) <> "" Then
    On Error Resume Next
    Kill sFullPath
    On Error GoTo ErrorHandler
End If


Open sFullPath For Binary Access Write As #iFile
Put #iFile, , pbytArrContents
Close #iFile

Save = True
Exit Function
ErrorHandler:
psError = Err.Description

End Function

Private Sub Class_Initialize()
FORM_DATA = "Content-Disposition: form-data; name=" & Chr(34)
poSavedRequest.CompareMode = TextCompare


End Sub

Private Sub Class_Terminate()
    Set poContext = Nothing
    Set poSavedRequest = Nothing
    Set poRequest = Nothing
    Erase pbytArrInput

End Sub
Public Property Get FormDetails() As clsFormDetails
'if the person requests this before it's been populated
'return an empty object.
If poFormDetails Is Nothing Then Set poFormDetails = New clsFormDetails
Set FormDetails = poFormDetails

End Property


