<%@ LANGUAGE = "VBScript" %>

<%
'***********************************************
'    UTE - (U)niversal ASP (T)able (E)ditor
'***********************************************
' UTE_EXPORT.ASP                       Rev.: 1.4
' Table export (csv) script     
'                                               
' (c) in 2000-2001 by Tom Wellige                    
' http://www.wellige.com , tom@wellige.com     
'                                               
' You may use and alter this script as long as  
' you put this original header in it !          
'                                               
'***********************************************
%>

<!--#include file ="ute.inc"-->

<%
   ' if not called from valid ute.asp session quit
   if Not Session("bValid") then
     WriteHTMLHeader "Export Error"
     Response.Write("Error: No Table specified !")
     WriteHTMLFooter
     Response.End
   else

     RequestParameter
     Set db = Session("db")
     Set rs = Session("rs")
     sTableName = Session("sTableName")

     ' set RecordSet to get all data
     rs.PageSize = rs.RecordCount
     rs.AbsolutePage = 1
     rs.MoveFirst

     ' get FileSystem Object
     Dim FSO
     Set FSO = Server.CreateObject("Scripting.FileSystemObject")

     ' calculate Filename
     Dim FileName
     FileName = sExportDir & UCase(sTableName) & "_" & CStr(Session.SessionID) & ".csv"

     Dim FilePath
     FilePath = Server.MapPath(FileName)

     ' create File
     Dim FileHandle
     Set fExport = FSO.CreateTextFile(FilePath, true)

     ' write Header
     sLine = ""
     if PrimaryKeyFieldsCount > 0 then
       for i = 1 to PrimaryKeyFieldsCount
         sLine = sLine & """" & PrimaryKeyFields(i) & ""","
       next
     end if 
     if StandardFieldsCount > 0 then
       for i = 1 to StandardFieldsCount
         sLine = sLine & """" & StandardFields(i) & ""","
       next
     end if 
     if sLine <> "" then
       sLine = Left(sLine, Len(sLine)-1)
       fExport.WriteLine(sLine)
     end if 

     ' write Data
     Do Until rs.EOF
       sLine = ""
       if PrimaryKeyFieldsCount > 0 then
         for i = 1 to PrimaryKeyFieldsCount
           sLine = sLine & """" & rs(PrimaryKeyFields(i)) & ""","
         next
       end if 
       if StandardFieldsCount > 0 then
         for i = 1 to StandardFieldsCount
           sLine = sLine & """" & rs(StandardFields(i)) & ""","
         next
       end if 
       if sLine <> "" then
         sLine = Left(sLine, Len(sLine)-1)
         fExport.WriteLine(sLine)
       end if 
       rs.MoveNext
     Loop
     
     ' close File
     fExport.Close

     ' send File to User
     Response.Redirect(FileName)

   end if

%>