<%
'***********************************************
'    UTE - (U)niversal ASP (T)able (E)ditor
'***********************************************
' UTE.INC                              Rev.: 1.4
' Application wide definitions       
'                                               
' (c) in 2000-2001 by Tom Wellige                    
' http://www.wellige.com , tom@wellige.com     
'                                               
' You may use and alter this script as long as  
' you put this original header in it !          
'                                               
'***********************************************
%>

<!--#include file ="adovbs.inc"-->
<!--#include file ="adolib.inc"-->

<%

' ---- Definitions ----
Const sUTELongName      = "Universal Table Editor"
Const sUTEShortName     = "UTE"
Const sUTEVersion       = "1.4"
Const sUTELink          = "http://www.codeproject.com/asp/ute.asp"

dim   sDSN

' To use a DSN-Less Connection use the following sDSN definition.
' By using this, UTE is able to detect Primary Keys accurately !!!
      sDSN              = "Provider=Microsoft.Jet.OLEDB.4.0;" &_
	                      "Data Source=" & Server.MapPath("test.mdb")

' To use a DSN (ODBC) Connection use the following sDSN defintion.
' In this case you need to setup an ODBC data source.
' By using this, UTE is *NOT* able to detect Primary Keys accurately !!!
'      sDSN              = "test"                ' the DSN for your database


Const sStartPage        = "index.html"          ' goto this page after a reset


Const sParamName        = "name"                ' name of table
Const sParamPKey        = "pkey"                ' e.g. pkey1, pkey2, ... pkeyn
Const sParamPage        = "page"                ' current page
Const sParamPageSize    = "pagesize"            ' page size (default=10)
Const sParamSort        = "sort"                ' sort field
Const sParamSortDir     = "sortdir"             ' sort direction  (asc, desc, default=asc) 
Const sParamMode        = "mode"                ' mdEdit, mdInsert, mdDelete
Const sParamRecord      = "record"              ' editing or deleting record
Const sParamDefs        = "definitions"         ' show field definitions
Const sParamSortFields  = "sorted"              ' sort fields alphabetically (1=true, 0=false, default=1)
const sParamReset       = "reset"               ' reset current session and goto start page

Const sDefSortFields    = "1"                   ' default sort fields alphabetically
Const sDefSortDir       = "asc"                 ' default sort direction
Const nDefPageSize      = 10                    ' default number of records per page

Const sUteASP           = "ute.asp"             ' name of table script
Const sEditASP          = "ute_form.asp"        ' name of form script
Const sExportASP        = "ute_export.asp"      ' name of data export (csc) script

Const sImageDir         = "images/"             ' directory where the images are
Const sExportDir        = "export/"             ' export directory

Const sFormPre          = "_#"
Const sFormPost         = "#_"
Const sFormOkButton     = "Ok"
Const sFormCancelButton = "Cancel"

Const mdInsert          = 1                     ' insert mode
Const mdEdit            = 2                     ' edit mode
Const mdDelete          = 3                     ' delete mode

Const gpQueryString     = 1                     ' get parameter via Request.QueryString
Const gpForm            = 2                     ' get parameter via Request.Form

Const nMaxInputLength   = 58                    ' max length of INPUT
Const nMemoCols         = 50                    ' number of cols of TEXTAREA
Const nMemoRows         = 8                     ' number of rows of TEXTAREA


' ---- Global Variables ----

Dim bAutoPKDetection                           ' use automatic primary key detection ?
Dim bViewDefinitions                           ' show field definitions

Dim StandardFields()                           ' array of all "standard" fields
Dim PrimaryKeyFields()                         ' array of all primary key fields
Dim StandardFieldsCount                        ' number of all "standard" fields
Dim PrimaryKeyFieldsCount                      ' number of all primary key fields

Dim sTableName
Dim sSort
Dim sSortDir
Dim sSortFields
Dim nPage
Dim nPageSize
Dim nMode

Dim s
Dim i

sTableName = ""
sSort      = ""
sSortDir   = ""
nPage      = 0
nPageSize  = 0
nMode      = 0

bAutoPKDetection = True

s = ""
i = 0

PrimaryKeyFieldsCount = 0
StandardFieldsCount   = 0


' ---- Functions ----


'
' Add's a primary key field to the array
'
Sub AddPrimaryKeyField (feld)
  PrimaryKeyFieldsCount = PrimaryKeyFieldsCount + 1
  Redim Preserve PrimaryKeyFields(PrimaryKeyFieldsCount)
  PrimaryKeyFields(PrimaryKeyFieldsCount) = feld
End Sub


'
' Add's a "standard" field to the array
'
Sub AddStandardField (feld)
  StandardFieldsCount = StandardFieldsCount + 1
  Redim Preserve StandardFields(StandardFieldsCount)
  StandardFields(StandardFieldsCount) = feld
End Sub


'
' Get all parameters (from address line, Session or use defaults)
'
Sub RequestParameter
  Dim i

  ' ---- Primary Keys ----
  i = 1
  while Request.QueryString(sParamPKey & CStr(i)) <> ""
    ' switch off auto primary key detection 
    bAutoPKDetection = False
    AddPrimaryKeyField Request.QueryString(sParamPKey & CStr(i))
    i = i + 1
  wend
  if PrimaryKeyFieldsCount = 0 then
    if Session("bValid") then
      PrimaryKeyFieldsCount = Session("PrimaryKeyFieldsCount")
      Redim PrimaryKeyFields(PrimaryKeyFieldsCount)
      for i = 1 to PrimaryKeyFieldsCount
        PrimaryKeyFields(i) = Session("PrimaryKeyFields")(i)
      next
    else
      PrimaryKeyFieldsCount = 0
    end if
  end if

  ' ---- Standard Fields ----
  if Session("bValid") then
    StandardFieldsCount = Session("StandardFieldsCount")
    Redim StandardFields(StandardFieldsCount)
    for i = 1 to StandardFieldsCount
      StandardFields(i) = Session("StandardFields")(i)
    next
  else
    StandardFieldsCount = 0
  end if

  ' ---- Page ----
  if Request.QueryString(sParamPage) <> "" then
    nPage = CInt(Request.QueryString(sParamPage))
  else
    if Session("bValid") then
      nPage = Session("nPage")
    else
      nPage = 1
    end if
  end if

  ' ---- Page Size ----
  if Request.QueryString(sParamPageSize) <> "" then
    nPageSize = CInt(Request.QueryString(sParamPageSize))
  else
    if Session("bValid") then
      nPageSize = Session("nPageSize")
    else
      nPageSize = nDefPageSize
    end if
  end if

  ' ---- Sort Field ----
  if Request.QueryString(sParamSort) <> "" then
    sSort = Request.QueryString(sParamSort)
  else
    if Session("bValid") then
      sSort = Session("sSort")
    else
      sSort = ""
      ' sSort will be set to the first field in 
      ' the table later on in UTE.ASP
    end if
  end if 

  ' ---- Sort Direction ----
  if Request.QueryString(sParamSortDir) <> "" then
    sSortDir = Request.QueryString(sParamSortDir)
  else
    if Session("bValid") then
      sSortDir = Session("sSortDir")
    else
      sSortDir = sDefSortDir
    end if
  end if


  ' ---- Sort Fields Alphabetically ----
  if Request.QueryString(sParamSortFields) <> "" then
    sSortFields = Request.QueryString(sParamSortFields)
  else
    if Session("bValid") then
      sSortFields = Session("sSortFields")
    else
      sSortFields = sDefSortFields
    end if
  end if
  

  ' ---- View Field Definitions ----
  if Request.QueryString(sParamDefs) <> "" then
    bViewDefinitions = (Request.QueryString(sParamDefs) = "yes")
  else
    if Session("bViewDefinitions") then
      bViewDefinitions = Session("bViewDefinitions")
    else
      bViewDefinitions = False
    end if
  end if

End Sub


'
' Checks if the given field is already known as primary key
'
Function IsKnownPrimaryKey ( sField ) 
  Dim bReturn
  bReturn = False
  for i = 1 to PrimaryKeyFieldsCount
    if PrimaryKeyFields(i) = sField then bReturn = True
  next
  IsKnownPrimaryKey = bReturn
End Function


'
' Checks if the given field is defined in db schema
'
Function IsPrimaryKey_inDBSchema ( sField )
  Dim bReturn
  bReturn = False

  Dim rsSchema
  Set rsSchema = Server.CreateObject("ADODB.Recordset")
  rsSchema.CursorType = adOpenDynamic
  Set rsSchema = db.openSchema(adSchemaIndexes)

  do while (not rsSchema.EOF) and (not bReturn)
    if LCase(rsSchema("TABLE_NAME")) = LCase(sTableName) then
      if LCase(rsSchema("COLUMN_NAME")) = LCase(sField) then
        if rsSchema("PRIMARY_KEY") then
          bReturn = True
        end if
	  end if
	end if
    rsSchema.MoveNext
  loop
  
  rsSchema.Close
  Set rsSchema = Nothing

  IsPrimaryKey_inDBSchema = bReturn
End Function


'
' Sort given array ascending
'
Sub SortFields ( ByRef arr, ByVal cnt )
  ' standard bubble sort
  for pa = 1 to cnt - 1
    for pb = 1 to cnt - pa
      if arr(pb) > arr(pb + 1) then 
        temp = arr(pb)
        arr(pb) = arr(pb + 1)
        arr(pb + 1) = temp
      end if
    next
  next

End Sub


'
' Analyzing Table for Primary Key Fields and "normal" Fields
'
Function AnalyzeTable
  Dim rsTemp
  Set rsTemp = Server.CreateObject("ADODB.Recordset")
  rsTemp.Open "[" & sTableName & "]", db, adOpenStatic, adLockReadOnly, adCmdTable

  for each fld in rsTemp.fields
    if bAutoPKDetection then
	    ' (KeyColumn) OR (Fixed and ((not Updateable) and not UnknownUpdateable))
      if ((fld.attributes and adFldKeyColumn) = adFldKeyColumn) or _
		 (((fld.attributes and adFldFixed) = adFldFixed) and _
		  ((fld.attributes and adFldUpdatable) <> adFldUpdatable) and ((fld.attributes and adFldUnknownUpdatable) <> adFldUnknownUpdatable)) then
        if Not(IsKnownPrimaryKey(fld.name)) then 
          AddPrimaryKeyField fld.name
        end if
      else
	    if IsPrimaryKey_inDBSchema(fld.name) then
          if Not(IsKnownPrimaryKey(fld.name)) then 
            AddPrimaryKeyField fld.name
          end if
		else
          if Not(IsKnownPrimaryKey(fld.name)) then 
            AddStandardField fld.name
          end if
        end if
      end if
    else
      if Not(IsKnownPrimaryKey(fld.name)) then 
        AddStandardField fld.name
      end if
    end if
  next

  rsTemp.Close
  Set rsTemp = Nothing

  if sSortFields <> "0" then
    SortFields PrimaryKeyFields, PrimaryKeyFieldsCount
    SortFields StandardFields, StandardFieldsCount
  end if

End Function


'
'  Write HTML Header
'
Sub WriteHTMLHeader ( sTitle )
  Response.Write("<!DOCTYPE HTML PUBLIC ""-//W3C//DTD HTML 3.2//EN"">")
  Response.Write("<HTML>")
  Response.Write("<HEAD>")
  Response.Write("  <TITLE>" & sTitle & "</TITLE>")
  Response.Write("  <LINK REL=""stylesheet"" TYPE=""text/css"" HREF=""ute.css"">")
  Response.Write("</HEAD>")
  Response.Write("<BODY BGCOLOR=""#FFFFFF"" LINK=""#0000A0"" VLINK=""#0000A0"" ALINK=""#0000A0"">")
End Sub


'
' Write HTML footer
'
Sub WriteHTMLFooter
  Response.Write("</BODY>")
  Response.Write("</HTML>")
End Sub


'
' Write HTML code for column header (i.e. field name)
'
Sub InsertField ( sFeld, Feld, bPrimaryKey )

  if (sSort <> sFeld) or (IsExcluded(Feld.type)) then

    sOrderDir   = sDefSortDir
    sOrderDescr = ""
    sOrderPic   = "" 'sImageDir & "sort_none.gif"
    bPicLink    = False

  else

    if sSortDir = "asc" then
      sOrderDir   = "desc"
      sOrderDescr = "sort descending"
      sOrderPic   = sImageDir & "sort_asc.gif"
    else '     -> "desc"
      sOrderDir   = "asc"
      sOrderDescr = "sort ascending"
      sOrderPic   = sImageDir & "sort_desc.gif"
    end if

    bPicLink = True

  end if

  sLinkPrefix = ""
  sLinkSuffix = ""

  if Not IsExcluded(Feld.type) then
    sLinkPrefix = "<a href=""" & sUteASP & "?" & sParamSort & "=" & sFeld & "&" & _
	    sParamSortDir & "=" & sOrderDir & """>"
	sLinkSuffix = "</a>"
  end if

  Response.Write "<table><tr><td>"
  Response.Write "<font size=""2""><b>"
  if bPrimaryKey then Response.Write "<i>"
  Response.Write sLinkPrefix & sFeld & sLinkSuffix
  if bPrimaryKey then Response.Write "</i>"
  Response.Write "</b></font>"
  Response.Write "</td><td>"

  if sOrderPic <> "" then
    sImg = "<img src=""" & sOrderPic & """ border=""0"" alt=""" & sOrderDescr & """>"
    Response.Write sLinkPrefix & sImg & sLinkSuffix
  end if 

  Response.Write "</td></td></table>"

End Sub


'
' Write HTML code for field value
'
Sub InsertFieldValue ( Feld ) 
  sField = "<td valign=top align="
  if IsExcluded(Feld.type) then
    sField = sField & "center><img src=""" & sImageDir & "exclude.gif"" border=""0"" " & _ 
             "alt=""none-viewable data"">"
  else
    select case Feld.type
	  case adBoolean
        if Feld.value then
		  sValue = "True"
		else
		  sValue = "False"
		end if 
	  case else
        sValue = Feld.value
	end select
    sField = sField & "left><font size=2>" & sValue & "</font>"
  end if
  sField = sField & "</td>" & chr(10)
  Response.Write(sField)
End Sub


'
' Write HTML code for field definitions
'
Sub InsertFieldDefinition ( Feld, bIsPK ) 
  Response.Write("<tr bgcolor=""#EFEFEF"">")
  Response.Write("  <td><FONT SIZE=2>")
  if bIsPK then Response.Write("<i>")
  Response.Write(feld.name)
  if bIsPK then Response.Write("</i>")
  Response.Write("</FONT></td>")
  Response.Write("  <td><FONT SIZE=2>" & GetTypeString(feld.type) & "</FONT></td>")
  Response.Write("  <td><FONT SIZE=2>" & CStr(feld.definedsize) & "</FONT></td>")
  Response.Write("  <td><FONT SIZE=2>" & CStr(feld.numericscale) & "</FONT></td>")
  Response.Write("  <td><FONT SIZE=2>" & CStr(feld.precision) & "</FONT></td>")
  Response.Write("  <td><FONT SIZE=2>" & GetAttributesString(feld.attributes) & "</FONT></td>")
  Response.Write("  </tr>")
End Sub


%>