<%
'option explicit
class clsImage

	dim cropX								'POSIO "X" DA SELEO DO THUMB
	dim cropY								'POSIO "Y" DA SELEO DO THUMB
	dim cropW								'LARGURA DA SELEO DO THUMB
	dim cropH								'ALTURA DA SELEO DO THUMB
	dim thumbMaxH						'MXIMA LARGURA DA IMAGEM THUMB
	dim thumbMaxW						'MXIMA LARGURA DA IMAGEM THUMB
	dim thumbName						'NOME DA NOVA IMAGEM THUMB
	dim thumbAuto						'True PARA CRIAR O THUMB PELA IMAGEM REDIMENSIONADA E False PARA REDIMENSIONAR POR SELEO
	dim createThumb					'HABILITA OU DESABILITA A CRIAO DE THUMB
	dim originalNameFile		'NOME DA IMAGEM ORIGINAL QUE EST NA PASTA "TEMP"
	dim newNameFile					'NOME DA NOVA IMAGEM QUE SER REDIMENSIONADA
	dim maxW								'MXIMA LARGURA DA IMAGEM REDIMENSIONADA
	dim maxH								'MXIMA ALTURA DA IMAGEM REDIMENSIONADA
	dim deleteOriginalFile	'EXCLUIR O ARQUIVO ENVIADO PARA A PASTA "TEMP"
	dim component						'NOME DO COMPONENTE DE IMAGEM A SER UTILIZADO
	dim quality							'QUALIDADE DA IMAGEM
	dim tempPath						'CAMINHO DA PASTA TEMP
	dim imagePath						'CAMINHO DA PASTA DE IMAGENS REDIMENSIONADAS
	dim thumbPath						'CAMINHO DA PASTA DOS THUMBS CRIADOS E REDIMENSIONADOS

	private sub class_Initialize()

		if not isNumeric(maxH) or maxH = "" then 								 		maxH = 500 'Altura mxima do redimensionamento
		if not isNumeric(maxW) or maxW = ""then 										maxW = 700 'Largura mxima do redimensionamento
				
		if not isNumeric(thumbMaxH) or thumbMaxH = "" then 		 thumbMaxH = 83 'Altura mxima do redimensionamento do thumb
		if not isNumeric(thumbMaxW) or thumbMaxW = "" then 		 thumbMaxW = 117 'Largura mxima do redimensionamento	do thumb
		
		if (createThumb <> true and createThumb <> false) or len(trim(createThumb))=0 then 		createThumb = false 
		if (thumbAuto <> false and thumbAuto <> true) or len(trim(thumbAuto))=0 then 						thumbAuto = true
		if (thumbAuto = true) and (createThumb = false) then																	createthumb = true
		if (deleteOriginalFile <> false and deleteOriginalFile <> true) or varIsEmpty(deleteOriginalFile) then deleteOriginalFile = true

		if not isNumeric(cropH) or varIsEmpty(cropH)then 	 					cropH	= thumbMaxH
		if not isNumeric(cropW) or varIsEmpty(cropW) then 					cropW	= thumbMaxW
		if varIsEmpty(newNameFile)  then 	 										newNameFile	= originalNameFile
		if varIsEmpty(thumbName)  then 	 												thumbName	= newNameFile
		if not isNumeric(quality) or varIsEmpty(quality) then 		quality	= 70
		if varIsEmpty(component) then 												 	component = "ASPIMAGE"
				
		if varIsEmpty(imagePath) then
			imagePath = Server.MapPath(".")&"\imagens\"
		end if
		
		if varIsEmpty(tempPath) and varIsEmpty(thumbPath) then
			thumbPath = imagePath&"thumb\"
			tempPath 	= imagePath&"temp\"
		end if		

		if createThumb = true and varIsEmpty(thumbPath) then
			Response.Write("Diretrio Thumb no definido")
			Response.End()
		end if
		
		if tempPath = imagePath then
			deleteOriginalFile = false
		end if
		
		if right(imagePath, 1) <> "\" then imagePath = imagePath & "\"
		if right(thumbPath, 1) <> "\" then thumbPath = thumbPath & "\"
		if right(tempPath, 1)  <> "\" then tempPath  = tempPath  & "\"
		
	end Sub
	
	private function varIsEmpty(var)
	
		var = trim(var)&""
		if cInt(len(var)) = 0 or isEmpty(var) or var = "" or isnull(var) then
			varIsEmpty = true
		else
			varIsEmpty = false
		end if
		
	end function

	public function resizeImage()
	
		dim formatImage
		dim objImage
		dim width
		dim height
		dim newWidth
		dim newHeight
		dim x
		dim y
		
		call class_Initialize()	
		
		Select case uCase(nameExtension(imagePath & originalNameFile))
			case "JPG", "JPEG" 	: formatImage = 1
			case "BMP" 					: formatImage = 2
			case "PNG" 					: formatImage = 3
			case "GIF" 					: formatImage = 5
			case "TGA" 					: formatImage = 6
			case "PCX" 					: formatImage = 7
			case else						: formatImage = 1
		end select	
		
		select case uCase(component)
		
			case "ASPIMAGE"
			
				Set objImage = Server.CreateObject("AspImage.Image")
				'redimensiona e renomeia a imagem original		
				objImage.LoadImage(tempPath & originalNameFile)
				objImage.PixelFormat = 6
				objImage.ImageFormat = formatImage
				objImage.JPEGQuality = quality
				width 	= int(objImage.MaxX)
				height 	= int(objImage.MaxY)
				
				'cria o thumb	a partir da imagem original
				if width>maxW or height>maxH then
					newWidth = maxW
					newHeight = (maxW * height) \ width
					'[ Se a altura ficar menor que o esperado, aumenta a largura
					if newHeight>maxH then
						newHeight = maxH
						newWidth = (maxH * width) \ height
					end if
					 y = newWidth
					 x = newHeight
				else
					y = width
					x = height
				end if
				'[ Redimensiona e salva a imagem
				objImage.ResizeR y , x
				objImage.Filename = imagePath & newNameFile
				objImage.SaveImage
				
				if verificaArquivo(imagePath & newNameFile) = false then
					set objImage = nothing
					Response.Write("ERRO ao redimensionar imagem")
					Response.End()
				end if					
		
				if thumbAuto and createThumb = true then
					objImage.LoadImage(imagePath & newNameFile)	
					'cria o thumb	a partir da imagem original
					if y <> thumbMaxW then
						'[ Calcula a altura
						height = (x * thumbMaxW) \ y
						width = thumbMaxW				
						'[ Se a altura ficar menor que o esperado, aumenta a largura
						if height < thumbMaxH then
							width = (y * thumbMaxH) \ x
							height = thumbMaxH
						end if				
						'[ Redimensiona a imagem
						objImage.ResizeR width, height				
						'[ Salva a imagem
						objImage.Filename = thumbPath & thumbName
						objImage.SaveImage
						
						if verificaArquivo(thumbPath & thumbName) = false then
							set objImage = nothing
							Response.Write("ERRO ao criar o thumb Padro")
							Response.End()
						end if							
						
					end if
					
				elseif thumbAuto = false and createThumb = true then
				
					'cria o thumb exatamente como selecionado
					objImage.LoadImage(imagePath & originalNameFile)
					objImage.CropImage cropX, cropY, cropW, cropH
					objImage.Filename = thumbPath & thumbName
					objImage.SaveImage
		
					'Redimensiona o thumb para o tamanho fixo
					objImage.LoadImage(thumbPath & thumbName) 
					objImage.ResizeR thumbMaxW, thumbMaxH
					objImage.Filename = thumbPath & thumbName
					objImage.SaveImage
					
					if verificaArquivo(thumbPath & thumbName) = false then
						set objImage = nothing
						Response.Write("ERRO ao criar o thumb Personalizado")
						Response.End()
					end if						
		
				end if
				Set objImage = Nothing
		
			case "ASPJPEG"

				Set objImage = Server.CreateObject("Persits.Jpeg")
				
				objImage.PreserveAspectRatio = True
				objImage.Quality  = quality

				'redimensiona e renomeia a imagem original
				objImage.open tempPath & originalNameFile
				width 	= int(objImage.OriginalWidth)
				height 	= int(objImage.OriginalHeight)
				
				'cria o thumb	a partir da imagem original
				if width>maxW or height>maxH then
					newWidth 	= maxW
					newHeight = (maxW * height) \ width
					'[ Calcula a altura
					if newHeight>maxH then
						'[ Se a altura ficar menor que o esperado, aumenta a largura
						newHeight = maxH
						newWidth 	= (maxH * width) \ height
					end if
					 y = newWidth
					 x = newHeight
				else
					y = width
					x = height
				end if
				'redimensiona e salva a imagem
				objImage.Width = y
				objImage.Height = x
				objImage.save imagePath & newNameFile
				if verificaArquivo(imagePath & newNameFile) = false then
					set objImage = nothing
					Response.Write("ERRO ao redimensionar imagem")
					Response.End()
				end if					
		
				if thumbAuto and createThumb = true then
					objImage.open imagePath & newNameFile
					'cria o thumb	a partir da imagem original
					if y <> thumbMaxW then
						'[ Calcula a altura
						height = (x * thumbMaxW) \ y
						width = thumbMaxW				
						'[ Se a altura ficar menor que o esperado, aumenta a largura
						if height < thumbMaxH then
							width = (y * thumbMaxH) \ x
							height = thumbMaxH
						end if
						'redimensiona e salva a imagem			
						objImage.Width 	= width
						objImage.Height = height
						objImage.save thumbPath & thumbName						

						if verificaArquivo(thumbPath & thumbName) = false then
							set objImage = nothing
							Response.Write("ERRO ao criar o thumb Padro")
							Response.End()
						end if								
						
					end if
					
				elseif thumbAuto = false and createThumb = true then
				
					'cria o thumb exatamente como selecionado
					objImage.open tempPath & originalNameFile
					objImage.Crop cropX, cropY, 1+cropW+cropX-1, 1+cropH+cropY-1	
					objImage.save thumbPath & thumbName
		
					'Redimensiona o thumb para o tamanho fixo
					objImage.open thumbPath & thumbName
					objImage.Width 	= thumbMaxW
					objImage.Height = thumbMaxH				
					objImage.save thumbPath & thumbName
					
					if verificaArquivo(thumbPath & thumbName) = false then
						set objImage = nothing
						Response.Write("ERRO ao criar o thumb Personalizado")
						Response.End()
					end if					
											
				end if
				set objImage = nothing
				
			case else
			
				Response.Write("Objeto invlido. Somente ASPJPEG ou ASPIMAGE")
				Response.End()
				
		end select
		
		call deleteFile(tempPath, originalNameFile)
		
	end function
		
	private function nameExtension(ByVal fileName)
	
		fileName = strReverse(fileName)
		fileName = strReverse(mid(fileName, 1, instr(fileName, ".") - 1))
		
	end function
		
	private function deleteFile(byval path,byval file)
	
		dim fso, folder
		if deleteOriginalFile then
			'exclui o arquivo original
			set fso = server.createobject("scripting.filesystemobject")
			if fso.fileExists(path & file) then
				fso.deletefile(path & file)
				deleteFile = true
			else
				deleteFile = false	
			end if
			set fso = nothing
		end if
		
	end function

	private function verificaArquivo(arquivo)
	
		dim objFso
			set objFso = CreateObject("Scripting.FileSystemObject")
			if not objFso.FileExists(arquivo) then
				verificaArquivo = false
			else
				verificaArquivo = true
			end if
			set objFso = nothing
			
	end function

end class
%>