using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Xml;
using System.IO;
using System.Windows.Forms;

namespace Minesweeper.NET
{
	/// <summary>
	/// Summary description for SetRecord.
	/// </summary>
	public class frmSetRecord : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label lblTime;
		private System.Windows.Forms.TextBox txtName;
		private System.Windows.Forms.Button btnOK;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;


		private int iTime;
		private String strNodeName;


		public String Difficulty
		{
			set { strNodeName = value; }
			get { return strNodeName; }
		}

		public int Time
		{
			set { iTime = value; }
			get { return iTime; }
		}


		public void SetLabelValues()
		{
			this.lblTime.Text = iTime.ToString();
		}


		public String WinnersName
		{
			get { return this.txtName.Text; }
		}


		public frmSetRecord()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			this.txtName.Focus();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.btnOK = new System.Windows.Forms.Button();
			this.txtName = new System.Windows.Forms.TextBox();
			this.lblTime = new System.Windows.Forms.Label();
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// btnOK
			// 
			this.btnOK.Location = new System.Drawing.Point(60, 120);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(48, 24);
			this.btnOK.TabIndex = 5;
			this.btnOK.Text = "OK";
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// txtName
			// 
			this.txtName.Location = new System.Drawing.Point(64, 64);
			this.txtName.MaxLength = 15;
			this.txtName.Name = "txtName";
			this.txtName.Size = new System.Drawing.Size(72, 20);
			this.txtName.TabIndex = 1;
			this.txtName.Text = "";
			// 
			// lblTime
			// 
			this.lblTime.Location = new System.Drawing.Point(64, 96);
			this.lblTime.Name = "lblTime";
			this.lblTime.Size = new System.Drawing.Size(80, 16);
			this.lblTime.TabIndex = 3;
			this.lblTime.Text = "label4";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(20, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(128, 32);
			this.label1.TabIndex = 0;
			this.label1.Text = "Congratulations!  You set a new record!";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(16, 64);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(48, 16);
			this.label2.TabIndex = 1;
			this.label2.Text = "Name:";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(16, 96);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(32, 16);
			this.label3.TabIndex = 2;
			this.label3.Text = "Time:";
			// 
			// frmSetRecord
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(168, 149);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.btnOK,
																		  this.txtName,
																		  this.lblTime,
																		  this.label3,
																		  this.label2,
																		  this.label1});
			this.MaximizeBox = false;
			this.MaximumSize = new System.Drawing.Size(176, 176);
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(176, 176);
			this.Name = "frmSetRecord";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "New Record!";
			this.ResumeLayout(false);

		}
		#endregion

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			// update the XML
			// read in the best times
			String strFilePath = Environment.CurrentDirectory + "\\scores.xml";

			XmlDocument xmlScores = new XmlDocument();

			if (!File.Exists(strFilePath))
			{
				// the XML file doesn't exist, create it
				XmlNode root = xmlScores.CreateNode(XmlNodeType.Element, "minesweeper", null);
				XmlNode xmlNode = xmlScores.CreateNode(XmlNodeType.Element, strNodeName, null);
				XmlNode xmlTime = xmlScores.CreateNode(XmlNodeType.Element, "time", null);
				XmlNode xmlName = xmlScores.CreateNode(XmlNodeType.Element, "name", null);
				xmlTime.InnerText = iTime.ToString();
				xmlName.InnerText = this.txtName.Text;

				xmlNode.AppendChild(xmlTime);
				xmlNode.AppendChild(xmlName);
				root.AppendChild(xmlNode);
				xmlScores.AppendChild(root);

				xmlScores.Save(strFilePath);		// save the XML file results
			}
			else
			{
				// the xml file already exists
				xmlScores.Load(strFilePath);		// load up the XML

				// see if we can't find the proper node
				bool bolFoundNode = false;
				XmlNode root = xmlScores.FirstChild, xmlChild;

				for (int iLoop=0; iLoop < root.ChildNodes.Count; iLoop++)
					if (root.ChildNodes[iLoop].Name == strNodeName)
					{
						bolFoundNode = true;		// we found the node

						// update the name/time
						xmlChild = root.ChildNodes[iLoop].FirstChild;
						if (xmlChild.Name == "name")
							xmlChild.InnerText = this.txtName.Text;
						else if (xmlChild.Name == "time")
							xmlChild.InnerText = iTime.ToString();

						xmlChild = root.ChildNodes[iLoop].FirstChild.NextSibling;
						if (xmlChild.Name == "name")
							xmlChild.InnerText = this.txtName.Text;
						else if (xmlChild.Name == "time")
							xmlChild.InnerText = iTime.ToString();

						// save the xml
						xmlScores.Save(strFilePath);
					}

				// if we didn't find the node, add it
				if (!bolFoundNode)
				{
					XmlNode xmlNode = xmlScores.CreateNode(XmlNodeType.Element, strNodeName, null);
					XmlNode xmlTime = xmlScores.CreateNode(XmlNodeType.Element, "time", null);
					XmlNode xmlName = xmlScores.CreateNode(XmlNodeType.Element, "name", null);
					xmlTime.InnerText = iTime.ToString();
					xmlName.InnerText = this.txtName.Text;

					xmlNode.AppendChild(xmlTime);
					xmlNode.AppendChild(xmlName);
					root.AppendChild(xmlNode);
					xmlScores.AppendChild(root);

					xmlScores.Save(strFilePath);		// save the XML file results
				}
			}


			// close the dialog box
			this.Close();
		}
	}
}
