using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.IO;

namespace Minesweeper.NET
{
	/// <summary>
	/// Summary description for BestTimes.
	/// </summary>
	public class frmBestTimes : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label lblBestBeginner;
		private System.Windows.Forms.Label lblBestIntermediate;
		private System.Windows.Forms.Label lblBestExpert;
		private System.Windows.Forms.Label lblTimeBeginner;
		private System.Windows.Forms.Label lblTimeIntermediate;
		private System.Windows.Forms.Label lblTimeExpert;
		private System.Windows.Forms.Button btnOK;
		private System.Windows.Forms.Button btnResetScores;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;



		private String strBestTimeBeginner, strBestTimeIntermediate, strBestTimeExpert;
		private int iBestTimeBeginner, iBestTimeIntermediate, iBestTimeExpert;

		public int BestTimeBeginner
		{
			set { iBestTimeBeginner = value; }
			get { return iBestTimeBeginner; }
		}

		public int BestTimeIntermediate
		{
			set { iBestTimeIntermediate = value; }
			get { return iBestTimeIntermediate; }
		}

		public int BestTimeExpert
		{
			set { iBestTimeExpert = value; }
			get { return iBestTimeExpert; }
		}

		public String BestTimeBeginnerName
		{
			set { strBestTimeBeginner = value; }
			get { return strBestTimeBeginner; }
		}

		public String BestTimeIntermediateName
		{
			set { strBestTimeIntermediate = value; }
			get { return strBestTimeIntermediate; }
		}

		public String BestTimeExpertName
		{
			set { strBestTimeExpert = value; }
			get { return strBestTimeExpert; }
		}


		public void SetLableValues()
		{
			this.lblBestBeginner.Text = strBestTimeBeginner;
			this.lblTimeBeginner.Text = iBestTimeBeginner.ToString();

			this.lblBestIntermediate.Text = strBestTimeIntermediate;
			this.lblTimeIntermediate.Text = iBestTimeIntermediate.ToString();

			this.lblBestExpert.Text = strBestTimeExpert;
			this.lblTimeExpert.Text = iBestTimeExpert.ToString();
		}

		public frmBestTimes()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.lblTimeIntermediate = new System.Windows.Forms.Label();
			this.lblTimeExpert = new System.Windows.Forms.Label();
			this.lblTimeBeginner = new System.Windows.Forms.Label();
			this.lblBestExpert = new System.Windows.Forms.Label();
			this.btnResetScores = new System.Windows.Forms.Button();
			this.btnOK = new System.Windows.Forms.Button();
			this.lblBestBeginner = new System.Windows.Forms.Label();
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.lblBestIntermediate = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// lblTimeIntermediate
			// 
			this.lblTimeIntermediate.Location = new System.Drawing.Point(200, 40);
			this.lblTimeIntermediate.Name = "lblTimeIntermediate";
			this.lblTimeIntermediate.Size = new System.Drawing.Size(64, 16);
			this.lblTimeIntermediate.TabIndex = 7;
			this.lblTimeIntermediate.Text = "label4";
			// 
			// lblTimeExpert
			// 
			this.lblTimeExpert.Location = new System.Drawing.Point(200, 64);
			this.lblTimeExpert.Name = "lblTimeExpert";
			this.lblTimeExpert.Size = new System.Drawing.Size(64, 16);
			this.lblTimeExpert.TabIndex = 8;
			this.lblTimeExpert.Text = "label4";
			// 
			// lblTimeBeginner
			// 
			this.lblTimeBeginner.Location = new System.Drawing.Point(200, 16);
			this.lblTimeBeginner.Name = "lblTimeBeginner";
			this.lblTimeBeginner.Size = new System.Drawing.Size(64, 16);
			this.lblTimeBeginner.TabIndex = 6;
			this.lblTimeBeginner.Text = "label4";
			// 
			// lblBestExpert
			// 
			this.lblBestExpert.Location = new System.Drawing.Point(104, 64);
			this.lblBestExpert.Name = "lblBestExpert";
			this.lblBestExpert.Size = new System.Drawing.Size(72, 16);
			this.lblBestExpert.TabIndex = 5;
			this.lblBestExpert.Text = "label4";
			// 
			// btnResetScores
			// 
			this.btnResetScores.Location = new System.Drawing.Point(40, 96);
			this.btnResetScores.Name = "btnResetScores";
			this.btnResetScores.Size = new System.Drawing.Size(88, 24);
			this.btnResetScores.TabIndex = 10;
			this.btnResetScores.Text = "Reset Scores";
			this.btnResetScores.Click += new System.EventHandler(this.btnResetScores_Click);
			// 
			// btnOK
			// 
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Location = new System.Drawing.Point(168, 96);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(56, 24);
			this.btnOK.TabIndex = 9;
			this.btnOK.Text = "OK";
			// 
			// lblBestBeginner
			// 
			this.lblBestBeginner.Location = new System.Drawing.Point(104, 16);
			this.lblBestBeginner.Name = "lblBestBeginner";
			this.lblBestBeginner.Size = new System.Drawing.Size(80, 16);
			this.lblBestBeginner.TabIndex = 3;
			this.lblBestBeginner.Text = "label4";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(72, 24);
			this.label1.TabIndex = 0;
			this.label1.Text = "Beginner:";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(16, 40);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(80, 16);
			this.label2.TabIndex = 1;
			this.label2.Text = "Intermediate:";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(16, 64);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(72, 16);
			this.label3.TabIndex = 2;
			this.label3.Text = "Expert:";
			// 
			// lblBestIntermediate
			// 
			this.lblBestIntermediate.Location = new System.Drawing.Point(104, 40);
			this.lblBestIntermediate.Name = "lblBestIntermediate";
			this.lblBestIntermediate.Size = new System.Drawing.Size(80, 16);
			this.lblBestIntermediate.TabIndex = 4;
			this.lblBestIntermediate.Text = "label4";
			// 
			// frmBestTimes
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(272, 125);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.btnResetScores,
																		  this.btnOK,
																		  this.lblTimeExpert,
																		  this.lblTimeIntermediate,
																		  this.lblTimeBeginner,
																		  this.lblBestExpert,
																		  this.lblBestIntermediate,
																		  this.lblBestBeginner,
																		  this.label3,
																		  this.label2,
																		  this.label1});
			this.MaximizeBox = false;
			this.MaximumSize = new System.Drawing.Size(280, 152);
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(280, 152);
			this.Name = "frmBestTimes";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Fastest Mine Sweepers";
			this.ResumeLayout(false);

		}
		#endregion

		private void btnResetScores_Click(object sender, System.EventArgs e)
		{
			// we need to reset the scores (i.e., delete the scores.xml file, if it exists
			// read in the best times
			String strFilePath = Environment.CurrentDirectory + "\\scores.xml";

			if (File.Exists(strFilePath)) File.Delete(strFilePath);

			// rest the labels
			this.lblBestBeginner.Text = this.lblBestIntermediate.Text = this.lblBestExpert.Text = "";
			this.lblTimeBeginner.Text = this.lblTimeIntermediate.Text = this.lblTimeExpert.Text = "0";			
		}
	}
}
