CREATE DATABASE _af COLLATE Cyrillic_General_CI_AS
GO
EXEC sp_addlogin 'af_owner', 'password', '_af', 'Russian'
GO
USE _af EXEC sp_adduser 'af_owner', 'af_owner', 'db_owner'
GO
USE _af CREATE TABLE [_ban] (
	[ip1] [bigint] NOT NULL ,
	[ip2] [bigint] NOT NULL ,
	[expire] [datetime] NOT NULL 
) ON [PRIMARY]
GO
USE _af CREATE TABLE [_boards] (
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
	[title] [varchar] (255) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[keywords] [varchar] (500) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[css] [varchar] (6000) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[pagesize] [int] NOT NULL ,
	[pagesize2] [int] NOT NULL ,
	[sortbyreply] [bit] NOT NULL ,
	[mainpagetitle] [varchar] (100) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[mainpageurl] [varchar] (255) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[pictureurl] [varchar] (255) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[picturelink] [varchar] (255) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[description] [varchar] (1000) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[rules] [varchar] (6000) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[ban] [varchar] (1000) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[hasarchive] [bit] NOT NULL ,
	[fulltext] [bit] NOT NULL ,
	[mainlistcache] [text] COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[timecreated] [smalldatetime] NOT NULL ,
	[type] [int] NOT NULL ,
	[membersonlypost] [bit] NOT NULL ,
	[ownerID] [int] NOT NULL ,
	[status] [int] NOT NULL ,
	[totalmessages] [int] NOT NULL ,
	[avghits] [float] NOT NULL ,
	[avgusers] [float] NOT NULL ,
	[hitstoday] [int] NOT NULL ,
	[userstoday] [int] NOT NULL ,
	[todayis] [smalldatetime] NOT NULL ,
	[creatorSID] [int] NOT NULL ,
	[division] [int] NOT NULL ,
	[informviamail] [bit] NOT NULL ,
	[frozen] [smalldatetime] NOT NULL DEFAULT (dateadd(year,50,getdate())),
	[tstamp] [timestamp] NOT NULL ,
	CONSTRAINT [PK__boards] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
USE _af CREATE TABLE [_codes] (
	[code] [int] NOT NULL ,
	[time] [datetime] NOT NULL 
) ON [PRIMARY]
GO
USE _af CREATE TABLE [_divisions] (
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
	[name] [varchar] (50) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	CONSTRAINT [PK__divisions] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
) ON [PRIMARY]
GO
USE _af CREATE TABLE [_hosts] (
	[ip] [bigint] NOT NULL ,
	[boardID] [int] NOT NULL ,
	CONSTRAINT [PK__hosts] PRIMARY KEY  CLUSTERED 
	(
		[ip]
	)  ON [PRIMARY] 
) ON [PRIMARY]
GO
USE _af CREATE TABLE [_members] (
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
	[name] [varchar] (100) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[password] [varchar] (100) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[email] [varchar] (100) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[page] [varchar] (300) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[info] [varchar] (6000) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[rating] [int] NOT NULL ,
	[contra] [int] NOT NULL ,
	[votedpro] [int] NOT NULL ,
	[votedcontra] [int] NOT NULL ,
	[status] [int] NOT NULL ,
	[untouchable] [bit] NOT NULL ,
	[posted] [int] NOT NULL ,
	[dateregistered] [smalldatetime] NOT NULL ,
	[fromBoard] [int] NOT NULL ,
	[invalid] [int] NOT NULL ,
	[frozen] [smalldatetime] NOT NULL DEFAULT (dateadd(year,50,getdate())),
	[tstamp] [timestamp] NOT NULL ,
	CONSTRAINT [PK__members] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
) ON [PRIMARY]
GO
USE _af CREATE TABLE [_predbannik] (
	[ip] [bigint] NOT NULL ,
	[counter] [int] NOT NULL ,
	[expire] [datetime] NOT NULL ,
	CONSTRAINT [PK__predbannik] PRIMARY KEY  CLUSTERED 
	(
		[ip]
	)  ON [PRIMARY] 
) ON [PRIMARY]
GO
USE _af CREATE TABLE [_sth] (
	[ID] [int] IDENTITY (0, 1) NOT NULL ,
	[name] [varchar] (50) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	CONSTRAINT [PK__sth] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
) ON [PRIMARY]
GO
USE _af CREATE TABLE [_votes] (
	[itemclass] [int] NOT NULL ,
	[itemID] [int] NOT NULL ,
	[itemID2] [int] NOT NULL ,
	[memberID] [int] NOT NULL ,
	[ip] [bigint] NOT NULL ,
	[cookie] [varchar] (500) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[expire] [smalldatetime] NOT NULL 
) ON [PRIMARY]
GO
USE _af CREATE UNIQUE INDEX PK_name ON _members (name) WITH IGNORE_DUP_KEY
GO
USE _af EXEC sp_fulltext_database 'enable'
GO
USE _af EXEC sp_fulltext_catalog 'fulltext', 'create'
GO
USE _af EXEC sp_fulltext_table _boards, 'create', 'fulltext', 'PK__boards'
GO
USE _af EXEC sp_fulltext_column _boards, title, 'add', 0
GO
USE _af EXEC sp_fulltext_column _boards, description, 'add', 0
GO
USE _af EXEC sp_fulltext_column _boards, keywords, 'add', 0
GO
USE _af EXEC sp_fulltext_table _boards, 'activate'
GO
USE _af EXEC sp_fulltext_table _members, 'create', 'fulltext', 'PK__members'
GO
USE _af EXEC sp_fulltext_column _members, name, 'add', 0
GO
USE _af EXEC sp_fulltext_column _members, email, 'add', 0
GO
USE _af EXEC sp_fulltext_column _members, info, 'add', 0
GO
USE _af EXEC sp_fulltext_table _members, 'activate'
GO
USE _af INSERT INTO _divisions (name) VALUES ('not used')
GO
USE _af INSERT INTO _sth (name) VALUES ('')
GO
USE _af GRANT ALL ON _BAN TO af_owner
GO
USE _af GRANT ALL ON _BOARDS TO af_owner
GO
USE _af GRANT ALL ON _CODES TO af_owner
GO
USE _af GRANT ALL ON _DIVISIONS TO af_owner
GO
USE _af GRANT ALL ON _HOSTS TO af_owner
GO
USE _af GRANT ALL ON _MEMBERS TO af_owner
GO
USE _af GRANT ALL ON _PREDBANNIK TO af_owner
GO
USE _af GRANT ALL ON _STH TO af_owner
GO
USE _af GRANT ALL ON _VOTES TO af_owner
GO