using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

/* Author: Rafael lvares Rend - rafaelrend@gmail.com
 * Creation Date: 2012-02-01
 * 
 * Description: Chronometer - This UserControl simulates a chronometer, with buttons: Play, Pause and Reset.
 * The main secret is the file chrono.js, don't forget include it in aspx page. <script src='crono.js' type='text/javascript'></script>
 * Advantage: You can use any times you need into an aspx page and is compatible with masterpages and/or ajax extensions. 
 *
 * 
 * Descrio: Este UserControl simula um cronmetro, com botes: Play, Pausa e Reset.
 * O principal segredo  o arquivo chrono.js, no esquea de inclu-lo na sua pgina aspx. <script src='crono.js' type='text/javascript'></script>
 * Vantagem: Voc pode instancia-lo vrias vezes no corpo de sua pgina e ele funciona tranquilamente com masterpages ou ajax extensions...
 * na verdade, o ajax extensionos no ajuda o cronmetro, nem atrapalha.
 * 
 */
public partial class ucChronometer : System.Web.UI.UserControl
{

    protected void Page_Init(object sender, EventArgs e)
    {
        /* The second secret is the ClientID property existing in controls with tag runat=server
         * ClientID returns the real input's ID value generated to browser's HTML. So, we need to know 
         * what is the real ID to manipulating values with javascript (document.getElementbyId('realid')).
         * 
         * Page_Init occurs before Page_Load, at this point we insert calls to javascript functions.
         *
         * Traduo: O Segundo segredo  a popriedade ClientID, que existe nos cotrols do .NET cuja tag  runat=server.
         * O ClientID returna o id real do elemento, quando gerado para o browser do usurio. Ento, ns precisamos
         * saber essa id para criar as chamadas ao mtodo javascript, para que o javascript saiba onde colocar o restultado
         * da contagem de tempo.  
         * 
         */

        btplay.Attributes.Remove("onclick");
        btplay.Attributes.Add("onclick", "crono_play('"+TextBox1.ClientID+"','"+btplay.ClientID+"','"+btpause.ClientID+"'); ");

        btpause.Attributes.Remove("onclick");
        btpause.Attributes.Add("onclick", "crono_pause('"+TextBox1.ClientID+"','"+btplay.ClientID+"','"+btpause.ClientID+"'); ");
        
        btreset.Attributes.Remove("onclick");
        btreset.Attributes.Add("onclick", "crono_reset('" + TextBox1.ClientID + "','" + btplay.ClientID + "','" + btpause.ClientID + "'); ");

    }

    protected void Page_Load(object sender, EventArgs e)
    {
    }

    /// <summary>
    /// Get and Set Value property - Propriedade Value: Use-a para coloca valores ou obter via cdigo fonte.
    /// </summary>
    public string Value
    {
        set { this.TextBox1.Text = value; }
        get { return this.TextBox1.Text; }
    }
}
