﻿
/* Author: Rafael Álvares Rend - rafaelrend@gmail.com
 * Creation Date: 2012-02-01
 * Description: Javascript Chronometer Functions.
 */

//Function: crono_play      
//Objective: set current play button visibility and call timer method. (controla a visibilidade do botão de play e chama o método "timer").
//Parameters: input text id, button play id, button pause id. 
function crono_play(txtid, btplayid, btpauseid){

     var btplay = document.getElementById(btplayid);
     var btpause = document.getElementById(btpauseid);

     if ( btplay.style.display != "none" ){
          
          
          btplay.style.display = "none"; //hide button play
          btpause.style.display = ""; //show button pause         
         
         //Call timer method.  
         timer( txtid , btplayid);
     
     }

}

//Function: crono_pause
//Objective: set current pause button visibility (controla a visibilidade do botão de pause).
//Parameters: input text id, button play id, button pause id. 
function crono_pause(txtid, btplayid, btpauseid){

     var btplay = document.getElementById(btplayid);
     var btpause = document.getElementById(btpauseid);
          
          btpause.style.display = "none"; //Hide button pause. 
          btplay.style.display = ""; //show Button play. When show this button, timer method will stop on next call.
}
//Function: crono_reset
//Objective: set current both pause button and play button visibility (controla a visibilidade dos botões pause e play).
//Parameters: input text id, button play id, button pause id. 
function crono_reset(txtid, btplayid, btpauseid){


       var txt = document.getElementById(txtid);
       var btplay = document.getElementById(btplayid);
       var btpause = document.getElementById(btpauseid);
       
       txt.value = "00:00";    
       btpause.style.display = "none";
       btplay.style.display = "";
}


//Function: timer - recursive javascript function
//Objetive: Couting time using play button visibility as requirement. If play button is not visible, function starts. Else (if visible) function stops. 
//Parameters: txtid - Real ID of input element, btplayid - Button Play ID, arg3 - Milliseconds - this argument wont be set at first call

//Função: timer - Função recursiva em javascript
//Objetivo: Conta o tempo utilizando a visibilidade do botão de play como requisito. Se o botão play não está visivel a função inicia, se estiver visível ela para.
//Parâmetros: ID real do text, id do botão de play, arg3 - Milisegundos -> Este argumento não será setado a primeira vez que a função for chamada.

function timer(txtid, btplayid, arg3){
  //keepgoin - help to control the function
  var keepgoin=false;  

  var btplay = document.getElementById(btplayid);
       
       //If Play Button is not visible, keepgoing is true.
       if ( btplay.style.display == "none" ){
       
            keepgoin = true;
       } 
       
       //If keepgoin is false ( Play Button is visible ) lets stop function.
       //This is our control to not lock the browser.
       if ( !keepgoin )
          return;

   
  //Declaring vars to secs, minutes and milliseconds 
  var currentsec=0;	
  var currentmin=0;	
  var currentmil=0;
  
  //if args3 is null, then timer is called at first time.
  //else, we have more miliseconds and not first time call.
  if ( arg3 != null && arg3 != undefined){ 
     currentmil = parseInt( arg3 );
  }
        
  
        
       //Using txtid, lets get input's object reference  
       var txt = document.getElementById(txtid);
             
       if ( txt.value == "" ){    
           txt.value = "00:00";       
       }
       
       //Getting already set field's value
       var ar_time = txt.value.split(":");
       currentsec = parseInt( ar_time[1] , 10 ); //Getting seconds.
       currentmin = parseInt( ar_time[0] , 10 ); //Getting minutes.
       
       var Strsec = "";
       var Strmin = "";
       var Strmil = "";
       
       //Here, we have magic:
        if(keepgoin){
                    //Increase current milliseconds. 
                    
                    currentmil+=1;
                    //We call function every 100 milliseconds.. and 1000 milliseconds (100 * 10) is equal 1 second.
                    if (currentmil==10){
                        currentmil=0;  //reset milliseconds count.
                        currentsec+=1; //plus 1 second.
                    }        
                    
                    
                    
                    if (currentsec==60){ //60 secods. Reset seconds count and plus 1 minute.
                        currentsec=0;	
                        currentmin+=1;
                    }
                    //Converting integer to string.
                    Strsec=""+currentsec;
                    Strmin=""+currentmin;
                    Strmil=""+currentmil;         
                  
                    //Formating values.
                    if (Strsec.length<2){
                         Strsec="0"+currentsec;
                    }
                    if (Strmin.length<2){
                         Strmin="0"+currentmin;
                    }
                    //Setting values. Minutes:seconds
                    txt.value = Strmin + ":" + Strsec;
                    //If you need show milliseconds too, use:  txt.value = Strmin + ":" + Strsec +":" + Strmil;
                    
                    //Se você precisar mostrar os milisegundos também ( 00:00:00), use assim:
                    //txt.value = Strmin + ":" + Strsec +":" + Strmil;
                    
                    
                    //Let's call our function again, using setTimeOut javascript method. (vamos chamar a função de novo, usando o setTimeOut do javascript).
                    //In call, we pass again input text id, button play id and our current milliseconds.
                    //Last argument (100) means => wait 100 milliseconds to call again. ( o 100 abaixo significa: espere 100 milisegundos, então chame a função de novo).
                    setTimeout("timer('"+txtid+"','"+btplayid+"',"+currentmil+")", 100);
        }
}
