/*
* (C) Systementor AB Stefan Holmberg
*/
namespace AdMentorNET
{
	using System;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.UI;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;

	/// <summary>
	///		Summary description for ucviewbanner.
	/// </summary>
	public abstract class ucviewbanner : System.Web.UI.UserControl
	{
		protected System.Web.UI.WebControls.Label lblStartDate;
		protected System.Web.UI.WebControls.Label lblEndDate;
		protected System.Web.UI.WebControls.Label lblWeight;
		protected System.Web.UI.WebControls.Label lblExposures;
		protected System.Web.UI.WebControls.Label lblClicks;
		protected System.Web.UI.WebControls.Label lblExpPerDay;
		protected System.Web.UI.WebControls.Label lblRatio;
		protected System.Web.UI.WebControls.DataGrid oDataGrid;
		protected System.Web.UI.WebControls.Label lblDestination;
		protected System.Web.UI.WebControls.HyperLink lblRedirUrl;
		protected System.Web.UI.WebControls.PlaceHolder PlaceHolder1;
		public long lBannerId;
		private void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here
			AdMentorDatabase db = new AdMentorDatabase();
			DataSet ds = db.GetBannerForEditing("bannerid=" + lBannerId.ToString());
			DataRow datarow = ds.Tables[0].Rows[0];
			DateTime dtFrom = AdMentorGlobals.AdMentorDBDateToDateTime((string)datarow["validfromdate"]);
			lblStartDate.Text = dtFrom.ToString("yyyy-mm-dd");
			DateTime dtTo = AdMentorGlobals.AdMentorDBDateToDateTime((string)datarow["validtodate"]);
			lblEndDate.Text = dtTo.ToString("yyyy-mm-dd");
			lblWeight.Text = datarow["weight"].ToString();
			lblExposures.Text = datarow["showcount"].ToString();
			lblClicks.Text = datarow["clickcount"].ToString();
			lblRedirUrl.Text = datarow["redirurl"].ToString();
			lblRedirUrl.NavigateUrl = datarow["redirurl"].ToString();
			bool bIsHtml = (bool)datarow["ishtml"];
			bool bCanTrackClicks = (bool)datarow["cantrackclicks"];
			if ( !bCanTrackClicks )
				lblClicks.Text = "N/A";
			string strIsHtml = "FALSE";
			if ( bIsHtml )
				strIsHtml = "TRUE";					
			lblRatio.Text = AdMentorGlobals.ClickRatio(lblExposures.Text,lblClicks.Text, strIsHtml,bCanTrackClicks.ToString());
			
			//Counts per day so far?
			System.TimeSpan sp = System.DateTime.Now - dtFrom;
			int nDays = sp.Days +1;
			if ( nDays <= 0 )
				nDays = 1;
			long lShowCount = Convert.ToInt64(datarow["showcount"]);
			double dPerDay = Convert.ToDouble(lShowCount)/Convert.ToDouble(nDays);
			lblExpPerDay.Text = dPerDay.ToString("F");

			//Show it
			string strTxt;
			strTxt = GetBannerHTML(datarow);
			PlaceHolder1.Controls.Add(new LiteralControl(strTxt));

			oDataGrid.DataSource = db.GetTraceClicks( Convert.ToInt32(lBannerId) );
			oDataGrid.DataBind();


		}
		private string GetBannerHTML( DataRow dr )
		{
			//Here we can create a HTML stuff which makes us not need session
			string strTxt;
			if ( (bool)dr["ishtml"] )
			{
				strTxt = (string)dr["htmlcode"];
			}
			else
			{
				strTxt = "<a href=\"";
				string strLoc = "http://" + Request["SERVER_NAME"];
				if ( Request.ApplicationPath.Length >1)
					strLoc+= Request.ApplicationPath;
				strTxt += strLoc + "/admentorserve.aspx?type=click&bannerid=" + dr["bbannerid"];
				string strPage = Server.UrlEncode(Request["HTTP_REFERER"]);
				strTxt += "&frompage=" + strPage;
				strTxt += "\"";
				if ( Request["target"] != null && (string)Request["target"] != "" )
					strTxt += " target=" + Request["target"];
				else
					strTxt += " target=_top";
				strTxt += ">";

				strTxt += "<img src=\"" + dr["gifurl"] + "\" border=\"0\">";
				strTxt += "</a>";
			}
			return strTxt;

		}		
		#region Web Form Designer generated code
	override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
