/*
* (C) Systementor AB Stefan Holmberg
*/
namespace AdMentorNET
{
	using System;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;

	public class user_MentorGridHandler : MentorGridHandlerBase
	{ 
		public override void OnEditControlsToRow( DataRow row, DataGrid oGrid, DataGridItem e, bool fIsInsert )
		{
			//We need to move controls to row
			TextBox txtName =(TextBox) e.FindControl("txtEditName");
			TextBox txtPwd =(TextBox) e.FindControl("txtEditPwd");
			TextBox txtFullName =(TextBox) e.FindControl("txtEditFullName");
			CheckBox cbEditAdmin = ( CheckBox)e.FindControl("cbEditAdmin");
			TextBox txtEmail =(TextBox) e.FindControl("txtEditEmailAddress");
			row["name"] = txtName.Text;
			row["fullname"] = txtFullName.Text;
			row["pwd"] = txtPwd.Text;
			row["admin"] = cbEditAdmin.Checked;
			row["emailaddress"] = txtEmail.Text;
			
		}
		public override void OnDeleteRowEvent( int nFldAuto )
		{
			//Nothing special to do, let the base class handle delete
		}
		public override void OnNewRow( DataRow row )
		{
			//Nothing special to do, let the base class handle new
		}
		public override bool OnCanDeleteRow( DataGrid oGrid, DataGridItem e )
		{
			//Kolla hur mnga som finns
			int nFldAutoToDelete = (int) oGrid.DataKeys[e.ItemIndex];
			if ( GetBannerCount( "active",nFldAutoToDelete)>0 )
				return false;
			if ( GetBannerCount( "nonactive",nFldAutoToDelete)>0 )
				return false;
			return true;
		}
		public static long GetBannerCount(string strActive, int nFldAuto )
		{
			AdMentorDatabase db = new AdMentorDatabase();
			long lFldAuto = Convert.ToInt32(nFldAuto);
			long lRet = 0;
			if ( strActive == "active" )
				lRet = db.GetBannerCountForAdvertiser(lFldAuto,true,false);
			else
				lRet = db.GetBannerCountForAdvertiser(lFldAuto,false, true);
			return lRet;
		}
	};

	/// <summary>
	///		Summary description for uczones.
	/// </summary>
	public abstract class ucusers : System.Web.UI.UserControl
	{
		protected System.Web.UI.WebControls.PlaceHolder PlaceHolderBefore;
		protected System.Web.UI.WebControls.PlaceHolder PlaceHolderAfter;
		protected System.Web.UI.WebControls.DataGrid oDataGrid;


		private void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here
		}

		public bool FixBool2( string sVal )
		{
			sVal = sVal.ToUpper();
			if ( sVal == "TRUE" || sVal == "YES" || sVal == "1" )
				return true;
			return false;
		}

		public string GetInformation( string strActive, string sFldAuto )
		{
			return user_MentorGridHandler.GetBannerCount(strActive,Convert.ToInt32(sFldAuto)).ToString();
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
			AdMentorDatabase db = new AdMentorDatabase();
			MentorGridExt oExt = new MentorGridExt(oDataGrid,new user_MentorGridHandler(),
				db.GetConnectionString(),"a_users","fldAuto","Full name",
				"user","","",true,true);
		}
		
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion


	}
}
