/*
* (C) Systementor AB Stefan Holmberg
*/
namespace AdMentorNET
{
	using System;
	using System.Data;
	using System.Data.OleDb;
	using System.Drawing;
	using System.Web;
	using System.Web.UI;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;
	using System.Collections;


	/// <summary>
	///		Summary description for uczones.
	/// </summary>
	public abstract class ucstats : System.Web.UI.UserControl
	{
		protected System.Web.UI.WebControls.PlaceHolder PlaceHolderBefore;
		protected System.Web.UI.WebControls.DataGrid oDataGrid;
		protected System.Web.UI.WebControls.Panel Panel1;
		protected System.Web.UI.WebControls.Label Label1;
		protected System.Web.UI.WebControls.ListBox lbFilterZones;
		protected System.Web.UI.WebControls.Label Label3;
		protected System.Web.UI.WebControls.ListBox lblAdvertisers;
		protected System.Web.UI.WebControls.Label Label2;
		protected System.Web.UI.WebControls.ListBox lblAdPositions;
		protected System.Web.UI.WebControls.Label Label4;
		protected System.Web.UI.WebControls.Button Button1;
		protected System.Web.UI.WebControls.PlaceHolder PlaceHolderAfter;
		public AdMentorUser m_oUser;
		private DataTable m_dtAdvertisers;
		string[] m_oStringListYears;
		string [] m_oStringListMonths;
		string [] m_oStringListDays;
		private DataTable m_dtAdpositions;
		private DataTable m_dtZones;
		protected System.Web.UI.WebControls.DropDownList ddlYearStart;
		protected System.Web.UI.WebControls.DropDownList ddlMonthStart;
		protected System.Web.UI.WebControls.DropDownList ddlDayStart;
		protected System.Web.UI.WebControls.Label Label5;
		protected System.Web.UI.WebControls.DropDownList ddlMonthEnd;
		protected System.Web.UI.WebControls.DropDownList ddlDayEnd;
		protected System.Web.UI.WebControls.DropDownList ddlYearEnd;
		protected long m_lTotalClicks; 
		protected long m_lTotalShows;

		private ArrayList  m_YearArray;
		private ArrayList  m_DayArray;
		private ArrayList  m_MonthArray;
		protected System.Web.UI.WebControls.Button Button2;
		protected System.Web.UI.WebControls.Button Button3;
		protected System.Web.UI.WebControls.Label lblReportName;
		protected System.Web.UI.WebControls.DataGrid oDataGrid2;
		protected System.Web.UI.WebControls.DataGrid oDataGrid3;
		int m_lStartYear=2002;

		int GetMonthIndex( string strName )
		{
			GetMonths();
			for ( int i = 0; i < 12; i++ )
			{
				string strName2 = ( string )m_MonthArray[i];
				if ( strName2 == strName )
					return i;
			}
			return 0;
		}

		public int GetDay( string strStartOrEnd )
		{
			string strTemp;
			if ( strStartOrEnd == "start" )
				strTemp = (string)ViewState["startdate"];
			else
				strTemp = (string)ViewState["enddate"];
			strTemp = strTemp.Substring(8,2);
			return Convert.ToInt16(strTemp)-1;
		}
		public int GetMonth( string strStartOrEnd )
		{
			string strTemp;
			if ( strStartOrEnd == "start" )
				strTemp = (string)ViewState["startdate"];
			else
				strTemp = (string)ViewState["enddate"];
			strTemp = strTemp.Substring(5,2);
			return Convert.ToInt16(strTemp)-1;
		}
		public int GetYear( string strStartOrEnd )
		{
			string strTemp;
			if ( strStartOrEnd == "start" )
				strTemp = (string)ViewState["startdate"];
			else
				strTemp = (string)ViewState["enddate"];
			strTemp = strTemp.Substring(0,4);
			return Convert.ToInt16(strTemp)-m_lStartYear;
		}

		public System.Collections.ICollection GetDays()
		{
			if (m_DayArray == null ) 
			{
				m_DayArray = new ArrayList();
				for ( int i = 1; i < 32; i++ )
					m_DayArray.Add( i.ToString() );
			}
			return m_DayArray;
		}
		public System.Collections.ICollection GetYears()
		{
			if (m_YearArray == null ) 
			{
				m_YearArray = new ArrayList();
				for ( int i = m_lStartYear; i < m_lStartYear+3; i++ )
					m_YearArray.Add( i.ToString() );
			}
			return m_YearArray;
		}

		public System.Collections.ICollection GetMonths()
		{
			if (m_MonthArray == null ) 
			{
				m_MonthArray = new ArrayList();
				m_MonthArray.Add("January");
				m_MonthArray.Add("February");
				m_MonthArray.Add("March");
				m_MonthArray.Add("April");
				m_MonthArray.Add("May");
				m_MonthArray.Add("June");
				m_MonthArray.Add("July");
				m_MonthArray.Add("August");
				m_MonthArray.Add("September");
				m_MonthArray.Add("October");
				m_MonthArray.Add("November");
				m_MonthArray.Add("December");
			}
			return m_MonthArray;
		}


		private void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here

			if (!IsPostBack )
			{
				lblReportName.Text = "Totals";
				m_lTotalClicks = 0; 
				m_lTotalShows = 0;
				DateTime dtNow = DateTime.Now;
				dtNow = dtNow.AddDays(-7);
				string strStartDate = dtNow.ToString("yyyy-MM-dd"); 
				dtNow = dtNow.AddDays(7);
				string strEndDate = dtNow.ToString("yyyy-MM-dd"); 
				ViewState["startdate"] = strStartDate;
				ViewState["enddate"] = strEndDate;
				BindGrid();
			}
			ddlYearEnd.DataBind();
			ddlYearStart.DataBind();
			ddlMonthEnd.DataBind();
			ddlMonthStart.DataBind();
			ddlDayEnd.DataBind();
			ddlDayStart.DataBind();
		
		}
		

	public System.Data.DataTable GetZones()
	{
		if ( m_dtZones		 != null )
			return m_dtZones		;
		AdMentorDatabase db = new AdMentorDatabase();
		m_dtZones		 = db.GetZones();
		return m_dtZones		;
	}
		public System.Data.DataTable GetAdpos()
		{
			if ( m_dtAdpositions != null )
				return m_dtAdpositions;
			AdMentorDatabase db = new AdMentorDatabase();
			m_dtAdpositions = db.GetAdPositions();
			return m_dtAdpositions;
		}
		
		
		public System.Data.DataTable GetAdvertisers()
		{
		if ( m_dtAdvertisers != null )
			return m_dtAdvertisers;
		AdMentorDatabase db = new AdMentorDatabase();
		m_dtAdvertisers = db.GetAdvertisers(-1);
		return m_dtAdvertisers;
		}


	public int GetSelectedAdpos( string nId )
	{
		if ( m_dtAdpositions == null )
			GetAdpos();
		for(int i=0;i<m_dtAdpositions.DefaultView.Count;i++)
		{
			if (m_dtAdpositions.DefaultView[i]["adposid"].ToString()==nId.ToString())
			{
				return i;
			}
		}
		return 0;
	}


		public int GetSelectedAdvertiser( string nId )
		{
			if ( m_dtAdvertisers == null )
				GetAdvertisers();
			for(int i=0;i<m_dtAdvertisers.DefaultView.Count;i++)
			{
				if (m_dtAdvertisers.DefaultView[i]["fldauto"].ToString()==nId.ToString())
				{
					return i;
				}
			}
			return 0;
		}

		public int Cal_GetYear( string strDat )
		{
			Cal_GetYears();
			if ( strDat == "" )
				 strDat = System.DateTime.Now.ToString("yyyy-MM-dd");
			string nYear = strDat.Substring(0,4);
			for ( int i = 0; i < m_oStringListYears.GetUpperBound(0); i++ )
				{
				if ( nYear ==(string)m_oStringListYears.GetValue(i) )
					return i;
				}
			return 0;
		}

		public int Cal_GetDay( string strDat )
		{
			Cal_GetMonths();
			if ( strDat == "" )
				strDat = System.DateTime.Now.ToString("yyyy-MM-dd");
			int nYear = Convert.ToInt32(strDat.Substring(8,2));
			return nYear-1;
		}


		public int Cal_GetMonth( string strDat )
		{
			Cal_GetMonths();
			if ( strDat == "" )
				strDat = System.DateTime.Now.ToString("yyyy-MM-dd");
			int nYear = Convert.ToInt32(strDat.Substring(5,2));
			return nYear-1;
		}


		public System.Collections.ICollection Cal_GetMonths()
		{
			if ( m_oStringListMonths != null )
				return m_oStringListMonths;
			m_oStringListMonths = new string[12];
			m_oStringListMonths.SetValue("January",0);
			m_oStringListMonths.SetValue("February",1);
			m_oStringListMonths.SetValue("March",2);
			m_oStringListMonths.SetValue("April",3);
			m_oStringListMonths.SetValue("May",4);
			m_oStringListMonths.SetValue("June",5);
			m_oStringListMonths.SetValue("July",6);
			m_oStringListMonths.SetValue("August",7);
			m_oStringListMonths.SetValue("September",8);
			m_oStringListMonths.SetValue("October",9);
			m_oStringListMonths.SetValue("November",10);
			m_oStringListMonths.SetValue("December",11);
			return m_oStringListMonths;
		}

		public System.Collections.ICollection Cal_GetDays()
		{
			if ( m_oStringListDays != null )
				return m_oStringListDays;
			m_oStringListDays = new string[31];
			for ( int i = 1; i <= 31;i++ )
				m_oStringListDays.SetValue(i.ToString(),i-1);
			return m_oStringListDays;
		}


		public System.Collections.ICollection Cal_GetYears()
		{
			if ( m_oStringListYears != null )
				return m_oStringListYears;
			m_oStringListYears = new string[10];
			m_oStringListYears.SetValue("1999",0);
			m_oStringListYears.SetValue("2000",1);
			m_oStringListYears.SetValue("2001",2);
			m_oStringListYears.SetValue("2002",3);
			m_oStringListYears.SetValue("2003",4);
			m_oStringListYears.SetValue("2004",5);
			m_oStringListYears.SetValue("2005",6);
			m_oStringListYears.SetValue("2006",7);
			m_oStringListYears.SetValue("2007",8);
			m_oStringListYears.SetValue("2008",9);
			return m_oStringListYears;
		}
		
		private System.Collections.ICollection GetActiveStatus()
		{
			string[] oStringList2 = new string[2];
			oStringList2.SetValue("Active",0);
			oStringList2.SetValue("Non-active",1);
			return oStringList2;
		}
		private void BindGrid()
		{
			AdMentorDatabase db = new AdMentorDatabase();
			if ( !IsPostBack )	
			{
				lbFilterZones.DataSource = db.GetZones();
				lbFilterZones.DataValueField = "zoneid";
				lbFilterZones.DataTextField = "zonename";
				lbFilterZones.DataBind();
				for ( int i = 0; i < lbFilterZones.Items.Count; i++ )
					lbFilterZones.Items[i].Selected = true;

				lblAdPositions.DataSource = db.GetAdPositions();
				lblAdPositions.DataValueField = "adposid";
				lblAdPositions.DataTextField = "name";
				lblAdPositions.DataBind();
				for ( int i = 0; i < lblAdPositions.Items.Count; i++ )
					lblAdPositions.Items[i].Selected = true;
			}

			
			int nFldAuto;
			if ( m_oUser.m_fAdmin )
				nFldAuto = -1;
			else
				nFldAuto = m_oUser.m_fldAuto;
			if ( !IsPostBack )	
			{
				lblAdvertisers.DataSource = db.GetAdvertisers( nFldAuto );
				lblAdvertisers.DataValueField = "fldAuto";
				lblAdvertisers.DataTextField = "fullname";
				lblAdvertisers.DataBind();
				for ( int i = 0; i < lblAdvertisers.Items.Count; i++ )
					lblAdvertisers.Items[i].Selected = true;
			}

			string strSortDir;
			if ( Attributes["sortdirection-z"] == null )
				strSortDir = "ASC";
			else
				strSortDir = Attributes["sortdirection-z"].ToString();

			string strSortField;
			if ( Attributes["sortfield-z"] == null )
				strSortField = "a_banner.bannerid";
			else
				strSortField = Attributes["sortfield-z"].ToString();
			if ( strSortField == "" )
				strSortField = "1";



			string strWhere;
			if ( m_oUser.m_fAdmin )
				strWhere = "";
			else
				strWhere = " a_banner.advid=" + m_oUser.m_fldAuto.ToString();
			
			string strZones = "";
			for ( int i = 0; i < lbFilterZones.Items.Count; i++ )
			{
				if ( lbFilterZones.Items[i].Selected == true )
				{
					if ( strZones != "" )
						strZones += "," ;
					strZones +=lbFilterZones.Items[i].Value.ToString();
				}
			}
			if ( strZones != "" )
			{
				if ( strWhere != "" )
					strWhere += " AND ";
				strWhere += " a_zone.zoneid in(" + strZones + ")";
			}


			string strAdvertisers = "";
			for ( int i = 0; i < lblAdvertisers.Items.Count; i++ )
			{
				if ( lblAdvertisers.Items[i].Selected == true )
				{
					if ( strAdvertisers != "" )
						strAdvertisers += "," ;
					strAdvertisers +=lblAdvertisers.Items[i].Value.ToString();
				}
			}
			if ( strAdvertisers != "" )
			{
				if ( strWhere != "" )
					strWhere += " AND ";
				strWhere += " a_banner.advid in(" + strAdvertisers + ")";
			}

			string strAdpos = "";
			for ( int i = 0; i < lblAdPositions.Items.Count; i++ )
			{
				if ( lblAdPositions.Items[i].Selected == true )
				{
					if ( strAdpos != "" )
						strAdpos += "," ;
					strAdpos+=lblAdPositions.Items[i].Value.ToString();
				}
			}
			if ( strAdpos != "" )
			{
				if ( strWhere != "" )
					strWhere += " AND ";
				strWhere += " a_banner.adpos_id in(" + strAdpos + ")";
			}
			//Active status

			
			DataSet ds;
			string strStartDate = "";
			string strEndDate = "";
			if ( ddlYearStart.SelectedItem == null )
			{
				strStartDate = System.DateTime.Now.AddDays(-7).ToString("yyyy-MM-dd");
				strEndDate = System.DateTime.Now.ToString("yyyy-MM-dd");
			}
			else
			{
				strStartDate = ddlYearStart.SelectedItem.Value + "-";
				int nMonth = GetMonthIndex(ddlMonthStart.SelectedItem.Value);
				nMonth++;
				if ( nMonth<10 )
					strStartDate += "0";
				strStartDate += nMonth.ToString() + "-";
				if ( ddlDayStart.SelectedItem.Value.Length == 1 )
					strStartDate += "0";
				strStartDate += ddlDayStart.SelectedItem.Value;
				strEndDate = ddlYearEnd.SelectedItem.Value + "-";
				nMonth = GetMonthIndex(ddlMonthEnd.SelectedItem.Value);
				nMonth++;
				if ( nMonth<10 )
					strEndDate += "0";
				strEndDate += nMonth.ToString() + "-";
				if ( ddlDayEnd.SelectedItem.Value.Length == 1 )
					strEndDate += "0";
				strEndDate += ddlDayEnd.SelectedItem.Value;
			}
			if ( lblReportName.Text == "Totals" )
			{
				oDataGrid.Visible = true;
				oDataGrid2.Visible = false;
				oDataGrid3.Visible = false;
				ds = db.GetBannersAndStats(strSortField,strSortDir,strWhere,strStartDate, strEndDate );
				oDataGrid.DataSource = ds;
				oDataGrid.DataBind();
			}
			if ( lblReportName.Text == "Per day/banner" )
			{
				oDataGrid.Visible = false;
				oDataGrid2.Visible = true;
				oDataGrid3.Visible = false;
				ds = db.GetBannersAndStats2(strSortField,strSortDir,strWhere,strStartDate, strEndDate );
				oDataGrid2.DataSource = ds;
				oDataGrid2.DataBind();
			}
			if ( lblReportName.Text == "Per day" )
			{
				oDataGrid.Visible = false;
				oDataGrid2.Visible = false;
				oDataGrid3.Visible = true;
				ds = db.GetBannersAndStats3(strSortField,strSortDir,strWhere,strStartDate, strEndDate );
				oDataGrid3.DataSource = ds;
				oDataGrid3.DataBind();
			}
		}

		
		
		private void lblEditZones_PreRender		(object sender, System.EventArgs e)
		{
		if ( ((string)ViewState["Operation"]) == "Add"  )
			return;
		
		ListBox b1 = ( ListBox) sender;
		//What should we select...
		AdMentorDatabase db = new AdMentorDatabase();
		DataTable dt = db.GetZonesForBanner((int)oDataGrid.DataKeys[oDataGrid.EditItemIndex] );
		b1.ClearSelection();
		foreach( DataRow row in dt.Rows )
		{
			for ( int i = 0; i < b1.Items.Count; i++ )
			{
			if ( b1.Items[i].Value == row["zoneid"].ToString() )
				b1.Items[i].Selected = true;
			}
		}
		}
		
		protected void FixColumns()
		{
			if ( ((string)ViewState["Operation"]) == "List"  )
			{
				for ( int n=0; n < oDataGrid.Columns.Count; n++ )
					oDataGrid.Columns[n].Visible = true;
				oDataGrid.EditItemIndex = -1;
				oDataGrid.Columns[0].HeaderText = "Name";
			}
			else
			{
				for ( int n=1; n < oDataGrid.Columns.Count; n++ )
					oDataGrid.Columns[n].Visible = false;
				oDataGrid.EditItemIndex = 0;
				oDataGrid.Columns[0].HeaderText = ((string)ViewState["Operation"]) + " banner";
			}
			if ( ((string)ViewState["Operation"]) == "List"  )
				Panel1.Visible = true;
			else
				Panel1.Visible = false;
			
			
		}
		private OleDbConnection GetDB()
		{
			AdMentorDatabase db = new AdMentorDatabase();
			OleDbConnection Conn = new System.Data.OleDb.OleDbConnection(db.GetConnectionString());
			return Conn;
		}		
		private string MakeDate( DataGridItem e, string sDay, string sMonth, string sYear )
		{
		if ( m_oStringListMonths == null )
			Cal_GetMonths();
		ListItem l = ((DropDownList) e.FindControl(sMonth)).SelectedItem;
		string nDay = ((DropDownList) e.FindControl(sDay)).SelectedItem.Text;
		string nMonth = ((DropDownList) e.FindControl(sMonth)).SelectedItem.Value;
		for ( int i = 0; i < 12; i++ )
		{
		if ( nMonth == (string)m_oStringListMonths.GetValue(i) )
			nMonth = (i +1).ToString();
		}
		string nYear = ((DropDownList) e.FindControl(sYear)).SelectedItem.Text;
		if ( nMonth.Length == 1 )
			nMonth = "0" + nMonth;
		if ( nDay.Length == 1 )
			nDay = "0" + nDay;
		return nYear + "-" + nMonth + "-" + nDay ;
		}
		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Button1.Click += new System.EventHandler(this.Button1_Click);
			this.Button2.Click += new System.EventHandler(this.Button2_Click);
			this.Button3.Click += new System.EventHandler(this.Button3_Click);
			this.oDataGrid.ItemCreated += new System.Web.UI.WebControls.DataGridItemEventHandler(this.oDataGrid_ItemCreated);
			this.oDataGrid.SortCommand += new System.Web.UI.WebControls.DataGridSortCommandEventHandler(this.oDataGrid_SortCommand);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void oDataGrid_SortCommand(object source, System.Web.UI.WebControls.DataGridSortCommandEventArgs e)
		{
			if ( Attributes["sortfield-z"] == null )
				Attributes.Add( "sortfield-z", e.SortExpression );
			if ( Attributes["sortdirection-z"] == null )
				Attributes.Add("sortdirection-z", "ASC");
			else
				if ( Attributes["sortdirection-z"] == "ASC" )
				Attributes.Add("sortdirection-z", "DESC");
			else
				Attributes.Add("sortdirection-z", "ASC");
			BindGrid();		
		}

		public string ClickRatio( string sShow, string strClicks, string strIsHtml, string strCanTrackClicks )
		{
			strIsHtml = strIsHtml.ToUpper();
			strCanTrackClicks = strCanTrackClicks.ToUpper();
			if ( strIsHtml == "1" || strIsHtml == "TRUE" )
				if ( strCanTrackClicks == "0" || strCanTrackClicks == "FALSE" )
					return "N/A - no click tracking";
			m_lTotalShows += Convert.ToInt64(sShow);
			m_lTotalClicks += Convert.ToInt64(strClicks);
			return AdMentorGlobals.ClickRatio( sShow,strClicks,strIsHtml, strCanTrackClicks );
		}


		private void oDataGrid_ItemCreated(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
		{
			switch (e.Item.ItemType)
			{
				case ListItemType.Footer:
					e.Item.Cells[0].Controls.Add( new LiteralControl("<b>TOTAL</b>") );
					e.Item.Cells[2].Controls.Add( new LiteralControl("<b>" + m_lTotalShows.ToString() + "</b>") );
					e.Item.Cells[3].Controls.Add( new LiteralControl("<b>" + m_lTotalClicks.ToString() + "</b>") );
					e.Item.Cells[4].Controls.Add( new LiteralControl("<b>" + AdMentorGlobals.ClickRatio(m_lTotalShows.ToString(),m_lTotalClicks.ToString(), "FALSE", "TRUE" ) + "</b>") );
					break;
				case ListItemType.Item:
				case ListItemType.AlternatingItem:
				{
					break;
				}
			}
		
		}

		private void Button1_Click(object sender, System.EventArgs e)
		{
			lblReportName.Text = "Totals";
			RunReport();
		}

		private void RunReport()
		{
			string strEnd = ddlYearEnd.SelectedItem.Value + "-";
			int nMonth = GetMonthIndex(ddlMonthEnd.SelectedItem.Value);
			nMonth++;
			if ( nMonth<10 )
				strEnd += "0";
			strEnd += nMonth.ToString() + "-";
			if ( ddlDayEnd.SelectedItem.Value.Length == 1 )
				strEnd += "0";
			strEnd += ddlDayEnd.SelectedItem.Value;

			string strStart = ddlYearStart.SelectedItem.Value + "-";
			nMonth = GetMonthIndex(ddlMonthStart.SelectedItem.Value);
			nMonth++;
			if ( nMonth<10 )
				strStart += "0";
			strStart += nMonth.ToString() + "-";
			if ( ddlDayStart.SelectedItem.Value.Length == 1 )
				strStart += "0";
			strStart += ddlDayStart.SelectedItem.Value;
			if ( strEnd.CompareTo(strStart)<0 )
				ViewState["startdate"] = strStart;
			ViewState["enddate"] = strEnd;
			BindGrid();
		}


		private void Button2_Click(object sender, System.EventArgs e)
		{
			lblReportName.Text = "Per day/banner";
			RunReport();
		}

		private void Button3_Click(object sender, System.EventArgs e)
		{
			lblReportName.Text = "Per day";
			RunReport();
		}



	}
}
