<%@ Control Language="c#" AutoEventWireup="false" Codebehind="ucstats.ascx.cs" Inherits="AdMentorNET.ucstats" TargetSchema="http://schemas.microsoft.com/intellisense/ie5"%>
<asp:panel id="Panel1" runat="server" CssClass="Grid_Item" BorderStyle="Groove" HorizontalAlign="Left">
	<B>Filter</B>
	<TABLE class="Grid_Item">
		<TR>
			<TD vAlign="top">
				<asp:Label id="Label1" CssClass="Grid_Item" runat="server">Zones</asp:Label></TD>
			<TD vAlign="top">
				<asp:ListBox id="lbFilterZones" CssClass="Grid_Item" runat="server" SelectionMode="Multiple"></asp:ListBox></TD>
			<TD vAlign="top">
				<asp:Label id="Label3" CssClass="Grid_Item" runat="server">Advertisers</asp:Label></TD>
			<TD vAlign="top">
				<asp:ListBox id="lblAdvertisers" CssClass="Grid_Item" runat="server" SelectionMode="Multiple"></asp:ListBox></TD>
			<TD vAlign="top">
				<asp:Label id="Label2" CssClass="Grid_Item" runat="server">Ad positions</asp:Label></TD>
			<TD vAlign="top">
				<asp:ListBox id="lblAdPositions" CssClass="Grid_Item" runat="server" SelectionMode="Multiple"></asp:ListBox></TD>
		</TR>
		<TR>
			<TD>
				<asp:label id="Label4" CssClass="Grid_item" runat="server">From</asp:label></TD>
			<TD colSpan="2">
				<asp:dropdownlist id=ddlYearStart CssClass="Grid_item" runat="server" DataSource="<%# GetYears() %>" SelectedIndex='<%# GetYear("start") %>'>
				</asp:dropdownlist>
				<asp:dropdownlist id=ddlMonthStart CssClass="Grid_item" runat="server" DataSource="<%# GetMonths() %>" SelectedIndex='<%# GetMonth("start") %>'>
				</asp:dropdownlist>
				<asp:dropdownlist id=ddlDayStart CssClass="Grid_item" runat="server" DataSource="<%# GetDays() %>" SelectedIndex='<%# GetDay("start") %>'>
				</asp:dropdownlist></TD>
			<TD>
				<asp:label id="Label5" CssClass="Grid_item" runat="server">To</asp:label></TD>
			<TD colSpan="2">
				<asp:dropdownlist id=ddlYearEnd CssClass="Grid_item" runat="server" DataSource="<%# GetYears() %>" SelectedIndex='<%# GetYear("end") %>'>
				</asp:dropdownlist>
				<asp:dropdownlist id=ddlMonthEnd CssClass="Grid_item" runat="server" DataSource="<%# GetMonths() %>" SelectedIndex='<%# GetMonth("end") %>'>
				</asp:dropdownlist>
				<asp:dropdownlist id=ddlDayEnd CssClass="Grid_item" runat="server" DataSource="<%# GetDays() %>" SelectedIndex='<%# GetDay("end") %>'>
				</asp:dropdownlist></TD>
		</TR>
		<TR>
			<TD vAlign="top">
				<asp:Button id="Button1" CssClass="Button" runat="server" Text="Totals"></asp:Button></TD>
			<TD vAlign="top">
				<asp:Button id="Button2" CssClass="Button" runat="server" Text="Per day/banner"></asp:Button></TD>
			<TD vAlign="top" colSpan="2">
				<asp:Button id="Button3" CssClass="Button" runat="server" Text="Per day"></asp:Button></TD>
		</TR>
	</TABLE>
</asp:panel>
<P><asp:placeholder id="PlaceHolderBefore" runat="server"></asp:placeholder><asp:label id="lblReportName" runat="server" Font-Bold="True">Totals</asp:label></P>
<DIV align="center"><asp:datagrid id="oDataGrid" runat="server" CssClass="Grid_general" AllowSorting="True" AutoGenerateColumns="False" DataKeyField="bbannerid" ShowFooter="True">
		<SelectedItemStyle CssClass="Grid_SelectedItem"></SelectedItemStyle>
		<AlternatingItemStyle CssClass="Grid_AlternatingItem"></AlternatingItemStyle>
		<ItemStyle CssClass="Grid_Item"></ItemStyle>
		<HeaderStyle CssClass="Grid_Header"></HeaderStyle>
		<FooterStyle CssClass="Grid_Footer"></FooterStyle>
		<Columns>
			<asp:TemplateColumn SortExpression="a_banner.name" HeaderText="Name">
				<ItemStyle VerticalAlign="Top"></ItemStyle>
				<ItemTemplate>
					<%# DataBinder.Eval(Container.DataItem,"bname") %>
				</ItemTemplate>
			</asp:TemplateColumn>
			<asp:TemplateColumn SortExpression="[a_banner].weight" HeaderText="Weight">
				<ItemStyle VerticalAlign="Top"></ItemStyle>
				<ItemTemplate>
					<%# DataBinder.Eval(Container.DataItem,"bweight").ToString() %>
				</ItemTemplate>
			</asp:TemplateColumn>
			<asp:TemplateColumn SortExpression="a_banner.showcount" HeaderText="Total impressions">
				<ItemStyle VerticalAlign="Top"></ItemStyle>
				<ItemTemplate>
					<%# DataBinder.Eval(Container.DataItem,"bshowcount").ToString() %>
				</ItemTemplate>
			</asp:TemplateColumn>
			<asp:TemplateColumn SortExpression="a_banner.clickcount" HeaderText="Clickcount">
				<ItemStyle VerticalAlign="Top"></ItemStyle>
				<ItemTemplate>
					<%# DataBinder.Eval(Container.DataItem,"bclickcount").ToString() %>
				</ItemTemplate>
			</asp:TemplateColumn>
			<asp:TemplateColumn HeaderText="Click ratio">
				<ItemStyle VerticalAlign="Top"></ItemStyle>
				<ItemTemplate>
					<%# ClickRatio( DataBinder.Eval(Container.DataItem,"bshowcount").ToString(), DataBinder.Eval(Container.DataItem,"bclickcount").ToString(), DataBinder.Eval(Container.DataItem,"bishtml").ToString(), DataBinder.Eval(Container.DataItem,"bcantrackclicks").ToString() )%>
				</ItemTemplate>
			</asp:TemplateColumn>
			<asp:TemplateColumn>
				<ItemStyle VerticalAlign="Top"></ItemStyle>
				<ItemTemplate>
					<asp:HyperLink runat="server" Text='View banner' NavigateUrl='<%# "admin.aspx?what=viewbanner&bid=" +
		DataBinder.Eval(Container.DataItem,"bbannerid").ToString()   %>' ID="Hyperlink3">
					</asp:HyperLink>
				</ItemTemplate>
			</asp:TemplateColumn>
		</Columns>
	</asp:datagrid>
	<P>&nbsp;</P>
	<P><asp:placeholder id="PlaceHolderAfter" runat="server"></asp:placeholder></P>
	<P>
		<asp:datagrid id="oDataGrid2" runat="server" CssClass="Grid_general" AllowSorting="False" AutoGenerateColumns="False" DataKeyField="fldAuto" ShowFooter="True">
			<SelectedItemStyle CssClass="Grid_SelectedItem"></SelectedItemStyle>
			<AlternatingItemStyle CssClass="Grid_AlternatingItem"></AlternatingItemStyle>
			<ItemStyle CssClass="Grid_Item"></ItemStyle>
			<HeaderStyle CssClass="Grid_Header"></HeaderStyle>
			<FooterStyle CssClass="Grid_Footer"></FooterStyle>
			<Columns>
				<asp:TemplateColumn HeaderText="Date">
					<ItemStyle VerticalAlign="Top"></ItemStyle>
					<ItemTemplate>
						<%# DataBinder.Eval(Container.DataItem,"datum") %>
					</ItemTemplate>
				</asp:TemplateColumn>
				<asp:TemplateColumn HeaderText="Name">
					<ItemStyle VerticalAlign="Top"></ItemStyle>
					<ItemTemplate>
						<%# DataBinder.Eval(Container.DataItem,"bname") %>
					</ItemTemplate>
				</asp:TemplateColumn>
				<asp:TemplateColumn HeaderText="Weight">
					<ItemStyle VerticalAlign="Top"></ItemStyle>
					<ItemTemplate>
						<%# DataBinder.Eval(Container.DataItem,"bweight").ToString() %>
					</ItemTemplate>
				</asp:TemplateColumn>
				<asp:TemplateColumn HeaderText="Total impressions">
					<ItemStyle VerticalAlign="Top"></ItemStyle>
					<ItemTemplate>
						<%# DataBinder.Eval(Container.DataItem,"bshowcount").ToString() %>
					</ItemTemplate>
				</asp:TemplateColumn>
				<asp:TemplateColumn HeaderText="Clickcount">
					<ItemStyle VerticalAlign="Top"></ItemStyle>
					<ItemTemplate>
						<%# DataBinder.Eval(Container.DataItem,"bclickcount").ToString() %>
					</ItemTemplate>
				</asp:TemplateColumn>
				<asp:TemplateColumn HeaderText="Click ratio">
					<ItemStyle VerticalAlign="Top"></ItemStyle>
					<ItemTemplate>
						<%# ClickRatio( DataBinder.Eval(Container.DataItem,"bshowcount").ToString(), 
										DataBinder.Eval(Container.DataItem,"bclickcount").ToString(), 
										DataBinder.Eval(Container.DataItem,"bishtml").ToString(), 
										DataBinder.Eval(Container.DataItem,"bcantrackclicks").ToString() )%>
					</ItemTemplate>
				</asp:TemplateColumn>
				<asp:TemplateColumn>
					<ItemStyle VerticalAlign="Top"></ItemStyle>
					<ItemTemplate>
						<asp:HyperLink runat="server" Text='View banner' NavigateUrl='<%# "admin.aspx?what=viewbanner&bid=" +
		DataBinder.Eval(Container.DataItem,"bbannerid").ToString()   %>' ID="Hyperlink32">
						</asp:HyperLink>
					</ItemTemplate>
				</asp:TemplateColumn>
			</Columns>
		</asp:datagrid></P>
	<P>
		<asp:datagrid id="oDataGrid3" runat="server" CssClass="Grid_general" AllowSorting="False" AutoGenerateColumns="False" DataKeyField="datum" ShowFooter="True">
			<SelectedItemStyle CssClass="Grid_SelectedItem"></SelectedItemStyle>
			<AlternatingItemStyle CssClass="Grid_AlternatingItem"></AlternatingItemStyle>
			<ItemStyle CssClass="Grid_Item"></ItemStyle>
			<HeaderStyle CssClass="Grid_Header"></HeaderStyle>
			<FooterStyle CssClass="Grid_Footer"></FooterStyle>
			<Columns>
				<asp:TemplateColumn HeaderText="Date">
					<ItemStyle VerticalAlign="Top"></ItemStyle>
					<ItemTemplate>
						<%# DataBinder.Eval(Container.DataItem,"datum") %>
					</ItemTemplate>
				</asp:TemplateColumn>
				<asp:TemplateColumn HeaderText="Total impressions">
					<ItemStyle VerticalAlign="Top"></ItemStyle>
					<ItemTemplate>
						<%# DataBinder.Eval(Container.DataItem,"bshowcount").ToString() %>
					</ItemTemplate>
				</asp:TemplateColumn>
				<asp:TemplateColumn HeaderText="Clickcount">
					<ItemStyle VerticalAlign="Top"></ItemStyle>
					<ItemTemplate>
						<%# DataBinder.Eval(Container.DataItem,"bclickcount").ToString() %>
					</ItemTemplate>
				</asp:TemplateColumn>
			</Columns>
		</asp:datagrid></P>
</DIV>
