/*
* (C) Systementor AB Stefan Holmberg
*/
namespace AdMentorNET
{
	using System;
	using System.Data;
	using System.Data.OleDb;
	using System.Drawing;
	using System.Web;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;


	/// <summary>
	///		Summary description for uczones.
	/// </summary>
	public abstract class ucbanners : System.Web.UI.UserControl
	{
		protected System.Web.UI.WebControls.DataGrid oDataGrid;
		public AdMentorUser m_oUser;
		private bool m_fAllowDelete = true;
		private bool m_fAllowNew = true;
		private DataTable m_dtAdvertisers;
		string[] m_oStringListYears;
		string [] m_oStringListMonths;
		string [] m_oStringListDays;
		private DataTable m_dtAdpositions;
		protected System.Web.UI.WebControls.Label Label1;
		protected System.Web.UI.WebControls.ListBox lbFilterZones;
		protected System.Web.UI.WebControls.Label Label3;
		protected System.Web.UI.WebControls.ListBox lblAdvertisers;
		protected System.Web.UI.WebControls.Label Label2;
		protected System.Web.UI.WebControls.ListBox lblAdPositions;
		protected System.Web.UI.WebControls.Label Label4;
		protected System.Web.UI.WebControls.ListBox lblActiveStatus;
		protected System.Web.UI.WebControls.Button Button1;
		protected System.Web.UI.WebControls.Panel Panel1;
		protected System.Web.UI.WebControls.PlaceHolder PlaceHolderBefore;
		protected System.Web.UI.WebControls.PlaceHolder PlaceHolderAfter;
		private DataTable m_dtZones;

		bool IsHtml()
		{
			if ( ViewState["ishtml"] == null )
				return false;
			if ( (string)ViewState["ishtml"] == "yes" )
				return true;
			return false;
		}

		private void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here
			if ( ViewState["Operation"] == null )
			{
				if ( oDataGrid.EditItemIndex == -1 )
					ViewState["Operation"] = "List";
				else
					ViewState["Operation"] = "Edit";
				BindGrid();
				return;
			}
			if ( ((string)ViewState["Operation"]) == "" )
			{
				if ( oDataGrid.EditItemIndex == -1 )
					ViewState["Operation"] = "List";
				else
					ViewState["Operation"] = "Edit";
				BindGrid();
			}
			if ( !IsPostBack )
			{
				BindGrid();
			}
		}
		

	public System.Data.DataTable GetZones()
	{
		if ( m_dtZones != null )
			return m_dtZones;
		AdMentorDatabase db = new AdMentorDatabase();
		m_dtZones = db.GetZones();
		return m_dtZones;
	}
		public System.Data.DataTable GetAdpos()
		{
			if ( m_dtAdpositions != null )
				return m_dtAdpositions;
			AdMentorDatabase db = new AdMentorDatabase();
			m_dtAdpositions = db.GetAdPositions();
			return m_dtAdpositions;
		}
		
		
		public System.Data.DataTable GetAdvertisers()
		{
		if ( m_dtAdvertisers != null )
			return m_dtAdvertisers;
		AdMentorDatabase db = new AdMentorDatabase();
		m_dtAdvertisers = db.GetAdvertisers(-1);
		return m_dtAdvertisers;
		}


	public int GetSelectedAdpos( string nId )
	{
		if ( m_dtAdpositions == null )
			GetAdpos();
		for(int i=0;i<m_dtAdpositions.DefaultView.Count;i++)
		{
			if (m_dtAdpositions.DefaultView[i]["adposid"].ToString()==nId.ToString())
				return i;
		}
		return 0;
	}


		public int GetSelectedAdvertiser( string nId )
		{
			if ( m_dtAdvertisers == null )
				GetAdvertisers();
			for(int i=0;i<m_dtAdvertisers.DefaultView.Count;i++)
			{
				if (m_dtAdvertisers.DefaultView[i]["fldauto"].ToString()==nId.ToString())
					return i;
			}
			return 0;
		}

		public int Cal_GetYear( string strDat, string strStartEnd )
		{
			Cal_GetYears();
			if ( strDat == "" )
				{
				DateTime dt = DateTime.Now;
				if ( strStartEnd == "end" )
					dt = dt.AddYears(1);
				 strDat = dt.ToString("yyyy-MM-dd");
				 }
			string nYear = strDat.Substring(0,4);
			for ( int i = 0; i < m_oStringListYears.GetUpperBound(0); i++ )
				{
				if ( nYear ==(string)m_oStringListYears.GetValue(i) )
					return i;
				}
			return 0;
		}

		public int Cal_GetDay( string strDat , string strStartEnd)
		{
			Cal_GetDays();
			if ( strDat == "" )
			{
				DateTime dt = DateTime.Now;
				if ( strStartEnd == "end" )
					dt = dt.AddYears(1);
				strDat = dt.ToString("yyyy-MM-dd");
			}
			int nYear = Convert.ToInt32(strDat.Substring(8,2));
			return nYear-1;
		}


		public int Cal_GetMonth( string strDat, string strStartEnd )
		{
			Cal_GetMonths();
			if ( strDat == "" )
			{
				DateTime dt = DateTime.Now;
				if ( strStartEnd == "end" )
					dt = dt.AddYears(1);
				strDat = dt.ToString("yyyy-MM-dd");
			}
			int nYear = Convert.ToInt32(strDat.Substring(5,2));
			return nYear-1;
		}


		public System.Collections.ICollection Cal_GetMonths()
		{
			if ( m_oStringListMonths != null )
				return m_oStringListMonths;
			m_oStringListMonths = new string[12];
			m_oStringListMonths.SetValue("January",0);
			m_oStringListMonths.SetValue("February",1);
			m_oStringListMonths.SetValue("March",2);
			m_oStringListMonths.SetValue("April",3);
			m_oStringListMonths.SetValue("May",4);
			m_oStringListMonths.SetValue("June",5);
			m_oStringListMonths.SetValue("July",6);
			m_oStringListMonths.SetValue("August",7);
			m_oStringListMonths.SetValue("September",8);
			m_oStringListMonths.SetValue("October",9);
			m_oStringListMonths.SetValue("November",10);
			m_oStringListMonths.SetValue("December",11);
			return m_oStringListMonths;
		}

		public System.Collections.ICollection Cal_GetDays()
		{
			if ( m_oStringListDays != null )
				return m_oStringListDays;
			m_oStringListDays = new string[31];
			for ( int i = 1; i <= 31;i++ )
				m_oStringListDays.SetValue(i.ToString(),i-1);
			return m_oStringListDays;
		}


		public System.Collections.ICollection Cal_GetYears()
		{
			if ( m_oStringListYears != null )
				return m_oStringListYears;
			m_oStringListYears = new string[10];
			m_oStringListYears.SetValue("1999",0);
			m_oStringListYears.SetValue("2000",1);
			m_oStringListYears.SetValue("2001",2);
			m_oStringListYears.SetValue("2002",3);
			m_oStringListYears.SetValue("2003",4);
			m_oStringListYears.SetValue("2004",5);
			m_oStringListYears.SetValue("2005",6);
			m_oStringListYears.SetValue("2006",7);
			m_oStringListYears.SetValue("2007",8);
			m_oStringListYears.SetValue("2008",9);
			return m_oStringListYears;
		}
		
		private System.Collections.ICollection GetActiveStatus()
		{
			string[] oStringList2 = new string[2];
			oStringList2.SetValue("Active",0);
			oStringList2.SetValue("Non-active",1);
			return oStringList2;
		}
		private void BindGrid()
		{
			AdMentorDatabase db = new AdMentorDatabase();
			if ( !IsPostBack )	
			{
			lbFilterZones.DataSource = db.GetZones();
			lbFilterZones.DataValueField = "zoneid";
			lbFilterZones.DataTextField = "zonename";
			lbFilterZones.DataBind();

			lblAdPositions.DataSource = db.GetAdPositions();
			lblAdPositions.DataValueField = "adposid";
			lblAdPositions.DataTextField = "name";
			lblAdPositions.DataBind();
			}
			
			int nFldAuto;
			if ( m_oUser.m_fAdmin )
				nFldAuto = -1;
			else
				{
				nFldAuto = m_oUser.m_fldAuto;
				}
			if ( !IsPostBack )	
			{
			lblAdvertisers.DataSource = db.GetAdvertisers( nFldAuto );
			lblAdvertisers.DataValueField = "fldAuto";
			lblAdvertisers.DataTextField = "fullname";
			lblAdvertisers.DataBind();

			lblActiveStatus.DataSource = GetActiveStatus();
			lblActiveStatus.DataBind();
			}
			if ( !IsPostBack )
			{
				lblActiveStatus.ClearSelection();
				if ( Request["status"] == null )
					lblActiveStatus.Items[0].Selected = true;
				else
				{
					if ( Request["status"] == "both" )
					{
						lblActiveStatus.Items[0].Selected = true;
						lblActiveStatus.Items[1].Selected = true;
					}
					else if ( Request["status"] == "active" )
					{
						lblActiveStatus.Items[0].Selected = true;
					}
					else if ( Request["status"] == "nonactive" )
					{
						lblActiveStatus.Items[1].Selected = true;
					}
					else
						lblActiveStatus.Items[0].Selected = true;
				}


				lblAdPositions.ClearSelection();
				for ( int i = 0; i < lblAdPositions.Items.Count; i++ )
					if ( Request["adpos"] != null )
					{
						if ( lblAdPositions.Items[i].Value == Request["adpos"] )
							lblAdPositions.Items[i].Selected = true;
					}
					else
					{
						lblAdPositions.Items[i].Selected = true;
					}

				lbFilterZones.ClearSelection();
				string[] strZoneArray = new string[1];
				if ( Request["zones"] != null )
				{
					//Extract to list?
					string strZonesInRequest = Request["zones"];
					strZoneArray = strZonesInRequest.Split(',');
				}
				for ( int i = 0; i < lbFilterZones.Items.Count; i++ )
				{
					if ( Request["zones"] != null )
					{
						bool fFound = false;
						for ( int j = 0; j < strZoneArray.GetLength(0); j++ )
						{
							if ( (string)strZoneArray.GetValue(j) == lbFilterZones.Items[i].Value )
							{
								fFound = true;
								break;
							}
						} 
						lbFilterZones.Items[i].Selected = fFound;
					}
					else
					{
						lbFilterZones.Items[i].Selected = true;
					}
				}
				lblAdvertisers.ClearSelection();
				for ( int i = 0; i < lblAdvertisers.Items.Count; i++ )
				{
					if ( m_oUser.m_fAdmin && Request["advertiser"] != null )
					{
						if ( lblAdvertisers.Items[i].Value == Request["advertiser"] )
							lblAdvertisers.Items[i].Selected = true;
					}
					else
					{
						lblAdvertisers.Items[i].Selected = true;
					}
				}
			}

			string strSortDir;
			if ( Attributes["sortdirection-z"] == null )
				strSortDir = "ASC";
			else
				strSortDir = Attributes["sortdirection-z"].ToString();

			string strSortField;
			if ( Attributes["sortfield-z"] == null )
				strSortField = "a_banner.bannerid";
			else
				strSortField = Attributes["sortfield-z"].ToString();
			if ( strSortField == "" )
				strSortField = "1";



			string strWhere;
			if ( m_oUser.m_fAdmin )
				strWhere = "";
			else
				strWhere = " a_banner.advid=" + m_oUser.m_fldAuto.ToString();
			
			string strZones = "";
			for ( int i = 0; i < lbFilterZones.Items.Count; i++ )
			{
				if ( lbFilterZones.Items[i].Selected == true )
				{
					if ( strZones != "" )
						strZones += "," ;
					strZones +=lbFilterZones.Items[i].Value.ToString();
				}
			}
			if ( strZones != "" )
			{
				if ( strWhere != "" )
					strWhere += " AND ";
				strWhere += " a_zone.zoneid in(" + strZones + ")";
			}


			string strAdvertisers = "";
			for ( int i = 0; i < lblAdvertisers.Items.Count; i++ )
			{
				if ( lblAdvertisers.Items[i].Selected == true )
				{
					if ( strAdvertisers != "" )
						strAdvertisers += "," ;
					strAdvertisers +=lblAdvertisers.Items[i].Value.ToString();
				}
			}
			if ( strAdvertisers != "" )
			{
				if ( strWhere != "" )
					strWhere += " AND ";
				strWhere += " a_banner.advid in(" + strAdvertisers + ")";
			}

			string strAdpos = "";
			for ( int i = 0; i < lblAdPositions.Items.Count; i++ )
			{
				if ( lblAdPositions.Items[i].Selected == true )
				{
					if ( strAdpos != "" )
						strAdpos += "," ;
					strAdpos+=lblAdPositions.Items[i].Value.ToString();
				}
			}
			if ( strAdpos != "" )
			{
				if ( strWhere != "" )
					strWhere += " AND ";
				strWhere += " a_banner.adpos_id in(" + strAdpos + ")";
			}
			//Active status
			bool fActive = lblActiveStatus.Items[0].Selected;
			bool fNonActive = lblActiveStatus.Items[1].Selected;
			if ( fActive && !fNonActive )
			{
				//Only active
				
			}
			if ( !fActive && fNonActive )
			{
				//Only nonactive
			}
			

			
			DataSet ds;
			//Now check if we are editing/adding new?
			if ( ((string)ViewState["Operation"]) != "List"  )
			{
				strWhere = "bannerid=";
				if (oDataGrid.EditItemIndex == -1 )
					strWhere += "-1";
				else
					strWhere += oDataGrid.DataKeys[oDataGrid.EditItemIndex].ToString();
				ds = db.GetBannerForEditing(strWhere);
			}
			else
				ds = db.GetBanners(strSortField,strSortDir,strWhere, fActive, fNonActive );
			if ( ((string)ViewState["Operation"]) == "Add"  )
			{
				DataRow dr;
				dr = ds.Tables["zones"].NewRow();
				dr["bannerid"] = -1;
				dr["bbannerid"] = -1;
				dr["maxclicks"] = 0;
				dr["maximpressions"] = 0;
				dr["weight"] = 0;
				ds.Tables["zones"].Rows.InsertAt(dr, 0);
				
			}
			if ( ((string)ViewState["Operation"]) == "Edit"  )
			{
				DataRow dr = ds.Tables["zones"].Rows[0];
				if ( (bool)dr["ishtml"] == true )
					ViewState["ishtml"] = "yes";
				else
					ViewState["ishtml"] = "no";
			}
			
			

			FixColumns();
			oDataGrid.DataSource = ds;
			oDataGrid.DataBind();
		
		}
		
		
		private void lblEditZones_PreRender		(object sender, System.EventArgs e)
		{
		if ( ((string)ViewState["Operation"]) == "Add"  )
			return;
		
		ListBox b1 = ( ListBox) sender;
		//What should we select...
		AdMentorDatabase db = new AdMentorDatabase();
		DataTable dt = db.GetZonesForBanner((int)oDataGrid.DataKeys[oDataGrid.EditItemIndex] );
		b1.ClearSelection();
		for ( int i = 0; i < dt.Rows.Count; i++ )
		{
			for ( int j = 0; j < b1.Items.Count; j++ )
			{
				DataRow row = dt.Rows[i];
			if ( b1.Items[j].Value == row["zoneid"].ToString() )
				b1.Items[j].Selected = true;
			}
		}
		}
		
		protected void FixColumns()
		{
			if ( ((string)ViewState["Operation"]) == "List"  )
			{
				for ( int n=0; n < oDataGrid.Columns.Count; n++ )
					oDataGrid.Columns[n].Visible = true;
				oDataGrid.EditItemIndex = -1;
				oDataGrid.Columns[0].HeaderText = "Name";
			}
			else
			{
				for ( int n=1; n < oDataGrid.Columns.Count; n++ )
					oDataGrid.Columns[n].Visible = false;
				oDataGrid.EditItemIndex = 0;
				oDataGrid.Columns[0].HeaderText = ((string)ViewState["Operation"]) + " banner";
			}
			if ( ((string)ViewState["Operation"]) == "List"  )
				Panel1.Visible = true;
			else
				Panel1.Visible = false;
			
			
		}
		private OleDbConnection GetDB()
		{
			AdMentorDatabase db = new AdMentorDatabase();
			OleDbConnection Conn = new System.Data.OleDb.OleDbConnection(db.GetConnectionString());
			return Conn;
		}		
		private void btnUpdate_Click(object sender, System.EventArgs e)
		{
			//			TextBox txtName =(TextBox) e.Item.FindControl("txtEditName");
			//			TextBox txtDescription =(TextBox) e.Item.FindControl("txtEditDescr");
			int nfldAuto = (int)oDataGrid.DataKeys[oDataGrid.EditItemIndex];
			string strSQL = "select * from a_banner where bannerid=" + oDataGrid.DataKeys[oDataGrid.EditItemIndex].ToString();
			
			OleDbConnection oCn = GetDB();
			OleDbDataAdapter oDA = new OleDbDataAdapter(strSQL,oCn); 
			DataSet oDs = new DataSet(); 
			oDA.Fill(oDs,"hej"); 
			DataRow oDR;
			bool fNew = false;
			if ( nfldAuto == -1 )
			{
				oDR = oDs.Tables["hej"].NewRow();
				oDs.Tables["hej"].Rows.Add(oDR);
				fNew = true;
			}
			else
			{
				oDR = oDs.Tables["hej"].Rows[0];
			}	
			DataGridItem e2 = oDataGrid.Items[oDataGrid.EditItemIndex];
			//Controls to row
			oDR["name"] = ((TextBox) e2.FindControl("txtEditName")).Text;
			oDR["redirurl"] = ((TextBox) e2.FindControl("txtEditRedirUrl")).Text;

			oDR["gifurl"] = ((TextBox) e2.FindControl("txtEditGifUrl")).Text;
			oDR["weight"] = ((TextBox) e2.FindControl("txtEditWeight")).Text;
			oDR["alttext"] = ((TextBox) e2.FindControl("txtEditAlttext")).Text;
			if ( fNew )
				{
				oDR["showcount"] = 0;
				oDR["clickcount"] = 0;
				}
			//oDR["showcount"] = ((TextBox) e2.FindControl("txtEditRedirUrl")).Text;
			//oDR["clickcount"] = ((TextBox) e.2FindControl("txtEditRedirUrl")).Text;
			oDR["adpos_id"] = ((DropDownList) e2.FindControl("lbEditAdPosition")).SelectedItem.Value;
			oDR["validfromdate"] = MakeDate(e2, "lblDayStart", "lblMonthStart", "lblYearStart" );
			
			if ( fNew )
				{
				if ( IsHtml() )
				{
					oDR["maxclicks"] = 0;
					oDR["ishtml"] = true;
				}
				else
				{
					oDR["ishtml"] = false;
					oDR["maxclicks"] = ((TextBox) e2.FindControl("txtEditMaxClicks")).Text;
				}
				}
			else
				{
				if ( ((TextBox) e2.FindControl("txtEditMaxClicks")).Text == "" )
					oDR["maxclicks"] = 0;
				else
					oDR["maxclicks"] = ((TextBox) e2.FindControl("txtEditMaxClicks")).Text;
				//oDR["ishtml"] = false;
				}

			if ( IsHtml() )
				{
				oDR["htmlcode"] = ((TextBox) e2.FindControl("txtEditHTMLCode")).Text;
				int nFindIndex = oDR["htmlcode"].ToString().IndexOf("<ADM_CLICKURL");
				oDR["cantrackclicks"] = nFindIndex>0;
				}
			else
				{
				oDR["htmlcode"] = " ";
				oDR["cantrackclicks"] = true;
				}

			oDR["maximpressions"] = ((TextBox) e2.FindControl("txtEditMaxImpressions")).Text;
			oDR["validtodate"] = MakeDate(e2, "lblDayEnd", "lblMonthEnd", "lblYearEnd" );
			oDR["advid"] = ((DropDownList) e2.FindControl("lblAdvertiser")).SelectedItem.Value;
			
			
			
			OleDbCommandBuilder builder = new OleDbCommandBuilder(oDA);
			oDA.UpdateCommand = builder.GetUpdateCommand();
			oDA.InsertCommand = builder.GetInsertCommand();
			
			dbhelper helper = new dbhelper(oCn,"bannerid", oDA);
			
			oDA.Update(oDs,"hej"); 
			string  sBannerId = oDR["bannerid"].ToString();
			oDA.Dispose();	
			//Now go onto setting banzones
			if ( oCn.State == ConnectionState.Closed )
				oCn.Open();
			OleDbCommand oCommand = oCn.CreateCommand();
			oCommand.CommandText = "delete from a_banzone where bannerid=" +sBannerId;
			oCommand.ExecuteNonQuery();
			
			//Nu skall vi kra insert
			ListBox lbZones = (ListBox) e2.FindControl("lbEditZones");
			oCommand = oCn.CreateCommand();
			for ( int i=0; i < lbZones.Items.Count;i++ )
				{
				if ( lbZones.Items[i].Selected == true )
					{
					oCommand.CommandText = "insert into a_banzone(bannerid,zoneid) values( " + sBannerId + "," + lbZones.Items[i].Value + ")";
					oCommand.ExecuteNonQuery();
					}
				}
			oCn.Close();
			oCn.Dispose();
			
			//			oDB.UpdateZone(nfldAuto, txtName.Text, txtDescription.Text);
			oDataGrid.EditItemIndex = -1;
			ViewState["Operation"] = "List";
			BindGrid();
		}

		private string MakeDate( DataGridItem e, string sDay, string sMonth, string sYear )
		{
		if ( m_oStringListMonths == null )
			Cal_GetMonths();
		ListItem l = ((DropDownList) e.FindControl(sMonth)).SelectedItem;
		string nDay = ((DropDownList) e.FindControl(sDay)).SelectedItem.Text;
		string nMonth = ((DropDownList) e.FindControl(sMonth)).SelectedItem.Value;
		for ( int i = 0; i < 12; i++ )
		{
		if ( nMonth == (string)m_oStringListMonths.GetValue(i) )
			nMonth = (i +1).ToString();
		}
		string nYear = ((DropDownList) e.FindControl(sYear)).SelectedItem.Text;
		if ( nMonth.Length == 1 )
			nMonth = "0" + nMonth;
		if ( nDay.Length == 1 )
			nDay = "0" + nDay;
		return nYear + "-" + nMonth + "-" + nDay ;
		}
		private void btnAdd_Click(object sender, System.EventArgs e)
		{
			Button b1 = ( Button ) sender;
			if ( b1.Text == "New banner" )
				ViewState["ishtml"] = "no";
			else
				ViewState["ishtml"] = "yes";
			ViewState["Operation"] = "Add";
			BindGrid();
		}
		private void btnEdit_Click(object sender, System.EventArgs e)
		{
			Button lc;
			lc = (Button) sender;
			DataGridItem container = (DataGridItem) lc.NamingContainer;
			oDataGrid.EditItemIndex = container.ItemIndex;
			ViewState["Operation"] = "Edit";
			BindGrid();
		}

		private void btnDelete_Click(object sender, System.EventArgs e)
		{
			Button lc;
			lc = (Button) sender;
			DataGridItem container = (DataGridItem) lc.NamingContainer;
			int nItem = container.ItemIndex;

			int nFldAutoToDelete = (int) oDataGrid.DataKeys[nItem];
			OleDbConnection Conn =GetDB();

			OleDbCommand oCommand = Conn.CreateCommand();

			Conn.Open();
			oCommand.CommandText = "delete from a_banner where bannerid=" + nFldAutoToDelete.ToString();
			oCommand.ExecuteNonQuery();

			oCommand.CommandText = "delete from a_banzone where bannerid=" + nFldAutoToDelete.ToString();
			oCommand.ExecuteNonQuery();

			oCommand.CommandText = "delete from a_traceclicks where bannerid=" + nFldAutoToDelete.ToString();
			oCommand.ExecuteNonQuery();
			
			oCommand.CommandText = "delete from a_bannerstats where bannerid=" + nFldAutoToDelete.ToString();
			oCommand.ExecuteNonQuery();

			Conn.Close();


			ViewState["Operation"] = "List";
			BindGrid();
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			oDataGrid.EditItemIndex = -1;
			ViewState["Operation"] = "List";
			BindGrid();
		}





		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Button1.Click += new System.EventHandler(this.Button1_Click);
			this.oDataGrid.ItemCreated += new System.Web.UI.WebControls.DataGridItemEventHandler(this.oDataGrid_ItemCreated);
			this.oDataGrid.SortCommand += new System.Web.UI.WebControls.DataGridSortCommandEventHandler(this.oDataGrid_SortCommand_1);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void oDataGrid_SortCommand(object source, System.Web.UI.WebControls.DataGridSortCommandEventArgs e)
		{
			if ( Attributes["sortfield-z"] == null )
				Attributes.Add( "sortfield-z", e.SortExpression );
			if ( Attributes["sortdirection-z"] == null )
				Attributes.Add("sortdirection-z", "ASC");
			else
				if ( Attributes["sortdirection-z"] == "ASC" )
				Attributes.Add("sortdirection-z", "DESC");
			else
				Attributes.Add("sortdirection-z", "ASC");
			BindGrid();		
		}

		private void oDataGrid_ItemCreated(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
		{
			switch (e.Item.ItemType)
			{
				case ListItemType.EditItem:
				{
					ListBox b1 = (ListBox)e.Item.FindControl("lbEditZones");
					TextBox b2 = (TextBox)e.Item.FindControl("txtEditMaxClicks");
					RangeValidator b3 = (RangeValidator)e.Item.FindControl("RangevalidatorEditMaxClicks");
					Label lblEditMaxClicks = (Label)e.Item.FindControl("lblEditMaxClicks");
					b1.PreRender += new System.EventHandler(lblEditZones_PreRender);
					Panel oReg = (Panel)e.Item.FindControl("panelRegular");
					Panel oHtml = (Panel)e.Item.FindControl("panelHTML");
					
					if ( (string)ViewState["ishtml"] == "yes" )
					{
						oReg.Visible = false;
						oHtml.Visible = true;
						b2.Visible = false;
						b3.Visible = false;
						lblEditMaxClicks.Visible = false;
					}
					else
					{
						oReg.Visible = true;
						oHtml.Visible = false;
						b2.Visible = true;
						b3.Visible = true;
						lblEditMaxClicks.Visible = true;
					}

				}
				break;
				case ListItemType.Footer:
					if ( m_oUser.m_fAdmin )
					{
						if ( ((string)ViewState["Operation"]) == ""  )
						{
							if ( m_fAllowNew )
							{
								Button AddBut = new Button();
								AddBut.CssClass = "Button";
								AddBut.Text = "New banner";
								AddBut.Click += new System.EventHandler(this.btnAdd_Click);
								AddBut.Visible = true;
								e.Item.Cells[0].Controls.Add( AddBut );
								AddBut = new Button();
								AddBut.CssClass = "Button";
								AddBut.Text = "New HTML banner";
								AddBut.Click += new System.EventHandler(this.btnAdd_Click);
								AddBut.Visible = true;
								e.Item.Cells[0].Controls.Add( AddBut );
							}
						}
						else if ( ((string)ViewState["Operation"]) == "List"  )
						{
							if ( m_fAllowNew )
							{
								Button AddBut = new Button();
								AddBut.CssClass = "Button";
								AddBut.Text = "New banner";
								AddBut.Click += new System.EventHandler(this.btnAdd_Click);
								AddBut.Visible = true;
								e.Item.Cells[0].Controls.Add( AddBut );
								AddBut = new Button();
								AddBut.CssClass = "Button";
								AddBut.Text = "New HTML banner";
								AddBut.Click += new System.EventHandler(this.btnAdd_Click);
								AddBut.Visible = true;
								e.Item.Cells[0].Controls.Add( AddBut );
							}
						}
						else
						{
							Button AddBut = new Button();
							AddBut.CssClass = "Button";
							AddBut.Text = "Update";
							AddBut.Click += new System.EventHandler(this.btnUpdate_Click);
							AddBut.Visible = true;
							e.Item.Cells[0].Controls.Add( AddBut );
							AddBut = new Button();
							AddBut.CssClass = "Button";
							AddBut.Text = "Cancel";
							AddBut.Click += new System.EventHandler(this.btnCancel_Click);
							AddBut.CausesValidation = false;
							AddBut.Visible = true;
							e.Item.Cells[0].Controls.Add( AddBut );
						}
						oDataGrid.ShowFooter = true;
					}
					//					e.Item.Cells[1].Controls.Add( new LiteralControl("</div>") );
					break;
				case ListItemType.Pager:
					break;
				case ListItemType.Item:
				case ListItemType.AlternatingItem:
				{
					if ( ((string)ViewState["Operation"]) == "List"  )
					{
						if ( m_oUser.m_fAdmin )
						{
							Button AddBut = new Button();
							AddBut.CssClass = "Button";
							AddBut.Text = "Edit";
							AddBut.Visible = true;
							AddBut.Click += new System.EventHandler(this.btnEdit_Click);
							//					LinkButton myDeleteButton = (LinkButton) e.Item.FindControl("Delete") ; 
							e.Item.Cells[oDataGrid.Columns.Count-2].Controls.Add( AddBut );
							if ( m_fAllowDelete )
							{
								AddBut = new Button();
								AddBut.CssClass = "Button";
								AddBut.Text = "Delete";
								AddBut.Visible = true;
								AddBut.Click += new System.EventHandler(this.btnDelete_Click);
								//					LinkButton myDeleteButton = (LinkButton) e.Item.FindControl("Delete") ; 
								AddBut.Attributes.Add("onclick", "return confirm('Are you sure you want to delete this banner? It will delete all banner stats as well for the banner');");
								e.Item.Cells[oDataGrid.Columns.Count-1].Controls.Add( AddBut );
							}
						}
					}
					break;
				}
			}
		
		}

		private void Button1_Click(object sender, System.EventArgs e)
		{
			BindGrid();
		}

		private void oDataGrid_SortCommand_1(object source, System.Web.UI.WebControls.DataGridSortCommandEventArgs e)
		{
			if ( Attributes["sortfield-z"] == null )
				Attributes.Add( "sortfield-z", e.SortExpression );
			if ( Attributes["sortdirection-z"] == null )
				Attributes.Add("sortdirection-z", "ASC");
			else
				if ( Attributes["sortdirection-z"] == "ASC" )
				Attributes.Add("sortdirection-z", "DESC");
			else
				Attributes.Add("sortdirection-z", "ASC");
			BindGrid();
		}



	}
}
