<%@ Control Language="c#" AutoEventWireup="false" Codebehind="ucbanners.ascx.cs" Inherits="AdMentorNET.ucbanners" TargetSchema="http://schemas.microsoft.com/intellisense/ie5"%>
<asp:panel id="Panel1" HorizontalAlign="Left" BorderStyle="Groove" CssClass="Grid_Item" runat="server">
	<B>Filter</B>
	<TABLE class="Grid_Item">
		<TR>
			<TD vAlign="top">
				<asp:Label id="Label1" runat="server" CssClass="Grid_Item">Zones</asp:Label></TD>
			<TD vAlign="top">
				<asp:ListBox id="lbFilterZones" runat="server" CssClass="Grid_Item" SelectionMode="Multiple"></asp:ListBox></TD>
			<TD vAlign="top">
				<asp:Label id="Label3" runat="server" CssClass="Grid_Item">Advertisers</asp:Label></TD>
			<TD vAlign="top">
				<asp:ListBox id="lblAdvertisers" runat="server" CssClass="Grid_Item" SelectionMode="Multiple"></asp:ListBox></TD>
		</TR>
		<TR>
			<TD vAlign="top">
				<asp:Label id="Label2" runat="server" CssClass="Grid_Item">Ad positions</asp:Label></TD>
			<TD vAlign="top">
				<asp:ListBox id="lblAdPositions" runat="server" CssClass="Grid_Item" SelectionMode="Multiple"></asp:ListBox></TD>
			<TD vAlign="top">
				<asp:Label id="Label4" runat="server" CssClass="Grid_Item">Active status</asp:Label></TD>
			<TD vAlign="top">
				<asp:ListBox id="lblActiveStatus" runat="server" CssClass="Grid_Item" SelectionMode="Multiple"></asp:ListBox></TD>
		</TR>
		<TR>
			<TD vAlign="top" colSpan="4">
				<asp:Button id="Button1" runat="server" CssClass="Button" Text="Submit"></asp:Button></TD>
		</TR>
	</TABLE>
</asp:panel>
<P><asp:placeholder id="PlaceHolderBefore" runat="server"></asp:placeholder></P>
<DIV align="center"><asp:datagrid id="oDataGrid" CssClass="Grid_general" runat="server" ShowFooter="True" DataKeyField="bbannerid" AutoGenerateColumns="False" AllowSorting="True">
		<SelectedItemStyle CssClass="Grid_SelectedItem"></SelectedItemStyle>
		<AlternatingItemStyle CssClass="Grid_AlternatingItem"></AlternatingItemStyle>
		<ItemStyle CssClass="Grid_Item"></ItemStyle>
		<HeaderStyle CssClass="Grid_Header"></HeaderStyle>
		<FooterStyle CssClass="Grid_Footer"></FooterStyle>
		<Columns>
			<asp:TemplateColumn SortExpression="a_banner.name" HeaderText="Name">
				<ItemStyle VerticalAlign="Top"></ItemStyle>
				<ItemTemplate>
					<%# DataBinder.Eval(Container.DataItem,"bname") %>
				</ItemTemplate>
				<EditItemTemplate>
					<TABLE class="Grid_Item">
						<TR>
							<TD colSpan="4">
								<HR>
							</TD>
						</TR>
						<TR>
							<TD colSpan="4"><B>General campaign info</B></TD>
						</TR>
						<TR>
							<TD>Campaign name</TD>
							<TD colSpan="3">
								<asp:TextBox id=txtEditName CssClass="TextBox" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"name") %>' Width="100%" TextMode="SingleLine" Columns="40">
								</asp:TextBox>
								<asp:RequiredFieldValidator id="Requiredfieldvalidator2" runat="server" Display="Dynamic" ControlToValidate="txtEditName">* Name is required
								</asp:RequiredFieldValidator></TD>
						</TR>
						<TR>
							<TD>Advertiser</TD>
							<TD colSpan="3">
								<asp:DropDownList id=lblAdvertiser CssClass="TextBox" runat="server" Width="180" SelectedIndex='<%# GetSelectedAdvertiser( DataBinder.Eval(Container.DataItem,"advid").ToString()) %>' DataValueField="fldAuto" DataTextField="fullname" DataSource="<%#  GetAdvertisers() %>">
								</asp:DropDownList>
								<asp:RequiredFieldValidator id="Requiredfieldvalidator1" runat="server" Display="Dynamic" ControlToValidate="lblAdvertiser">* Advertiser is required
								</asp:RequiredFieldValidator></TD>
						</TR>
						<TR>
							<TD>Campaign start</TD>
							<TD>
								<asp:DropDownList id=lblDayStart CssClass="TextBox" runat="server" Width="180" SelectedIndex='<%# Cal_GetDay( DataBinder.Eval(Container.DataItem,"validfromdate").ToString(), "start") %>' DataSource="<%#  Cal_GetDays() %>">
								</asp:DropDownList>
								<asp:DropDownList id=lblMonthStart CssClass="TextBox" runat="server" Width="180" SelectedIndex='<%# Cal_GetMonth( DataBinder.Eval(Container.DataItem,"validfromdate").ToString(), "start") %>' DataSource="<%#  Cal_GetMonths() %>">
								</asp:DropDownList>
								<asp:DropDownList id=lblYearStart CssClass="TextBox" runat="server" Width="180" SelectedIndex='<%# Cal_GetYear( DataBinder.Eval(Container.DataItem,"validfromdate").ToString(), "start") %>' DataSource="<%#  Cal_GetYears() %>">
								</asp:DropDownList></TD>
							<TD>Campaign end</TD>
							<TD>
								<asp:DropDownList id=lblDayEnd CssClass="TextBox" runat="server" Width="180" SelectedIndex='<%# Cal_GetDay( DataBinder.Eval(Container.DataItem,"validtodate").ToString(), "end") %>' DataSource="<%#  Cal_GetDays() %>">
								</asp:DropDownList>
								<asp:DropDownList id=lblMonthEnd CssClass="TextBox" runat="server" Width="180" SelectedIndex='<%# Cal_GetMonth( DataBinder.Eval(Container.DataItem,"validtodate").ToString(), "end") %>' DataSource="<%#  Cal_GetMonths() %>">
								</asp:DropDownList>
								<asp:DropDownList id=lblYearEnd CssClass="TextBox" runat="server" Width="180" SelectedIndex='<%# Cal_GetYear( DataBinder.Eval(Container.DataItem,"validtodate").ToString(), "end") %>' DataSource="<%#  Cal_GetYears() %>">
								</asp:DropDownList></TD>
						</TR>
						<TR>
							<TD>Impressions bought<br>
								( 0 means no limit/not applicable)</TD>
							<TD>
								<asp:TextBox id=txtEditMaxImpressions CssClass="TextBox" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"maximpressions") %>' Width="50" TextMode="SingleLine" Columns="40">
								</asp:TextBox>
								<asp:RangeValidator id="Requiredfieldvalidator3" runat="server" Display="Dynamic" ControlToValidate="txtEditMaxImpressions" MinimumValue="0" MaximumValue="999999999">* Bought impressions should be numeric
								</asp:RangeValidator></TD>
							<TD>
								<asp:Label id="lblEditMaxClicks" CssClass="Grid_Item" Runat="server">Clicks bought<br>( 0 means no limit/not applicable)</asp:Label></TD>
							<TD>
								<asp:TextBox id=txtEditMaxClicks CssClass="TextBox" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"maxclicks") %>' Width="50" TextMode="SingleLine" Columns="40">
								</asp:TextBox>
								<asp:RangeValidator id="RangevalidatorEditMaxClicks" runat="server" Display="Dynamic" ControlToValidate="txtEditMaxClicks" MinimumValue="0" MaximumValue="999999999">* Max clicks should be numeric
								</asp:RangeValidator>
							</TD>
						</TR>
						<TR>
							<TD colSpan="4">
								<HR>
							</TD>
						</TR>
						<TR>
							<TD colSpan="4"><B>Banner data</B></TD>
						</TR>
						<TR>
							<TD colspan="2">Weight ( relative to other banners, 0 means it wont be shown at all 
								)
							</TD>
							<TD colspan="2">
								<asp:TextBox id="txtEditWeight" CssClass="TextBox" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"weight") %>' Width="50" TextMode="SingleLine" Columns="5">
								</asp:TextBox>
								<asp:RangeValidator id="Rangevalidator2" runat="server" Display="Dynamic" ControlToValidate="txtEditWeight" MinimumValue="0" MaximumValue="500">* Weight error. Numeric value between 0 and 500 please.
								</asp:RangeValidator></TD>
						</TR>
						<tr>
							<td colspan="4">
								<asp:panel id="panelRegular" HorizontalAlign="Left" CssClass="Grid_Item" runat="server">
									<table class="Grid_Item">
										<TR>
											<TD colspan="1">Image url (path to gif/jpeg picture)<br>
												(For remote invocation to work - always specify full path, for example 
												http://www.yourserver.com/banners/test.gif</TD>
											<TD colSpan="3">
												<asp:TextBox id=txtEditGifUrl CssClass="TextBox" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"gifurl") %>' Width="150" TextMode="SingleLine" Columns="80">
												</asp:TextBox>
												<asp:RequiredFieldValidator id="Requiredfieldvalidator4" runat="server" Display="Dynamic" ControlToValidate="txtEditGifUrl">* Image url is required
											</asp:RequiredFieldValidator>
											</TD>
										</TR>
										<TR>
											<TD colspan="1">Click through url</TD>
											<TD colSpan="3">
												<asp:TextBox id=txtEditRedirUrl CssClass="TextBox" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"redirurl") %>' Width="100%" TextMode="SingleLine" Columns="80">
												</asp:TextBox>
												<asp:RequiredFieldValidator id="Requiredfieldvalidator5" runat="server" Display="Dynamic" ControlToValidate="txtEditRedirUrl">* Redir url is required
											</asp:RequiredFieldValidator>
											</TD>
										</TR>
										<TR>
											<TD>Alttext (optional)</TD>
											<TD colSpan="3">
												<asp:TextBox id=txtEditAlttext CssClass="TextBox" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"alttext") %>' Width="100%" TextMode="SingleLine" Columns="80">
												</asp:TextBox></TD>
										</TR>
									</table>
								</asp:panel>
								<asp:panel id="panelHTML" HorizontalAlign="Left" CssClass="Grid_Item" runat="server">
									<table class="Grid_Item">
										<TR>
											<TD><b>HTML code</b><br>
												There are also some special tags you can use whereever in your HTML code;
												<P>&lt;ADM_RANDOM-XXX-YYY&gt;
													<BR>
													This will be changed to a random number between XXX and YYY</P>
												<P>&lt;ADM_RANDOM-LAST&gt;
													<BR>
													Same number as last time</P>
												<P>&lt;ADM_CLICKURL-http://www.yoururl.com&gt;
													<BR>
													Enables click tracking for HTML banners. Replace http://www.yoururl.com with 
													the real clickthrough url</P>
											</TD>
											<TD colSpan="3">
												<asp:TextBox id=txtEditHTMLCode runat="server" CssClass="TextBox" Text='<%# DataBinder.Eval(Container.DataItem,"htmlcode") %>' Columns="40" TextMode="MultiLine" Rows="10">
												</asp:TextBox><br>
												<asp:RequiredFieldValidator id="Requiredfieldvalidator8" runat="server" Display="Dynamic" ControlToValidate="txtEditHTMLCode">* HTML code is required
											</asp:RequiredFieldValidator></TD>
										</TR>
									</table>
								</asp:panel>
							</td>
						</tr>
						<tr>
							<TD colSpan="4">
								<HR>
							</TD>
						</tr>
						<TR>
							<TD colSpan="4"><B>Targetting</B></TD>
						</TR>
						<TR>
							<TD>Ad position</TD>
							<TD>
								<asp:DropDownList id=lbEditAdPosition CssClass="TextBox" runat="server" Width="180" SelectedIndex='<%# GetSelectedAdpos( DataBinder.Eval(Container.DataItem,"adpos_id").ToString()) %>' DataValueField="adposid" DataTextField="name" DataSource="<%#  GetAdpos() %>">
								</asp:DropDownList>
								<asp:RequiredFieldValidator id="Requiredfieldvalidator6" runat="server" Display="Dynamic" ControlToValidate="lbEditAdPosition">* Ad position is required
								</asp:RequiredFieldValidator>
							</TD>
							<TD>Zones</TD>
							<TD>
								<asp:ListBox id=lbEditZones CssClass="Grid_Item" runat="server" SelectionMode="Multiple" DataValueField="zoneid" DataTextField="zonename" DataSource="<%#  GetZones() %>">
								</asp:ListBox>
								<asp:RequiredFieldValidator id="Requiredfieldvalidator7" runat="server" Display="Dynamic" ControlToValidate="lbEditZones">* At least one zone is required
								</asp:RequiredFieldValidator>
							</TD>
						</TR>
					</TABLE>
				</EditItemTemplate>
			</asp:TemplateColumn>
			<asp:TemplateColumn SortExpression="[a_banner].weight" HeaderText="Weight">
				<ItemStyle VerticalAlign="Top"></ItemStyle>
				<ItemTemplate>
					<%# DataBinder.Eval(Container.DataItem,"bweight").ToString() %>
				</ItemTemplate>
			</asp:TemplateColumn>
			<asp:TemplateColumn SortExpression="a_banner.showcount" HeaderText="Total impressions">
				<ItemStyle VerticalAlign="Top"></ItemStyle>
				<ItemTemplate>
					<%# DataBinder.Eval(Container.DataItem,"bshowcount").ToString() %>
				</ItemTemplate>
			</asp:TemplateColumn>
			<asp:TemplateColumn SortExpression="a_banner.clickcount" HeaderText="Clickcount">
				<ItemStyle VerticalAlign="Top"></ItemStyle>
				<ItemTemplate>
					<%# DataBinder.Eval(Container.DataItem,"bclickcount").ToString() %>
				</ItemTemplate>
			</asp:TemplateColumn>
			<asp:TemplateColumn SortExpression="a_adposition.name" HeaderText="Ad position">
				<ItemStyle VerticalAlign="Top"></ItemStyle>
				<ItemTemplate>
					<%# DataBinder.Eval(Container.DataItem,"pname").ToString() %>
				</ItemTemplate>
			</asp:TemplateColumn>
			<asp:TemplateColumn HeaderText="Zones">
				<ItemStyle VerticalAlign="Top"></ItemStyle>
				<ItemTemplate>
					<%# DataBinder.Eval(Container.DataItem,"zones").ToString() %>
				</ItemTemplate>
			</asp:TemplateColumn>
			<asp:TemplateColumn>
				<ItemStyle VerticalAlign="Top"></ItemStyle>
				<ItemTemplate>
					<asp:HyperLink runat="server" Text='View banner' NavigateUrl='<%# "admin.aspx?what=viewbanner&bid=" +
		DataBinder.Eval(Container.DataItem,"bbannerid").ToString()   %>' ID="Hyperlink3">
					</asp:HyperLink>
				</ItemTemplate>
			</asp:TemplateColumn>
			<asp:TemplateColumn HeaderText="">
				<ItemStyle VerticalAlign="Top"></ItemStyle>
				<ItemTemplate>
				</ItemTemplate>
			</asp:TemplateColumn>
			<asp:TemplateColumn HeaderText="">
				<ItemStyle VerticalAlign="Top"></ItemStyle>
				<ItemTemplate>
				</ItemTemplate>
			</asp:TemplateColumn>
		</Columns>
	</asp:datagrid>
	<P>&nbsp;</P>
</DIV>
<P><asp:placeholder id="PlaceHolderAfter" runat="server"></asp:placeholder></P>
