/*
* (C) Systementor AB Stefan Holmberg
*/
namespace AdMentorNET
{
	using System;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;

	public class adpos_MentorGridHandler : MentorGridHandlerBase
	{ 
		public override void OnEditControlsToRow( DataRow row, DataGrid oGrid, DataGridItem e, bool fIsInsert )
		{
			//We need to move controls to row
			TextBox txtName =(TextBox) e.FindControl("txtEditName");
			TextBox txtDescription =(TextBox) e.FindControl("txtEditDescr");
			DropDownList ddlDefaultBanner =(DropDownList) e.FindControl("lbEditDefaultBanner");
			row["name"] = txtName.Text;
			row["description"] = txtDescription.Text;
			row["defaultbanner"] = Convert.ToInt32(ddlDefaultBanner.SelectedItem.Value);
		}
		public override void OnDeleteRowEvent( int nFldAuto )
		{
			//Nothing special to do, let the base class handle delete
		}
		public override void OnNewRow( DataRow row )
		{
			//Nothing special to do, let the base class handle new
		}
		public override bool OnCanDeleteRow( DataGrid oGrid, DataGridItem e )
		{
			//Kolla hur mnga som finns
			int nFldAutoToDelete = (int) oGrid.DataKeys[e.ItemIndex];
			if ( GetBannerCount( "active",nFldAutoToDelete)>0 )
				return false;
			if ( GetBannerCount( "nonactive",nFldAutoToDelete)>0 )
				return false;
			return true;
		}
		public static long GetBannerCount(string strActive, int nFldAuto )
		{
			AdMentorDatabase db = new AdMentorDatabase();
			long lFldAuto = Convert.ToInt32(nFldAuto);
			long lRet = 0;
			if ( strActive == "active" )
				lRet = db.GetBannerCountForAdpos(lFldAuto,true,false);
			else
				lRet = db.GetBannerCountForAdpos(lFldAuto,false, true);
			return lRet;
		}
	};

	/// <summary>
	///		Summary description for uczones.
	/// </summary>
	public abstract class ucadpositions : System.Web.UI.UserControl
	{
		protected System.Web.UI.WebControls.PlaceHolder PlaceHolderBefore;
		protected DataGrid oDataGrid;
		protected System.Web.UI.WebControls.PlaceHolder PlaceHolderAfter;
		private DataTable m_dtBanners;

		public System.Data.DataTable GetDefaultBanners()
		{
			if ( m_dtBanners != null )
				return m_dtBanners;
			AdMentorDatabase db = new AdMentorDatabase();
			m_dtBanners = db.GetDefaultBanners();
			DataRow row = m_dtBanners.NewRow();
			row["bannerid"] = 0;
			row["name"] = "<None>";
			m_dtBanners.Rows.InsertAt(row,0);
			return m_dtBanners;
		}

		public int GetSelectedDefaultBanner( string nId )
		{
			if ( m_dtBanners == null )
				GetDefaultBanners();
			for(int i=0;i<m_dtBanners.DefaultView.Count;i++)
			{
				if (m_dtBanners.DefaultView[i]["bannerid"].ToString()==nId.ToString())
					return i;
			}
			return 0;
		}

		


		private void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here

		}


		public string GetInformation( string strActive, string sFldAuto )
		{
			return adpos_MentorGridHandler.GetBannerCount(strActive, Convert.ToInt32(sFldAuto)).ToString();
		}


		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
			AdMentorDatabase db = new AdMentorDatabase();
			MentorGridExt oExt = new MentorGridExt(oDataGrid,new adpos_MentorGridHandler(),
				db.GetConnectionString(),"a_adposition","adposid","Name",
				"ad position","","",true,true);

		}
		
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion


	}
}
