/*
* (C) Systementor AB Stefan Holmberg
*/
using System;
using System.Data;
using System.Data.OleDb;

namespace AdMentorNET
{
	/// <summary>
	/// Summary description for dbhelper.
	/// </summary>
	public class dbhelper
	{
		static private OleDbConnection	m_Conn;
		static private string m_strAutoNumberFieldName;
		static private OleDbDataAdapter m_DataAdapter;
		public dbhelper( OleDbConnection	Conn, string strAutoNumberFieldName, OleDbDataAdapter da )
		{
		m_DataAdapter = da;
		m_strAutoNumberFieldName = strAutoNumberFieldName;
		m_Conn = Conn;
		m_DataAdapter.RowUpdated += new OleDbRowUpdatedEventHandler(OnRowUpdated);
		}
		
		protected static void OnRowUpdated(object sender, OleDbRowUpdatedEventArgs args)
		{
			// Include a variable and a command to retrieve the identity value from the Access database.
			int newID = 0;
			OleDbCommand idCMD = new OleDbCommand("SELECT @@IDENTITY", m_Conn);

			if (args.StatementType == StatementType.Insert)
			{
				// Retrieve the identity value and store it in the CategoryID column.
				try
				{
					newID = Convert.ToInt32(idCMD.ExecuteScalar());
				}
				catch
				{
					
				}
				args.Row[m_strAutoNumberFieldName] = newID;
			}
		}
		
	}
	public class AdMentorDBExecutor
	{
		public static DataSet GetDataSet( string strConn, string strSQL, string strTableName )
		{
			OleDbConnection Conn = new OleDbConnection(strConn);
			Conn.Open();
			DataSet oDataSet = new System.Data.DataSet(strTableName);

			OleDbDataAdapter oAdapter = new OleDbDataAdapter(strSQL,Conn);
			oAdapter.Fill(oDataSet, strTableName);
			Conn.Close();
			Conn.Dispose();

			return oDataSet;
		}

		public static DataTable GetTable1VarCharParam( string strConn, string strSQL, string strValue, int nColumnLen )
		{
			OleDbConnection Conn = new OleDbConnection(strConn);
			Conn.Open();
			DataSet oDataSet = new System.Data.DataSet("temp");
			OleDbCommand oCommand = Conn.CreateCommand();
			oCommand.CommandText = strSQL;
			oCommand.Parameters.Add("@param1", System.Data.OleDb.OleDbType.VarChar,nColumnLen).Value=strValue;
			OleDbDataAdapter oAdapter = new OleDbDataAdapter("",Conn);
			oAdapter.SelectCommand = oCommand;
			oAdapter.Fill(oDataSet, "temp");
			Conn.Close();
			Conn.Dispose();
			return oDataSet.Tables["temp"];
		}

		
		public static DataTable GetTable( string strConn, string strSQL )
		{
			return GetDataSet(strConn, strSQL,"table1").Tables["table1"];
		}
/*
		public static OleDbDataReader GetReader1IntParam( string strConn, string strSQL, int nValue )
		{
			OleDbConnection Conn = new OleDbConnection(strConn);
			Conn.Open();
			OleDbDataReader oDataReader;
			OleDbCommand oCommand = Conn.CreateCommand();
			oCommand.CommandText = strSQL;
			oCommand.Parameters.Add("@param1", System.Data.OleDb.OleDbType.Integer).Value=nValue;

			oDataReader = oCommand.ExecuteReader(System.Data.CommandBehavior.CloseConnection);
			return oDataReader;
		}
		public static OleDbDataReader GetReader( string strConn, string strSQL )
		{
			OleDbConnection Conn = new OleDbConnection(strConn);
			Conn.Open();
			OleDbDataReader oDataReader;
			OleDbCommand oCommand = Conn.CreateCommand();
			oCommand.CommandText = strSQL;
			oDataReader = oCommand.ExecuteReader(System.Data.CommandBehavior.CloseConnection);
			return oDataReader;
		}
		public static OleDbDataReader GetReader1VarCharParam( string strConn, string strSQL, string strVal, int nColumnLen )
		{
			OleDbConnection Conn = new OleDbConnection(strConn);
			Conn.Open();
			OleDbDataReader oDataReader;
			OleDbCommand oCommand = Conn.CreateCommand();
			oCommand.CommandText = strSQL;
			oCommand.Parameters.Add("@param1", System.Data.OleDb.OleDbType.VarChar,nColumnLen).Value=strVal;

			oDataReader = oCommand.ExecuteReader(System.Data.CommandBehavior.CloseConnection);
			return oDataReader;
		}
*/		
		public static long GetScalar( string strConn, string strSQL )
		{
			OleDbConnection Conn = new OleDbConnection(strConn);
			Conn.Open();
			OleDbCommand oCommand = Conn.CreateCommand();
			oCommand.CommandText = strSQL;

			int lCount = (int)oCommand.ExecuteScalar();
			Conn.Close();
			Conn.Dispose();
			return lCount;
		}
	}
}
