/*
* (C) Systementor AB Stefan Holmberg
*/
using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace AdMentorNET
{
	/// <summary>
	/// Summary description for admin.
	/// </summary>
	public class admin : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.Label lblHeader;
		protected System.Web.UI.WebControls.PlaceHolder m_Menu;
		protected System.Web.UI.WebControls.PlaceHolder m_Content;
		AdMentorUser m_oUser;

	
		private bool ValidateUser()
		{
			if ( Session["admentor_currentuser"] == null )
					return false;
			int nFldAuto = (int)Session["admentor_currentuser"];
			if ( m_oUser.Load( nFldAuto ) == false )
				return false;
			return true;
		}
		private void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here
			 m_oUser = new AdMentorUser();
			if ( ValidateUser() == false )
				ViewState["CurrentFunc"] = "login";
			else
				if ( !IsPostBack )
					ViewState["CurrentFunc"] = Request["what"];

			string strCurFunc = (string)ViewState["CurrentFunc"];
			if ( strCurFunc == null )
				strCurFunc = "";
			if ( strCurFunc == "" )
				strCurFunc = "start";
			LoadControls(strCurFunc);
		}
		private void LoadControls( string strFunc )
		{
			
			m_Menu.Controls.Add( new LiteralControl(AdMentorGlobals.IncnavGetMenu(m_oUser)) );
			
			switch( strFunc.ToLower() )
			{
			case "login":
				lblHeader.Text = "AdMentor login";
				m_Content.Controls.Add( LoadControl("uclogin.ascx") );
				break;
			case "logout":
				Session.Clear();
				Response.Redirect("admin.aspx");
				break;
			case "start":
				lblHeader.Text = "AdMentor admin interface";
				break;
			case "zone":
				{
				if ( m_oUser.m_fAdmin == false )
					Response.Redirect("admin.aspx",true);
				
				lblHeader.Text = "Zone admin";
				m_Content.Controls.Add( LoadControl("uczones.ascx") );
				}
				break;
			case "adpos":
				{
					if ( m_oUser.m_fAdmin == false )
						Response.Redirect("admin.aspx",true);
					lblHeader.Text = "Ad position admin";
					m_Content.Controls.Add( LoadControl("ucadpositions.ascx") );
				}
				break;
			case "banner":
				{
					lblHeader.Text = "Banner admin";
					ucbanners lbanner = ( ucbanners ) LoadControl("ucbanners.ascx");
					lbanner.m_oUser = m_oUser;
					m_Content.Controls.Add( lbanner );
				}
					break;

			case "clickslog":
				{
					lblHeader.Text = "Clicks log";
					ucClicksLog ustats = ( ucClicksLog ) LoadControl("ucClicksLog.ascx");
					m_Content.Controls.Add( ustats );
				}
					break;
			case "stats":
				{
					lblHeader.Text = "Stats";
					ucstats ustats = ( ucstats ) LoadControl("ucstats.ascx");
					ustats.m_oUser = m_oUser;
					m_Content.Controls.Add( ustats );
				}
					break;
			case "viewbanner":
				{
					lblHeader.Text = "View banner";
					ucviewbanner uvb = ( ucviewbanner ) LoadControl("ucviewbanner.ascx");
					uvb.lBannerId = Convert.ToInt32(Request["bid"]);
					m_Content.Controls.Add( uvb );
				}
					break;
			case "genhtml":
				{
					if ( m_oUser.m_fAdmin == false )
						Response.Redirect("admin.aspx",true);
					lblHeader.Text = "Generate HTML";
					ucgenhtml ustats = ( ucgenhtml ) LoadControl("ucgenhtml.ascx");
					m_Content.Controls.Add( ustats );
				}
					break;
			case "user":
				if ( m_oUser.m_fAdmin == false )
					Response.Redirect("admin.aspx",true);
				lblHeader.Text = "User admin";
				m_Content.Controls.Add( LoadControl("ucusers.ascx") );
				break;
			case "myaccount":
				lblHeader.Text = "My account";
				ucmyaccount lc = (ucmyaccount)LoadControl("ucmyaccount.ascx");
				m_Content.Controls.Add( lc );
				break;
			}
		}
		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
