/*
* (C) Systementor AB Stefan Holmberg
*/
using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data.OleDb;
using System.Web.Caching;

namespace AdMentorNET
{


	class CurrentPageBanners
	{
		public static string GetBanners()
		{
		if ( HttpContext.Current.Session["admentor_onthispage"] == null )
			return "";
		string strRet = HttpContext.Current.Session["admentor_onthispage"].ToString();
		return strRet;
		} 
		public static void ClearBanners()
		{
			if ( HttpContext.Current.Session["admentor_onptime"] == null )
				{
				HttpContext.Current.Session["admentor_onptime"] = System.DateTime.Now;
				HttpContext.Current.Session["admentor_onthispage"] = "";
				}
			else
				{
				//Check if it was X seconds since last call?
				System.DateTime dt = (System.DateTime)HttpContext.Current.Session["admentor_onptime"];
				System.TimeSpan sp = System.DateTime.Now - dt;
				if ( sp.Seconds > 10 ||  sp.Seconds < 0 )
					{
					HttpContext.Current.Session["admentor_onptime"] = System.DateTime.Now;
					HttpContext.Current.Session["admentor_onthispage"] = "";
					}
				}
		}
		public static void AddBanner( int nID )
		{
		string strRet = GetBanners();
		if ( strRet != "" )
			strRet = strRet + ","; 		
		strRet += nID.ToString();
		HttpContext.Current.Session["admentor_onthispage"] = strRet;						
		
		}
	}
	
	
	/// <summary>
	/// Summary description for admentorserve.
	/// </summary>
	/// 

	public class admentorserve : System.Web.UI.Page
	{
		private void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here
			bool fCanDoHtml;
			if ( Request["type"] != null  && Request["type"] == "click" )
			{
				ClickBanner();
			}
			if ( Request["type"] != null && Request["type"] == "iframe" )
					fCanDoHtml = true;
			else
				fCanDoHtml = false;

			if ( Request["type"] != null && Request["type"] == "js" )
				fCanDoHtml = true;

			
			//So simple scheme. Everytime we find number '1' then we clears it out and assumes
			//here starts a new page. It might not be a perfect scheme
			CurrentPageBanners.ClearBanners();

			DataRow dr = ReturnBanner( Request["z"], Request["a"], fCanDoHtml );
			if ( dr == null )
			{
			//Some error...return a default banner...
			dr = ServeDefaultBanner( Convert.ToInt32(Request["a"]) );
			}
			Log( "view", (int)dr["bbannerid"] );
			CurrentPageBanners.AddBanner((int)dr["bbannerid"]);
			if ( Request["type"] != null && Request["type"] == "iframe" )
				ServeIFrame(dr);
			if ( Request["type"] != null && Request["type"] == "js" )
				ServeJScript(dr);
			ServeImg(dr);
		}
		private void Log(string strWhat, int nBannerId )
		{
			AdMentorDatabase db = new AdMentorDatabase();
			if ( strWhat == "click" )
			{
				string strPage;
				string strIP;
				if ( Request["frompage"] != null && (string )Request["frompage"] != "" )
						strPage = Request["frompage"];
				else
					strPage = Request["HTTP_REFERER"];
				strIP = Request["REMOTE_ADDR"];
				db.LogClick1( nBannerId ); // Updates clickcount in regular = a_banners
				db.LogClick2( nBannerId, strPage, strIP ); // insert into a_traceclicks in stats database
				db.LogStats2( nBannerId,"click"); // insert/update into a_bannerstats in stats database
			}
			else
			{
				db.LogView1(nBannerId ); // Updates showcount in regular = a_banners
				db.LogStats2( nBannerId,"show"); // insert/update into a_bannerstats in stats database
			}

		}
		private string GetSessionString()
		{
			return "[admentor]" + Request["z"] + Request["a"] + Request["n"];
		}
		private void ServeImg(DataRow dr)
		{
			//Save it
			Session[GetSessionString()] = dr["bbannerid"];
			//We should return a img tag...
			Response.Clear();
			Response.Redirect((string)dr["gifurl"], true);
		}
		private void ClickBanner()
		{
			DataRow dr = null;
			int nBannerId = -1;
			if ( Request["bannerid"] != null )
			{
				dr = GetBanner( Convert.ToInt32(Request["bannerid"]), false );
				if ( dr != null )
					nBannerId = (int) dr["bbannerid"];
			}
			else
			{
				//Try with session
				if ( Session[GetSessionString()] != null )
					dr = GetBanner( Convert.ToInt32(Session[GetSessionString()] ), false );
				if ( dr != null )
					nBannerId = (int) dr["bbannerid"];
			}
			//And now --------- EXTREME ERROR...
			if ( nBannerId == -1 )
				Response.Redirect("http://www.aspcode.net", true);
			else
			{
				//Vi har en banner. Log it
				Log( "click", nBannerId );
				Response.Clear();
				string strRedir = (string)dr["redirurl"];
				if ( Request["encurl"] != null && Request["encurl"] != "" )
					{
					EncryptHelper Enc = new EncryptHelper(AdMentorGlobals.GetEncryptionKey());
					strRedir = Enc.DecryptData(Server.UrlDecode(Request["encurl"]));
					}
				Response.Redirect(strRedir, true);
			}
		}
		private string ReplaceSpecialTags( string strTxt, int nBannerId )
		{
			string strRet = strTxt;
			int nFoundIndex = -1;
			int nLastValue = 0;
			System.Random myrand = new System.Random(((int) DateTime.Now.Ticks));
			while( true )
			{
				nFoundIndex = strRet.IndexOf("<ADM_RANDOM-");
				if ( nFoundIndex > 0 )
				{
					string strLeft = strRet.Substring(0,nFoundIndex);
					string strRight = strRet.Substring(nFoundIndex+1);
					//Now check next chars...
					int nEnd = strRet.IndexOf(">",nFoundIndex);
					if ( nEnd>0 )
					{
						strRight =strRet.Substring(nEnd+1);
						string strThis = strRet.Substring(nFoundIndex,nEnd-nFoundIndex);
						string[] strArray = strThis.Split('-');
						int nCount = strArray.GetUpperBound(0);
						if ( nCount == 2 )
						{
							string str1 = (string)strArray.GetValue(1);
							string str2 = (string)strArray.GetValue(2);
							int nLow = Convert.ToInt32(	strArray.GetValue(1) );
							int nHigh = 	Convert.ToInt32(	strArray.GetValue(2) );
							nLastValue = Convert.ToInt32(myrand.Next(nHigh-1))+nLow;
						}
						else // It is last, do nothing
						{
						}
					strRet = strLeft + nLastValue.ToString() + strRight;
					}
				}
				else 
					break;
			}
			//And now for special urls:s
			while( true )
			{
				nFoundIndex = strRet.IndexOf("<ADM_CLICKURL-");
				if ( nFoundIndex > 0 )
				{
					string strLeft = strRet.Substring(0,nFoundIndex);
					string strRight = strRet.Substring(nFoundIndex+1);
					int nEnd = strRet.IndexOf(">",nFoundIndex);
					if ( nEnd>0 )
						{
						strRight =strRet.Substring(nEnd+1);
						string strThis = strRet.Substring(nFoundIndex+14,nEnd-nFoundIndex-14);
						EncryptHelper Enc = new EncryptHelper(AdMentorGlobals.GetEncryptionKey());
						
						string strLoc = "http://" + Request["SERVER_NAME"];
						if ( Request.ApplicationPath.Length >1)
							strLoc+= Request.ApplicationPath;
						strLoc+="/admentorserve.aspx?type=click&bannerid=" + nBannerId.ToString() + "&encurl=";
						strThis = strLoc + Server.UrlEncode(Enc.EncryptData( strThis ));
						strRet = strLeft + strThis + strRight;
						}
				}
				else
					break;
			}
			return strRet;
		}
		private string MakeJava(string strIn )
		{
			strIn = strIn.Replace("\r", "" );
			strIn = strIn.Replace("\\", "\\\\" );
			strIn = strIn.Replace("\'", "\\'" );
			strIn = strIn.Replace("\r", "" );
			strIn = strIn.Replace("\n", "\\n" );
			strIn = strIn.Replace("\t", "\\t" );
			strIn = strIn.Replace("<", "<'+'" );
			return strIn;
		}
		private void ServeJScript( DataRow dr )
		{
			string strTxt;
			if ( (bool)dr["ishtml"] )
			{
				DataRow dr2 = GetBanner((int)dr["bbannerid"], true );
				strTxt = (string)dr2["htmlcode"];
				strTxt = ReplaceSpecialTags(strTxt,(int)dr["bbannerid"]);
				strTxt = "document.write('" + MakeJava( strTxt ) + "');";
				//Replace special tags...
				//1. Split on all  
			}
			else
			{
				strTxt = "document.write('<a href=\"";
				string strLoc = "http://" + Request["SERVER_NAME"];
				if ( Request.ApplicationPath.Length >1)
					strLoc+= Request.ApplicationPath;
				strTxt += strLoc + "/admentorserve.aspx?type=click&bannerid=" + dr["bbannerid"];
//				string strPage = Server.UrlEncode(Request["HTTP_REFERER"]);
//				strTxt += "&frompage=" + strPage;
				strTxt += "\"";
				if ( Request["target"] != null && (string)Request["target"] != "" )
					strTxt += " target=" + Request["target"];
				else
					strTxt += " target=_top";

				strTxt += ">');\n";

				strTxt += "document.write('<img border=\"0\" src=\"";
				strTxt += dr["gifurl"] + "\"";
				if ( dr["alttext"] != null && (string)dr["alttext"] != "" )
					strTxt += " alt=\"" + dr["alttext"] + "\"";
				strTxt += ">');\n";
				strTxt +="document.write('</a>');\n";
			}
			Response.Buffer = true;
			Response.ContentType = "application/x-javascript";
			Response.ExpiresAbsolute = System.DateTime.Now - System.TimeSpan.FromSeconds(1);
			Response.AddHeader( "cache-control","private");
			Response.CacheControl = "no-cache";
			Response.CacheControl = "Private";
			Response.Clear();
			Response.Write(strTxt);
			Response.End();
		}
		private void ServeIFrame( DataRow dr )
		{
			//Here we can create a HTML stuff which makes us not need session
			string strTxt;
			if ( (bool)dr["ishtml"] )
			{
				DataRow dr2 = GetBanner((int)dr["bbannerid"], true );
				strTxt = (string)dr2["htmlcode"];
				strTxt = ReplaceSpecialTags(strTxt,(int)dr["bbannerid"]);
				//Replace special tags...
				//1. Split on all  
			}
			else
			{
				strTxt = "<html><body><a href=\"";
				string strLoc = "http://" + Request["SERVER_NAME"];
				if ( Request.ApplicationPath.Length >1)
					strLoc+= Request.ApplicationPath;
				strTxt += strLoc + "/admentorserve.aspx?type=click&bannerid=" + dr["bbannerid"];
				string strPage = Server.UrlEncode(Request["HTTP_REFERER"]);
				strTxt += "&frompage=" + strPage;
				strTxt += "\"";
				if ( Request["target"] != null && (string)Request["target"] != "" )
					strTxt += " target=" + Request["target"];
				else
					strTxt += " target=_top";

				strTxt += ">";

				strTxt += "<img src=\"" + dr["gifurl"] + "\" border=\"0\"";
				if ( dr["alttext"] != null && (string)dr["alttext"] != "" )
					strTxt += " alt=\"" + dr["alttext"] + "\"";
				strTxt += ">";
				strTxt +="</a></body></html>";
			}
			Response.Clear();
			Response.Write(strTxt);
			Response.End();
		}

		public DataRow ReturnBanner(string strZones, string strAdPos, bool fCanDoHtml)
		{
			AdMentorDatabase db = new AdMentorDatabase();
			OleDbConnection Conn = new OleDbConnection(db.GetConnectionString() );
			Conn.Open();

			//Get banners sure to be active today...
			string strSQL = "select distinct a_banner.bannerid as bbannerid, weight, redirurl, gifurl, alttext, 0 as weight2 ";
			strSQL += ", ishtml ";
			strSQL += "from a_banner, a_banzone WHERE a_banzone.zoneid in(";
			strSQL += strZones + ") and a_banzone.bannerid=a_banner.bannerid and a_banner.adpos_id=" + strAdPos;
			strSQL += " AND validfromdate<='" + System.DateTime.Now.ToString("yyyy-MM-dd") + "'";
			strSQL += " AND validtodate>='" + System.DateTime.Now.ToString("yyyy-MM-dd")+ "'";
			strSQL += " AND validtodate>='" + System.DateTime.Now.ToString("yyyy-MM-dd")+ "'";
			strSQL += " AND (  clickcount<maxclicks OR maxclicks=0 )";
			strSQL += " AND (  showcount<maximpressions OR maximpressions=0 )";
			
			string strAlreadyUsed = CurrentPageBanners.GetBanners();
			if ( strAlreadyUsed != "" )
				strSQL += " AND a_banner.bannerid not in ( " + strAlreadyUsed + ") ";
			

			OleDbDataAdapter oAdapter = new OleDbDataAdapter(strSQL, Conn);

			DataSet ds = new DataSet();
			oAdapter.Fill(ds, "admentorbanners");
			Conn.Close();
			Conn.Dispose();
			
			//Now generate an extra column
			int nSumWeight = 0;
			for ( int i = 0; i < ds.Tables["admentorbanners"].Rows.Count;i++ )
				{
				System.Data.DataRow r2 = ds.Tables["admentorbanners"].Rows[i];
				nSumWeight += (int)r2["weight"]*10;
				r2["weight2"] = nSumWeight;
				}
			//And generate
			System.Random myrand = new System.Random(((int) DateTime.Now.Ticks));
			if ( nSumWeight < 1 )
				return null;
			int nSelected = Convert.ToInt32(myrand.Next(1,nSumWeight));
			for ( int i = 0; i < ds.Tables["admentorbanners"].Rows.Count;i++ )
			{
				System.Data.DataRow r2 = ds.Tables["admentorbanners"].Rows[i];
				if ( (int)r2["weight2"] >= nSelected )
					return r2;
			}
			return null;
		}

		public DataRow GetBanner(int nBannerId, bool fGetHtml)
		{
			AdMentorDatabase db = new AdMentorDatabase();
			OleDbConnection Conn = new OleDbConnection(db.GetConnectionString() );
			Conn.Open();

			//Get banners sure to be active today...
			string strSQL = "select a_banner.bannerid as bbannerid, redirurl, gifurl, alttext, ishtml ";
			if ( fGetHtml )
				strSQL += ", htmlcode ";
			strSQL += " from a_banner where bannerid=" + nBannerId.ToString();
			OleDbDataAdapter oAdapter = new OleDbDataAdapter(strSQL, Conn);

			DataSet ds = new DataSet();
			oAdapter.Fill(ds, "admentorbanners");
			Conn.Close();
			Conn.Dispose();
			if ( ds.Tables["admentorbanners"].Rows.Count == 0 )
				return null;
			return ds.Tables["admentorbanners"].Rows[0];
		}
		public DataRow ServeDefaultBanner(int nAdPosId )
		{
			//Get default banner for this ad pos
			AdMentorDatabase db = new AdMentorDatabase();
			string strSQL = "select defaultbanner ";
			strSQL += " from a_adposition where adposid=" + nAdPosId.ToString();
			DataTable dt = AdMentorDBExecutor.GetTable( db.GetConnectionString(), 
				strSQL ); 
			if ( dt.Rows.Count>0 )
			{
				DataRow row = dt.Rows[0];
				int nID = Convert.ToInt32(row["defaultbanner"]);
				DataRow dr = GetBanner(nID,true);
				if ( dr != null )
					return dr;
			}
		Response.End(); //Empty...
		return null;
		}


		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);
		}
		#endregion
	}
}
