/*
* (C) Systementor AB Stefan Holmberg
*/
using System;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.ComponentModel;
using System.Data;
using System.Data.OleDb;

namespace AdMentorNET
{

	public class MentorGridHandlerBase
	{
		public MentorGridHandlerBase()
		{
		}
		public virtual void OnEditControlsToRow( DataRow row, DataGrid oGrid, DataGridItem e, bool fIsInsert )
		{
		}
		public virtual void OnDeleteRowEvent( int nFldAuto )
		{
		}
		public virtual void OnNewRow( DataRow row )
		{
		}
		public virtual bool OnCanDeleteRow( DataGrid oGrid, DataGridItem e )
		{
			return true;
		}
	};

	public class MentorGridEditDeleteTemplate : ITemplate
	{
		public void InstantiateIn(Control container) 
		{
		}


	}


	/// <summary>
	/// Summary description for MentorGridExt.
	/// </summary>
	public class MentorGridExt
	{
		private DataGrid m_DataGrid = null;
		private MentorGridHandlerBase  m_GridHandler = null;
		private string m_strDefaultSortField;
		private string m_strConnectionString;
		private string m_strTableName; //ex zone
		private string m_strFirstColumnHeaderText; //= columnnamn ex name
		private string m_strAdminName; // = vad man administrerar ex zone
		private string m_strSQLSpecialSelect ="";
		private string m_strSQLAdditionalWhere ="";
		private bool m_fAllowDelete = true;
		private bool m_fAllowNew = true;

		public MentorGridExt( DataGrid oDataGrid, MentorGridHandlerBase oBase, string strConnectionString, string strTableName, string strDefaultSortField, string strFirstColumnHeaderText, string strAdminName, string strSQLSpecialSelect, string strSQLAdditionalWhere, bool fAllowDelete, bool fAllowNew )
		{
			m_DataGrid = oDataGrid;
			m_GridHandler = oBase;
			m_strConnectionString = strConnectionString;
			m_strTableName = strTableName;
			m_strFirstColumnHeaderText = strFirstColumnHeaderText;
			m_strAdminName = strAdminName;
			m_strSQLSpecialSelect = strSQLSpecialSelect;
			m_strSQLAdditionalWhere = strSQLAdditionalWhere;
			m_fAllowDelete = fAllowDelete;
			m_fAllowNew = fAllowNew;
			m_strDefaultSortField = strDefaultSortField;
			m_DataGrid.ItemCreated += new System.Web.UI.WebControls.DataGridItemEventHandler(this.Grid_ItemCreated);
			m_DataGrid.SortCommand += new System.Web.UI.WebControls.DataGridSortCommandEventHandler(this.Grid_SortCommand);
			m_DataGrid.Load += new System.EventHandler(this.Page_Load);
		}
		private OleDbConnection GetDB()
		{
			OleDbConnection Conn = new System.Data.OleDb.OleDbConnection(m_strConnectionString);
			return Conn;
		}		

		private void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here
			if ( m_DataGrid.Attributes["Operation"] == null )
			{
				if ( m_DataGrid.EditItemIndex == -1 )
					m_DataGrid.Attributes["Operation"] = "List";
				else
					m_DataGrid.Attributes["Operation"] = "Edit";
				BindGrid();
				return;
			}
			if ( ((string)m_DataGrid.Attributes["Operation"]) == "" )
			{
				if ( m_DataGrid.EditItemIndex == -1 )
					m_DataGrid.Attributes["Operation"] = "List";
				else
					m_DataGrid.Attributes["Operation"] = "Edit";
				BindGrid();
			}
		}



		private void BindGrid()
		{
			string strSortDir;
			if ( m_DataGrid.Attributes["sortdirection-z"] == null )
				strSortDir = "ASC";
			else
				strSortDir = m_DataGrid.Attributes["sortdirection-z"].ToString();

			string strSortField;
			if ( m_DataGrid.Attributes["sortfield-z"] == null )
				strSortField = m_strDefaultSortField;
			else
				strSortField = m_DataGrid.Attributes["sortfield-z"].ToString();
			if ( strSortField == "" )
				strSortField = "1";
			
			OleDbConnection oDB = GetDB();
			DataSet ds = new System.Data.DataSet("zones");
			string strSQL;
			
			string strWhere = "";
			if ( ((string)m_DataGrid.Attributes["Operation"]) != "List"  )
			{
				strWhere = m_DataGrid.DataKeyField.ToString() + "=";
				if (m_DataGrid.EditItemIndex == -1 )
					strWhere += "-1";
				else
					strWhere += m_DataGrid.DataKeys[m_DataGrid.EditItemIndex].ToString();
			}
			if ( m_strSQLSpecialSelect == "" )
				strSQL = "select * from " + m_strTableName;
			else
				strSQL = m_strSQLSpecialSelect;
			if ( m_strSQLAdditionalWhere != "" )
			{
				if ( strWhere == "" )
					strWhere = " " + m_strSQLAdditionalWhere;
				else
					strWhere += " AND ( " + m_strSQLAdditionalWhere + ")";
			}
			if ( strWhere != "" )
				strSQL += " WHERE " + strWhere;
			strSQL += " ORDER BY " + strSortField + " " + strSortDir;
			OleDbDataAdapter oAdapter = new OleDbDataAdapter(strSQL,oDB);
			oAdapter.Fill(ds, "zones");
			oDB.Close();
			
			if ( ((string)m_DataGrid.Attributes["Operation"]) == "Add"  )
			{
				DataRow dr;
				dr = ds.Tables["zones"].NewRow();
				dr[m_DataGrid.DataKeyField] = -1;
				if ( m_GridHandler != null )
					m_GridHandler.OnNewRow(dr);
				ds.Tables["zones"].Rows.InsertAt(dr, 0);
			}
			if ( ((string)m_DataGrid.Attributes["Operation"]) == "List"  )
			{
				TemplateColumn  tc = new TemplateColumn();
				tc.ItemTemplate = new MentorGridEditDeleteTemplate();
				tc.ItemStyle.CssClass = "Grid_Pager";
				tc.ItemStyle.VerticalAlign = System.Web.UI.WebControls.VerticalAlign.Top;
				m_DataGrid.Columns.Add( tc );
				tc = new TemplateColumn();
				tc.ItemTemplate = new MentorGridEditDeleteTemplate();
				tc.ItemStyle.CssClass = "Grid_Pager";
				tc.ItemStyle.VerticalAlign = System.Web.UI.WebControls.VerticalAlign.Top;
				m_DataGrid.Columns.Add( tc );
				for ( int n=0; n < m_DataGrid.Columns.Count; n++ )
					m_DataGrid.Columns[n].Visible = true;
				m_DataGrid.EditItemIndex = -1;
				m_DataGrid.Columns[0].HeaderText = m_strFirstColumnHeaderText;
			}
			else
			{
				for ( int n=1; n < m_DataGrid.Columns.Count; n++ )
					m_DataGrid.Columns[n].Visible = false;
				m_DataGrid.EditItemIndex = 0;
				m_DataGrid.Columns[0].HeaderText = ((string)m_DataGrid.Attributes["Operation"]) + " " + m_strAdminName;
			}

			m_DataGrid.DataSource = ds;
			m_DataGrid.DataBind();
		}

		private void Grid_SortCommand(object source, System.Web.UI.WebControls.DataGridSortCommandEventArgs e)
		{
			if ( m_DataGrid.Attributes["sortfield-z"] == null )
				m_DataGrid.Attributes.Add( "sortfield-z", e.SortExpression );
			if ( m_DataGrid.Attributes["sortdirection-z"] == null )
				m_DataGrid.Attributes.Add("sortdirection-z", "ASC");
			else
				if ( m_DataGrid.Attributes["sortdirection-z"] == "ASC" )
				m_DataGrid.Attributes.Add("sortdirection-z", "DESC");
			else
				m_DataGrid.Attributes.Add("sortdirection-z", "ASC");
			BindGrid();		
		}

		private void btnUpdate_Click(object sender, System.EventArgs e)
		{
			//			TextBox txtName =(TextBox) e.Item.FindControl("txtEditName");
			//			TextBox txtDescription =(TextBox) e.Item.FindControl("txtEditDescr");
			int nfldAuto = (int)m_DataGrid.DataKeys[m_DataGrid.EditItemIndex];
			string strSQL = "select * from " + m_strTableName + " where " + m_DataGrid.DataKeyField.ToString() + "=" + m_DataGrid.DataKeys[m_DataGrid.EditItemIndex].ToString();
			
			OleDbConnection oCn = GetDB();
			OleDbDataAdapter oDA = new OleDbDataAdapter(strSQL,oCn); 
			DataSet oDs = new DataSet(); 
			oDA.Fill(oDs,"hej"); 
			DataRow oDR;
			bool fNew = false;
			if ( nfldAuto == -1 )
			{
				oDR = oDs.Tables["hej"].NewRow();
				oDs.Tables["hej"].Rows.Add(oDR);
				fNew = true;
			}
			else
			{
				oDR = oDs.Tables["hej"].Rows[0];
			}	
			if ( m_GridHandler != null )
			{
				m_GridHandler.OnEditControlsToRow(oDR, m_DataGrid,m_DataGrid.Items[m_DataGrid.EditItemIndex],fNew );
			}
			OleDbCommandBuilder builder = new OleDbCommandBuilder(oDA);
			oDA.UpdateCommand = builder.GetUpdateCommand();
			oDA.InsertCommand = builder.GetInsertCommand();
			oDA.Update(oDs,"hej"); 

			
			//			oDB.UpdateZone(nfldAuto, txtName.Text, txtDescription.Text);
			m_DataGrid.EditItemIndex = -1;
			m_DataGrid.Attributes["Operation"] = "List";
			BindGrid();
		}

		private void btnAdd_Click(object sender, System.EventArgs e)
		{
			m_DataGrid.Attributes["Operation"] = "Add";
			BindGrid();
		}
		private void btnEdit_Click(object sender, System.EventArgs e)
		{
			Button lc;
			lc = (Button) sender;
			DataGridItem container = (DataGridItem) lc.NamingContainer;
			m_DataGrid.EditItemIndex = container.ItemIndex;
			m_DataGrid.Attributes["Operation"] = "Edit";
			BindGrid();
		}

		private void btnDelete_Click(object sender, System.EventArgs e)
		{
			Button lc;
			lc = (Button) sender;
			DataGridItem container = (DataGridItem) lc.NamingContainer;
			int nItem = container.ItemIndex;

			int nFldAutoToDelete = (int) m_DataGrid.DataKeys[nItem];
			OleDbConnection Conn =GetDB();

			if ( m_GridHandler != null )
			{
				m_GridHandler.OnDeleteRowEvent(nFldAutoToDelete);
			}

			OleDbCommand oCommand = Conn.CreateCommand();

			Conn.Open();
			oCommand.CommandText = "delete from " + m_strTableName + " where " + m_DataGrid.DataKeyField + "=" + nFldAutoToDelete.ToString();
			oCommand.ExecuteNonQuery();
			Conn.Close();


			m_DataGrid.Attributes["Operation"] = "List";
			BindGrid();
		}

		private bool CanDeleteRow( DataGridItem e )
		{
			if ( m_GridHandler != null )
			{
				return m_GridHandler.OnCanDeleteRow(m_DataGrid,e );
			}
			return true;
		}


		private void Grid_ItemCreated(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
		{
			switch (e.Item.ItemType)
			{
				case ListItemType.Footer:
					if ( ((string)m_DataGrid.Attributes["Operation"]) == ""  || ((string)m_DataGrid.Attributes["Operation"]) == "List" )
					{
						if ( m_fAllowNew )
						{
							Button AddBut = new Button();
							AddBut.CssClass = "Button";
							AddBut.Text = "New " + m_strAdminName;
							AddBut.Click += new System.EventHandler(this.btnAdd_Click);
							AddBut.Visible = true;
							e.Item.Cells[0].Controls.Add( AddBut );
						}
					}
					else
					{
						Button AddBut = new Button();
						AddBut.CssClass = "Button";
						AddBut.Text = "Update";
						AddBut.Click += new System.EventHandler(this.btnUpdate_Click);
						AddBut.Visible = true;
						e.Item.Cells[0].Controls.Add( AddBut );
						AddBut = new Button();
						AddBut.CssClass = "Button";
						AddBut.Text = "Cancel";
						AddBut.Click += new System.EventHandler(this.btnCancel_Click);
						AddBut.CausesValidation = false;
						AddBut.Visible = true;
						e.Item.Cells[0].Controls.Add( AddBut );
					}
					m_DataGrid.ShowFooter = true;
					//					e.Item.Cells[1].Controls.Add( new LiteralControl("</div>") );
					break;
				case ListItemType.Pager:
					break;
				case ListItemType.Item:
				case ListItemType.AlternatingItem:
				{
					if ( ((string)m_DataGrid.Attributes["Operation"]) == "List"  )
					{
						Button AddBut = new Button();
						AddBut.CssClass = "Button";
						AddBut.Text = "Edit";
						AddBut.Visible = true;
						AddBut.Click += new System.EventHandler(this.btnEdit_Click);
						//					LinkButton myDeleteButton = (LinkButton) e.Item.FindControl("Delete") ; 
						e.Item.Cells[m_DataGrid.Columns.Count-2].Controls.Add( AddBut );
						if ( m_fAllowDelete && CanDeleteRow(e.Item ))
						{
							AddBut = new Button();
							AddBut.CssClass = "Button";
							AddBut.Text = "Delete";
							AddBut.Visible = true;
							AddBut.Click += new System.EventHandler(this.btnDelete_Click);
							//					LinkButton myDeleteButton = (LinkButton) e.Item.FindControl("Delete") ; 
							AddBut.Attributes.Add("onclick", "return confirm('Are you sure you want to delete this " + m_strAdminName + "?');");
							e.Item.Cells[m_DataGrid.Columns.Count-1].Controls.Add( AddBut );
						}
					}
					break;
				}
			}

		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			m_DataGrid.EditItemIndex = -1;
			m_DataGrid.Attributes["Operation"] = "List";
			BindGrid();
		
		}



	}
}
