/*
* (C) Systementor AB Stefan Holmberg
*/
using System;
using System.Data;
using System.Data.OleDb;

namespace AdMentorNET
{
	/// <summary>
	/// Summary description for AdMentorLogger.
	/// </summary>
	public class AdMentorLogger
	{
		private string m_strConn;
		public AdMentorLogger( string strConn )
		{
			m_strConn = strConn;
		}
		public void LogClick1(int nBannerID)
		{
			OleDbConnection Conn = new OleDbConnection(m_strConn);
			Conn.Open();
			OleDbCommand oCommand = Conn.CreateCommand();
			oCommand.CommandText = "update a_banner set clickcount=clickcount+1 where bannerid=" + nBannerID.ToString();
			oCommand.ExecuteNonQuery();
			Conn.Close();
			Conn.Dispose();
		}
		public void LogView1(int nBannerID)
		{
			OleDbConnection Conn = new OleDbConnection(m_strConn);
			Conn.Open();
			OleDbCommand oCommand = Conn.CreateCommand();
			oCommand.CommandText = "update a_banner set showcount=showcount+1 where bannerid=" + nBannerID.ToString();
			oCommand.ExecuteNonQuery();
			Conn.Close();
			Conn.Dispose();
		}
		public void LogClick2(int nBannerID, string strPage, string strIP)
		{
			OleDbConnection Conn = new OleDbConnection(m_strConn);
			Conn.Open();
			OleDbCommand oCommand = Conn.CreateCommand();
			oCommand = Conn.CreateCommand();
			oCommand.CommandText = "insert into a_traceclicks(bannerid, page,dt,ip) values(?,?,?,?)";
			oCommand.Parameters.Add("@1", System.Data.OleDb.OleDbType.Integer).Value=nBannerID;
			oCommand.Parameters.Add("@2", System.Data.OleDb.OleDbType.VarChar,255).Value=strPage;
			oCommand.Parameters.Add("@3", System.Data.OleDb.OleDbType.Date).Value=System.DateTime.Now;
			oCommand.Parameters.Add("@4", System.Data.OleDb.OleDbType.VarChar,20).Value=strIP;
			oCommand.ExecuteNonQuery();
			Conn.Close();
		}
		public void LogStats2(int nBannerID, string strClickOrShow)
		{
			System.Data.OleDb.OleDbConnection Conn = new System.Data.OleDb.OleDbConnection(m_strConn);
			Conn.Open();
			OleDbCommand oCommand = Conn.CreateCommand();
			oCommand.CommandText = "select count(*) from a_bannerstats where datum=? and bannerid=?";
			oCommand.Parameters.Add("@1", System.Data.OleDb.OleDbType.VarChar,10).Value=System.DateTime.Now.ToString("yyyy-MM-dd");
			oCommand.Parameters.Add("@2", System.Data.OleDb.OleDbType.Integer).Value=nBannerID;
			int lCount = (int)oCommand.ExecuteScalar();
			
			oCommand = Conn.CreateCommand();
			if ( lCount == 0 )
			{
				oCommand.CommandText = "insert into a_bannerstats(datum,showcount,clickcount, bannerid) values(?,?,?,?)";
				oCommand.Parameters.Add("@1", System.Data.OleDb.OleDbType.VarChar,10).Value=System.DateTime.Now.ToString("yyyy-MM-dd");
				if ( strClickOrShow == "click" )
				{
					oCommand.Parameters.Add("@2", System.Data.OleDb.OleDbType.Integer).Value=0;
					oCommand.Parameters.Add("@3", System.Data.OleDb.OleDbType.Integer).Value=1;
				}
				else
				{
					oCommand.Parameters.Add("@2", System.Data.OleDb.OleDbType.Integer).Value=1;
					oCommand.Parameters.Add("@3", System.Data.OleDb.OleDbType.Integer).Value=0;
				}
				oCommand.Parameters.Add("@4", System.Data.OleDb.OleDbType.Integer).Value=nBannerID;
			}
			else
			{
				oCommand.CommandText = "update a_bannerstats set ";
				if (strClickOrShow == "click" ) 
					oCommand.CommandText += "clickcount=clickcount+1";
				else
					oCommand.CommandText += "showcount=showcount+1";
				oCommand.CommandText += " where bannerid=? and datum=?";
				oCommand.Parameters.Add("@1", System.Data.OleDb.OleDbType.Integer).Value=nBannerID;
				oCommand.Parameters.Add("@2", System.Data.OleDb.OleDbType.VarChar,10).Value=System.DateTime.Now.ToString("yyyy-MM-dd");
			}
			oCommand.ExecuteNonQuery();
			Conn.Close();
		}
	}
}
