using System;
using System.Data;
using System.Data.OleDb;
/*
 * (C) Systementor AB Stefan Holmberg
 */

namespace AdMentorNET
{
	/// <summary>
	/// Summary description for AdMentorDatabase.
	/// </summary>
	public class AdMentorDatabase
	{
		public AdMentorDatabase()
		{
			//
			// TODO: Add constructor logic here
			//
		}
		public string GetConnectionString()
		{
			return System.Configuration.ConfigurationSettings.AppSettings["AdMentorConnString"];
		}
		public void LogClick1(int nBannerID)
		{
			AdMentorLogger Logger = new AdMentorLogger(GetConnectionString());
			Logger.LogClick1(nBannerID);
		}
		public void LogView1(int nBannerID)
		{
			AdMentorLogger Logger = new AdMentorLogger(GetConnectionString());
			Logger.LogView1(nBannerID);
		}

		public void LogClick2(int nBannerID, string strPage, string strIP)
		{
			AdMentorLogger Logger = new AdMentorLogger(GetConnectionString());
			Logger.LogClick2(nBannerID, strPage, strIP);
		}
		
		public void LogStats2(int nBannerID, string strClickOrShow)
		{
			AdMentorLogger Logger = new AdMentorLogger(GetConnectionString());
			Logger.LogStats2(nBannerID, strClickOrShow);
		}

		
		public  DataTable GetZonesForBanner(int nFldAuto)
		{
			return AdMentorDBExecutor.GetTable( GetConnectionString(), "select a_zone.zoneid as zoneid from a_zone, a_banzone where a_banzone.bannerid=" + nFldAuto.ToString() +  " and a_zone.zoneid=a_banzone.zoneid"  );
		}
		public  DataTable GetUser(int nFldAuto)
		{
			return AdMentorDBExecutor.GetTable( GetConnectionString(), "select * from a_users where fldAuto=" + nFldAuto.ToString()  );
		}
		public  DataTable GetUser2(string strLoginName)
		{
			return AdMentorDBExecutor.GetTable1VarCharParam( GetConnectionString(), "select * from a_users where name=?", strLoginName,50  );
		}
		public System.Data.DataTable GetZones()
		{
			return AdMentorDBExecutor.GetTable( GetConnectionString(), 
				"select * from a_zone" );
		}
		public System.Data.DataTable GetTraceClicks( int nBannerId )
		{
			string strSQL;
			strSQL = "select fldAuto, page,dt,ip, name, a_traceclicks.bannerid as bannerid from a_traceclicks, a_banner where a_banner.bannerid=a_traceclicks.bannerid ";
			if ( nBannerId != -1 )
				strSQL += " and a_traceclicks.bannerid=" + nBannerId.ToString();
			strSQL += " order by dt desc";
			return AdMentorDBExecutor.GetTable( GetConnectionString(), 
				strSQL );
		}
		public System.Data.DataTable GetAdPositions()
		{
			return AdMentorDBExecutor.GetTable( GetConnectionString(), 
				"select * from a_adposition" );
		}
		public System.Data.DataTable GetDefaultBanners()
		{
			return AdMentorDBExecutor.GetTable( GetConnectionString(), 
				"select * from a_banner where ishtml=0" );
		}
		public System.Data.DataTable GetAdvertisers( int nFldAuto )
		{
			string strSQL;
			strSQL = "select * from a_users ";
			if ( nFldAuto != -1 )
				strSQL += " where fldAuto=" +nFldAuto.ToString();

			return AdMentorDBExecutor.GetTable( GetConnectionString(), 
				strSQL );
		}
		public string GetZoneNamesForBanner( int nBannerId )
		{
			DataTable dt = AdMentorDBExecutor.GetTable( GetConnectionString(), 
					"select a_zone.zonename as name from a_zone,a_banzone where a_banzone.bannerid=" + nBannerId.ToString() + " and a_banzone.zoneid=a_zone.zoneid" );
			string strRet = "";
			foreach( DataRow row in dt.Rows )
			{
				if ( strRet != "" )
					strRet += "<br>";
				strRet += (string)row["name"];
			}
			if ( strRet == "" )
				strRet = "[None]";
			return strRet;
		}

		public long  GetStatsForBanner(string strWhat, int nBannerId, string strStartDate, string strEndDate )
		{
			if ( strWhat == "clicks")
				strWhat = "clickcount";
			else
				strWhat = "showcount";
			string strSQL = "select sum(" + strWhat + ") as antal from a_bannerstats where bannerid =" + nBannerId.ToString() + " AND datum>='" + strStartDate + "' AND datum <='" + strEndDate + "'";
			DataTable dt = AdMentorDBExecutor.GetTable( GetConnectionString(), 
				strSQL );
			
			long lCount = 0;	
			if ( dt.Rows.Count>0 )
			{
				DataRow row = dt.Rows[0];
				if ( row["antal"] != null  )
					try
					{
						lCount = Convert.ToInt32( row["antal"] );
					}
					catch
					{
					}
			}

					
			return lCount;
		}
		public string GetZoneIdsForBanner( int nBannerId )
		{
			string strSQL = "select a_zone.zoneid as name from a_zone,a_banzone where a_banzone.bannerid=" + nBannerId.ToString() + " and a_banzone.zoneid=a_zone.zoneid";
			DataTable dt = AdMentorDBExecutor.GetTable( GetConnectionString(), 
				strSQL );
			string strRet = "";
			foreach( DataRow row in dt.Rows )
			{
				if ( strRet != "" )
					strRet += ";";
				strRet += (string)row["name"];
			}
			if ( strRet == "" )
				strRet = "";
			return strRet;
		}

		public System.Data.DataSet GetBannerForEditing(string strWhere)
		{
			string strSQL;
			strSQL = "select * from a_banner ";
			strSQL += " WHERE " + strWhere + "";

					
			DataSet oDataSet = AdMentorDBExecutor.GetDataSet(GetConnectionString(), strSQL, "zones");
			
			System.Data.DataColumn dc = new System.Data.DataColumn("zones",System.Type.GetType("System.String"));
			oDataSet.Tables["zones"].Columns.Add(dc);
			for ( int i = 0; i < oDataSet.Tables["zones"].Rows.Count;i++ )
			{
				System.Data.DataRow r = oDataSet.Tables["zones"].Rows[i];
				r["zones"] = GetZoneNamesForBanner( (int)r["bannerid"] );
			}
			//Fix to keep grid happy
			dc = new System.Data.DataColumn("bbannerid",System.Type.GetType("System.Int32"));
			oDataSet.Tables["zones"].Columns.Add(dc);
			for ( int i = 0; i < oDataSet.Tables["zones"].Rows.Count;i++ )
			{
				System.Data.DataRow r = oDataSet.Tables["zones"].Rows[i];
				r["bbannerid"] =  (int)r["bannerid"] ;
			}
			dc = new System.Data.DataColumn("bweight",System.Type.GetType("System.Int32"));
			oDataSet.Tables["zones"].Columns.Add(dc);
			for ( int i = 0; i < oDataSet.Tables["zones"].Rows.Count;i++ )
			{
				System.Data.DataRow r = oDataSet.Tables["zones"].Rows[i];
				r["bweight"] = 0;
			}
			dc = new System.Data.DataColumn("bshowcount",System.Type.GetType("System.Int32"));
			oDataSet.Tables["zones"].Columns.Add(dc);
			for ( int i = 0; i < oDataSet.Tables["zones"].Rows.Count;i++ )
			{
				System.Data.DataRow r = oDataSet.Tables["zones"].Rows[i];
				r["bshowcount"] = 0;
			}
			dc = new System.Data.DataColumn("bclickcount",System.Type.GetType("System.Int32"));
			oDataSet.Tables["zones"].Columns.Add(dc);
			for ( int i = 0; i < oDataSet.Tables["zones"].Rows.Count;i++ )
			{
				System.Data.DataRow r = oDataSet.Tables["zones"].Rows[i];
				r["bclickcount"] = 0;
			}
			dc = new System.Data.DataColumn("pname",System.Type.GetType("System.Int32"));
			oDataSet.Tables["zones"].Columns.Add(dc);
			for ( int i = 0; i < oDataSet.Tables["zones"].Rows.Count;i++ )
			{
				System.Data.DataRow r = oDataSet.Tables["zones"].Rows[i];
				r["pname"] = 0;
			}
			return oDataSet;
		}

		private string GetActiveBannersSQL( bool fActive )
		{
			if ( fActive )
				return " AND ( validfromdate<='" + System.DateTime.Now.ToString("yyyy-MM-dd") + "'" + 
					" AND validtodate>='" + System.DateTime.Now.ToString("yyyy-MM-dd")+ "'" + 
					" AND (  clickcount<maxclicks OR maxclicks=0 )" + 
					" AND (  showcount<maximpressions OR maximpressions=0 ) )";
			return " AND NOT ( validfromdate<='" + System.DateTime.Now.ToString("yyyy-MM-dd") + "'" + 
					" AND validtodate>='" + System.DateTime.Now.ToString("yyyy-MM-dd")+ "'" + 
					" AND (  clickcount<maxclicks OR maxclicks=0 )" + 
					" AND (  showcount<maximpressions OR maximpressions=0 ) )";

		}

		public long GetBannerCountForAdpos(long lAdposd, bool fActive, bool fNonActive)
		{
			string strSQL;
			strSQL = "select count(*) as antal from a_banner where a_banner.adpos_id =" + lAdposd.ToString();

			if ( fNonActive )
				strSQL += GetActiveBannersSQL(false);
			else if ( fActive )
				strSQL += GetActiveBannersSQL(true);
			return AdMentorDBExecutor.GetScalar(GetConnectionString(),strSQL);
		}
		public long GetBannerCountForAdvertiser(long lUserFldAuto, bool fActive, bool fNonActive)
		{
			string strSQL;
			strSQL = "select count(*) as antal from a_banner, a_users where a_users.fldAuto=a_banner.advid and a_users.fldAuto=" + lUserFldAuto.ToString();
			if ( fNonActive )
				strSQL += GetActiveBannersSQL(false);
			else if ( fActive )
				strSQL += GetActiveBannersSQL(true);

			return AdMentorDBExecutor.GetScalar(GetConnectionString(),strSQL);
		}


		public long GetBannerCountForZone(long lUserFldAuto, bool fActive, bool fNonActive)
		{
			string strSQL;
			strSQL = "select count(*) as antal from a_banzone, a_banner where a_banner.bannerid=a_banzone.bannerid AND a_banzone.zoneid=" + lUserFldAuto.ToString();

			if ( fNonActive )
				strSQL += GetActiveBannersSQL(false);
			else if ( fActive )
				strSQL += GetActiveBannersSQL(true);

			return AdMentorDBExecutor.GetScalar(GetConnectionString(),strSQL);
		}

		public System.Data.DataSet GetBannersAndStats3(string strSortField, string strSortDirection, string strWhere, string strStartDate, string strEndDate)
		{
			string strSQL;
			strSQL = "select a_bannerstats.datum as datum, sum(a_bannerstats.showcount) as bshowcount, sum(a_bannerstats.clickcount) as bclickcount from a_bannerstats, a_banner, a_zone, a_banzone where a_banzone.bannerid=a_banner.bannerid and  a_banzone.zoneid=a_zone.zoneid AND a_banner.bannerid=a_bannerstats.bannerid  AND datum>='" + strStartDate + "' AND datum<='" + strEndDate + "' ";
			if ( strWhere != "" )
				strSQL += " AND ( " + strWhere + ")";
			
			if ( strSortField == "" )
				strSortField = "datum";

			strSQL += " GROUP BY datum";
			strSQL += " ORDER BY datum";

							
			return AdMentorDBExecutor.GetDataSet(GetConnectionString(), strSQL, "zones");
		}


		public System.Data.DataSet GetBannersAndStats2(string strSortField, string strSortDirection, string strWhere, string strStartDate, string strEndDate)
		{
			string strSQL;
			strSQL = "select distinct fldAuto, a_bannerstats.datum as datum, a_banner.bannerid as bbannerid, a_banner.name as bname, a_banner.weight as bweight, a_bannerstats.showcount as bshowcount, a_bannerstats.clickcount as bclickcount, a_adposition.name as pname, a_banner.ishtml as bishtml, a_banner.cantrackclicks as bcantrackclicks from a_banner, a_adposition, a_zone, a_banzone, a_bannerstats WHERE a_bannerstats.bannerid=a_banner.bannerid AND a_banzone.zoneid=a_zone.zoneid and a_banzone.bannerid=a_banner.bannerid and a_adposition.adposid=a_banner.adpos_id ";
			if ( strWhere != "" )
				strSQL += "AND( " + strWhere + ")";
			
			if ( strSortField == "" )
				strSortField = "datum";

			strSQL += " ORDER BY " + strSortField +  " " + strSortDirection;

					
			return AdMentorDBExecutor.GetDataSet(GetConnectionString(), strSQL, "zones");
		}

		

		public System.Data.DataSet GetBannersAndStats(string strSortField, string strSortDirection, string strWhere, string strStartDate, string strEndDate)
		{
			string strSQL;
			strSQL = "select distinct a_banner.bannerid as bbannerid, a_banner.name as bname, a_banner.weight as bweight, a_banner.showcount as bshowcount, a_banner.clickcount as bclickcount, a_adposition.name as pname, a_banner.ishtml as bishtml, a_banner.cantrackclicks as bcantrackclicks from a_banner, a_adposition, a_zone, a_banzone WHERE  a_banzone.zoneid=a_zone.zoneid and a_banzone.bannerid=a_banner.bannerid and a_adposition.adposid=a_banner.adpos_id ";
			if ( strWhere != "" )
				strSQL += "AND( " + strWhere + ")";
				
			strSQL += " ORDER BY " + strSortField +  " " + strSortDirection;

					
			DataSet oDataSet = AdMentorDBExecutor.GetDataSet(GetConnectionString(), strSQL, "zones");
			
			for ( int i = 0; i < oDataSet.Tables["zones"].Rows.Count;i++ )
			{
				System.Data.DataRow r = oDataSet.Tables["zones"].Rows[i];
				//Now fix up showcount and clickcount...
				r["bclickcount"] = GetStatsForBanner( "clicks", (int)r["bbannerid"] ,strStartDate, strEndDate );
				r["bshowcount"] = GetStatsForBanner( "shows", (int)r["bbannerid"],strStartDate, strEndDate );
			}
			return oDataSet;
		}



		public System.Data.DataSet GetBanners(string strSortField, string strSortDirection, string strWhere, bool fActive, bool fNonActive)
		{
			string strSQL;
			strSQL = "select distinct a_banner.bannerid as bbannerid, a_banner.name as bname, a_banner.weight as bweight, a_banner.showcount as bshowcount, a_banner.clickcount as bclickcount, a_adposition.name as pname, a_banner.ishtml as bishtml from a_banner, a_adposition, a_zone, a_banzone WHERE  a_banzone.zoneid=a_zone.zoneid and a_banzone.bannerid=a_banner.bannerid and a_adposition.adposid=a_banner.adpos_id ";
			if ( strWhere != "" )
				strSQL += "AND( " + strWhere + ")";
				
			if ( fNonActive && fActive	)
				{
				}
			else if ( fNonActive )
				strSQL += GetActiveBannersSQL(false);
			else if ( fActive )
			{
				strSQL += GetActiveBannersSQL(true);
			}
			strSQL += " ORDER BY " + strSortField +  " " + strSortDirection;

					
			DataSet oDataSet = AdMentorDBExecutor.GetDataSet(GetConnectionString(), strSQL, "zones");
			
			System.Data.DataColumn dc = new System.Data.DataColumn("zones",System.Type.GetType("System.String"));
			oDataSet.Tables["zones"].Columns.Add(dc);
			for ( int i = 0; i < oDataSet.Tables["zones"].Rows.Count;i++ )
			{
				System.Data.DataRow r = oDataSet.Tables["zones"].Rows[i];
				r["zones"] = GetZoneNamesForBanner( (int)r["bbannerid"] );
			}
			return oDataSet;
		}
	}
}
