<?php
/*
	WMLStart.php
	by Tim Strehle <tim@digicol.de>

	http://tim.digicol.de/wmlstart/

	WMLStart.php is a compact, understandable, yet fully-working sample
	WAP/WML application contained in a single PHP script. It requires no
	installation and no configuration.

	Use it as an example or starting point when developing your own WML
	pages. WMLStart.php is free and Open Source.
	Feel free to contact me at tim@digicol.de with questions/comments.

	Disclaimer:
	Use this software at your own risk. I won't guarantee that it works, and
	I won't be held liable for any damage caused by it!

	Version: 1.0

    Requirements:
    PHP 4 (version 4.1 or greater) with Session support.
    Works fine with the php.ini setting "register_globals = off".
*/

// Set up login data

define('WMLSTART_USER', 'test');
define('WMLSTART_PASS', 'secret');

// Set up dummy data
// (Quotes taken from http://www.quotegarden.com/presidents-by.html)

$records = array(
	'History, in general, only informs us what bad government is.  ~Thomas Jefferson',
	'I have never advocated war except as a means of peace.  ~Ulysses S. Grant',
	'Older men declare war.  But it is the youth that must fight and die.  ~Herbert Hoover',
	'We seek peace, knowing that peace is the climate of freedom.  ~Dwight D. Eisenhower',
	'Mankind must put an end to war, or war will put an end to mankind.  ~John F. Kennedy, 1961',
	'The basic problems facing the world today are not susceptible to a military solution.  ~John F. Kennedy',
	'Freedom is not enough.  ~Lyndon B. Johnson'
	);

// No cookies in WAP

ini_set('session.use_cookies', 0);

// session.use_trans_sid will break our XML as it appends URL parameters with & instead of &amp;
// - since session.use_trans_sid cannot be disabled in a script, set url_rewriter.tags instead

ini_set('url_rewriter.tags', '');

// Get session ID from GET/POST

if (isset($_REQUEST[ 'ses' ])) session_id($_REQUEST[ 'ses' ]);

// Start session

session_name('wmlstart');
@session_start();

// Initialize session data

if (! isset($_SESSION[ 'data' ]))
  $_SESSION[ 'data' ] = array(
	'user_id'    => '',
	'user_name'  => '',
	'searchterm' => '',
	);


function _dologin()
{ // Hardcoded login data, defined at the top of this script

  if ((strtolower($_REQUEST[ 'user' ]) == strtolower(WMLSTART_USER))
	&& (strtolower($_REQUEST[ 'pass' ]) == strtolower(WMLSTART_PASS)))
	{ $_SESSION[ 'data' ][ 'user_name' ] = $_REQUEST[ 'user' ];
	  return true;
	}
  else
	return false;
}


header('Content-type: text/vnd.wap.wml');
echo '<?xml version="1.0" encoding="iso-8859-1"?>' . "\n";

?>
<!DOCTYPE wml PUBLIC "-//WAPFORUM//DTD WML 1.1//EN" "http://www.wapforum.org/DTD/wml_1.1.xml">
<wml>
<card title="WMLStart.php" newcontext="true">
<p>
<?php

// Default mode: Display HOME page

$mode = 'home';
$errmsg = '';

// Logout if "logout" is in GET/POST request

if (isset($_REQUEST[ 'logout' ]))
  $_SESSION[ 'data' ][ 'user_name' ] = '';

// Try to login if "user" and "pass" are given

if (($_SESSION[ 'data' ][ 'user_name' ] == '') && isset($_REQUEST[ 'user' ]) && isset($_REQUEST[ 'pass' ]))
  if (_dologin())
	$mode = 'home';
  else
	$errmsg = 'Login failed.';

// Force LOGIN page display if not logged in

if ($_SESSION[ 'data' ][ 'user_name' ] == '')
  $mode = 'login';

// Switch to FIND mode if "search" parameter is given

if (isset($_REQUEST[ 'search' ]))
  $mode = 'find';

// Switch to DISPLAY mode if record ID ("rec") is given

if (isset($_REQUEST[ 'rec' ]))
  $mode = 'display';

// FIND: Validate search term

if ($mode == 'find')
  { $_SESSION[ 'data' ][ 'searchterm' ] = trim(preg_replace('/[^a-zA-Z0-9 ]/', '', $_REQUEST[ 'search' ]));

	if ($_SESSION[ 'data' ][ 'searchterm' ] == '')
	  { $mode = 'home';
		$errmsg = 'Invalid search term.';
	  }
  }

// FIND: Execute search

if ($mode == 'find')
  { $i = 0;

	// Look for matching strings in $record array

	foreach ($records as $key => $record)
	  { if (! stristr($record, $_SESSION[ 'data' ][ 'searchterm' ]))
		  continue;

		$label = $record;
		if (strlen($record) > 30)
		  $label = substr($label, 0, 27) . '...';

		echo '<a href="' . $_SERVER[ 'PHP_SELF' ] . '?ses=' . urlencode(session_id()) . '&amp;rec=' . $key . '">' . ++$i . ': ' . htmlspecialchars($label) . '</a><br/>';
	  }

	?>

	<a href="<?=$_SERVER[ 'PHP_SELF' ]?>?ses=<?=urlencode(session_id())?>">New search</a><br/>

	<a href="<?=$_SERVER[ 'PHP_SELF' ]?>?ses=<?=urlencode(session_id())?>&amp;logout=1">Logout</a>

	<?php
  }

// DISPLAY: Validate record ID ("rec")

if ($mode == 'display')
  { if (! isset($records[ $_REQUEST[ 'rec' ] ]))
	  { $errmsg = intval($_REQUEST[ 'rec' ]) . ' could not be loaded.';
		$mode = 'home';
	  }
  }

// DISPLAY: Display record

if ($mode == 'display')
  { ?>

	<em><?=htmlspecialchars($records[ $_REQUEST[ 'rec' ] ])?></em><br/><br/>

	<a href="<?=$_SERVER[ 'PHP_SELF' ]?>?ses=<?=urlencode(session_id())?>&amp;search=<?=urlencode($_SESSION[ 'data' ][ 'searchterm' ])?>">Back to list</a><br/>

	<a href="<?=$_SERVER[ 'PHP_SELF' ]?>?ses=<?=urlencode(session_id())?>">New search</a><br/>

	<a href="<?=$_SERVER[ 'PHP_SELF' ]?>?ses=<?=urlencode(session_id())?>&amp;logout=1">Logout</a>

	<?php
  }

// HOME: Display search/login form

if ($mode == 'home')
  { // Display error message

	if ($errmsg != '') echo '<em>' . htmlspecialchars($errmsg) . '</em><br/>'; ?>

	Search term: <input type="text" name="search" emptyok="false" title="Search term" value="<?php echo htmlspecialchars($_SESSION[ 'data' ][ 'searchterm' ]); ?>"/><br/>

	Hint: Search for &quot;war&quot; or &quot;Kennedy&quot;...<br />

	<anchor>
		Search
		<go href="<?php echo $_SERVER[ 'PHP_SELF' ]; ?>" method="post">
		<postfield name="search" value="$(search)"/>
		<postfield name="ses" value="<?php echo session_id(); ?>"/>
		</go>
	</anchor>

	<br/>
	<a href="<?=$_SERVER[ 'PHP_SELF' ]?>?ses=<?=urlencode(session_id())?>&amp;logout=1">Logout</a>

	<?php
  }

// LOGIN: Display login form

if ($mode == 'login')
  { // Display previous user name in "user_name" field

	$uservalue = $_SESSION[ 'data' ][ 'user_name' ];
	if (isset($_REQUEST[ 'user' ]))
	  $uservalue = trim(preg_replace('/[^a-zA-Z0-9 ]/', '', $_REQUEST[ 'user' ]));

	// Display error message

	if ($errmsg != '') echo '<em>' . htmlspecialchars($errmsg) . '</em><br/>'; ?>

	User: <input type="text" name="user" emptyok="false" title="User" value="<?php echo htmlspecialchars($uservalue); ?>"/><br/>
	Password: <input type="password" name="pass" emptyok="false" title="Password" value=""/><br/>

	<anchor>
		Login
		<go href="<?php echo $_SERVER[ 'PHP_SELF' ]; ?>" method="post">
		<postfield name="user" value="$(user)"/>
		<postfield name="pass" value="$(pass)"/>
		<postfield name="ses" value="<?php echo session_id(); ?>"/>
		</go>
	</anchor>

	<?php
  }

?>
</p>
</card>
</wml>