package Relogio;

import java.text.DateFormat;
import java.util.*;

public class Relogio {
    Calendar  calendar = null;

    public Relogio() {
	calendar = Calendar.getInstance();
	Date DataAtual = new Date();
	calendar.setTime(DataAtual);
    }

    public int getAno() {
	return calendar.get(Calendar.YEAR);
    }
    
    public String getMes() {
	int m = getMesNum();
	String[] mes = new String [] { "Janeiro", "Fevereiro", "Marco",
					"Abril", "Maio", "Junho",
					"Julho", "Agosto", "Setembro",
					"Outubro", "Novembro", "Dezembro" };
	if (m > 12)
	    return "Desconhecido";
	
	return mes[m - 1];

    }

    public String getDia() {
	int x = getDiaDaSemana();
	String[] dia = new String[] {"Domingo", "Segunda-feira", "Terca-feira", "Quarta-feira", 
				      "Quinta-feita", "Sexta-feira", "Sabado"};

	if (x > 7)
	    return "Desconhecido";

	return dia[x - 1];

    }
    
    public int getMesNum() {
	return 1 + calendar.get(Calendar.MONTH);
    }

    public String getData() {
	return getDiadoMes() + "/" + getMesNum() + "/" +  getAno();

    }

    public String getHoras() {
	return getHora() + ":" + getMinuto() + ":" + getSegundo();
    }

    public int getDiadoMes() {
	return calendar.get(Calendar.DAY_OF_MONTH);
    }

    public int getDiaDoAno() {
	return calendar.get(Calendar.DAY_OF_YEAR);
    }

    public int getSemanaDoAno() {
	return calendar.get(Calendar.WEEK_OF_YEAR);
    }

    public int getSemanaDoMes() {
	return calendar.get(Calendar.WEEK_OF_MONTH);
    }

    public int getDiaDaSemana() {
	return calendar.get(Calendar.DAY_OF_WEEK);
    }
     
    public int getHora() {
	return calendar.get(Calendar.HOUR_OF_DAY);
    }
    
    public int getMinuto() {
	return calendar.get(Calendar.MINUTE);
    }


    public int getSegundo() {
	return calendar.get(Calendar.SECOND);
    }

    public int getEra() {
	return calendar.get(Calendar.ERA);
    }

    public String getUSTimeZone() {
	String[] zones = new String[] {"Hawaii", "Alaskan", "Pacific",
				       "Mountain", "Central", "Eastern"};
	
	return zones[10 + getZoneOffset()];
    }

    public int getZoneOffset() {
	return calendar.get(Calendar.ZONE_OFFSET)/(60*60*1000);
    }


    public int getDSTOffset() {
	return calendar.get(Calendar.DST_OFFSET)/(60*60*1000);
    }

    
    public int getAMPM() {
	return calendar.get(Calendar.AM_PM);
    }
}

