//Definindo um pacote para a classe
package GPSServlet;

//Importando as classes necessrias as funes chamadas
import java.io.*;
import java.text.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

//Classe principal extendida da classe generica de tratamento de servlets HttpServlet
public class ServletGPS extends HttpServlet {
  private String Msg;
  private int NumAcessos = 0;

  //Mtodo que  executado toda vez que um servlet  carregado
  public void init(ServletConfig servletConfig) throws ServletException{
    super.init(servletConfig);
    Msg = "Nenhuma mensagem foi enviada";
  }

  //Mtodo que  executado toda vez que um servlet  descarregado
  public void destroy(){
    Msg = "Fim do Servlet";
  }

  //Mtodo que atende ao acionamento do mtodo get do formulrio
  public void doGet(HttpServletRequest Req, HttpServletResponse Res)throws IOException, ServletException{

    Res.setContentType("text/html");
    PrintWriter out = Res.getWriter();

    //Parmetro fornecido pelo formulrio chamador
    Msg = Req.getParameter("Mensagem");

    //HTML que ser gerado como resposta
    //Cada linha  enviada ao cliente em uma conexo
    out.println("<html>");
    out.println("<head>");
    out.println("<title>Building Dynamic WebSite - www.catalunha.eng.br</title>");
    out.println("</head>");
    out.println("<body>");
    out.println("<p><h1>Mtodo acionado foi o: <b> GET </b></h1></p>");
    out.println("<p><h1>A mensagem enviada : <b> " + Msg + "</b></h1></p>");
    out.println("<p><h2>Nmero de acessos: " + ++NumAcessos + "</h2>");
    out.println("</body>");
    out.println("</html>");

  }


  //Mtodo que atende ao acionamento do mtodo post do formulrio
  public void doPost(HttpServletRequest Req, HttpServletResponse Res)throws IOException, ServletException{

    Res.setContentType("text/html");
    PrintWriter out = Res.getWriter();

    //Parmetro fornecido pelo formulrio chamador
    Msg = Req.getParameter("Mensagem");

    //HTML que ser gerado como resposta
    //Cada linha  enviada ao cliente em uma conexo
    out.println("<html>\n");
    out.println("<head>\n");
    out.println("<title>Building Dynamic WebSite - www.catalunha.eng.br</title>\n");
    out.println("</head>\n");
    out.println("<body>\n");
    out.println("<p><h1>Mtodo acionado foi o: <b> POST </b></h1></p>\n");
    out.println("<p><h1>A mensagem enviada : <b> " + Msg + "</b></h1></p>\n");
    out.println("<p><h2>Nmero de acessos: " + ++NumAcessos + "</h2>\n");
    out.println("</body>\n");
    out.println("</html>\n");
  }

  //Mtodo que atende ao acionamento do mtodo get ou post do formulrio indiferentemente
  public void service(HttpServletRequest Req, HttpServletResponse Res)throws IOException, ServletException{

    Res.setContentType("text/html");

    //Parmetro fornecido pelo formulrio chamador
    Msg = Req.getParameter("Mensagem");
  
    //HTML que ser gerado como resposta
    //Todo o texto  armazenado em um buffer de sada
    StringBuffer buffer = new StringBuffer();
    buffer.append("<html>\n");
    buffer.append("<head>\n");
    buffer.append("<title>Building Dynamic WebSite - www.catalunha.eng.br</title>\n");
    buffer.append("</head>\n");
    buffer.append("<body bgcolor=\"#CCCCCC\">\n");
    buffer.append("<p><h1>Mtodo acionado foi o: <b>" + Req.getMethod() + "</b></h1></p>\n");
    buffer.append("<p><h1>A mensagem enviada : <b> " + Msg + "</b></h1></p>\n");
    buffer.append("<p><h2>Nmero de acessos: " + ++NumAcessos + "</h2>\n");
    buffer.append("</body>\n");
    buffer.append("</html>\n");

    //O buffer ser enviado ao cliente em uma nica conexo. Processo mais rpido que o anterior
    Res.setContentLength(buffer.length());
    Res.getOutputStream().print(buffer.toString());
  }

}
