package EtoWeb;

import java.io.*;
import java.text.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;


public class RelatorioEto extends HttpServlet {
  // variaveis instanciada para metodo de calculo GeralEto
  GeralEto CalcEto = new GeralEto();

  // variaveis privadas a esta classe para calculo dos metodos
  private String[]
    Metodos;

  // Funcao que associa valores de variaveis da pagina a classe GeralEto
  public void AssVarHtmlEto(HttpServletRequest Req){
    try{   
      Metodos = Req.getParameterValues("QMet");
      CalcEto.AssValEntrada("Dia",Req.getParameter("tfDia"));
      CalcEto.AssValEntrada("Mes",Req.getParameter("tfMes"));
      CalcEto.AssValEntrada("Ano",Req.getParameter("tfAno"));
      CalcEto.AssValEntrada("GSC",Req.getParameter("tfGSC"));
      CalcEto.AssValEntrada("LatG",Req.getParameter("tfLatG"));
      CalcEto.AssValEntrada("LatM",Req.getParameter("tfLatM"));
      CalcEto.AssValEntrada("LatS",Req.getParameter("tfLatS"));
      CalcEto.AssValEntrada("Ins",Req.getParameter("tfIns"));
      CalcEto.AssValEntrada("Tx",Req.getParameter("tfTx"));
      CalcEto.AssValEntrada("T",Req.getParameter("tfT"));
      CalcEto.AssValEntrada("Tn",Req.getParameter("tfTn"));
      CalcEto.AssValEntrada("Urn",Req.getParameter("tfUrn"));
      CalcEto.AssValEntrada("Vvd",Req.getParameter("tfVvd"));
    }catch(Exception e){
      System.out.println("Erro de parmetros dos mtodos");
      e.printStackTrace();
    }
  }

  public void service(HttpServletRequest Req, HttpServletResponse Res) throws IOException, ServletException{

    CalcEto.InicVariaveis();
    AssVarHtmlEto(Req);
    CalcEto.Calculo();   

    StringBuffer buffer = new StringBuffer();

    Res.setContentType("text/html");
    buffer.append("<html>");
    buffer.append("<body>");
    buffer.append("<head>");
    buffer.append("<title>Relatrio do clculo de Evapotranspirao</title>");
    buffer.append("</head>");
    buffer.append("<body bgcolor=\"white\">");
    buffer.append("<b>Valor da Evapotranspira&ccedil;&atilde;o</b>");
    buffer.append("<p></p>");
    buffer.append("<table border=\"1\">");
    buffer.append("<tr bgcolor=\"#FFFFCC\"> ");
    buffer.append("  <td >");
    buffer.append("    <div align=\"center\"><font color=\"#0000FF\"><b>M&eacute;todo</b></font></div>");
    buffer.append("  </td>");
    buffer.append("  <td> ");
    buffer.append("    <div align=\"center\"><font color=\"#0000FF\"><b>ETo</b></font></div> ");
    buffer.append("  </td>");
    buffer.append("</tr>");

    if(Metodos != null){
      for(int i = 0; i < Metodos.length; i++){
        if( Metodos[i].equals("HS")){
          buffer.append("<tr>");
          buffer.append("  <td >Hargreaves e Samani</td>");
          buffer.append("  <td >" + Double.toString(CalcEto.HS) + "</td>");
          buffer.append("</tr>");
        }
        if( Metodos[i].equals("BC_FAO")){
          buffer.append("<tr>");
          buffer.append("  <td >Blaney-Criddle FAO</td>");
          buffer.append("  <td >" + Double.toString(CalcEto.BC_FAO) + "</td>");
          buffer.append("</tr>");
        }
      }
      buffer.append("</table>");
    }
    buffer.append("<p></p>");
    buffer.append("<b>Valor das vari&aacute;veis intermedi&aacute;rias:</b>");
    buffer.append("<p></p>");

    for(int L=0;L<=111;++L){
      if(CalcEto.AssValSaida(L) != "" ){
        buffer.append(CalcEto.AssValSaida(L) + "<br>");
      }
    }
    buffer.append("</body>");
    buffer.append("</html>");

    //O buffer ser enviado ao cliente em uma nica conexo. Processo mais rpido que o anterior
    Res.setContentLength(buffer.length());
    Res.getOutputStream().print(buffer.toString());
  }
}