// Desenvolvido por
// Brauliro
// Catalunha 
// 25/03/2000

package EtoWeb;

import java.math.*;

public class GeralEto {

// variaveis de config geral dos projetos,
    private double
      LatG,LatM,LatS,GSC,RbA,RbB,RboA1,RboB1,RsA,RsB,RsoK,
      Cp = 1.013,Epsilon  = 0.622;
    private int
      NULO=9999,MetDpv,MetJH,RboT,CMed,Veg;


// variaveis de calculo de Eto,
    public double
      BC_FAO,HS,JH,Mk_FAO,Pe_63,Pe_FAO,Pe_FAO_C,PM_91,PT,TCA;

// variaveis privadas a esta classe para calculo dos metodos
    private int
      DiaAno,Ano, Dia, Mes; //Hora, Minuto; 
    private double
      A,Albedo,B,Alfa,Bord,C,C1,C2,Ct,CH,D,DecSol,Delta,Deltat,Dpv,Dr,Dren,Ea,Es,
      ETo,ETp,Ev,F,G,Gama,GamaL,Hc,I,IAF,Ins,Irrig,K,Kt,L,Lat,Leit1,Leit2,Lis,N,
      P,Patm,Prec,Ra,Rb,Rbo,Rc,Rho,Rins,Rn,Ro,Rs,Rso,T,Tmes,Tn,Tnm,Tnnorm,Transb,
      Tx,Tjh,Txm,Txnorm,Ur,Urn,Urx,Vv,Vvd,Vvd_Vvn,Vvn,Vvz,W1,W2,Wf,Ws,Z,Zv,Zp;

////////////////////////////////////////////////////////////////////
//////////// FUNCOES MEMBRO DA CLASSE GeralEto /////////////////////
////////////////////////////////////////////////////////////////////
  // Retorna o dia do ano, 01/Jan -> 1 e 31/Dez -> 365 ou 366
  private int DiaDoAno( int Dia, int Mes, int Ano){
    if ((Dia == NULO) | (Mes == NULO) | (Ano == NULO))
      return NULO;
    else {  
      int DiasNoMes[] = {31,28,31,30,31,30,31,31,30,31,30,31};
      int vMes,DiasNoAno;
      DiasNoAno = Dia;
      for (vMes = 0; vMes <= (Mes - 2); vMes++){
        DiasNoAno = DiasNoAno + DiasNoMes[vMes];
        if (( vMes == 2 ) & ((Ano % 4 == 0) & (Ano % 100!=0 ) | (Ano % 400 == 0)))
          DiasNoAno++;
      }
    return DiasNoAno;
    }
  }

  private double fL(){
    if (T == NULO)
      return 2.45;
    else
      return 2.501-2.361E-3*T;
  }

  private double e(double x){
    return 0.6108* Math.exp( 17.27*x  / ( x + 237.3 ) );
  }

  private double fA(){
    if ((Urn == NULO) | (Rins == NULO))
      return NULO;
    else
      return 0.0043 * Urn - Rins - 1.41;
  }

  private double fAlbedo(){
     return Albedo;
  }

  private double fAlfa(){
    return Alfa;
  }


  private double fB(){
    double a0 =  0.81917,      a1 = -0.0040922,     a2 =  1.0705,
      a3 =  0.065649,     a4 = -0.0059684,     a5 = -0.0005967;
    if ((Urn == NULO) | (Rins == NULO) | (Vvd == NULO))
      return NULO;
    else
      return  a0 + a1*Urn + a2*Rins + a3*Vvd + a4*Urn*Rins + a5*Urn*Vvd;
  }

  private double fBord(){
    return Bord;
  }

  private double fBC_FAO(){
     if ((A == NULO) | (B == NULO) | (F == NULO))
       return NULO;
     else
       return (A + B * F) * L;
  }

  private double fC(){
    double _Urx, _Rs, _Vvd, _Vvd_Vvn;
    if ((Urx == NULO) | (Rs == NULO) | (Vvd == NULO) | (Vvd_Vvn == NULO))
       return NULO;
     else{
          _Urx      =  Urx;
          _Rs       =  Rs*0.408;
          _Vvd      =  Vvd;
          _Vvd_Vvn  =  Vvd_Vvn;
          if (_Vvd_Vvn <  0.5 )  _Vvd_Vvn  =  0.5;
          if (_Vvd_Vvn >  4   )  _Vvd_Vvn  =  4;
          if (_Vvd     >  9   )  _Vvd      =  9;
          if (_Urx     < 30   )  _Urx      = 30;
          if (_Urx     > 90   )  _Urx      = 90;
          if (_Rs      <  3   )  _Rs       =  3;
          if (_Rs      > 12   )  _Rs       = 12;
          return 0.68 + 0.0028*_Urx + 0.018*_Rs - 0.068*_Vvd + 0.013*_Vvd_Vvn+
                    0.0097*_Vvd*_Vvd_Vvn + 0.430E-4 *_Urx*_Rs*_Vvd_Vvn;
         }
  }
  private double fC1(){
    if ((Z == NULO) | (MetJH == NULO))
      return NULO;
    else if (MetJH == 1)
           return 38;
         else
           return 38 - 2 * Z / 305;
  }
  private double fC2(){
    if (C2 == NULO)
      return 7.3;
    else
      return C2;
  }
  private double fCH(){
    if ((Txnorm == NULO) | (Tnnorm == NULO) | (Tnnorm == Txnorm))
      return NULO;
    else
      return 50 / (1.3329* Math.exp(21.07 - 5336.0/(Txnorm + 273.1)) -
                          1.3329*Math.exp(21.07 - 5336.0/(Tnnorm + 273.1)));
 }

  private double fCt(){
    if ((C1 == NULO) | (C2 == NULO) | (CH == NULO) | (MetJH == NULO))
      return NULO;
    else
      if (MetJH == 0)
        return 0.014;
      else
        return 1/(C1 + C2*CH);
  }
  private double fD(){
     if (Hc == NULO)
       return NULO;
     else
       return (2/3) * Hc;
  }

  private double fDecSol(){
    if (DiaAno == NULO)
      return NULO;
    else
      return  0.4102 * Math.sin( 2 * Math.PI * (DiaAno+284)/365 );
  }
  private int fDiaAno(){
    return DiaDoAno(Dia,Mes,Ano);
  }

  private double fDelta(){
    if ((Es == NULO) | (T == NULO))
      return NULO;
    else
      return 4098 * Es / Math.pow((T+237.3),2);
  }
  private double fDeltat(){
    return 1;
  }
  private double fEa(){
    if ((T == NULO) | (Ur == NULO))
      return NULO;
    else
      return e(T)*Ur/100;
  }
  private double fEs(){
    if (T == NULO)
      return NULO;
    else
      return e(T);
  }
  private double fEv(){
     if ((Leit1 == NULO) | (Leit2 == NULO) | (Prec == NULO) | (Transb == NULO))
       return NULO;
     else
       return Leit2 - Leit1 + Prec - Transb;
  }


  private double fDpv(){
    double _Ea,_Es,Res=9999;
    if (MetDpv == 9999)
      return Res;
    else {  
    switch(MetDpv){
      case 0 : { if ((T == NULO) | (Ur == NULO))
                   Dpv = NULO;
                 else{
                    _Es     = e(T);
                    _Ea     = e(T)*Ur/100;
                 }
                 break;
                }
      case 1 : { if ((T==NULO)|(Tn==NULO)|(Tx==NULO)|(Urn==NULO)|(Urx==NULO))
                   Dpv = NULO;
                 else{
                   _Es     = e(T);
                   _Ea     = ( e(Tn)* Urx + e(Tx) * Urn )/ 100;
                 }
                 break;
               }
      case 2 : { if ((T == NULO) | (Tn == NULO))
                   Dpv = NULO;
                 else {
                   _Es     = e(T);
                   _Ea     = e(Tn);
                 }
                 break;
               }
      case 3 : { if ((T == NULO) | (Tn == NULO) | (Tx == NULO) | (Urn == NULO) | (Urx == NULO))
                   Dpv = NULO;
                 else {
                   _Es     = (e(Tx) + e(Tn)) / 2;
                   _Ea     = (e(Tn)*Urx + e(Tx)*Urn)/ 100;
                 }
                 break;
               }
      default: { if ((T == NULO) | (Ur == NULO))
                   Dpv = NULO;
                 else {
                   _Es        = e(T);
                   _Ea        = e(T)*Ur/100;
                 }
                 break;
               }
    }//fim switch
    if (Dpv == NULO){
          if ((T == NULO) | (Ur == NULO))
            Res = NULO;
          else {
            _Es     = e(T);
            _Ea     = e(T)*Ur/100;
            Res =  _Es - _Ea;
          }
    }
    return Res;    
  }
  }

  private double fDr(){
    if (DiaAno == NULO)
      return  NULO;
    else
      return (1 + 0.033 * Math.cos( 2*Math.PI*DiaAno / 365 ));
  }


  private double fF(){
    if ((P == NULO) | (T == NULO))
      return NULO;
    else
      return P*(0.46*T + 8.0);
  }

  private double fG(){
    return 0;
  }
  private double fGama(){
    if (Patm == NULO)
      return NULO;
    else
      return Cp*Patm / (1000*Epsilon * L);
  }
  private double fGamaL(){
    if ((Gama == NULO) | (Rc == NULO) | (Ra == NULO) | (Ra <= 0))
      return NULO;
    else
      return Gama * ( 1 + Rc / Ra );
  }

  private double fHc(){
    return Hc;
  }

  private double fHS(){
    if ((Ro == NULO) | (Tx == NULO) | (T == NULO) | (Tn == NULO))
      return NULO;
    else
      return 0.0023 * Ro * Math.sqrt(Tx-Tn) * ( T + 17.8);
  }


  private double fI(){
     return 1;
  }
  private double fIAF(){
    if (Hc == NULO)
      return NULO;
    else if (Hc < 0.15)
           return 24 * Hc;
         else
           return 1.5 * Math.log( 100 * Hc )-1.4;
  }
  private double fJH(){
    if ((Ct == NULO) | (T == NULO) | (Tjh == NULO) | (Rs == NULO))
      return NULO;
    else
      return Ct * ( T - Tjh ) * Rs;
  }

  private double fK(){
     if ((Ur == NULO) | (Vvd == NULO))
       return NULO;
     else
       return 1.066 - 0.13E-2 * Ur + 0.045 * Vvd - 0.20E-3 * Ur * Vvd -
                    0.315E-4 * Math.pow(Ur,2) - 0.11E-2 * Math.pow(Vvd,2);
  }

  private double fKt(){
    double _Ur,_Vv,_Bord;
    if ((Ur == NULO) | (Vv == NULO) | (Bord == NULO) | (Veg == NULO))
      return NULO;
    else{
          _Ur    = Ur;
          _Vv    = Vv;
          _Bord  = Bord;
          if (_Ur   <   30      ) _Ur    =  30;
          if (_Ur   >   84      ) _Ur    =  84;
          if (_Vv   <    0.9722 ) _Vv    =  0.9722;
          if (_Vv   >    8.102  ) _Vv    =  8.102;
          if (_Bord <    1      ) _Bord  =  1;
          if (_Bord > 1000      ) _Bord  =  1000;
          if (Veg == 1)
            return  0.108 - 0.000331*_Vv + 0.0422*Math.log(_Bord) + 0.1434*Math.log(_Ur) -
                        0.000631*Math.pow(Math.log(_Bord),2)*Math.log(_Ur);
          else
            return  0.61 + 0.00341*_Ur - 0.00000187*_Vv*_Ur -
                        0.000000111*_Vv*_Bord + 0.0000378*_Vv*Math.log(_Bord) -
                        0.0000332*_Vv*Math.log(_Vv) - 0.0106*Math.log(_Vv)*Math.log(_Bord) +
                        0.00063*Math.pow(Math.log(_Bord),2)*Math.log(_Vv);
        }
  }

  private double fLat(){
    if  ((LatG == NULO) | (LatM == NULO)  | (LatS == NULO))
      return NULO;    
    else   
      return LatG + ( LatM + LatS / 60 ) / 60;    
  }

  private double fLis(){
    if ((Dren == NULO) | (Irrig == NULO)  | (Prec == NULO))
      return NULO;
    else
      return Prec + Irrig - Dren;
  }
  private double fMk_FAO(){
    if ((K == NULO) | (Delta == NULO) | (Gama == NULO) | (Rs == NULO))
      return NULO;
    else
      return -0.3 * L + K * Delta/( Delta + Gama )* Rs;
  }

  private double fN (){
    if (Ws == NULO)
      return NULO;
    else
      return Ws * 24 / Math.PI;
  }

  private double fP(){
    int    i;
    double S;
    if ((Lat == NULO) | (N == NULO))
      return NULO;
    else {
          S = 0;
          for (i = 1; i <= 365; i++){
              S = S + (24/Math.PI)* Math.acos( Math.tan(Lat * Math.PI/180) *
                                        Math.tan( 0.493*Math.sin( 2*Math.PI * (284 + i)/365)));
          }                              
          return 100*N/S;
         }
  }

  private double fPatm (){
    if (Z == NULO)
      return NULO;
    else
      return 101.3 - 0.01061*Z;
  }

  private double fPe_63 (){
     if ((Delta == NULO) | (Gama == NULO) | (Rn  == NULO) |
         (G     == NULO) | (Vv   == NULO) | (Dpv == NULO))
       return NULO;
     else
       return  ( Delta / ( Delta + Gama  ) * (Rn - G) +
                       Gama  / ( Delta + Gama  ) * 6.43 * ( 1+0.53*Vv) * Dpv);
  }
  private double fPe_FAO (){
     if ((Delta == NULO) | (Gama == NULO) | (Rn  == NULO) |
         (G     == NULO) | (Wf   == NULO) | (Dpv == NULO))
       return NULO;
     else
       return   Delta / ( Delta + Gama  ) * (Rn - G) +
                      Gama / ( Delta + Gama  ) * 2.7 * Wf * Dpv * L;
  }

  private double fPe_FAO_C (){
     if ((fPe_FAO() == NULO) | (C == NULO))
       return NULO;
     else
       return C * fPe_FAO();
  }
  private double fPM_91 (){
    if ((Delta == NULO) | (Gama == NULO) | (Rn  == NULO) |
        (G     == NULO) | (Dpv  == NULO) | (Rho == NULO) |
        (Patm  == NULO) | (Ra  == NULO))
       return NULO;
     else
       return  Delta / ( Delta + GamaL ) * (Rn - G) +
                     Gama  / ( Delta + GamaL ) * 900 * Vv * Dpv /(T+275) * L;
  }
  private double fPT (){
     if ((Delta == NULO)|(Gama == NULO)|(Rn  == NULO)|(G == NULO)|(Alfa == NULO))
       return NULO;
     else
       return  Alfa * Delta / ( Delta + Gama  ) * (Rn - G) ;
  }
  private double fRa (){
    if (Vv == NULO)
       return NULO;
     else
       if  (Vv > 0)
            return 208/Vv;
          else
            return 2080;
  }

  private double fRb (){
     if ((Rbo == NULO) | (Rs == NULO) | (Rso == NULO) | (RbA == NULO) | (RbB == NULO))
       return NULO;
     else
       return Rbo * (RbA* Rs/Rso + RbB);
 }

  private double fRbo (){
    if ((Ea == NULO) | (Tx == NULO) | (Tn == NULO) | (RboA1 == NULO) | (RboB1 == NULO) |(RboT == NULO) | (Ea < 0))
       return NULO;
     else
       if (RboT == 1)
         return (RboA1 + RboB1*Math.sqrt(Ea))*11.71E-8* Math.pow(T,4);
       else
         return (RboA1 + RboB1*Math.sqrt(Ea))*11.71E-8* (Math.pow(Tx,4)+Math.pow(Tn,4))/2;
  }

  private double fRc(){
    if ((IAF == NULO) | (IAF <= 0))
       return NULO;
     else
       return 200 / IAF;
  }
  private double fRho (){
    if ((Patm == NULO) | (T == 0))
      return NULO;
    else
      return 3.486 * Patm / (T+275);
  }

  private double fRins(){
    if ((Ins == NULO) | (N == NULO)  | (N <= 0))
      return NULO;
    else
      return Ins / N;
  }

  private double fRn (){
     if ((Albedo == NULO) | (Rs == NULO) | (Rb == NULO))
       return NULO;
     else
       return (1-Albedo) * Rs - Rb;
  }

  private double fRo(){
    if ((Dr == NULO) | (Ws == NULO) | (DecSol == NULO) | ( GSC == NULO ))
      return  NULO;
    else
      return ( 1440/Math.PI )*GSC*Dr*( Ws * Math.sin(Lat * Math.PI/180) * Math.sin(DecSol) +
                           Math.cos(Lat * Math.PI/180) * Math.cos(DecSol) * Math.sin(Ws) );
  }

  private double fRs(){
     if ((Ro == NULO) | (Rins == NULO) | (RsA == NULO) | (RsB == NULO))
       return NULO;
     else
       return Ro*(RsA + RsB * Rins);
  }

  private double fRso(){
     if ((Ro == NULO) | (RsoK == NULO) )
       return NULO;
     else
       return RsoK * Ro;
  }

  private double fT(){
     if (T == NULO)
        if ((Tn == NULO) | (Tx == NULO))
          return NULO;
        else
          return ( Tn + Tx ) / 2;
     else
       return T;
  }
  private double fTCA(){
     if ((Kt == NULO) | (Ev == NULO))
       return NULO;
     else
       return Kt*Ev;
  }


  private double fTnnorm(){
     return Tnm;
  }

  private double fTjh(){
     double Res=0;
     if ((Txm == NULO) | (Tnm == NULO) | (Z == NULO) |(MetJH == NULO) )
       Res =  NULO;
     else
       switch (MetJH){
         case 0 :{ Res = 26.4;}
         case 1 :{ Res = - 2.5 - 1.4 * (e(Txm) - e(Tnm));}
         case 2 :{ Res = - 2.5 - 1.4 * (e(Txm) - e(Tnm)) - Z/550;}
      }
     return Res;
  }

  private double fTxnorm(){
     return Txm;
  }


  private double fVv (){
     if ((Vvz == NULO) | ( Zv == NULO) | ( Zv <= 0 ))
       return NULO;
     else
       return Vvz * Math.pow( 2 / Zv, 0.2 );
  }

  private double fVvd_Vvn (){
     if ((Vvd == NULO) | ( Vvn == NULO) | ( Vvn <= 0)){
        if (CMed == 1)
           return 2;
        else
           return NULO;
     }else
        return Vvd/Vvn;
  }
  private double fVvd (){
     if (Vv == NULO)
       return NULO;
     else
        if (CMed == 1)
           return 1.33*Vv;
        else
           return Vvd;
  }

  private double fVvn (){
    if (Vv == NULO)
      return NULO;
    else
      if (CMed == 1)
        return 0.665*Vv;
      else
        return Vvn;
  }

  private double fWs(){
    if ((Lat == NULO) | (DecSol == NULO))
      return NULO;
    else
      return Math.acos( -Math.tan(Lat * Math.PI/180) * Math.tan(DecSol) );
  }

  private double fWf(){
    if (Vv == NULO)
       return NULO;
     else
       return (1 + 0.864 * Vv);
  }

  private double fZ(){
     return Z;
  }

  private double fZom(){
     if (Hc == NULO)
       return NULO;
     else
       return Hc/8.15;
  }
  private double fZov(){
     if (Hc == NULO)
       return NULO;
     else
       return Hc/81.5;
  }

  private double fZp(){
     return Zp;
  }
  private double fZv(){
     return Zv;
  }

////////////////////////////////////////////////////////////////////////////////
///////// METODOS DE CONTROLE GERAL/////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

  public void InicVariaveis(){
     A       = NULO;
     Albedo  = NULO;
     Alfa    = NULO;
     Ano     = NULO;
     B       = NULO;     
     Bord    = NULO;
     BC_FAO  = NULO;
     C       = NULO;
     CMed    = NULO;
     Cp      = 1.013;
     C1      = NULO;
     C2      = NULO;
     Ct      = NULO;
     CH      = NULO;
     D       = NULO;
     Dia   = NULO;
     DiaAno  = NULO;     
//     Data    = EncodeDate(1900,1,1);
     DecSol  = NULO;
     Delta   = NULO;
     Deltat  = NULO;
     Dpv     = NULO;
     Dr      = NULO;
     Dren    = NULO;
     Epsilon  = 0.622;
     Ea      = NULO;
     Es      = NULO;
     ETo     = NULO;
     ETp     = NULO;
     Ev      = NULO;
     F       = NULO;
     G       = NULO;
     GSC       = NULO;
     Gama    = NULO;
     GamaL   = NULO;
     Hc      = NULO;
     HS      = NULO;
//     Hora    = NULO;
     I       = NULO;
     IAF     = NULO;
     Ins     = NULO;
     Irrig   = NULO;
     JH      = NULO;
     K       = NULO;
     Kt      = NULO;
     L       = NULO;
     Lat     = NULO;
     LatG     = NULO;
     LatM     = NULO;
     LatS     = NULO;
     Leit1   = NULO;
     Leit2   = NULO;
     Lis     = NULO;
     MetDpv  = NULO;
     MetJH  = NULO;
     Mes  = NULO;
//     Minuto  = NULO;
     Mk_FAO  = NULO;
     N       = NULO;
     P       = NULO;
     Patm    = NULO;
     Pe_63   = NULO;
     Pe_FAO  = NULO;
     Pe_FAO_C= NULO;
     PM_91   = NULO;
     Prec    = NULO;
     PT      = NULO;
     Ra      = NULO;
     Rb      = NULO;
     RbA      = NULO;
     RbB      = NULO;
     Rbo     = NULO;
     RboT    = NULO;
     RboA1     = NULO;
     RboB1     = NULO;
     Rc      = NULO;
     Rho     = NULO;
     Rins    = NULO;
     Rn      = NULO;
     Ro      = NULO;
     Rs      = NULO;
     RsA      = NULO;
     RsB      = NULO;
     Rso     = NULO;
     RsoK    = NULO;
     T       = NULO;
     TCA     = NULO;
     Tjh     = NULO;
     Tmes    = NULO;
     Tn      = NULO;
     Tnnorm  = NULO;
     Tnm     = NULO;
     Transb  = NULO;
     Tx      = NULO;
     Txnorm  = NULO;
     Txm     = NULO;
     Ur      = NULO;
     Urn     = NULO;
     Urx     = NULO;
     Veg     = NULO;
     Vv      = NULO;
     Vvd     = NULO;
     Vvd_Vvn = NULO;
     Vvn     = NULO;
     Vvz     = NULO;
     W1      = NULO;
     W2      = NULO;
     Wf      = NULO;
     Ws      = NULO;
     Z       = NULO;
     Zv      = NULO;
     Zp      = NULO;
  }


  public void AssValEntrada(String Campo, String ValorStr){
    double Valor; 
    if ((ValorStr != null) && (ValorStr != " ")){
       Valor = Float.valueOf(ValorStr).doubleValue();
    }else{
       Valor = 9999;
    }

     if (Campo == "A" )           A       = Valor;
     if (Campo == "Albedo" )      Albedo  = Valor;
     if (Campo == "Alfa" )        Alfa    = Valor;
     if (Campo == "Ano" )         Ano     = (int)Valor;
     if (Campo == "B" )           B       = Valor;
     if (Campo == "BC_FAO" )      BC_FAO  = Valor;
     if (Campo == "Bord" )        Bord    = Valor;
     if (Campo == "C" )           C       = Valor;
     if (Campo == "C1" )          C1      = Valor;
     if (Campo == "C2" )          C2      = Valor;
     if (Campo == "Ct" )          Ct      = Valor;
     if (Campo == "CH" )          CH      = Valor;
     if (Campo == "CMed" )        CMed  = (int)Valor;     
     if (Campo == "D" )           D       = Valor;
     if (Campo == "Dia" )         Dia     = (int)Valor;
     if (Campo == "DiaAno" )      DiaAno  = (int)Valor;
     if (Campo == "Dren" )        Dren    = Valor;
//     if (Campo == "Data" )        Data    = Valor;
     if (Campo == "DecSol" )      DecSol  = Valor;
     if (Campo == "Delta" )       Delta   = Valor;
     if (Campo == "Deltat" )      Deltat  = Valor;
     if (Campo == "Dpv" )         Dpv     = Valor;
     if (Campo == "Dr" )          Dr      = Valor;
     if (Campo == "Ea" )          Ea      = Valor;
     if (Campo == "Es" )          Es      = Valor;
     if (Campo == "ETo" )         ETo     = Valor;
     if (Campo == "ETp" )         ETp     = Valor;
     if (Campo == "Ev" )          Ev      = Valor;
     if (Campo == "F" )           F       = Valor;
     if (Campo == "G" )           G       = Valor;
     if (Campo == "GSC" )         GSC     = Valor;     
     if (Campo == "Gama" )        Gama    = Valor;
     if (Campo == "Gamal" )       GamaL   = Valor;
     if (Campo == "Hc" )          Hc      = Valor;
//     if (Campo == "Hora" )        Hora    = Valor;
     if (Campo == "HS" )          HS      = Valor;
     if (Campo == "I" )           I       = Valor;
     if (Campo == "IAF" )         IAF     = Valor;
     if (Campo == "Ins" )         Ins     = Valor;
     if (Campo == "Irrig" )       Irrig   = Valor;
     if (Campo == "JH" )          JH      = Valor;
     if (Campo == "K" )           K       = Valor;
     if (Campo == "Kt" )          Kt      = Valor;
     if (Campo == "L" )           L       = Valor;
     if (Campo == "Lat" )         Lat     = Valor;
     if (Campo == "LatG" )        LatG    = Valor;
     if (Campo == "LatM" )        LatM    = Valor;
     if (Campo == "LatS" )        LatS    = Valor;     
     if (Campo == "Leit1" )       Leit1   = Valor;
     if (Campo == "Leit2" )       Leit2   = Valor;
     if (Campo == "Lis" )         Lis     = Valor;
     if (Campo == "Mes" )         Mes     = (int)Valor;
     if (Campo == "MetJH" )       MetJH   = (int)Valor;     
     if (Campo == "MetDpv" )      MetDpv   = (int)Valor;          
//     if (Campo == "Minuto" )      Minuto  = Valor;
     if (Campo == "Mk_FAO" )      Mk_FAO  = Valor;
     if (Campo == "N" )           N       = Valor;
     if (Campo == "P" )           P       = Valor;
     if (Campo == "Patm" )        Patm    = Valor;
     if (Campo == "Pe_63" )       Pe_63   = Valor;
     if (Campo == "Pe_FAO" )      Pe_FAO  = Valor;
     if (Campo == "Pe_FAO_C" )    Pe_FAO_C= Valor;
     if (Campo == "PM_91" )       PM_91   = Valor;
     if (Campo == "Prec" )        Prec    = Valor;
     if (Campo == "Ra" )          Ra      = Valor;
     if (Campo == "Rb" )          Rb      = Valor;
     if (Campo == "RbA" )         RbA     = Valor;
     if (Campo == "RbB" )         RbB     = Valor;     
     if (Campo == "Rbo" )         Rbo     = Valor;
     if (Campo == "RboA1" )       RboA1   = Valor;
     if (Campo == "RboB1" )       RboB1   = Valor;     
     if (Campo == "RboT" )        RboT    = (int)Valor;          
     if (Campo == "Rc" )          Rc      = Valor;
     if (Campo == "Rho" )         Rho     = Valor;
     if (Campo == "Rins" )        Rins    = Valor;
     if (Campo == "Rn" )          Rn      = Valor;
     if (Campo == "Ro" )          Ro      = Valor;
     if (Campo == "Rs" )          Rs      = Valor;
     if (Campo == "RsA" )         RsA      = Valor;
     if (Campo == "RsB" )         RsB      = Valor;     
     if (Campo == "Rso" )         Rso     = Valor;
     if (Campo == "RsoK" )        RsoK    = Valor/100;     
     if (Campo == "T" )           T       = Valor;
     if (Campo == "TCA" )         TCA     = Valor;
     if (Campo == "Tmes" )        Tmes    = Valor;
     if (Campo == "Tn" )          Tn      = Valor;
     if (Campo == "Tnm" )         Tnm     = Valor;
     if (Campo == "Tnnorm" )      Tnnorm  = Valor;
     if (Campo == "Transb" )      Transb  = Valor;
     if (Campo == "Tx" )          Tx      = Valor;
     if (Campo == "Tjh" )         Tjh     = Valor;
     if (Campo == "Txm" )         Txm     = Valor;
     if (Campo == "Txnorm" )      Txnorm  = Valor;
     if (Campo == "Ur" )          Ur      = Valor;
     if (Campo == "Urn" )         Urn     = Valor;
     if (Campo == "Urx" )         Urx     = Valor;
     if (Campo == "Veg" )         Veg     = (int)Valor;     
     if (Campo == "Vv" )          Vv      = Valor;
     if (Campo == "Vvd" )         Vvd     = Valor;
     if (Campo == "Vvd_Vvn" )     Vvd_Vvn = Valor;
     if (Campo == "Vvn" )         Vvn     = Valor;
     if (Campo == "Vvz" )         Vvz     = Valor;
     if (Campo == "W1" )          W1      = Valor;
     if (Campo == "W2" )          W2      = Valor;
     if (Campo == "Wf" )          Wf      = Valor;
     if (Campo == "Ws" )          Ws      = Valor;
     if (Campo == "Z" )           Z       = Valor;
     if (Campo == "Zv" )          Zv      = Valor;
     if (Campo == "Zp" )          Zp      = Valor;     
     
  }


  public String AssValSaida(int Item){
    String Retorno="";
      switch(Item) {
  case 0 : {if(A != NULO) {Retorno ="A   =   " + Double.toString(A);};break;}
  case 1 : {if(Albedo != NULO) {Retorno ="Albedo   =   " + Double.toString(Albedo);};break;}
  case 2 : {if(Alfa != NULO) {Retorno ="Alfa   =   " + Double.toString(Alfa);};break;}
  case 3 : {if(Ano != NULO) {Retorno ="Ano   =   " + Double.toString(Ano);};break;}
  case 4 : {if(B != NULO) {Retorno ="B   =   " + Double.toString(B);};break;}
  case 5 : {if(BC_FAO != NULO) {Retorno ="BC_FAO   =   " + Double.toString(BC_FAO);};break;}
  case 6 : {if(Bord != NULO) {Retorno ="Bord   =   " + Double.toString(Bord);};break;}
  case 7 : {if(C != NULO) {Retorno ="C   =   " + Double.toString(C);};break;}
  case 8 : {if(C1 != NULO) {Retorno ="C1   =   " + Double.toString(C1);};break;}
  case 9 : {if(C2 != NULO) {Retorno ="C2   =   " + Double.toString(C2);};break;}
  case 10 : {if(CH != NULO) {Retorno ="CH   =   " + Double.toString(CH);};break;}
  case 11 : {if(CMed != NULO) {Retorno ="CMed   =   " + Double.toString(CMed);};break;}
  case 12 : {if(Cp != NULO) {Retorno ="Cp   =   " + Double.toString(Cp);};break;}
  case 13 : {if(Ct != NULO) {Retorno ="Ct   =   " + Double.toString(Ct);};break;}
  case 14 : {if(D != NULO) {Retorno ="D   =   " + Double.toString(D);};break;}
//  case 15 : {if(Data != NULO) {Retorno ="Data   =   " + Double.toString(Data);};break;}
  case 16 : {if(DecSol != NULO) {Retorno ="DecSol   =   " + Double.toString(DecSol);};break;}
  case 17 : {if(Delta != NULO) {Retorno ="Delta   =   " + Double.toString(Delta);};break;}
  case 18 : {if(Deltat != NULO) {Retorno ="Deltat   =   " + Double.toString(Deltat);};break;}
  case 19 : {if(Dia != NULO) {Retorno ="Dia   =   " + Double.toString(Dia);};break;}
  case 20 : {if(DiaAno != NULO) {Retorno ="DiaAno   =   " + Double.toString(DiaAno);};break;}
  case 21 : {if(Dpv != NULO) {Retorno ="Dpv   =   " + Double.toString(Dpv);};break;}
  case 22 : {if(Dr != NULO) {Retorno ="Dr   =   " + Double.toString(Dr);};break;}
  case 23 : {if(Dren != NULO) {Retorno ="Dren   =   " + Double.toString(Dren);};break;}
  case 24 : {if(Ea != NULO) {Retorno ="Ea   =   " + Double.toString(Ea);};break;}
  case 25 : {if(Epsilon != NULO) {Retorno ="Epsilon   =   " + Double.toString(Epsilon);};break;}
  case 26 : {if(Es != NULO) {Retorno ="Es   =   " + Double.toString(Es);};break;}
  case 27 : {if(ETo != NULO) {Retorno ="ETo   =   " + Double.toString(ETo);};break;}
  case 28 : {if(ETp != NULO) {Retorno ="ETp   =   " + Double.toString(ETp);};break;}
  case 29 : {if(Ev != NULO) {Retorno ="Ev   =   " + Double.toString(Ev);};break;}
  case 30 : {if(F != NULO) {Retorno ="F   =   " + Double.toString(F);};break;}
  case 31 : {if(G != NULO) {Retorno ="G   =   " + Double.toString(G);};break;}
  case 32 : {if(Gama != NULO) {Retorno ="Gama   =   " + Double.toString(Gama);};break;}
  case 33 : {if(GamaL != NULO) {Retorno ="GamaL   =   " + Double.toString(GamaL);};break;}
  case 34 : {if(GSC != NULO) {Retorno ="GSC   =   " + Double.toString(GSC);};break;}
  case 35 : {if(Hc != NULO) {Retorno ="Hc   =   " + Double.toString(Hc);};break;}
//  case 36 : {if(Hora != NULO) {Retorno ="Hora   =   " + Double.toString(Hora);};break;}
  case 37 : {if(HS != NULO) {Retorno ="HS   =   " + Double.toString(HS);};break;}
  case 38 : {if(I != NULO) {Retorno ="I   =   " + Double.toString(I);};break;}
  case 39 : {if(IAF != NULO) {Retorno ="IAF   =   " + Double.toString(IAF);};break;}
  case 40 : {if(Ins != NULO) {Retorno ="Ins   =   " + Double.toString(Ins);};break;}
  case 41 : {if(Irrig != NULO) {Retorno ="Irrig   =   " + Double.toString(Irrig);};break;}
  case 42 : {if(JH != NULO) {Retorno ="JH   =   " + Double.toString(JH);};break;}
  case 43 : {if(K != NULO) {Retorno ="K   =   " + Double.toString(K);};break;}
  case 44 : {if(Kt != NULO) {Retorno ="Kt   =   " + Double.toString(Kt);};break;}
  case 45 : {if(L != NULO) {Retorno ="L   =   " + Double.toString(L);};break;}
  case 46 : {if(Lat != NULO) {Retorno ="Lat   =   " + Double.toString(Lat);};break;}
  case 47 : {if(LatG != NULO) {Retorno ="LatG   =   " + Double.toString(Lat);};break;}
  case 48 : {if(LatM != NULO) {Retorno ="LatM   =   " + Double.toString(LatM);};break;}
  case 49 : {if(LatS != NULO) {Retorno ="LatS   =   " + Double.toString(LatS);};break;}
  case 50 : {if(Leit1 != NULO) {Retorno ="Leit1   =   " + Double.toString(Leit1);};break;}
  case 51 : {if(Leit2 != NULO) {Retorno ="Leit2   =   " + Double.toString(Leit2);};break;}
  case 52 : {if(Lis != NULO) {Retorno ="Lis   =   " + Double.toString(Lis);};break;}
  case 53 : {if(Mes != NULO) {Retorno ="Mes   =   " + Double.toString(Mes);};break;}
  case 54 : {if(MetDpv != NULO) {Retorno ="MetDpv   =   " + Double.toString(MetDpv);};break;}
  case 55 : {if(MetJH != NULO) {Retorno ="MetJH   =   " + Double.toString(MetJH);};break;}
//  case 56 : {if(Minuto != NULO) {Retorno ="Minuto   =   " + Double.toString(Minuto);};break;}
  case 57 : {if(Mk_FAO != NULO) {Retorno ="Mk_FAO   =   " + Double.toString(Mk_FAO);};break;}
  case 58 : {if(N != NULO) {Retorno ="N   =   " + Double.toString(N);};break;}
  case 59 : {if(P != NULO) {Retorno ="P   =   " + Double.toString(P);};break;}
  case 60 : {if(Patm != NULO) {Retorno ="Patm   =   " + Double.toString(Patm);};break;}
  case 61 : {if(Pe_63 != NULO) {Retorno ="Pe_63   =   " + Double.toString(Pe_63);};break;}
  case 62 : {if(Pe_FAO != NULO) {Retorno ="Pe_FAO   =   " + Double.toString(Pe_FAO);};break;}
  case 63 : {if(Pe_FAO_C != NULO) {Retorno ="Pe_FAO_C=   =   " + Double.toString(Pe_FAO_C);};break;}
  case 64 : {if(PM_91 != NULO) {Retorno ="PM_91   =   " + Double.toString(PM_91);};break;}
  case 65 : {if(Prec != NULO) {Retorno ="Prec   =   " + Double.toString(Prec);};break;}
  case 66 : {if(PT != NULO) {Retorno ="PT   =   " + Double.toString(PT);};break;}
  case 67 : {if(Ra != NULO) {Retorno ="Ra   =   " + Double.toString(Ra);};break;}
  case 68 : {if(Rb != NULO) {Retorno ="Rb   =   " + Double.toString(Rb);};break;}
  case 69 : {if(RbA != NULO) {Retorno ="RbA   =   " + Double.toString(RbA);};break;}
  case 70 : {if(RbB != NULO) {Retorno ="RbB   =   " + Double.toString(RbB);};break;}
  case 71 : {if(Rbo != NULO) {Retorno ="Rbo   =   " + Double.toString(Rbo);};break;}
  case 72 : {if(RboA1 != NULO) {Retorno ="RboA1   =   " + Double.toString(RboA1);};break;}
  case 73 : {if(RboB1 != NULO) {Retorno ="RboB1   =   " + Double.toString(RboB1);};break;}
  case 74 : {if(RboT != NULO) {Retorno ="RboT   =   " + Double.toString(RboT);};break;}
  case 75 : {if(Rc != NULO) {Retorno ="Rc   =   " + Double.toString(Rc);};break;}
  case 76 : {if(Rho != NULO) {Retorno ="Rho   =   " + Double.toString(Rho);};break;}
  case 77 : {if(Rins != NULO) {Retorno ="Rins   =   " + Double.toString(Rins);};break;}
  case 78 : {if(Rn != NULO) {Retorno ="Rn   =   " + Double.toString(Rn);};break;}
  case 79 : {if(Ro != NULO) {Retorno ="Ro   =   " + Double.toString(Ro);};break;}
  case 80 : {if(Rs != NULO) {Retorno ="Rs   =   " + Double.toString(Rs);};break;}
  case 81 : {if(RsA != NULO) {Retorno ="RsA   =   " + Double.toString(RsA);};break;}
  case 82 : {if(RsB != NULO) {Retorno ="RsB   =   " + Double.toString(RsB);};break;}
  case 83 : {if(Rso != NULO) {Retorno ="Rso   =   " + Double.toString(Rso);};break;}
  case 84 : {if(RsoK != NULO) {Retorno ="RsoK   =   " + Double.toString(RsoK);};break;}
  case 85 : {if(T != NULO) {Retorno ="T   =   " + Double.toString(T);};break;}
  case 86 : {if(TCA != NULO) {Retorno ="TCA   =   " + Double.toString(TCA);};break;}
  case 87 : {if(Tjh != NULO) {Retorno ="Tjh   =   " + Double.toString(Tjh);};break;}
  case 88 : {if(Tmes != NULO) {Retorno ="Tmes   =   " + Double.toString(Tmes);};break;}
  case 89 : {if(Tn != NULO) {Retorno ="Tn   =   " + Double.toString(Tn);};break;}
  case 90 : {if(Tnm != NULO) {Retorno ="Tnm   =   " + Double.toString(Tnm);};break;}
  case 91 : {if(Tnnorm != NULO) {Retorno ="Tnnorm   =   " + Double.toString(Tnnorm);};break;}
  case 92 : {if(Transb != NULO) {Retorno ="Transb   =   " + Double.toString(Transb);};break;}
  case 93 : {if(Tx != NULO) {Retorno ="Tx   =   " + Double.toString(Tx);};break;}
  case 94 : {if(Txm != NULO) {Retorno ="Txm   =   " + Double.toString(Txm);};break;}
  case 95 : {if(Txnorm != NULO) {Retorno ="Txnorm   =   " + Double.toString(Txnorm);};break;}
  case 96 : {if(Ur != NULO) {Retorno ="Ur   =   " + Double.toString(Ur);};break;}
  case 97 : {if(Urn != NULO) {Retorno ="Urn   =   " + Double.toString(Urn);};break;}
  case 98 : {if(Urx != NULO) {Retorno ="Urx   =   " + Double.toString(Urx);};break;}
  case 99 : {if(Veg != NULO) {Retorno ="Veg   =   " + Double.toString(Veg);};break;}
  case 100 : {if(Vv != NULO) {Retorno ="Vv   =   " + Double.toString(Vv);};break;}
  case 101 : {if(Vvd != NULO) {Retorno ="Vvd   =   " + Double.toString(Vvd);};break;}
  case 102 : {if(Vvd_Vvn != NULO) {Retorno ="Vvd_Vvn   =   " + Double.toString(Vvd_Vvn);};break;}
  case 103 : {if(Vvn != NULO) {Retorno ="Vvn   =   " + Double.toString(Vvn);};break;}
  case 104 : {if(Vvz != NULO) {Retorno ="Vvz   =   " + Double.toString(Vvz);};break;}
  case 105 : {if(W1 != NULO) {Retorno ="W1   =   " + Double.toString(W1);};break;}
  case 106 : {if(W2 != NULO) {Retorno ="W2   =   " + Double.toString(W2);};break;}
  case 107 : {if(Wf != NULO) {Retorno ="Wf   =   " + Double.toString(Wf);};break;}
  case 108 : {if(Ws != NULO) {Retorno ="Ws   =   " + Double.toString(Ws);};break;}
  case 109 : {if(Z != NULO) {Retorno ="Z   =   " + Double.toString(Z);};break;}
  case 110 : {if(Zp != NULO) {Retorno ="Zp   =   " + Double.toString(Zp);};break;}
  case 111 : {if(Zv != NULO) {Retorno ="Zv   =   " + Double.toString(Zv);};break;}
      }  
    return Retorno;
  }


/////

public void Calculo(){
////////////////////////////////////////////////////////////////////////////////
//// Default do Sistema                                                      ///
     if (Albedo   == NULO)     Albedo = fAlbedo();
     if (Bord     == NULO)     Bord   = fBord();
     if (Lat      == NULO)     Lat    = fLat();
     if (Hc       == NULO)     Hc     = fHc();
     if (Z        == NULO)     Z      = fZ();
     if (Zv       == NULO)     Zv     = fZv();
     if (Zp       == NULO)     Zp     = fZp();     
     
     if (Txnorm   == NULO)     Txnorm = fTxnorm();
     if (Tnnorm   == NULO)     Tnnorm = fTnnorm();

////////////////////////////////////////////////////////////////////////////////
//// Data e Tempo                                                            ///
     if (DiaAno   == NULO)     DiaAno = fDiaAno();


////////////////////////////////////////////////////////////////////////////////
//// Derivadas da Data e Latitude                                            ///
     if (DecSol   == NULO)     DecSol = fDecSol();
     if (Ws       == NULO)     Ws     = fWs();
     if (N        == NULO)     N      = fN();
     if (Rins     == NULO)     Rins   = fRins();
     if (T        == NULO)     T      = fT();
     if (L        == NULO)     L      = fL();
     if (Es       == NULO)     Es     = fEs();
     if (Ea       == NULO)     Ea     = fEa();
     if (Dpv      == NULO)     Dpv    = fDpv();

////////////////////////////////////////////////////////////////////////////////
//// Fundamentais                                                            ///
     if (Patm     == NULO)     Patm   = fPatm();
     if (Rho      == NULO)     Rho    = fRho();
     if (A        == NULO)     A      = fA();
     if (Alfa     == NULO)     Alfa   = fAlfa();
     if (C1       == NULO)     C1     = fC1();
//     if (C2       == NULO)     C2     = fC2(); 
     if (CH       == NULO)     CH     = fCH();
     if (Ct       == NULO)     Ct     = fCt();
     if (D        == NULO)     D      = fD();
     if (P        == NULO)     P      = fP();
     if (F        == NULO)     F      = fF();
     if (Tjh      == NULO)     Tjh    = fTjh();

////////////////////////////////////////////////////////////////////////////////
//// Derivadas da Temperatura - T                                            ///
     if (G        == NULO)     G      = fG();
     if (Gama     == NULO)     Gama   = fGama();
     if (Delta    == NULO)     Delta  = fDelta();
     if (I        == NULO)     I      = fI();
     if (Deltat   == NULO)     Deltat = fDeltat();


////////////////////////////////////////////////////////////////////////////////
//// Derivadas do Vento                                                      ///
//     if (Vvz      == NULO)     Vvz    = fVvz();
     if (Vv       == NULO)     Vv     = fVv();
     if (Vvd      == NULO)     Vvd    = fVvd();
     if (Vvn      == NULO)     Vvn    = fVvn();
     if (Vvd_Vvn  == NULO)     Vvd_Vvn= fVvd_Vvn();
     if (Wf       == NULO)     Wf     = fWf();
     if (B        == NULO)     B      = fB();

////////////////////////////////////////////////////////////////////////////////
//// Cultura de Referncia                                                   ///
     if (Ra       == NULO)     Ra     = fRa();
     if (IAF      == NULO)     IAF    = fIAF();
     if (Rc       == NULO)     Rc     = fRc();
     if (GamaL    == NULO)     GamaL  = fGamaL();

////////////////////////////////////////////////////////////////////////////////
//// Radiao                                                                ///
     if (Dr       == NULO)     Dr     = fDr();
     if (Ro       == NULO)     Ro     = fRo();
     if (Rbo      == NULO)     Rbo    = fRbo();
     if (Rs       == NULO)     Rs     = fRs();
     if (Rso      == NULO)     Rso    = fRso();
     if (Rb       == NULO)     Rb     = fRb();
     if (Rn       == NULO)     Rn     = fRn();
     if (C        == NULO)     C      = fC();

////////////////////////////////////////////////////////////////////////////////
//// ET                                                                      ///
     if (K        == NULO)     K       = fK();
     if (Kt       == NULO)     Kt      = fKt();
     if (Ev       == NULO)     Ev      = fEv();
     if (BC_FAO   == NULO)     BC_FAO  = fBC_FAO();
     if (Mk_FAO   == NULO)     Mk_FAO  = fMk_FAO();
     if (Pe_63    == NULO)     Pe_63   = fPe_63();
     if (Pe_FAO   == NULO)     Pe_FAO  = fPe_FAO();
     if (Pe_FAO_C == NULO)     Pe_FAO_C= fPe_FAO_C();
     if (PM_91    == NULO)     PM_91   = fPM_91();
     if (PT       == NULO)     PT      = fPT();
     if (TCA      == NULO)     TCA     = fTCA();
     if (Lis      == NULO)     Lis     = fLis();
     if (HS       == NULO)     HS      = fHS();
     if (JH       == NULO)     JH      = fJH();
  }
}
