package ConexaoBD;

import java.sql.*;

public class ConexaoBD{

  public java.sql.Connection AbreConexao(String driver,String url, String usuario, String senha){
    java.sql.Connection Con = null;
    try{
      System.out.print("Iniciando a conexao com o BD...");
      Class.forName(driver);
      Con = java.sql.DriverManager.getConnection(url,usuario,senha);
      if(!VerificaErroSql(Con.getWarnings())){
        System.out.println("OK!");
      }
    }catch(SQLException sql){
       System.out.println("Houve uma SQLException: " + sql);
    }catch(ClassNotFoundException fnf){
       System.out.println("Houve uma ClassNotFoundException: " + fnf);
    }
    return Con;
  }

  public boolean FechaConexao(java.sql.Connection Con){
    boolean fc = false;
    try{
      if(Con != null){
        System.out.print("Fechando a conexao com o BD...");
        Con.close();
      }else{
        System.out.println("Nao existe conexao aberta");
      } 
      if(!VerificaErroSql(Con.getWarnings())){
        System.out.println("OK!");
        fc = true;
      }
    }catch(SQLException sql){
       System.out.println("Houve uma SQLException: " + sql);
    }
    return fc;
  }

  private static boolean VerificaErroSql(SQLWarning warn) throws SQLException {
    boolean rc = false;
    if (warn != null) {
      System.out.println("\n *** Warning ***\n");
      rc = true;
      while (warn != null){
        System.out.println("SQLState: " + warn.getSQLState());
        System.out.println("Message:  " + warn.getMessage());
        System.out.println("Vendor:   " + warn.getErrorCode());
        System.out.println("");
        warn = warn.getNextWarning();
      }
    }
    return rc;
  }
}