
<%
	'Original calendar copyright Wrox Press
	' Recode Talin Senner
%>
<%
	'------------------------------------------------------------
	' This function finds the last date of the given month
	'------------------------------------------------------------
	Function GetLastDay(intMonthNum, intYearNum)
		Dim dNextStart
		If CInt(intMonthNum) = 12 Then
			dNextStart = "1/1/" & intYearNum
		Else
			dNextStart = intMonthNum + 1 & "/1/" & intYearNum
		End If
		GetLastDay = Day(DatePart("y",dNextStart)-1)
	End Function
	
	'-------------------------------------------------------------------------
	' This routine prints the individual table divisions for days of the month
	'-------------------------------------------------------------------------
	Sub Write_TD(sValue, sClass)
		Response.Write "		<TD ALIGN='RIGHT' WIDTH=20 HEIGHT=15 VALIGN='BOTTOM' CLASS='" & sClass & "'> " & sValue & "</TD>" & vbCrLf
	End Sub


	' Constants for the days of the week
	Const cSUN = 1, cMON = 2, cTUE = 3, cWED = 4, cTHU = 5, cFRI = 6, cSAT = 7
	
	' Get the name of this file
	sScript = Request.ServerVariables("SCRIPT_NAME")
	
	' Check for valid month input
	If IsEmpty(Request("MONTH")) OR NOT IsNumeric(Request("MONTH")) Then
	  datToday = today
	  intThisMonth = Month(datToday)
	ElseIf CInt(Request("MONTH")) < 1 OR CInt(Request("MONTH")) > 12 Then
	  datToday = today
	  intThisMonth =  Month(datToday)
	Else
	  intThisMonth = CInt(Request("MONTH"))
	End If
	
	' Check for valid year input
	If IsEmpty(Request("YEAR")) OR NOT IsNumeric(Request("YEAR")) Then
	  datToday = today
	  intThisYear = Year(datToday)
	Else
	  intThisYear = CInt(Request("YEAR"))
	End If

	strMonthName = MonthName(intThisMonth)
	datFirstDay = DateSerial(intThisYear, intThisMonth, 1)
	intFirstWeekDay = WeekDay(datFirstDay, vbSunday)
	intLastDay = GetLastDay(intThisMonth, intThisYear)
	
	' Get the previous month and year
	intPrevMonth = intThisMonth - 1
	If intPrevMonth = 0 Then
		intPrevMonth = 12
		intPrevYear = intThisYear - 1
	Else
		intPrevYear = intThisYear	
	End If
	
	' Get the next month and year
	intNextMonth = intThisMonth + 1
	If intNextMonth > 12 Then
		intNextMonth = 1
		intNextYear = intThisYear + 1
	Else
		intNextYear = intThisYear
	End If

	' Get the last day of previous month. Using this, find the sunday of
	' last week of last month
	LastMonthDate = GetLastDay(intLastMonth, intPrevYear) - intFirstWeekDay + 2
	NextMonthDate = 1

	' Initialize the print day to 1  
	intPrintDay = 1

	' Open a record set of schedules
	Set Rs = Server.CreateObject("ADODB.RecordSet")
	
	' These dates are used in the SQL
	dFirstDay = intThisMonth & "/1/" & intThisYear
	dLastDay 	= intThisMonth & "/" & intLastDay & "/" & intThisYear

	sSQL = 	"SELECT DISTINCT Start_Date, End_Date FROM tblRecordedLocations WHERE (Start_Date >=#" & dFirstDay & "# AND Start_Date <= #" & dLastDay & "#) OR (End_Date >=#" & dFirstDay & "# AND End_Date <= #" & dLastDay & "#) OR (Start_Date <= #" & dFirstDay & "# AND End_Date >= #" & dLastDay & "# )ORDER BY Start_Date "

'	Response.Write sSQL

	' Open the RecordSet with a static cursor. This cursor provides bi-directional navigation
	Rs.Open sSQL, sDSN,  adCmdText
%>

<html>

<head>
<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">
<title>Schedule for <% = strMonthName & " " & intThisYear %></title>

</head>

<body leftmargin="3" >

<br>
<table align="center" border="1" cellspacing="0" cellpadding="2" bgcolor="white" bordercolor="gray">
  <tr>
    <td>
      <table width="140" border="0" cellpadding="1" cellspacing="0" bgcolor="white">
        <tr height="18" bgcolor="silver">
          <td width="20" height="18" align="left" valign="center"><a href="<% =sScript%>?month=<% =IntPrevMonth %>&amp;year=<% =IntPrevYear %>"><img alt="Previous Month" border="0" height="18" src="images/prev.gif" width="10"></a></td>
          <td width="120" colspan="5" align="middle" valign="center" class="SOME"><% = strMonthName & " " & intThisYear %></td>
          <td width="20" height="18" align="right" valign="center"><a href="<% =sScript %>?month=<% =IntNextMonth %>&amp;year=<% =IntNextYear %>"><img alt="Next Month" border="0" height="18" src="images/next.gif" width="10"></a></td>
        </tr>
        <tr>
          <td align="right" class="SOME" width="20" height="15" valign="bottom">S</td>
          <td align="right" class="SOME" width="20" height="15" valign="bottom">M</td>
          <td align="right" class="SOME" width="20" height="15" valign="bottom">T</td>
          <td align="right" class="SOME" width="20" height="15" valign="bottom">W</td>
          <td align="right" class="SOME" width="20" height="15" valign="bottom">T</td>
          <td align="right" class="SOME" width="20" height="15" valign="bottom">F</td>
          <td align="right" class="SOME" width="20" height="15" valign="bottom">S</td>
        </tr>
        <tr>
          <td height="1" align="middle" colspan="7"><img border="0" height="1" src="images/line.gif" width="140"></td>
        </tr>
	    <%
			' Initialize the end of rows flag to false
			EndRows = False
			Response.Write vbCrLf
			
			' Loop until all the rows are exhausted
		 	Do While EndRows = False
				' Start a table row
				Response.Write "	<TR>" & vbCrLf
				' This is the loop for the days in the week
				For intLoopDay = cSUN To cSAT
					' If the first day is not sunday then print the last days of previous month in grayed font
					If intFirstWeekDay > cSUN Then
						Write_TD LastMonthDate, "NON"
						LastMonthDate = LastMonthDate + 1
						intFirstWeekDay = intFirstWeekDay - 1
					' The month starts on a sunday	
					Else
						' If the dates for the month are exhausted, start printing next month's dates
						' in grayed font
						If intPrintDay > intLastDay Then
							Write_TD NextMonthDate, "NON"
							NextMonthDate = NextMonthDate + 1
							EndRows = True 
						Else
							' If last day of the month, flag the end of the row
							If intPrintDay = intLastDay Then
								EndRows = True
							End If
							
							dToday = (intThisMonth & "/" & intPrintDay & "/" & intThisYear) 

							If NOT Rs.EOF Then
								' Set events flag to false. This means the day has no event in it
								bEvents = False
							  Do While NOT Rs.EOF AND bEvents = False
									' If the date falls within the range of dates in the recordset, then 
									' the day has an event. Make the events flag True
								
							    If FormatDateTime(dToday,2) >= FormatDateTime(Rs("Start_Date"),2) AND FormatDateTime(dToday,2) <= FormatDateTime(Rs("End_Date"),2) Then
										' Print the date in a highlighted font
							      Write_TD "<b><Font onMouseOver=javascript:style.cursor='hand'; onclick=javascript:parent.location.replace('days_events.asp?date="& Server.URLEncode(dToday) & "');  CLASS='EVENT' > " & intPrintDay & "</b>" , "SOME"
										bEvents = True
									' If the Start date is greater than the date itself, there is no point
									' checking other records. Exit the loop	
							    ElseIf dToday < Rs("Start_Date") Then
										Exit Do
									' Move to the next record
									Else	
								    Rs.MoveNext
									End If
							  Loop
								' Checks for that day
								Rs.MoveFirst
							End If
							
							' If the event flag is not raise for that day, print it in a plain font
							If bEvents = False Then
								Write_TD "<font onMouseOver=javascript:style.cursor='hand'; onclick=javascript:parent.location.replace('days_events.asp?date=" & Server.URLEncode(dToday) & "');  CLASS='NOEVENT'> " & intPrintDay, "SOME"
							End If
						End If 
						
						' Increment the date. Done once in the loop.
						intPrintDay = intPrintDay + 1
					End If
				
				' Move to the next day in the week
				Next
				Response.Write "	</TR>" & vbCrLf
				
			Loop 
			Rs.Close
			Set Rs = Nothing
		%>
      </table>
    </td>
  </tr>
</table>
<p>
<FONT FACE="Verdana, Arial" SIZE=2>
<FORM ACTION="<% =sScript%>" METHOD=GET>
<SELECT NAME=MONTH>
<OPTION VALUE=1 SELECTED>Jan
<OPTION VALUE=2>Feb
<OPTION VALUE=3>Mar
<OPTION VALUE=4>Apr
<OPTION VALUE=5>May
<OPTION VALUE=6>Jun
<OPTION VALUE=7>Jul
<OPTION VALUE=8>Aug
<OPTION VALUE=9>Sep
<OPTION VALUE=10>Oct
<OPTION VALUE=11>Nov
<OPTION VALUE=12>Dec
</SELECT>
<SELECT NAME=YEAR>
<OPTION VALUE=2001>2000
<OPTION VALUE=2001 SELECTED>2001
<OPTION VALUE=2002>2002
<OPTION VALUE=2003>2003
<OPTION VALUE=2004>2004
<OPTION VALUE=2005>2005
</SELECT>

<P><INPUT TYPE="Image" NAME="" SRC="images/go.jpg" BORDER="0" WIDTH="35" HEIGHT="20"></P>
</FORM>

<p><font class='NORMAL'> Bold Dates are dates with something scheduled</P>
</body>
<font class='normal' onMouseOver=javascript:style.cursor='hand'; onclick=javascript:parent.location.replace('http://senner.net');> Test </a>
</html>
